/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.builders;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.builders.PseudoLetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public class LetChainBuilder {
    protected LetInstruction m_outer = null;
    protected LetInstruction m_inner = null;

    public Instruction bind(Instruction instruction2) {
        return this.bind(ReductionHelper.generateIntermediateIdentifier2(), instruction2, false);
    }

    public Object bindToVar(Instruction instruction2) {
        if (instruction2 instanceof IdentifierInstruction) {
            return ((IdentifierInstruction)instruction2).getVariable();
        }
        Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
        this.bind(n2, instruction2, true);
        return n2;
    }

    public Object bindToVar(Object object2, Instruction instruction2) {
        this.bind(object2, instruction2, true);
        return object2;
    }

    public Instruction bind(Object object2, Instruction instruction2) {
        return this.bind(object2, instruction2, false);
    }

    public Instruction bind(Object object2, Instruction instruction2, boolean bl) {
        if (object2 instanceof Instruction || instruction2 == null) {
            throw new IllegalArgumentException();
        }
        if (!bl && (instruction2 instanceof IdentifierInstruction || instruction2 instanceof LiteralInstruction)) {
            return instruction2;
        }
        if (instruction2 instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction2;
            if (this.m_outer == null) {
                this.m_inner = this.m_outer = letInstruction;
            } else {
                this.m_inner.setBody(letInstruction);
            }
            instruction2 = letInstruction.getBody();
            while (instruction2 instanceof LetInstruction) {
                letInstruction = (LetInstruction)instruction2;
                instruction2 = letInstruction.getBody();
            }
            if (instruction2 == null) {
                throw new XylemError("ERR_SYSTEM", "LetChainBuilder: bind where value is a let itself but body of let is null!" + this);
            }
            this.m_inner = new LetInstruction(object2, instruction2, null);
            letInstruction.setBody(this.m_inner);
        } else {
            LetInstruction letInstruction = new LetInstruction(object2, instruction2, null);
            if (this.m_outer == null) {
                this.m_inner = this.m_outer = letInstruction;
            } else {
                this.m_inner.setBody(letInstruction);
                this.m_inner = letInstruction;
            }
        }
        return new IdentifierInstruction(object2);
    }

    public Instruction packageUp(Instruction instruction2) {
        if (this.m_outer == null) {
            return instruction2;
        }
        this.m_inner.setBody(instruction2);
        return this.m_outer;
    }

    public static Instruction inlinebody(Instruction[] instructionArray, IBinding[] iBindingArray, Instruction instruction2) {
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        Instruction instruction3 = letChainBuilder.bindAndRenameBody(instructionArray, iBindingArray, instruction2, new BindingEnvironment());
        return letChainBuilder.packageUp(instruction3);
    }

    public Instruction bindAndRenameBody(Instruction[] instructionArray, IBinding[] iBindingArray, Instruction instruction2, BindingEnvironment bindingEnvironment) {
        if (instructionArray.length != iBindingArray.length) {
            throw new RuntimeException();
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < instructionArray.length; ++i) {
            Object object2;
            Instruction instruction3 = instructionArray[i];
            if (instruction3 == null) continue;
            if (instruction3 instanceof IdentifierInstruction) {
                object2 = ((IdentifierInstruction)instruction3).getVariable();
            } else if (instruction3 instanceof LiteralInstruction) {
                object2 = this.bindToVar(instruction3);
                if (bindingEnvironment != null) {
                    bindingEnvironment.setVariableBinding(this.m_inner);
                }
            } else {
                throw new IllegalArgumentException();
            }
            hashMap.put(iBindingArray[i].getName(), object2);
        }
        return this.rebindLetsInternal(instruction2, hashMap, bindingEnvironment);
    }

    public Instruction rebindLets(Instruction instruction2, BindingEnvironment bindingEnvironment) {
        return this.rebindLetsInternal(instruction2, new HashMap(), bindingEnvironment);
    }

    public Instruction tryToResolve(Instruction instruction2) {
        if (instruction2 instanceof LetBaseInstruction) {
            return this.resolveLetInstruction((LetBaseInstruction)instruction2);
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return this.tryToResolve((IdentifierInstruction)instruction2, this.m_outer);
        }
        return instruction2;
    }

    private Instruction tryToResolve(IdentifierInstruction identifierInstruction, LetBaseInstruction letBaseInstruction) {
        Object object2 = identifierInstruction.getVariable();
        if (object2 == null) {
            return null;
        }
        while (letBaseInstruction != null) {
            Instruction instruction2;
            Object object3 = letBaseInstruction.getVariable();
            if (object3 != null && object3.equals(object2)) {
                instruction2 = letBaseInstruction.getValue();
                if (instruction2 == null) {
                    return null;
                }
                if (instruction2 instanceof IdentifierInstruction) {
                    return this.tryToResolve(instruction2);
                }
                if (instruction2 instanceof LetBaseInstruction) {
                    return this.resolveLetInstruction((LetBaseInstruction)instruction2);
                }
                return instruction2;
            }
            instruction2 = letBaseInstruction.getBody();
            if (instruction2 instanceof LetBaseInstruction) {
                letBaseInstruction = (LetBaseInstruction)instruction2;
                continue;
            }
            if (instruction2 instanceof IdentifierInstruction) break;
        }
        return null;
    }

    private Instruction resolveLetInstruction(LetBaseInstruction letBaseInstruction) {
        Instruction instruction2 = letBaseInstruction;
        while ((instruction2 = instruction2.getBody()) instanceof LetBaseInstruction) {
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return this.tryToResolve(instruction2);
        }
        return instruction2;
    }

    private Instruction rebindLetsInternal(Instruction instruction2, HashMap hashMap, BindingEnvironment bindingEnvironment) {
        Instruction instruction32;
        INewNameGenerator iNewNameGenerator = new INewNameGenerator(){

            @Override
            public Object getNewName() {
                return ReductionHelper.generateIntermediateIdentifier2();
            }
        };
        LinkedList linkedList = new LinkedList();
        Instruction instruction4 = OptimizerUtilities.skipLets(instruction2, linkedList);
        for (Instruction instruction32 : linkedList) {
            Object object2 = instruction32.getVariable();
            Instruction instruction5 = instruction32.getValue().assignNewNames(hashMap, iNewNameGenerator);
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(this.bindToVar(instruction5));
            if (bindingEnvironment != null) {
                bindingEnvironment.setVariableBinding(this.m_inner);
            }
            hashMap.put(object2, identifierInstruction);
        }
        instruction4 = instruction4.assignNewNames(hashMap, iNewNameGenerator);
        instruction32 = this.bind(instruction4);
        if (bindingEnvironment != null && this.m_inner != null) {
            bindingEnvironment.setVariableBinding(this.m_inner);
        }
        return instruction32;
    }

    public LetChainBuilder newInstance() {
        return new LetChainBuilder();
    }

    public static LetChainBuilder newInstance(boolean bl) {
        if (bl) {
            return new PseudoLetChainBuilder();
        }
        return new LetChainBuilder();
    }
}

