/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TupleMetaAnnotation
extends MetaAnnotation {
    TupleMetaAnnotation m_base;
    Instruction[] m_originalParams;
    Type[] m_types;
    IAnnotation[] m_components;

    public TupleMetaAnnotation(Instruction[] instructionArray, AnnotationEnvironment annotationEnvironment) {
        this.m_originalParams = instructionArray;
        this.m_types = new Type[instructionArray.length];
        this.m_components = new IAnnotation[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            this.m_components[i] = annotationEnvironment.get(instructionArray[i]);
            if (this.m_components[i] != null) {
                this.m_components[i] = this.m_components[i].clonePassthru();
            }
            this.m_types[i] = instructionArray[i].getType(annotationEnvironment.getTypeEnvironment(), annotationEnvironment.getBindingEnvironment());
        }
    }

    public TupleMetaAnnotation(TupleMetaAnnotation tupleMetaAnnotation) {
        IAnnotation[] iAnnotationArray = new IAnnotation[tupleMetaAnnotation.m_components.length];
        for (int i = 0; i < tupleMetaAnnotation.m_components.length; ++i) {
            if (tupleMetaAnnotation.m_components[i] == null) continue;
            iAnnotationArray[i] = tupleMetaAnnotation.m_components[i].clonePassthru();
        }
        this.m_types = tupleMetaAnnotation.m_types;
        this.m_components = iAnnotationArray;
        this.m_base = tupleMetaAnnotation;
    }

    public TupleMetaAnnotation(TupleMetaAnnotation tupleMetaAnnotation, IAnnotation[] iAnnotationArray) {
        this.m_types = tupleMetaAnnotation.m_types;
        this.m_components = iAnnotationArray;
        this.m_base = tupleMetaAnnotation;
    }

    @Override
    public void propagateDependanciesToBase() {
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null) continue;
            this.m_components[i].propagateDependancies(this);
        }
    }

    public IAnnotation[] getComponents() {
        return this.m_components;
    }

    @Override
    public IAnnotation clonePassthru() {
        return new TupleMetaAnnotation(this);
    }

    @Override
    public IAnnotation cloneAsFunctionParam() {
        IAnnotation[] iAnnotationArray = new IAnnotation[this.m_components.length];
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null) continue;
            iAnnotationArray[i] = this.m_components[i].cloneAsFunctionParam();
        }
        return new TupleMetaAnnotation(this, iAnnotationArray);
    }

    @Override
    public void setVariable(Object object2) {
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null) continue;
            this.m_components[i].setVariable(object2 + "_" + i);
        }
        super.setVariable(object2);
    }

    private String getVarName(Object object2) {
        return object2 + "$tuple";
    }

    public void insertMatchOperation(int n2, Binding binding, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        String string2 = this.getVarName(this.getVariable()) + n2;
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(this.getVarName(this.getVariable()));
        conversionEngine.insertBinding(string2, new TupleMatchInstruction((Instruction)identifierInstruction, this.m_components.length, n2));
        identifierInstruction = new IdentifierInstruction(string2);
        if (this.m_components[n2] == null) {
            conversionEngine.insertBinding(binding.getName(), identifierInstruction);
        } else {
            conversionEngine.insertValueDecomposition(string2, this.m_components[n2]);
            Iterator iterator = conversionEngine.getBindingList(string2, this.m_components[n2]).iterator();
            Iterator iterator2 = conversionEngine.getBindingList(binding.getName(), this.m_components[n2]).iterator();
            while (iterator.hasNext()) {
                Binding binding2 = (Binding)iterator.next();
                Binding binding3 = (Binding)iterator2.next();
                conversionEngine.insertBinding(binding3.getName(), new IdentifierInstruction(binding2.getName()));
            }
        }
    }

    @Override
    public boolean equals(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (!(object2 instanceof TupleMetaAnnotation)) {
            return false;
        }
        IAnnotation[] iAnnotationArray = ((TupleMetaAnnotation)object2).m_components;
        if (iAnnotationArray.length != this.m_components.length) {
            return false;
        }
        for (int i = 0; i < iAnnotationArray.length; ++i) {
            if (!(iAnnotationArray[i] == null ? this.m_components[i] != null : !iAnnotationArray[i].equals(this.m_components[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getBindingList(Object object2, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        return Collections.singletonList(new Binding((Object)this.getVarName(object2), this.getType(conversionEngine)));
    }

    @Override
    public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (this.m_originalParams == null) {
            this.insertPassthru(this, this.m_base, annotationEnvironment, conversionEngine);
        } else {
            conversionEngine.insertBinding(this.getVarName(this.getVariable()), conversionEngine.convertInstruction(new TupleInstruction(this.m_originalParams)));
        }
    }

    public Type getType(ConversionEngine conversionEngine) {
        String string2 = this.getVarName(this.getVariable());
        Type[] typeArray = new Type[this.m_components.length];
        for (int i = 0; i < this.m_components.length; ++i) {
            typeArray[i] = conversionEngine.convertType(this.m_components[i], this.m_types[i]);
        }
        return new TupleType(typeArray);
    }

    @Override
    public Instruction convert(Instruction instruction2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (instruction2 instanceof ConstructorInstantiationInstruction) {
            return null;
        }
        return super.convert(instruction2, annotationEnvironment, conversionEngine);
    }

    @Override
    public IAnnotation cloneAsFunctionReturn(ArrayList arrayList) {
        return super.cloneAsFunctionReturn(arrayList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(TupleAnnot ");
        stringBuffer.append(this.getVariable());
        stringBuffer.append(" base=");
        if (this.m_base != null) {
            stringBuffer.append(this.m_base.getVariable());
        } else {
            stringBuffer.append("null");
        }
        for (int i = 0; i < this.m_components.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(this.m_components[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

