/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.EmptyStreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StreamMetaAnnotation
extends MetaAnnotation {
    private Type m_originalType;
    private IAnnotation m_atomicAnnotation;
    private StreamMetaAnnotation m_base;

    public static IAnnotation newStream(StreamInstruction streamInstruction, AnnotationEnvironment annotationEnvironment, AnnotationTable annotationTable) {
        return null;
    }

    private StreamMetaAnnotation(Type type2, IAnnotation iAnnotation) {
        this.m_originalType = type2;
        this.m_atomicAnnotation = iAnnotation.clonePassthru();
        this.m_base = null;
    }

    private StreamMetaAnnotation(StreamMetaAnnotation streamMetaAnnotation) {
        this.m_base = streamMetaAnnotation;
        this.m_atomicAnnotation = streamMetaAnnotation.m_atomicAnnotation.clonePassthru();
    }

    @Override
    public boolean propagateDependancies(IAnnotation iAnnotation) {
        if (!(iAnnotation instanceof StreamMetaAnnotation)) {
            return this.m_atomicAnnotation.propagateDependancies(iAnnotation);
        }
        return this.m_atomicAnnotation.propagateDependancies(((StreamMetaAnnotation)iAnnotation).m_atomicAnnotation);
    }

    @Override
    public boolean equals(Object object2) {
        while (object2 instanceof ReturnValueMetaAnnotation) {
            object2 = ((ReturnValueMetaAnnotation)object2).getReturnAnnotation();
        }
        if (object2 == null) {
            return false;
        }
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof EmptyStreamMetaAnnotation) {
            return object2.equals(this);
        }
        if (!(object2 instanceof StreamMetaAnnotation)) {
            return false;
        }
        return this.m_atomicAnnotation.equals(((StreamMetaAnnotation)object2).m_atomicAnnotation);
    }

    @Override
    public List getBindingList(Object object2, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        List list = conversionEngine.getBindingList(object2, this.m_atomicAnnotation);
        for (Binding binding : list) {
            binding.setType(StreamType.makeStreamType(binding.getBindingType()));
        }
        return list;
    }

    @Override
    public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (iAnnotation != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        if (this.m_base != null) {
            this.insertPassthru(this, this.m_base, annotationEnvironment, conversionEngine);
        } else {
            conversionEngine.insertAnnotationOperation(this.m_atomicAnnotation);
            Iterator iterator = this.getBindingList(this.getVariable(), this, conversionEngine).iterator();
            Iterator iterator2 = conversionEngine.getBindingList(this.m_atomicAnnotation.getVariable(), this.m_atomicAnnotation).iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                Binding binding2 = (Binding)iterator2.next();
                if (binding2.getBindingType() instanceof StreamType) {
                    conversionEngine.insertBinding(binding.getName(), new IdentifierInstruction(binding2.getName()));
                    continue;
                }
                conversionEngine.insertBinding(binding.getName(), new StreamInstruction(binding2.getBindingType(), new IdentifierInstruction(binding2.getName())));
            }
        }
    }

    @Override
    public void setVariable(Object object2) {
        super.setVariable(object2);
        this.m_atomicAnnotation.setVariable(object2);
    }

    public Type getOriginalType() {
        return this.m_originalType;
    }

    @Override
    public IAnnotation cloneAsFunctionParam() {
        return new StreamMetaAnnotation(this.m_originalType, this.m_atomicAnnotation.cloneAsFunctionParam());
    }

    @Override
    public IAnnotation clonePassthru() {
        return new StreamMetaAnnotation(this);
    }

    @Override
    public IAnnotation getLoopBindingAnnotation() {
        return this.m_atomicAnnotation.getLoopBindingAnnotation();
    }

    @Override
    public IAnnotation getLoopValueAnnotation() {
        return this.clonePassthru();
    }

    @Override
    public void propagateDependanciesToBase() {
        throw new XylemError("ERR_SYSTEM", "!");
    }

    @Override
    public boolean propagateDependanciesTo(MetaAnnotation metaAnnotation) {
        if (metaAnnotation instanceof StreamMetaAnnotation) {
            return ((StreamMetaAnnotation)metaAnnotation).m_atomicAnnotation.propagateDependancies(this.m_atomicAnnotation);
        }
        if (metaAnnotation instanceof EmptyStreamMetaAnnotation) {
            return false;
        }
        return this.m_atomicAnnotation.propagateDependancies(metaAnnotation);
    }

    public String toString() {
        return "(StreamAnnot " + this.getVariable() + " base=" + (this.m_base == null ? "null" : this.m_base.getVariable()) + " " + this.m_atomicAnnotation + ")";
    }

    public IAnnotation getAtomicAnnotation() {
        return this.m_atomicAnnotation;
    }

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, ArrayList arrayList) {
        for (IAnnotation iAnnotation : arrayList) {
            while (iAnnotation instanceof ReturnValueMetaAnnotation) {
                iAnnotation = ((ReturnValueMetaAnnotation)iAnnotation).getReturnAnnotation();
            }
            if (iAnnotation instanceof EmptyStreamMetaAnnotation) {
                ((EmptyStreamMetaAnnotation)iAnnotation).define(this);
                continue;
            }
            if (this.equals(iAnnotation)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported " + this + " " + iAnnotation);
        }
        return this;
    }

    @Override
    public Instruction convert(Instruction instruction2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (this.m_base == null && instruction2 instanceof StreamInstruction) {
            return null;
        }
        return super.convert(instruction2, annotationEnvironment, conversionEngine);
    }
}

