/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.BaseAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IConverter;
import com.ibm.xltxe.rnm1.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MetaAnnotation
extends BaseAnnotation
implements IConverter {
    @Override
    public boolean propagateDependancies(IAnnotation iAnnotation) {
        MetaAnnotation metaAnnotation = (MetaAnnotation)iAnnotation;
        if (metaAnnotation.propagateDependanciesTo(this)) {
            this.propagateDependanciesToBase();
            return true;
        }
        return false;
    }

    public boolean propagateDependanciesTo(MetaAnnotation metaAnnotation) {
        return false;
    }

    public abstract void propagateDependanciesToBase();

    @Override
    public IAnnotation getLoopBindingAnnotation() {
        MetaAnnotation metaAnnotation = (MetaAnnotation)this.clonePassthru();
        return metaAnnotation;
    }

    @Override
    public IAnnotation getLoopValueAnnotation() {
        throw new XylemError("ERR_SYSTEM", "!");
    }

    @Override
    public IAnnotation cloneAsFunctionReturn(ArrayList arrayList) {
        return new ReturnValueMetaAnnotation(this, arrayList);
    }

    public abstract boolean equals(Object var1);

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, List list) {
        for (IAnnotation iAnnotation : list) {
            if (this.equals(iAnnotation)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported union " + this + " " + iAnnotation);
        }
        return this;
    }

    @Override
    public void addConversionSupport(Module module) {
    }

    @Override
    public Instruction convert(Instruction instruction2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (instruction2 instanceof IdentifierInstruction) {
            IAnnotation iAnnotation = annotationEnvironment.get(instruction2);
            if (iAnnotation != this) {
                throw new XylemError("ERR_SYSTEM", "?");
            }
            return this.getValueExpression(iAnnotation, conversionEngine);
        }
        return conversionEngine.convertInstructionAsCopy(instruction2);
    }

    public List getIdentifierList(Object object2, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        List list = this.getBindingList(object2, iAnnotation, conversionEngine);
        Iterator iterator = list.iterator();
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(list.size());
        while (iterator.hasNext()) {
            arrayList.add(new IdentifierInstruction(((IBinding)iterator.next()).getName()));
        }
        return arrayList;
    }

    @Override
    public Type getValueType(IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        Binding[] bindingArray = this.getBindingList(iAnnotation.getVariable(), iAnnotation, conversionEngine).toArray(new Binding[0]);
        if (bindingArray.length == 1) {
            return bindingArray[0].getBindingType();
        }
        Type[] typeArray = new Type[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            typeArray[i] = bindingArray[i].getBindingType();
        }
        return new TupleType(typeArray);
    }

    public Instruction getValueExpression(IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        Instruction[] instructionArray = this.getIdentifierList(iAnnotation.getVariable(), iAnnotation, conversionEngine).toArray(new Instruction[0]);
        if (instructionArray.length != 1) {
            return new TupleInstruction(instructionArray);
        }
        return instructionArray[0];
    }

    @Override
    public void preConversion(Program program) {
    }

    protected void insertPassthru(IAnnotation iAnnotation, IAnnotation iAnnotation2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (iAnnotation != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        Iterator iterator = this.getBindingList(iAnnotation2.getVariable(), this, conversionEngine).iterator();
        Iterator iterator2 = this.getBindingList(this.getVariable(), this, conversionEngine).iterator();
        while (iterator.hasNext()) {
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(((IBinding)iterator.next()).getName());
            conversionEngine.insertBinding(((IBinding)iterator2.next()).getName(), identifierInstruction);
        }
    }

    @Override
    public void insertLoopBinding(IAnnotation iAnnotation, IAnnotation iAnnotation2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (iAnnotation2 != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        Iterator iterator = this.getBindingList(iAnnotation.getVariable(), this, conversionEngine).iterator();
        Iterator iterator2 = this.getBindingList(this.getVariable(), this, conversionEngine).iterator();
        while (iterator.hasNext()) {
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(((IBinding)iterator.next()).getName() + "$item");
            conversionEngine.insertBinding(((IBinding)iterator2.next()).getName(), identifierInstruction);
        }
    }

    @Override
    public void insertValueDecomposition(Object object2, IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        IBinding[] iBindingArray = this.getBindingList(iAnnotation.getVariable(), iAnnotation, conversionEngine).toArray(new Binding[0]);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(object2);
        if (iBindingArray.length == 1) {
            conversionEngine.insertBinding(iBindingArray[0].getName(), identifierInstruction);
        } else {
            for (int i = 0; i < iBindingArray.length; ++i) {
                conversionEngine.insertBinding(iBindingArray[i].getName(), new TupleMatchInstruction((Instruction)identifierInstruction, iBindingArray.length, i));
            }
        }
    }
}

