/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;

public class LambdaApplySpec
implements ICallSpec {
    private IAnnotation[] m_paramAnnotations;
    private Binding[] m_lambdaBindings;
    private Instruction m_lambda;
    private String m_identifier;
    private boolean m_isPure;

    public LambdaApplySpec(String string2, Instruction instruction2, IBinding[] iBindingArray, IAnnotation[] iAnnotationArray, boolean bl) {
        this.m_paramAnnotations = iAnnotationArray;
        this.m_lambdaBindings = (Binding[])iBindingArray;
        this.m_lambda = instruction2;
        this.m_identifier = string2;
        if (string2 == null) {
            this.m_identifier = "lambda$" + System.identityHashCode(this.m_lambda);
        }
        this.m_isPure = bl;
    }

    public LambdaApplySpec(String string2, Instruction instruction2, IAnnotation[] iAnnotationArray, boolean bl) {
        this(string2, instruction2, ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(0), iAnnotationArray, bl);
    }

    public LambdaApplySpec(ApplyInstruction applyInstruction, AnnotationEnvironment annotationEnvironment) {
        this("lambda$" + ((IdentifierInstruction)applyInstruction.getLambda()).getVariable(), NavigationUtilities.resolveReducedIdentifier(applyInstruction.getLambda(), annotationEnvironment.getBindingEnvironment()), annotationEnvironment.get(applyInstruction.getOperands()), applyInstruction.isPure());
    }

    public boolean isPure() {
        return this.m_isPure;
    }

    @Override
    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    @Override
    public Binding[] getParamBindings() {
        return this.m_lambdaBindings;
    }

    public Instruction getLambda() {
        return this.m_lambda;
    }

    public String getName() {
        return this.m_identifier;
    }

    @Override
    public IFunctionAnnotationInfo newInfo(AnnotationTable annotationTable, AnnotationEnvironment annotationEnvironment) {
        return new LambdaAnnotationInfo(this, annotationEnvironment);
    }

    @Override
    public boolean equals(Object object2) {
        if (!(object2 instanceof LambdaApplySpec)) {
            return false;
        }
        LambdaApplySpec lambdaApplySpec = (LambdaApplySpec)object2;
        if (this.m_lambda != lambdaApplySpec.m_lambda) {
            return false;
        }
        if (this.getParamAnnotations().length != lambdaApplySpec.getParamAnnotations().length) {
            return false;
        }
        for (int i = 0; i < this.getParamAnnotations().length; ++i) {
            if (!(this.getParamAnnotations()[i] == null ? lambdaApplySpec.getParamAnnotations()[i] != null : !this.getParamAnnotations()[i].equals(lambdaApplySpec.getParamAnnotations()[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.m_lambda);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LAS: " + this.m_identifier);
        stringBuffer.append("(");
        IAnnotation[] iAnnotationArray = this.getParamAnnotations();
        for (int i = 0; i < this.getParamBindings().length; ++i) {
            stringBuffer.append(this.getParamBindings()[i].getName());
            stringBuffer.append("@");
            stringBuffer.append(i < iAnnotationArray.length ? this.getParamAnnotations()[i] + "" : "UNDEF!");
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

