/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionCallStackItem {
    private static final Logger s_logger = LoggerUtil.getLogger(FunctionCallStackItem.class);
    private static final String s_className = FunctionCallStackItem.class.getName();
    private ICallSpec m_fcs;
    private IFunctionAnnotationInfo m_fai;

    public FunctionCallStackItem(ICallSpec iCallSpec, IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        this.m_fai = iFunctionAnnotationInfo;
        this.m_fcs = iCallSpec;
    }

    public String toString() {
        return "FCSI:" + this.m_fai;
    }

    public ICallSpec getCallSpec() {
        return this.m_fcs;
    }

    public IFunctionAnnotationInfo getFunctionInfo() {
        return this.m_fai;
    }

    public static boolean backpatchFunctionCalls(List list) {
        FunctionCallStackItem functionCallStackItem;
        int n2;
        boolean bl = false;
        FunctionCallStackItem functionCallStackItem2 = (FunctionCallStackItem)list.get(list.size() - 1);
        if (list.size() == 1) {
            bl |= functionCallStackItem2.backpatchFunctionCall();
            functionCallStackItem2.m_fai.setComplete();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "backpatchFunctionCalls", "backpatched call " + functionCallStackItem2.m_fai.getFunctionName() + " (non-recursive)");
            }
            return bl;
        }
        if (!functionCallStackItem2.m_fai.equals(((FunctionCallStackItem)list.get((int)0)).m_fai)) {
            throw new XylemError("ERR_SYSTEM", "FCSI looks corrupt (or not ready), top and bottom don't match!\ntop:   " + functionCallStackItem2.m_fai + "\n" + "bottom:" + functionCallStackItem2.m_fai + "\n");
        }
        int n3 = list.size() * 2 + 2;
        int n4 = 0;
        boolean bl2 = false;
        do {
            bl2 = false;
            if (n4++ > n3) {
                throw new Error("recursion won't resolve (" + functionCallStackItem2 + ") limit = " + n3);
            }
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                functionCallStackItem = (FunctionCallStackItem)list.get(n2);
                if (!functionCallStackItem.backpatchFunctionCall()) continue;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "backpatchFunctionCalls", "recursive backpatch caused changes.");
                }
                bl2 = true;
                bl = true;
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "backpatchFunctionCalls", "backpatched call stack " + functionCallStackItem2.m_fai.getFunctionName() + " depth=" + list.size() + " (trial " + n4 + ")");
        } while (bl2);
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            functionCallStackItem = (FunctionCallStackItem)list.get(n2);
            functionCallStackItem.m_fai.setComplete();
        }
        return bl;
    }

    private boolean backpatchFunctionCall() {
        int n2 = this.m_fcs.getParamAnnotations().length;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (this.m_fai.getParamAnnotations()[i] != null) {
                IAnnotation iAnnotation = this.m_fcs.getParamAnnotations()[i];
                IAnnotation iAnnotation2 = this.m_fai.getParamAnnotations()[i];
                if (iAnnotation2 != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "backpatchFunctionCall", " backpatching '" + iAnnotation.getVariable() + "' calls '" + iAnnotation2.getVariable() + "' " + "in " + this.m_fai.getFunctionName() + " call=" + iAnnotation + " param=" + iAnnotation2);
                    }
                    if (!iAnnotation.propagateDependancies(iAnnotation2)) continue;
                    bl = true;
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "backpatchFunctionCall", " there were changes");
                    }
                    if (!iAnnotation.propagateDependancies(iAnnotation2)) continue;
                    throw new Error("non-stabilizing propagation " + iAnnotation2);
                }
                s_logger.logp(Level.SEVERE, s_className, "backpatchFunctionCall", " no annotations to backpatch for param " + i + "'.");
                continue;
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "backpatchFunctionCall", " not backpatching '" + this.m_fcs.getParamBindings()[i].getName() + "'" + "in " + this.m_fai.getFunctionName());
        }
        return bl;
    }
}

