/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;

public class FunctionCallSpec
implements ICallSpec {
    private IAnnotation[] m_paramAnnotations;
    private Function m_function;

    public FunctionCallSpec(FunctionCallInstruction functionCallInstruction, AnnotationEnvironment annotationEnvironment) {
        this.m_function = annotationEnvironment.getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
        if (this.m_function == null) {
            throw new Error("not found: " + functionCallInstruction.getFunction());
        }
        int n2 = functionCallInstruction.getChildInstructionCount();
        this.m_paramAnnotations = new IAnnotation[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_paramAnnotations[i] = annotationEnvironment.get(functionCallInstruction.getChildInstruction(i));
        }
    }

    public FunctionCallSpec(Function function2, IAnnotation[] iAnnotationArray) {
        this.m_paramAnnotations = iAnnotationArray;
        this.m_function = function2;
        if (this.m_paramAnnotations.length != this.m_function.getParameters().length) {
            throw new XylemError("ERR_SYSTEM", "paramAnnotations(" + iAnnotationArray.length + ") != " + "f(" + function2.getParameters().length + ") " + function2.getName());
        }
    }

    public FunctionCallSpec(Function function2) {
        this(function2, new IAnnotation[function2.m_parameters.length]);
    }

    public Function getFunction() {
        return this.m_function;
    }

    @Override
    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    @Override
    public Binding[] getParamBindings() {
        return this.getFunction().getParameters();
    }

    @Override
    public IFunctionAnnotationInfo newInfo(AnnotationTable annotationTable, AnnotationEnvironment annotationEnvironment) {
        return new FunctionAnnotationInfo(this, annotationTable);
    }

    @Override
    public boolean equals(Object object2) {
        if (!(object2 instanceof FunctionCallSpec)) {
            return false;
        }
        FunctionCallSpec functionCallSpec = (FunctionCallSpec)object2;
        if (this.getFunction() != functionCallSpec.getFunction()) {
            return false;
        }
        if (this.getParamAnnotations().length != functionCallSpec.getParamAnnotations().length) {
            return false;
        }
        for (int i = 0; i < this.getParamAnnotations().length; ++i) {
            if (!(this.getParamAnnotations()[i] == null ? functionCallSpec.getParamAnnotations()[i] != null : !this.getParamAnnotations()[i].equals(functionCallSpec.getParamAnnotations()[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getFunction().hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FCS: " + this.m_function.getName());
        stringBuffer.append("(");
        Binding[] bindingArray = this.getFunction().m_parameters;
        IAnnotation[] iAnnotationArray = this.getParamAnnotations();
        for (int i = 0; i < bindingArray.length; ++i) {
            stringBuffer.append(bindingArray[i]);
            stringBuffer.append("@");
            stringBuffer.append(i < iAnnotationArray.length ? this.getParamAnnotations()[i] + "" : "UNDEF!");
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

