/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotator;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IConverter;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaApplySpec;
import com.ibm.xltxe.rnm1.xylem.annot.NullAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.PedanticAnormalForm;
import com.ibm.xltxe.rnm1.xylem.annot.RecursiveADTStreamAppendInstruction;
import com.ibm.xltxe.rnm1.xylem.annot.meta.EmptyStreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.LambdaMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.TupleMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConversionEngine {
    private static final boolean DENNIS_PARALLEL = false;
    private static final Logger s_logger = LoggerUtil.getLogger(ConversionEngine.class);
    private static final String s_className = ConversionEngine.class.getName();
    public static final boolean DEBUG_TYPE_CHECK = false;
    public static final String ITEM_SUFFIX = "$item";
    public static final String ITEM_INDEX_SUFFIX = "$index";
    private LetChainBuilder m_lcb = new LetChainBuilder();
    private Map m_convertedLambdas;
    private AnnotationEnvironment m_environment;
    private IConverter m_converter;
    private Module m_module;
    private ArrayList m_functionsToTypeCheck = new ArrayList();
    private ArrayList m_functionsToConvert = new ArrayList();

    public static Function analyzeAndConvert(String string2, Program program, Function function2, IAnnotator iAnnotator, boolean bl) {
        try {
            try {
                if (bl) {
                    Program.dumpXylemFile(program, null, string2 + ".original");
                }
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", exception);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "converting to pedantic anormal");
            }
            program.optimize(new PedanticAnormalForm());
            program.typeCheckReduced();
            try {
                if (bl) {
                    Program.dumpXylemFile(program, null, string2 + ".pedantic");
                }
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", exception);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "applying pre-analysis methods");
            }
            iAnnotator.preAnalysis(program);
            try {
                if (bl) {
                    Program.dumpXylemFile(program, null, string2 + ".pre_analysis");
                }
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", exception);
                exception.printStackTrace();
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "clearing type info");
            }
            program.clearTypeInformation(true);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "type checking");
            }
            program.typeCheckReduced();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "instantiating reduced");
            }
            program.instantiateReducedPolymorphicFunctions();
        }
        catch (TypeCheckException typeCheckException) {
            s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "error type-checking pre-conversion form", typeCheckException);
            throw new RuntimeException();
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "analyzing code with " + iAnnotator);
        }
        AnnotationTable annotationTable = AnnotationTable.analyzeProgram(program, function2, iAnnotator);
        IConverter iConverter = iAnnotator.getConverter();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "converting code with " + iConverter);
        }
        iConverter.preConversion(program);
        ConversionEngine.convertEntryPoints(program, annotationTable, iConverter);
        try {
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".converted");
            }
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", exception);
        }
        try {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "type checking converted code");
            }
            function2.typeCheckReduced(program, new LinkedList());
            ModuleLinker.reflattenModules(program);
            program.typeCheckReduced();
            program.instantiateReducedPolymorphicFunctions();
            program.typeCheckReduced();
            function2.typeCheckReduced(program, new LinkedList());
            int n2 = 0;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".optimized." + n2++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".optimized." + n2++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".optimized." + n2++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            program.removeDeadFunctions();
            program.typeCheckReduced();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".optimized." + n2++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            program.removeDeadFunctions();
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".optimized." + n2++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + n2);
            }
            new PolymorphicADTDesugarer(program).desugar();
            if (bl) {
                Program.dumpXylemFile(program, null, string2 + ".optimized." + n2++);
            }
        }
        catch (Throwable throwable) {
            s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "error optimizing converted code (dumping program to " + string2 + ".exception.xylem)", throwable);
            Program.dumpXylemFile(program, null, string2 + ".exception");
            throw new XylemError("ERR_SYSTEM", "error optimizing converted code");
        }
        return null;
    }

    private static void convertEntryPoints(Module module, AnnotationTable annotationTable, IConverter iConverter) {
        ConversionEngine conversionEngine = new ConversionEngine(iConverter, module);
        FunctionAnnotationInfo[] functionAnnotationInfoArray = annotationTable.getEntryPoints();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "convertEntryPoints", "converting " + functionAnnotationInfoArray.length + " entry points");
        }
        conversionEngine.m_functionsToConvert.addAll(Arrays.asList(functionAnnotationInfoArray));
        while (!conversionEngine.m_functionsToConvert.isEmpty()) {
            FunctionAnnotationInfo functionAnnotationInfo = (FunctionAnnotationInfo)conversionEngine.m_functionsToConvert.remove(conversionEngine.m_functionsToConvert.size() - 1);
            conversionEngine.convertFunctionBody(functionAnnotationInfo);
        }
    }

    private void reduceFunction(Function function2) {
        Instruction instruction2;
        Instruction instruction3 = instruction2 = function2.getBody();
        function2.setBody(instruction2);
        try {
            ReducedForm.reduceFunction(function2);
        }
        catch (Exception exception) {
            function2.setComment(function2.getComment() + "\n" + exception);
            s_logger.logp(Level.SEVERE, s_className, "reduceFunction", "converted code did not reduce. See output in function.xylem", exception);
            function2.setBody(instruction3);
            Program.dumpXylemFunctions(new Function[]{function2}, new File("."), "function");
            Program.dumpXylemFile(this.m_module, new File("."), "program");
            throw new Error("died");
        }
    }

    private void convertEntryPoint(FunctionAnnotationInfo functionAnnotationInfo) {
        Function function2 = functionAnnotationInfo.getFunction();
        Map map2 = this.m_convertedLambdas;
        this.m_environment = functionAnnotationInfo.getEnvironment();
        this.m_convertedLambdas = new HashMap();
        function2.setBody(this.convertInstruction(function2.getBody()));
        this.reduceFunction(function2);
        try {
            function2.clearTypeInformation(true);
            function2.typeCheckReduced(this.m_module, new LinkedList());
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "convertEntryPoint", "function " + function2.getName() + " did not typeCheck", exception);
            throw new RuntimeException();
        }
        this.m_convertedLambdas = map2;
        this.m_environment = null;
    }

    private ConversionEngine(IConverter iConverter, Module module) {
        this.m_converter = iConverter;
        this.m_module = module;
    }

    public static Object generateIdentifier(Object object2, Object object3) {
        return object2.toString() + "_" + object3.toString();
    }

    public void insertBinding(Object object2, Instruction instruction2) {
        while (instruction2 instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction2;
            this.m_lcb.bind(letInstruction.getVariable(), letInstruction.getValue(), true);
            instruction2 = letInstruction.getBody();
        }
        this.m_lcb.bind(object2, instruction2, true);
    }

    public LetChainBuilder getLetChainBuilder() {
        return this.m_lcb;
    }

    private Function convert(FunctionAnnotationInfo functionAnnotationInfo) {
        Object object2;
        Function function2 = functionAnnotationInfo.getFunction();
        if (!functionAnnotationInfo.isCallAnnotated()) {
            return function2;
        }
        Function function3 = function2.lookupDerivative(functionAnnotationInfo.getSpec());
        if (function3 != null) {
            return function3;
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convert", "converting " + functionAnnotationInfo);
            try {
                object2 = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object2);
                new Error().printStackTrace(printStream);
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(((ByteArrayOutputStream)object2).toString()));
                while (streamTokenizer.nextToken() != -1) {
                }
                s_logger.logp(Level.FINER, s_className, "convert", "stack-depth=" + streamTokenizer.lineno());
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "convert", "", exception);
            }
        }
        object2 = function2.cloneFunctionForFixup(functionAnnotationInfo.getSpec(), false, false, true);
        ((Function)object2).setReturnType(this.convertReturnType(functionAnnotationInfo));
        int n2 = function2.m_parameters.length;
        ((Function)object2).m_parameters = this.convertParamBindings(functionAnnotationInfo);
        this.m_module.addFunction((Function)object2);
        this.m_functionsToConvert.add(functionAnnotationInfo);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convert", "created fixup '" + ((Function)object2).getName() + "' for " + functionAnnotationInfo);
        }
        return object2;
    }

    private void convertFunctionBody(FunctionAnnotationInfo functionAnnotationInfo) {
        Function function2 = functionAnnotationInfo.getFunction();
        final Function function3 = functionAnnotationInfo.isCallAnnotated() ? function2.lookupDerivative(functionAnnotationInfo.getSpec()) : function2;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertFunctionBody", "converting body of '" + function3.getName() + "' for " + functionAnnotationInfo);
        }
        this.m_environment = functionAnnotationInfo.getEnvironment();
        this.m_environment.debug();
        this.m_convertedLambdas = new HashMap();
        Instruction instruction2 = this.convertInstruction(function2.getBody());
        if (function2.getMemoizeResult()) {
            instruction2 = new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction instruction2) {
                    if (instruction2 instanceof MatchInstruction || instruction2 instanceof ForEachInstruction || instruction2 instanceof ParallelForEachInstruction) {
                        function3.setMemoizeResult(true);
                    }
                    return instruction2;
                }
            }.optimize(instruction2);
        }
        function3.setBody(instruction2);
        this.reduceFunction(function3);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertFunctionBody", "finished converting body of '" + function3.getName() + "' for " + functionAnnotationInfo);
        }
    }

    public Instruction convertInstruction(Instruction instruction2) {
        LetChainBuilder letChainBuilder = this.m_lcb;
        this.m_lcb = new LetChainBuilder();
        instruction2 = (instruction2 = this.convertNonLet(this.convertLets(instruction2), this.m_converter)) != null ? this.m_lcb.packageUp(instruction2) : this.m_lcb.packageUp(StreamInstruction.charStreamLiteral("dead-code"));
        this.m_lcb = letChainBuilder;
        return instruction2;
    }

    private Instruction convertNonLet(Instruction instruction2, IConverter iConverter) {
        IAnnotation iAnnotation;
        if (instruction2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            FunctionCallSpec functionCallSpec = new FunctionCallSpec(functionCallInstruction, this.m_environment);
            Object[] objectArray = new Object[functionCallInstruction.m_parameters.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Instruction instruction3 = functionCallInstruction.m_parameters[i];
                if (!(instruction3 instanceof IdentifierInstruction)) continue;
                objectArray[i] = ((IdentifierInstruction)instruction3).getVariable();
            }
            return this.convertFunctionCall(functionCallSpec, objectArray, functionCallInstruction.m_parameters);
        }
        if (instruction2 instanceof AutomatonInstruction) {
            return this.convertAutomaton((AutomatonInstruction)instruction2);
        }
        if (instruction2 instanceof ForEachInstruction) {
            return this.convertForEach((ForEachInstruction)instruction2);
        }
        if (instruction2 instanceof TestStreamInstruction) {
            return this.convertTestStream((TestStreamInstruction)instruction2);
        }
        if (instruction2 instanceof MatchInstruction) {
            return this.convertMatch((MatchInstruction)instruction2);
        }
        instruction2 = instruction2 instanceof ApplyInstruction ? this.convertLambdaApplication((ApplyInstruction)instruction2) : (instruction2 instanceof IdentifierInstruction ? ((iAnnotation = this.m_environment.get(instruction2)) instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).convert(instruction2, this.m_environment, this) : iConverter.convert(instruction2, this.m_environment, this)) : iConverter.convert(instruction2, this.m_environment, this));
        return instruction2;
    }

    public Instruction convertInstructionAsCopy(Instruction instruction2) {
        Instruction instruction3 = instruction2.cloneShallow();
        int n2 = instruction2.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction4 = instruction2.getChildInstruction(i);
            instruction4 = instruction4 instanceof LetInstruction ? this.convertInstruction(instruction4) : this.convertNonLet(instruction4, this.m_converter);
            instruction3.setChildInstruction(i, instruction4);
        }
        return instruction3;
    }

    private Instruction convertMatch(MatchInstruction matchInstruction) {
        Instruction instruction2 = matchInstruction.getToMatch();
        IAnnotation iAnnotation = this.m_environment.get(instruction2);
        if (iAnnotation instanceof TupleMetaAnnotation) {
            MatchInstruction.DeconstructionMatch deconstructionMatch = (MatchInstruction.DeconstructionMatch)matchInstruction.getMatches()[0];
            for (int i = 0; i < deconstructionMatch.getBindings().length; ++i) {
                ((TupleMetaAnnotation)iAnnotation).insertMatchOperation(i, deconstructionMatch.getBindings()[i], this.m_environment, this);
            }
            return this.convertLets(deconstructionMatch.getHandler());
        }
        if (matchInstruction.getMatches()[0] instanceof MatchInstruction.LiteralMatch && iAnnotation == null) {
            Set set2 = this.m_environment.getComputedLiteral(instruction2);
            ArrayList<MatchInstruction.LiteralMatch> arrayList = new ArrayList<MatchInstruction.LiteralMatch>();
            if (set2 != null) {
                Object object2;
                Iterator iterator = set2.iterator();
                Instruction instruction3 = null;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2);
                }
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    object2 = matchInstruction.getMatches();
                    int n2 = 0;
                    for (n2 = 0; n2 < ((MatchInstruction.Match[])object2).length; ++n2) {
                        LiteralInstruction literalInstruction = ((MatchInstruction.LiteralMatch)object2[n2]).getLiteral();
                        if (!literalInstruction.getValue().equals(e)) continue;
                        Instruction instruction4 = object2[n2].getHandler();
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2 + " for literal " + e);
                        }
                        instruction4 = this.convertInstruction(instruction4);
                        arrayList.add(new MatchInstruction.LiteralMatch(literalInstruction, instruction4));
                        break;
                    }
                    if (n2 != ((MatchInstruction.Match[])object2).length || instruction3 != null) continue;
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2 + " for default");
                    }
                    instruction3 = this.convertInstruction(matchInstruction.getDefault());
                }
                int n3 = arrayList.size();
                if (instruction3 != null) {
                    ++n3;
                }
                if (n3 == 0) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2 + " : no case matches replacing with HCFI.");
                    }
                    return Instruction.shouldNeverReach(matchInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
                }
                if (n3 == 1 && instruction3 == null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2 + " : one case matches.");
                    }
                    return ((MatchInstruction.Match)arrayList.get(0)).getHandler();
                }
                if (n3 == 1 && instruction3 != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2 + " : default case matches.");
                    }
                    return instruction3;
                }
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + instruction2 + " : " + n3 + " cases match.");
                }
                object2 = this.convertNonLet(instruction2, this.m_converter);
                object2 = new MatchInstruction(instruction2, arrayList.toArray(new MatchInstruction.Match[0]), instruction3);
                return object2;
            }
        }
        return this.convertInstructionAsCopy(matchInstruction);
    }

    private Instruction convertForEach(ForEachInstruction forEachInstruction) {
        Type type2;
        IAnnotation iAnnotation = this.m_environment.get(forEachInstruction.getSource());
        Object object2 = forEachInstruction.getVarName();
        IAnnotation iAnnotation2 = this.m_environment.get(object2);
        if (iAnnotation == null || iAnnotation2 == null) {
            return this.convertInstructionAsCopy(forEachInstruction);
        }
        Instruction instruction2 = NavigationUtilities.skipLets(forEachInstruction.getBody());
        IAnnotation iAnnotation3 = this.m_environment.get(instruction2);
        Instruction instruction3 = this.convertInstruction(forEachInstruction.getBody());
        instruction3 = this.insertLoopBindingAnnotationOperation(instruction3, iAnnotation, iAnnotation2);
        List list = iAnnotation instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this) : this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this);
        if (list == null) {
            throw new XylemError("ERR_SYSTEM", " illegal null bindings in " + iAnnotation);
        }
        List list2 = null;
        if (iAnnotation3 instanceof MetaAnnotation) {
            list2 = ((MetaAnnotation)iAnnotation3).getBindingList(iAnnotation3.getVariable(), iAnnotation3, this);
        } else if (iAnnotation3 != null) {
            list2 = this.m_converter.getBindingList(iAnnotation3.getVariable(), iAnnotation3, this);
        }
        if (list.size() == 0) {
            Type type3;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + forEachInstruction.getSource() + " converts to empty");
            }
            if ((type3 = forEachInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment())) == null) {
                throw new XylemError("ERR_SYSTEM", "type null for " + forEachInstruction);
            }
            return new StreamInstruction(((StreamType)type3).getElementType());
        }
        String string2 = iAnnotation.getVariable() + ITEM_INDEX_SUFFIX;
        if (forEachInstruction.getIndexVar() != null) {
            instruction3 = new LetInstruction(forEachInstruction.getIndexVar(), new IdentifierInstruction(string2), instruction3);
        }
        if ((type2 = ((Binding)list.get(0)).getBindingType()) instanceof ICollectionType) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + forEachInstruction.getSource() + " converts to streams");
            }
            instruction3 = this.convertForeachOnStreams(iAnnotation.getVariable(), list, instruction3, list2);
        } else if (this.isLambdaIterator(list)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + forEachInstruction.getSource() + " converts to lambda-iterator");
            }
            Type type4 = this.convertType(iAnnotation3, forEachInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
            instruction3 = this.convertForeachOnLambdaIterator(type4, iAnnotation.getVariable(), list, instruction3, list2);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + forEachInstruction.getSource() + " converts to atomic");
            }
            this.insertBinding(string2, LiteralInstruction.integerLiteral(0));
            instruction3 = this.convertLoopAtomics(list, instruction3);
        }
        return instruction3;
    }

    private Instruction convertLoopAtomics(List list, Instruction instruction2) {
        for (IBinding iBinding : list) {
            instruction2 = new LetInstruction(iBinding.getName() + ITEM_SUFFIX, new IdentifierInstruction(iBinding.getName()), instruction2);
        }
        return instruction2;
    }

    private Instruction convertForeachOnStreams(Object object2, List list, Instruction instruction2, List list2) {
        IBinding iBinding = (IBinding)list.get(0);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
        String string2 = iBinding.getName() + ITEM_SUFFIX;
        String string3 = object2 + ITEM_INDEX_SUFFIX;
        if (list2 != null && list2.size() > 1) {
            instruction2 = this.convertLoopBodyOnStreams(string3, Collections.EMPTY_LIST, instruction2);
            Binding[] bindingArray = list.toArray(new Binding[0]);
            Object[] objectArray = new Object[bindingArray.length];
            Instruction[] instructionArray = new Instruction[bindingArray.length];
            for (int i = 0; i < bindingArray.length; ++i) {
                instructionArray[i] = new IdentifierInstruction(bindingArray[i].getName());
                objectArray[i] = bindingArray[i].getName() + ITEM_SUFFIX;
            }
            ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(instructionArray, objectArray, instruction2);
            parallelForEachInstruction.setIndexVar(string3);
            return parallelForEachInstruction;
        }
        instruction2 = this.convertLoopBodyOnStreams(string3, list.subList(1, list.size()), instruction2);
        return new ForEachInstruction((Instruction)identifierInstruction, (Object)string2, string3, instruction2);
    }

    private void convertAutomatonOtherwiseOnStreams(AutomatonInstruction automatonInstruction, Object object2, List list, Instruction instruction2) {
        IBinding iBinding = (IBinding)list.get(0);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
        String string2 = iBinding.getName() + ITEM_SUFFIX;
        String string3 = object2 + ITEM_INDEX_SUFFIX;
        instruction2 = this.convertLoopBodyOnStreams(string3, list.subList(1, list.size()), instruction2);
        automatonInstruction.setSource(identifierInstruction);
        automatonInstruction.setDefaultHandler(instruction2);
        automatonInstruction.getDefaultElementBinding().setName(string2);
        if (automatonInstruction.getLoopIndexBinding() != null) {
            automatonInstruction.getLoopIndexBinding().setName(string3);
        } else {
            automatonInstruction.setLoopIndexVar(string3);
        }
    }

    private Instruction convertLoopBodyOnStreams(Object object2, List list, Instruction instruction2) {
        Object object32;
        LinkedList<IdentifierInstruction> linkedList = new LinkedList<IdentifierInstruction>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<IBinding> linkedList3 = new LinkedList<IBinding>();
        for (Object object32 : list) {
            if (object32.getBindingType() instanceof ICollectionType) {
                linkedList.add(new IdentifierInstruction(object32.getName()));
                linkedList2.add(object32.getName() + ITEM_SUFFIX);
                continue;
            }
            linkedList3.add((IBinding)object32);
        }
        instruction2 = this.convertLoopAtomics(linkedList3, instruction2);
        Iterator iterator = linkedList.iterator();
        object32 = linkedList2.iterator();
        while (iterator.hasNext()) {
            Object e = object32.next();
            Instruction instruction3 = (Instruction)iterator.next();
            instruction2 = new LetInstruction(e, new StreamElementInstruction(instruction3, new IdentifierInstruction(object2)), instruction2);
        }
        return instruction2;
    }

    private boolean isLambdaIterator(List list) {
        if (list.size() < 3) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: <3 bindings.");
            }
            return false;
        }
        Type type2 = ((IBinding)list.get(2)).getBindingType();
        IBinding iBinding = (IBinding)list.get(0);
        if (!(iBinding.getBindingType() instanceof LambdaType)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + iBinding + " != lambda.");
            }
            return false;
        }
        LambdaType lambdaType = (LambdaType)iBinding.getBindingType();
        if (lambdaType.getElementTypes().length != 1 || !lambdaType.getReturnType().equals(BooleanType.s_booleanType) || !type2.equals(lambdaType.getElementTypes()[0])) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + lambdaType + " != (-> (state) boolean).");
            }
            return false;
        }
        IBinding iBinding2 = (IBinding)list.get(1);
        if (!(iBinding2.getBindingType() instanceof LambdaType)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + iBinding + " != lambda.");
            }
            return false;
        }
        LambdaType lambdaType2 = (LambdaType)iBinding2.getBindingType();
        if (lambdaType2.getElementTypes().length != 1 || !lambdaType2.getReturnType().equals(type2) || !type2.equals(lambdaType2.getElementTypes()[0])) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + lambdaType2 + " != (-> (state) state).");
            }
            return false;
        }
        return true;
    }

    private Instruction convertForeachOnLambdaIterator(Type type2, Object object2, List list, Instruction instruction2, List list2) {
        Object object3;
        int n2;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        List list3 = list.subList(3, list.size());
        instruction2 = this.convertLoopAtomics(list3, instruction2);
        Type type3 = ((IBinding)list.get(2)).getBindingType();
        IBinding iBinding = (IBinding)list.get(0);
        IBinding iBinding2 = (IBinding)list.get(1);
        IBinding iBinding3 = (IBinding)list.get(2);
        String string2 = "$next";
        String string3 = iBinding3.getName() + ITEM_SUFFIX;
        String string4 = string3 + string2;
        String string5 = object2 + ITEM_INDEX_SUFFIX;
        String string6 = string5 + string2;
        Set<Object> set2 = FindFreeVariables.findFreeVariables(instruction2);
        boolean bl = set2.remove(string5);
        set2.remove(string3);
        set2.remove(iBinding.getName());
        set2.remove(iBinding2.getName());
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>(set2.size() + 4);
        ArrayList<IdentifierInstruction> arrayList2 = new ArrayList<IdentifierInstruction>(set2.size() + 4);
        arrayList.add(new Binding((Object)string3, type3));
        arrayList2.add(new IdentifierInstruction(string4));
        arrayList.add(iBinding);
        arrayList2.add(new IdentifierInstruction(iBinding.getName()));
        arrayList.add(iBinding2);
        arrayList2.add(new IdentifierInstruction(iBinding2.getName()));
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (list2 != null && list2.size() > 1) {
            stringArray = new String[list2.size()];
            stringArray2 = new String[list2.size()];
            Iterator<Object> iterator = list2.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                object7 = (Binding)iterator.next();
                stringArray[n3] = "head" + n3;
                stringArray2[n3] = stringArray[n3] + string2;
                object6 = ((Binding)object7).getBindingType() instanceof StreamType ? ((Binding)object7).getBindingType() : ((Binding)object7).getBindingType().getStreamType();
                arrayList.add(new Binding((Object)stringArray[n3], (Type)object6));
                arrayList2.add(new IdentifierInstruction(stringArray2[n3]));
                ++n3;
            }
        }
        if (bl) {
            arrayList.add(new Binding((Object)string5, IntType.s_intType));
            arrayList2.add(new IdentifierInstruction(string6));
        }
        for (Object object8 : set2) {
            object7 = new Binding(object8);
            arrayList.add((IBinding)object7);
            arrayList2.add(new IdentifierInstruction(object8));
        }
        String string7 = "foreachFunction$" + object2 + "$" + ReductionHelper.generateIntermediateIdentifier2();
        object7 = object2 + "$body";
        object6 = object2 + "$isEmpty";
        Instruction instruction3 = new FunctionCallInstruction(string7, arrayList2);
        if (list2 == null || list2.size() <= 1) {
            instruction3 = new StreamInstruction(((ICollectionType)((Object)type2)).getElementType(), new Instruction[]{new IdentifierInstruction(object7), instruction3});
        } else {
            object5 = new Object[list2.size()];
            object4 = list2.iterator();
            n2 = 0;
            while (object4.hasNext()) {
                object3 = (Binding)object4.next();
                object5[n2] = "body" + n2;
                Type type4 = ((Binding)object3).getBindingType();
                if (type4 instanceof StreamType) {
                    type4 = ((StreamType)type4).getElementType();
                }
                instruction3 = new LetInstruction(stringArray2[n2], new StreamInstruction(type4, new Instruction[]{new IdentifierInstruction(stringArray[n2]), new IdentifierInstruction(object5[n2])}), instruction3);
                ++n2;
            }
            instruction3 = new TupleMatchInstruction((Instruction)new IdentifierInstruction((String)object7 + "$2"), (Object[])object5, instruction3);
        }
        if (list2 != null && list2.size() > 1) {
            instruction3 = new LetInstruction((String)object7 + "$2", new AssertTypeInstruction(new IdentifierInstruction(object7), type2), instruction3);
        }
        instruction3 = new LetInstruction(object7, instruction2, instruction3);
        if (bl) {
            instruction3 = new LetInstruction(string6, new PrimitiveArithmeticInstruction(new IdentifierInstruction(string5), LiteralInstruction.integerLiteral(1), 0), instruction3);
        }
        object5 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding2.getName()), new Instruction[]{new IdentifierInstruction(string3)}, true);
        instruction3 = new LetInstruction(string4, (Instruction)object5, instruction3);
        if (list2 == null || list2.size() <= 1) {
            instruction3 = new ChooseInstruction(new IdentifierInstruction(object6), (Instruction)new StreamInstruction(((ICollectionType)((Object)type2)).getElementType()), instruction3);
        } else {
            object4 = new Instruction[stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object4[n2] = new IdentifierInstruction(stringArray[n2]);
            }
            instruction3 = new ChooseInstruction(new IdentifierInstruction(object6), (Instruction)new TupleInstruction((Instruction[])object4), instruction3);
        }
        object4 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding.getName()), new Instruction[]{new IdentifierInstruction(string3)}, true);
        instruction3 = new LetInstruction(object6, (Instruction)object4, instruction3);
        Function function2 = new Function(string7, arrayList.toArray(new Binding[0]), instruction3);
        this.m_module.addFunction(function2);
        function2.setReturnType(type2);
        this.reduceFunction(function2);
        this.insertBinding(string4, new IdentifierInstruction(iBinding3.getName()));
        if (list2 != null && list2.size() > 1) {
            object3 = list2.iterator();
            int n4 = 0;
            while (object3.hasNext()) {
                Binding binding = (Binding)object3.next();
                Type type5 = binding.getBindingType();
                if (binding.getBindingType() instanceof StreamType) {
                    type5 = ((StreamType)type5).getElementType();
                }
                this.insertBinding(stringArray2[n4++], new StreamInstruction(type5));
            }
        }
        if (bl) {
            this.insertBinding(string6, LiteralInstruction.integerLiteral(0));
        }
        return new FunctionCallInstruction(string7, arrayList2);
    }

    private Instruction convertAutomatonOnLambdaIterator(AutomatonInstruction automatonInstruction, Object object2, List list, Instruction instruction2) {
        Object object3;
        Object object42;
        Instruction instruction3 = automatonInstruction.getInitialState();
        Object object5 = automatonInstruction.getDefaultStateBinding().getName();
        AbstractDataType.Constructor constructor = automatonInstruction.getStateComboConstructor(this.m_environment.getTypeEnvironment());
        List list2 = list.subList(3, list.size());
        instruction2 = this.convertLoopAtomics(list2, instruction2);
        Type type2 = automatonInstruction.getResultElementType(this.m_environment.getTypeEnvironment());
        Type type3 = ((IBinding)list.get(2)).getBindingType();
        IBinding iBinding = (IBinding)list.get(0);
        IBinding iBinding2 = (IBinding)list.get(1);
        IBinding iBinding3 = (IBinding)list.get(2);
        String string2 = iBinding3.getName() + ITEM_SUFFIX;
        String string3 = object2 + ITEM_INDEX_SUFFIX;
        String string4 = "$next";
        String string5 = string2 + string4;
        String string6 = string3 + string4;
        String string7 = object5 + string4;
        String string8 = "automatonFunction" + object2 + "$" + ReductionHelper.generateIntermediateIdentifier2();
        String string9 = object2 + "$bodyCombo";
        String string10 = object2 + "$bodyValue";
        String string11 = object2 + "$isEmpty";
        Set<Object> set2 = FindFreeVariables.findFreeVariables(instruction2);
        boolean bl = set2.remove(string3);
        set2.remove(string2);
        set2.remove(iBinding.getName());
        set2.remove(iBinding2.getName());
        set2.remove(object5);
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>(set2.size() + 4);
        ArrayList<IdentifierInstruction> arrayList2 = new ArrayList<IdentifierInstruction>(set2.size() + 4);
        arrayList.add(new Binding((Object)string2, type3));
        arrayList2.add(new IdentifierInstruction(string5));
        arrayList.add(iBinding);
        arrayList2.add(new IdentifierInstruction(iBinding.getName()));
        arrayList.add(iBinding2);
        arrayList2.add(new IdentifierInstruction(iBinding2.getName()));
        arrayList.add(new Binding(object5, IntType.s_intType));
        arrayList2.add(new IdentifierInstruction(string7));
        if (bl) {
            arrayList.add(new Binding((Object)string3, IntType.s_intType));
            arrayList2.add(new IdentifierInstruction(string6));
        }
        for (Object object42 : set2) {
            object3 = new Binding(object42);
            arrayList.add((IBinding)object3);
            arrayList2.add(new IdentifierInstruction(object42));
        }
        object42 = null;
        object42 = automatonInstruction.getWrapResult() ? new RecursiveADTStreamAppendInstruction(new FunctionCallInstruction(string8, arrayList2), new IdentifierInstruction(string10 + "$2")) : new StreamInstruction(type2, new Instruction[]{new IdentifierInstruction(string10 + "$2"), new FunctionCallInstruction(string8, arrayList2)});
        object42 = new LetInstruction(string10 + "$2", new AssertTypeInstruction(new IdentifierInstruction(string10), type2.getStreamType()), (Instruction)object42);
        object3 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding2.getName()), new Instruction[]{new IdentifierInstruction(string2)}, true);
        object42 = new LetInstruction(string5, (Instruction)object3, (Instruction)object42);
        object42 = new LetInstruction(string10, new MatchInstruction((Instruction)new IdentifierInstruction(string9), constructor, 0), (Instruction)object42);
        object42 = new LetInstruction(string7, new MatchInstruction((Instruction)new IdentifierInstruction(string9), constructor, 1), (Instruction)object42);
        object42 = new LetInstruction(string9, new AssertTypeInstruction(new IdentifierInstruction(string9 + "$2"), automatonInstruction.getStateComboType()), (Instruction)object42);
        object42 = new LetInstruction(string9 + "$2", instruction2, (Instruction)object42);
        if (bl) {
            object42 = new LetInstruction(string6, new PrimitiveArithmeticInstruction(new IdentifierInstruction(string3), LiteralInstruction.integerLiteral(1), 0), (Instruction)object42);
        }
        Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
        Instruction instruction4 = new IdentifierInstruction(n2);
        if (automatonInstruction.getWrapResult()) {
            instruction4 = new ConstructorInstantiationInstruction(constructor, new Instruction[]{instruction4, new IdentifierInstruction(object5)});
        }
        object42 = new ChooseInstruction(new IdentifierInstruction(string11), instruction4, (Instruction)object42);
        object42 = new LetInstruction(n2, new StreamInstruction(type2), (Instruction)object42);
        ApplyInstruction applyInstruction = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding.getName()), new Instruction[]{new IdentifierInstruction(string2)}, true);
        object42 = new LetInstruction(string11, applyInstruction, (Instruction)object42);
        Function function2 = new Function(string8, arrayList.toArray(new Binding[0]), (Instruction)object42);
        if (automatonInstruction.getWrapResult()) {
            function2.setReturnType(automatonInstruction.getStateComboType());
        } else {
            function2.setReturnType(type2.getStreamType());
        }
        this.m_module.addFunction(function2);
        this.reduceFunction(function2);
        this.insertBinding(string5, new IdentifierInstruction(iBinding3.getName()));
        this.insertBinding(string7, instruction3);
        if (bl) {
            this.insertBinding(string6, LiteralInstruction.integerLiteral(0));
        }
        return new FunctionCallInstruction(string8, arrayList2);
    }

    private Instruction convertAutomaton(AutomatonInstruction automatonInstruction) {
        IAnnotation iAnnotation = this.m_environment.get(automatonInstruction.getSource());
        if (iAnnotation == null || iAnnotation instanceof EmptyStreamMetaAnnotation && ((EmptyStreamMetaAnnotation)iAnnotation).getAtomicModel() == null) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "not converting automaton on " + automatonInstruction.getSource());
            }
            return this.convertInstructionAsCopy(automatonInstruction);
        }
        if (automatonInstruction.getDefaultHandler() == null || automatonInstruction.m_matches.length != 0) {
            throw new Error("not yet supported! " + automatonInstruction);
        }
        IAnnotation iAnnotation2 = this.m_environment.get(automatonInstruction.getDefaultElementBinding().getName());
        if (iAnnotation2 == null) {
            return this.convertInstructionAsCopy(automatonInstruction);
        }
        Instruction instruction2 = this.convertInstruction(automatonInstruction.getDefaultHandler());
        instruction2 = this.insertLoopBindingAnnotationOperation(instruction2, iAnnotation, iAnnotation2);
        List list = iAnnotation instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this) : this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this);
        AbstractDataType.Constructor constructor = automatonInstruction.getStateComboConstructor(this.m_environment.getTypeEnvironment());
        if (list.size() == 0) {
            TypeEnvironment typeEnvironment;
            Type type2;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton on " + automatonInstruction.getSource() + " converts to empty");
            }
            if ((type2 = automatonInstruction.getResultElementType(typeEnvironment = this.m_environment.getTypeEnvironment())) == null) {
                throw new XylemError("ERR_SYSTEM", "type null for " + automatonInstruction);
            }
            Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
            this.insertBinding(n2, new StreamInstruction(type2));
            if (automatonInstruction.getWrapResult()) {
                Instruction instruction3 = automatonInstruction.getInitialState().cloneShallow();
                IdentifierInstruction identifierInstruction = new IdentifierInstruction(n2);
                n2 = ReductionHelper.generateIntermediateIdentifier2();
                this.insertBinding(n2, new ConstructorInstantiationInstruction(constructor, new Instruction[]{identifierInstruction, instruction3}));
            }
            return new IdentifierInstruction(n2);
        }
        String string2 = iAnnotation.getVariable() + ITEM_INDEX_SUFFIX;
        if (automatonInstruction.getLoopIndexBinding() != null) {
            instruction2 = new LetInstruction(automatonInstruction.getLoopIndexBinding().getName(), new IdentifierInstruction(string2), instruction2);
        }
        AutomatonInstruction automatonInstruction2 = (AutomatonInstruction)automatonInstruction.cloneShallow();
        Type type3 = ((Binding)list.get(0)).getBindingType();
        if (type3 instanceof ICollectionType) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton otherwise " + automatonInstruction.getDefaultElementBinding().getName() + " converts to streams " + list.get(0));
            }
            this.convertAutomatonOtherwiseOnStreams(automatonInstruction2, iAnnotation.getVariable(), list, instruction2);
            instruction2 = automatonInstruction2;
        } else if (this.isLambdaIterator(list)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton otherwise " + automatonInstruction.getDefaultElementBinding().getName() + " converts to lambda " + list.get(0));
            }
            instruction2 = this.convertAutomatonOnLambdaIterator(automatonInstruction2, iAnnotation.getVariable(), list, instruction2);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton on " + automatonInstruction.getSource() + " converts to atomic " + list.get(0));
            }
            this.insertBinding(automatonInstruction.getDefaultStateBinding().getName(), automatonInstruction.getInitialState());
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton otherwise " + automatonInstruction.getDefaultElementBinding().getName() + " converts to atomic " + list.get(0));
            }
            this.insertBinding(string2, LiteralInstruction.integerLiteral(0));
            instruction2 = this.convertLoopAtomics(list, instruction2);
            if (!automatonInstruction.getWrapResult()) {
                instruction2 = new MatchInstruction(instruction2, constructor, 0);
            }
        }
        return instruction2;
    }

    private Instruction convertTestStream(TestStreamInstruction testStreamInstruction) {
        IAnnotation iAnnotation = this.m_environment.get(testStreamInstruction.getSource());
        Object object2 = testStreamInstruction.getElementBinding().getName();
        IAnnotation iAnnotation2 = this.m_environment.get(object2);
        if (iAnnotation == null || iAnnotation2 == null) {
            testStreamInstruction = (TestStreamInstruction)testStreamInstruction.cloneShallow();
            Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
            this.insertBinding(n2, new AssertTypeInstruction(testStreamInstruction.getSource(), testStreamInstruction.getSource().getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment())));
            testStreamInstruction.setSource(new IdentifierInstruction(n2));
            testStreamInstruction.setHint(this.convertInstruction(testStreamInstruction.getHint()));
            testStreamInstruction.setBody(this.convertInstruction(testStreamInstruction.getBody()));
            return testStreamInstruction;
        }
        if (testStreamInstruction instanceof ProcessStreamInstruction) {
            throw new XylemError("ERR_SYSTEM", "not yet supported");
        }
        Instruction instruction2 = this.convertInstruction(testStreamInstruction.getBody());
        instruction2 = this.insertLoopBindingAnnotationOperation(instruction2, iAnnotation, iAnnotation2);
        List list = iAnnotation instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this) : this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this);
        if (list.size() == 0) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + testStreamInstruction.getSource() + " converts to empty");
            }
            if (testStreamInstruction instanceof ProcessStreamInstruction) {
                ProcessStreamInstruction processStreamInstruction = (ProcessStreamInstruction)testStreamInstruction;
                Integer n3 = ReductionHelper.generateIntermediateIdentifier2();
                Type type2 = testStreamInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment());
                if (!(type2 instanceof ICollectionType)) {
                    throw new XylemError("ERR_SYSTEM", "not yet supported: conversion of empty psi with wrapResult");
                }
                this.insertBinding(n3, new StreamInstruction(((ICollectionType)((Object)type2)).getElementType()));
                return new IdentifierInstruction(n3);
            }
            return testStreamInstruction.getHint().cloneShallow();
        }
        Type type3 = ((Binding)list.get(0)).getBindingType();
        if (type3 instanceof ICollectionType) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + testStreamInstruction.getSource() + " converts to streams");
            }
            IBinding iBinding = (IBinding)list.get(0);
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
            String string2 = iBinding.getName() + ITEM_SUFFIX;
            instruction2 = this.convertLoopAtomics(list.subList(1, list.size()), instruction2);
            instruction2 = new TestStreamInstruction(identifierInstruction, this.convertInstruction(testStreamInstruction.getHint()), string2, testStreamInstruction.getHintBinding().getName(), testStreamInstruction.getIndexVar(), instruction2, (ICollectionType)((Object)type3));
        } else if (this.isLambdaIterator(list)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + testStreamInstruction.getSource() + " converts to lambda-iterator");
            }
            instruction2 = this.convertTestStreamOnLambdaIterator(testStreamInstruction, iAnnotation.getVariable(), list, instruction2);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + testStreamInstruction.getSource() + " converts to atomic");
            }
            instruction2 = this.convertLoopAtomics(list, instruction2);
            instruction2 = new LetInstruction(testStreamInstruction.getHintBinding().getName(), testStreamInstruction.getHint(), instruction2);
        }
        return instruction2;
    }

    private Instruction convertTestStreamOnLambdaIterator(TestStreamInstruction testStreamInstruction, Object object2, List list, Instruction instruction2) {
        Object object3;
        Object object42;
        Instruction instruction3 = testStreamInstruction.getHint();
        List list2 = list.subList(3, list.size());
        instruction2 = this.convertLoopAtomics(list2, instruction2);
        IBinding iBinding = (IBinding)list.get(0);
        IBinding iBinding2 = (IBinding)list.get(1);
        IBinding iBinding3 = (IBinding)list.get(2);
        Type type2 = ((IBinding)list.get(2)).getBindingType();
        String string2 = iBinding3.getName() + ITEM_SUFFIX;
        Object object5 = testStreamInstruction.getHintBinding().getName();
        String string3 = iBinding3.getName() + "$isEmpty";
        String string4 = "$next";
        String string5 = string2 + string4;
        String string6 = object5 + string4;
        String string7 = "testStreamFunction" + object2 + "$" + ReductionHelper.generateIntermediateIdentifier2();
        Set<Object> set2 = FindFreeVariables.findFreeVariables(instruction2);
        set2.remove(string2);
        set2.remove(iBinding.getName());
        set2.remove(iBinding2.getName());
        set2.remove(object5);
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>(set2.size() + 4);
        ArrayList<IdentifierInstruction> arrayList2 = new ArrayList<IdentifierInstruction>(set2.size() + 4);
        arrayList.add(new Binding((Object)string2, type2));
        arrayList2.add(new IdentifierInstruction(string5));
        arrayList.add(iBinding);
        arrayList2.add(new IdentifierInstruction(iBinding.getName()));
        arrayList.add(iBinding2);
        arrayList2.add(new IdentifierInstruction(iBinding2.getName()));
        arrayList.add(new Binding(object5, testStreamInstruction.getHintBinding().getBindingType()));
        arrayList2.add(new IdentifierInstruction(string6));
        for (Object object42 : set2) {
            object3 = new Binding(object42);
            arrayList.add((IBinding)object3);
            arrayList2.add(new IdentifierInstruction(object42));
        }
        object42 = new FunctionCallInstruction(string7, arrayList2);
        object3 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding2.getName()), new Instruction[]{new IdentifierInstruction(string2)}, true);
        object42 = new LetInstruction(string5, (Instruction)object3, (Instruction)object42);
        object42 = new LetInstruction(string6, instruction2, (Instruction)object42);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(object5);
        object42 = new ChooseInstruction(new IdentifierInstruction(string3), (Instruction)identifierInstruction, (Instruction)object42);
        ApplyInstruction applyInstruction = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding.getName()), new Instruction[]{new IdentifierInstruction(string2)}, true);
        object42 = new LetInstruction(string3, applyInstruction, (Instruction)object42);
        Function function2 = new Function(string7, arrayList.toArray(new Binding[0]), (Instruction)object42);
        function2.setReturnType(testStreamInstruction.getHint().getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
        this.m_module.addFunction(function2);
        this.reduceFunction(function2);
        this.insertBinding(string5, new IdentifierInstruction(iBinding3.getName()));
        this.insertBinding(string6, instruction3);
        return new FunctionCallInstruction(string7, arrayList2);
    }

    private Instruction convertLets(Instruction instruction2) {
        while (instruction2 instanceof LetInstruction) {
            Instruction instruction3;
            LetInstruction letInstruction = (LetInstruction)instruction2;
            Object object2 = letInstruction.getVariable();
            Instruction instruction4 = letInstruction.getValue();
            IAnnotation iAnnotation = this.m_environment.get(object2);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertLets", "converting let val for " + object2);
            }
            if ((instruction3 = iAnnotation instanceof MetaAnnotation ? this.convertNonLet(instruction4, (MetaAnnotation)iAnnotation) : this.convertNonLet(instruction4, this.m_converter)) != null) {
                this.insertBinding(object2, instruction3);
            }
            if (instruction4 instanceof ISpecialForm || instruction4 instanceof FunctionCallInstruction) {
                this.insertValueDecomposition(object2, iAnnotation);
            } else {
                this.insertAnnotationOperation(iAnnotation);
            }
            instruction2 = letInstruction.getBody();
        }
        return instruction2;
    }

    public void insertAnnotationOperation(IAnnotation iAnnotation) {
        if (iAnnotation != null && !(iAnnotation instanceof NullAnnotation)) {
            if (iAnnotation instanceof MetaAnnotation) {
                ((MetaAnnotation)iAnnotation).insertAnnotationOperation(iAnnotation, this.m_environment, this);
            } else {
                this.m_converter.insertAnnotationOperation(iAnnotation, this.m_environment, this);
            }
        }
    }

    public void insertValueDecomposition(Object object2, IAnnotation iAnnotation) {
        if (iAnnotation != null && !(iAnnotation instanceof NullAnnotation)) {
            if (iAnnotation instanceof MetaAnnotation) {
                ((MetaAnnotation)iAnnotation).insertValueDecomposition(object2, iAnnotation, this.m_environment, this);
            } else {
                this.m_converter.insertValueDecomposition(object2, iAnnotation, this.m_environment, this);
            }
        }
    }

    private Instruction insertLoopBindingAnnotationOperation(Instruction instruction2, IAnnotation iAnnotation, IAnnotation iAnnotation2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "insertLoopBindingAnnotationOperation", "inserting loop annotations for (" + iAnnotation2 + ")");
        }
        LetChainBuilder letChainBuilder = this.m_lcb;
        this.m_lcb = new LetChainBuilder();
        if (!(iAnnotation2 instanceof NullAnnotation)) {
            if (iAnnotation2 == null) {
                throw new XylemError("ERR_SYSTEM", "null elt for src=" + iAnnotation);
            }
            if (iAnnotation2 instanceof MetaAnnotation) {
                ((MetaAnnotation)iAnnotation2).insertLoopBinding(iAnnotation, iAnnotation2, this.m_environment, this);
            } else {
                this.m_converter.insertLoopBinding(iAnnotation, iAnnotation2, this.m_environment, this);
            }
        }
        instruction2 = this.m_lcb.packageUp(instruction2);
        this.m_lcb = letChainBuilder;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "insertLoopBindingAnnotationOperation", "done(" + iAnnotation2 + ")");
        }
        return instruction2;
    }

    public Instruction convertSyntheticFunctionCall(Function function2, Object[] objectArray, AnnotationEnvironment annotationEnvironment) {
        AnnotationEnvironment annotationEnvironment2 = this.m_environment;
        this.m_environment = annotationEnvironment;
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iAnnotationArray[i] = this.m_environment.get(objectArray[i]);
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "convertSyntheticFunctionCall", "paramAnnotations[" + i + "] (i.e., " + objectArray[i] + ")=" + iAnnotationArray[i]);
        }
        FunctionCallSpec functionCallSpec = new FunctionCallSpec(function2, iAnnotationArray);
        Instruction instruction2 = this.convertFunctionCall(functionCallSpec, objectArray, null);
        this.m_environment = annotationEnvironment2;
        return instruction2;
    }

    private Instruction convertFunctionCall(FunctionCallSpec functionCallSpec, Object[] objectArray, Instruction[] instructionArray) {
        FunctionAnnotationInfo functionAnnotationInfo = (FunctionAnnotationInfo)this.m_environment.getTable().getFunctionInfo(functionCallSpec);
        Function function2 = functionCallSpec.getFunction();
        if (functionAnnotationInfo != null) {
            function2 = this.convert(functionAnnotationInfo);
        }
        Instruction[] instructionArray2 = this.convertCallParams(functionAnnotationInfo, functionCallSpec, objectArray, instructionArray);
        FunctionCallInstruction functionCallInstruction = new FunctionCallInstruction(function2.getName(), instructionArray2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertFunctionCall", "converted call " + functionCallSpec);
            s_logger.logp(Level.FINER, s_className, "convertFunctionCall", "            => " + functionCallInstruction);
        }
        return functionCallInstruction;
    }

    private Instruction convertLambdaApplication(ApplyInstruction applyInstruction) {
        Instruction instruction2;
        LambdaMetaAnnotation lambdaMetaAnnotation = (LambdaMetaAnnotation)this.m_environment.get(applyInstruction.getLambda());
        IAnnotation[] iAnnotationArray = this.m_environment.get(applyInstruction.getOperands());
        Instruction instruction3 = lambdaMetaAnnotation.getIdentifier(iAnnotationArray);
        Instruction[] instructionArray = applyInstruction.getOperands();
        Object[] objectArray = new Object[applyInstruction.getOperands().length];
        for (int i = 0; i < objectArray.length; ++i) {
            instruction2 = applyInstruction.getOperands()[i];
            if (!(instruction2 instanceof IdentifierInstruction)) continue;
            objectArray[i] = ((IdentifierInstruction)instruction2).getVariable();
        }
        Instruction[] instructionArray2 = this.convertCallParams(iAnnotationArray, objectArray, instructionArray);
        instruction2 = new ApplyInstruction(instruction3, instructionArray2, applyInstruction.isPure());
        return instruction2;
    }

    public ApplyInstruction convertSyntheticLambdaApplication(String string2, Instruction instruction2, Object[] objectArray, AnnotationEnvironment annotationEnvironment) {
        AnnotationEnvironment annotationEnvironment2 = this.m_environment;
        this.m_environment = annotationEnvironment;
        LambdaApplySpec lambdaApplySpec = new LambdaApplySpec(string2, instruction2, annotationEnvironment.get(objectArray), true);
        LambdaAnnotationInfo lambdaAnnotationInfo = (LambdaAnnotationInfo)this.m_environment.getTable().getFunctionInfo(lambdaApplySpec);
        if (lambdaAnnotationInfo == null) {
            throw new XylemError("ERR_SYSTEM", "no lai for " + lambdaApplySpec);
        }
        Object object2 = this.convertLambda(lambdaAnnotationInfo);
        ApplyInstruction applyInstruction = new ApplyInstruction((Instruction)new IdentifierInstruction(object2), this.convertCallParams(lambdaAnnotationInfo, lambdaApplySpec, objectArray, null), lambdaAnnotationInfo.isPure());
        this.m_environment = annotationEnvironment2;
        return applyInstruction;
    }

    public Object convertSyntheticLambdaApplication(String string2, Instruction instruction2, IAnnotation[] iAnnotationArray, AnnotationEnvironment annotationEnvironment) {
        AnnotationEnvironment annotationEnvironment2 = this.m_environment;
        this.m_environment = annotationEnvironment;
        LambdaApplySpec lambdaApplySpec = new LambdaApplySpec(string2, instruction2, iAnnotationArray, true);
        LambdaAnnotationInfo lambdaAnnotationInfo = (LambdaAnnotationInfo)this.m_environment.getTable().getFunctionInfo(lambdaApplySpec);
        if (lambdaAnnotationInfo == null) {
            throw new XylemError("ERR_SYSTEM", "no lai for " + lambdaApplySpec);
        }
        Object object2 = this.convertLambda(lambdaAnnotationInfo);
        this.m_environment = annotationEnvironment2;
        return object2;
    }

    public Object convertLambda(LambdaAnnotationInfo lambdaAnnotationInfo) {
        Object object2;
        Object object3;
        Object object4;
        Object object5 = this.m_convertedLambdas.get(lambdaAnnotationInfo);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertLambda", "converting " + lambdaAnnotationInfo);
            try {
                object4 = new ByteArrayOutputStream();
                object3 = new PrintStream((OutputStream)object4);
                new Error().printStackTrace((PrintStream)object3);
                object2 = new StreamTokenizer(new StringReader(((ByteArrayOutputStream)object4).toString()));
                while (((StreamTokenizer)object2).nextToken() != -1) {
                }
                s_logger.logp(Level.FINER, s_className, "convertLambda", "stack-depth=" + ((StreamTokenizer)object2).lineno());
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "convertLambda", "", exception);
            }
        }
        object4 = this.m_environment;
        object3 = this.m_convertedLambdas;
        this.m_environment = lambdaAnnotationInfo.getEnvironment();
        this.m_convertedLambdas = new HashMap();
        object2 = this.convertInstruction(lambdaAnnotationInfo.getBody());
        this.m_convertedLambdas = object3;
        this.m_environment = object4;
        LambdaInstruction lambdaInstruction = new LambdaInstruction((Instruction)object2, this.convertParamBindings(lambdaAnnotationInfo), lambdaAnnotationInfo.isPure());
        object5 = ReductionHelper.generateIntermediateIdentifier2();
        this.insertBinding(object5, lambdaInstruction);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertLambda", "created new lambda '" + object5 + "' for " + lambdaAnnotationInfo);
        }
        this.m_convertedLambdas.put(lambdaAnnotationInfo, object5);
        return object5;
    }

    public Type convertReturnType(IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        if (iFunctionAnnotationInfo.getResultAnnotation() == null) {
            return iFunctionAnnotationInfo.getOriginalReturnType();
        }
        if (iFunctionAnnotationInfo.getResultAnnotation() instanceof MetaAnnotation) {
            return ((MetaAnnotation)iFunctionAnnotationInfo.getResultAnnotation()).getValueType(iFunctionAnnotationInfo.getResultAnnotation(), this);
        }
        return this.m_converter.getValueType(iFunctionAnnotationInfo.getResultAnnotation(), this);
    }

    public List getBindingList(Object object2, IAnnotation iAnnotation) {
        if (iAnnotation instanceof MetaAnnotation) {
            return ((MetaAnnotation)iAnnotation).getBindingList(object2, iAnnotation, this);
        }
        return this.m_converter.getBindingList(object2, iAnnotation, this);
    }

    public Binding[] convertParamBindings(IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        int n2 = iFunctionAnnotationInfo.getParamBindings().length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            Binding binding = iFunctionAnnotationInfo.getParamBindings()[i];
            IAnnotation iAnnotation = iFunctionAnnotationInfo.getParamAnnotations()[i];
            if (iAnnotation == null) {
                arrayList.add(binding.clone());
                continue;
            }
            if (iAnnotation instanceof MetaAnnotation) {
                arrayList.addAll(((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this));
                continue;
            }
            arrayList.addAll(this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this));
        }
        return arrayList.toArray(new Binding[0]);
    }

    public Type convertType(IAnnotation iAnnotation, Type type2) {
        if (iAnnotation == null) {
            return type2;
        }
        if (iAnnotation instanceof MetaAnnotation) {
            return ((MetaAnnotation)iAnnotation).getValueType(iAnnotation, this);
        }
        return this.m_converter.getValueType(iAnnotation, this);
    }

    public Binding[] convertParamBindings(IAnnotation[] iAnnotationArray, IBinding[] iBindingArray) {
        int n2 = iBindingArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            Binding binding = (Binding)iBindingArray[i];
            IAnnotation iAnnotation = iAnnotationArray[i];
            if (iAnnotation == null) {
                arrayList.add(binding.clone());
                continue;
            }
            if (iAnnotation instanceof MetaAnnotation) {
                arrayList.addAll(((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this));
                continue;
            }
            arrayList.addAll(this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this));
        }
        return arrayList.toArray(new Binding[0]);
    }

    private Instruction[] convertCallParams(IFunctionAnnotationInfo iFunctionAnnotationInfo, ICallSpec iCallSpec, Object[] objectArray, Instruction[] instructionArray) {
        IAnnotation[] iAnnotationArray;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            int n2;
            iAnnotationArray = new StringBuilder();
            iAnnotationArray.append("converting call/apply " + iCallSpec + "\n");
            iAnnotationArray.append("originalParams=\n");
            if (null == instructionArray) {
                iAnnotationArray.append("null\n");
            } else {
                for (n2 = 0; n2 < instructionArray.length; ++n2) {
                    iAnnotationArray.append("  " + instructionArray[n2]);
                }
            }
            iAnnotationArray.append("\nparamVars=\n");
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                iAnnotationArray.append("  " + objectArray[n2]);
            }
            iAnnotationArray.append("\n");
            s_logger.logp(Level.FINER, s_className, "convertCallParams", iAnnotationArray.toString());
        }
        iAnnotationArray = new IAnnotation[objectArray.length];
        if (iFunctionAnnotationInfo != null) {
            iAnnotationArray = iFunctionAnnotationInfo.getParamAnnotations();
        } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertCallParams", "no fai found for '" + iCallSpec + "'");
        }
        return this.convertCallParams(iAnnotationArray, objectArray, instructionArray);
    }

    private Instruction[] convertCallParams(IAnnotation[] iAnnotationArray, Object[] objectArray, Instruction[] instructionArray) {
        int n2 = objectArray.length;
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(n2);
        for (int i = 0; i < n2; ++i) {
            IAnnotation iAnnotation;
            Object object2 = objectArray[i];
            if (object2 != null && (iAnnotation = this.m_environment.get(object2)) != null && iAnnotationArray[i] != null) {
                List list = this.getIdentifierList(iAnnotation.getVariable(), iAnnotationArray[i]);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "convertCallParams", "    param " + object2 + " => ");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
                    s_logger.logp(Level.FINER, s_className, "convertCallParams", "    " + iterator.next());
                }
                arrayList.addAll(list);
                continue;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertCallParams", "    param " + object2 + " unchanged.");
            }
            arrayList.add((IdentifierInstruction)(instructionArray == null ? new IdentifierInstruction(object2) : instructionArray[i]));
        }
        return arrayList.toArray(new Instruction[0]);
    }

    public List getIdentifierList(Object object2, IAnnotation iAnnotation) {
        List list = this.getBindingList(object2, iAnnotation);
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new IdentifierInstruction(((Binding)iterator.next()).getName()));
        }
        return arrayList;
    }
}

