/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallStackItem;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotator;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaApplySpec;
import com.ibm.xltxe.rnm1.xylem.annot.meta.LambdaMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.StreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.TupleMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationTable {
    private static final Logger s_logger = LoggerUtil.getLogger(AnnotationTable.class);
    private static final String s_className = AnnotationTable.class.getName();
    private Module m_module;
    private IAnnotator m_annotator;
    private HashMap m_functionInfo = new HashMap();
    private HashMap m_globalInfo = new HashMap();
    private ArrayList m_postponedFunctions = new ArrayList();
    private static final int FUNCTION_STACK_LIMIT = 100;
    private int m_currentFunctionStacklimit = 100;

    public AnnotationTable(Module module, IAnnotator iAnnotator) {
        this.m_module = module;
        this.m_annotator = iAnnotator;
    }

    public void addGlobalInfo(Object object2, Object object3) {
        this.m_globalInfo.put(object2, object3);
    }

    public Object getGlobalInfo(Object object2) {
        return this.m_globalInfo.get(object2);
    }

    public IAnnotator getAnnotator() {
        return this.m_annotator;
    }

    public Module getModule() {
        return this.m_module;
    }

    public IFunctionAnnotationInfo getFunctionInfo(ICallSpec iCallSpec) {
        return (IFunctionAnnotationInfo)this.m_functionInfo.get(iCallSpec);
    }

    public static AnnotationTable analyzeProgram(Module module, Function function2, IAnnotator iAnnotator) {
        AnnotationTable annotationTable = new AnnotationTable(module, iAnnotator);
        IAnnotation iAnnotation = annotationTable.analyzeFunction(function2, null);
        if (iAnnotation != null) {
            s_logger.logp(Level.WARNING, s_className, "analyzeProgram", "non-empty annotation for main return!");
        }
        annotationTable.analyzePostponedFunctions();
        return annotationTable;
    }

    public IAnnotation analyzeFunction(Function function2, IAnnotation[] iAnnotationArray) {
        if (iAnnotationArray == null) {
            iAnnotationArray = new IAnnotation[function2.m_parameters.length];
        }
        return this.analyzeFunction(new FunctionCallSpec(function2, iAnnotationArray), null, new ArrayList(), new ArrayList());
    }

    public IAnnotation analyzeCode(Instruction instruction2, AnnotationEnvironment annotationEnvironment, Object object2, ArrayList arrayList, ArrayList arrayList2) {
        Object object3;
        Object object4;
        Object object5;
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        while (true) {
            arrayList3.clear();
            if (!(instruction2 instanceof LetInstruction)) break;
            object5 = (LetInstruction)instruction2;
            object4 = ((LetBaseInstruction)object5).getValue();
            object3 = this.analyzeCode((Instruction)object4, annotationEnvironment, ((LetBaseInstruction)object5).getVariable(), arrayList, arrayList2);
            if (object3 != null && object3.getVariable() != null) {
                object3 = object3.clonePassthru();
            }
            annotationEnvironment.set(((LetBaseInstruction)object5).getVariable(), (IAnnotation)object3);
            instruction2 = ((LetBaseInstruction)object5).getBody();
        }
        if (instruction2 instanceof ForEachInstruction) {
            object5 = (ForEachInstruction)instruction2;
            object4 = annotationEnvironment.get(((ForEachInstruction)object5).getSource());
            if (object4 != null) {
                object4 = object4.getLoopBindingAnnotation();
            }
            annotationEnvironment.set(((ForEachInstruction)object5).getVarName(), (IAnnotation)object4);
            object3 = this.analyzeCode(((ForEachInstruction)object5).getBody(), annotationEnvironment, null, arrayList, arrayList2);
            if (object3 == null) {
                return null;
            }
            return object3.getLoopValueAnnotation();
        }
        if (instruction2 instanceof TestStreamInstruction) {
            object5 = (TestStreamInstruction)instruction2;
            object4 = annotationEnvironment.get(((TestStreamInstruction)object5).getSource());
            if (object4 != null) {
                object4 = object4.getLoopBindingAnnotation();
            }
            annotationEnvironment.set(((TestStreamInstruction)object5).getElementBinding().getName(), (IAnnotation)object4);
            if (annotationEnvironment.get(((TestStreamInstruction)object5).getHint()) != null) {
                throw new XylemError("ERR_SYSTEM", "not yet supported:" + object5);
            }
            object3 = this.analyzeCode(((TestStreamInstruction)object5).getBody(), annotationEnvironment, null, arrayList, arrayList2);
            if (object3 == null) {
                return null;
            }
            return object3;
        }
        if (instruction2 instanceof IdentifierInstruction) {
            object5 = annotationEnvironment.get(instruction2);
            return object5;
        }
        if (instruction2 instanceof AutomatonInstruction) {
            Object object6;
            object5 = (AutomatonInstruction)instruction2;
            object4 = annotationEnvironment.get(((AutomatonInstruction)object5).getSource());
            object3 = annotationEnvironment.get(((AutomatonInstruction)object5).getInitialState());
            IAnnotation iAnnotation = null;
            if (object4 != null) {
                iAnnotation = object4.getLoopBindingAnnotation();
            }
            if (((AutomatonInstruction)object5).getDefaultHandler() != null) {
                annotationEnvironment.set(((AutomatonInstruction)object5).getDefaultElementBinding().getName(), iAnnotation);
                Instruction instruction3 = ((AutomatonInstruction)object5).getDefaultHandler();
                if (object3 != null) {
                    throw new Error("TODO: support ai state annotation?");
                }
                object6 = this.analyzeCode(instruction3, annotationEnvironment, null, arrayList, arrayList2);
                arrayList3.add(object6);
            }
            for (int i = 0; i < ((AutomatonInstruction)object5).m_matches.length; ++i) {
                if (object3 != null || iAnnotation != null) {
                    throw new Error("TODO: support annotationg non-default ai matches?");
                }
                object6 = ((AutomatonInstruction)object5).getDefaultHandler();
                if (object6 == null) continue;
                IAnnotation iAnnotation2 = this.analyzeCode((Instruction)object6, annotationEnvironment, null, arrayList, arrayList2);
                arrayList3.add(iAnnotation2);
            }
            IAnnotation iAnnotation3 = this.unionValues(annotationEnvironment, arrayList3);
            if (iAnnotation3 == null) {
                return null;
            }
            return iAnnotation3.getLoopValueAnnotation();
        }
        if (instruction2 instanceof FunctionCallInstruction) {
            return this.analyzeFunctionCall(instruction2, annotationEnvironment, arrayList, arrayList2);
        }
        if (instruction2 instanceof ConstructorInstantiationInstruction && ((ConstructorInstantiationInstruction)instruction2).getConstructorName().startsWith("tuple")) {
            boolean bl = true;
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                if (annotationEnvironment.get(instruction2.getChildInstruction(i)) == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                return null;
            }
            return new TupleMetaAnnotation(((NaryPrimopInstruction)instruction2).getOperands(), annotationEnvironment);
        }
        if (instruction2 instanceof MatchInstruction && annotationEnvironment.get(((MatchInstruction)instruction2).getToMatch()) instanceof TupleMetaAnnotation) {
            object5 = (TupleMetaAnnotation)annotationEnvironment.get(((MatchInstruction)instruction2).getToMatch());
            object4 = ((MatchInstruction)instruction2).getMatches();
            if (((MatchInstruction.Match[])object4).length != 1) {
                throw new XylemError("ERR_SYSTEM", "isn't this a tuple?");
            }
            object3 = (MatchInstruction.DeconstructionMatch)object4[0];
            for (int i = 0; i < ((MatchInstruction.DeconstructionMatch)object3).getBindings().length; ++i) {
                if (((TupleMetaAnnotation)object5).getComponents()[i] == null) continue;
                annotationEnvironment.set(((MatchInstruction.DeconstructionMatch)object3).getBindings()[i].getName(), ((TupleMetaAnnotation)object5).getComponents()[i].clonePassthru());
            }
            return this.analyzeCode(((MatchInstruction.Match)object3).getHandler(), annotationEnvironment, null, arrayList, arrayList2);
        }
        if (instruction2 instanceof MatchInstruction) {
            object5 = (MatchInstruction)instruction2;
            if (((MatchInstruction)object5).getMatches()[0] instanceof MatchInstruction.LiteralMatch && ((MatchInstruction)object5).getToMatch() instanceof IdentifierInstruction) {
                object4 = (IdentifierInstruction)((MatchInstruction)object5).getToMatch();
                object3 = annotationEnvironment.getComputedLiteral((Instruction)object4);
                if (object3 == null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINER, s_className, "analyzeCode", "no literal for match on " + object4);
                    }
                } else {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "analyzeCode", "proactively optimizing match on " + object4 + " with " + object3.size() + " values");
                    }
                    Iterator iterator = object3.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "analyzeCode", "proactively optimizing match on " + object4 + " with val " + e);
                        }
                        MatchInstruction.Match[] matchArray = ((MatchInstruction)object5).getMatches();
                        int n2 = 0;
                        for (n2 = 0; n2 < matchArray.length; ++n2) {
                            LiteralInstruction literalInstruction = ((MatchInstruction.LiteralMatch)matchArray[n2]).getLiteral();
                            if (!literalInstruction.getValue().equals(e)) continue;
                            Instruction instruction4 = matchArray[n2].getHandler();
                            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                                s_logger.logp(Level.FINER, s_className, "analyzeCode", " -- match found " + object4 + " with value " + e);
                            }
                            arrayList3.add(this.analyzeCode(instruction4, annotationEnvironment, null, arrayList, arrayList2));
                            break;
                        }
                        if (n2 != matchArray.length) continue;
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "analyzeCode", " -- no match found " + object4);
                        }
                        bl = true;
                    }
                    if (bl) {
                        if (((MatchInstruction)object5).getDefault() != null) {
                            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                                s_logger.logp(Level.FINER, s_className, "analyzeCode", " some literals do not match any value. analyzing default.");
                            }
                            arrayList3.add(this.analyzeCode(((MatchInstruction)object5).getDefault(), annotationEnvironment, null, arrayList, arrayList2));
                        } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "analyzeCode", " some literal do not match any value. no analysis.");
                        }
                    }
                    return this.unionValues(annotationEnvironment, arrayList3);
                }
            }
            int n3 = instruction2.getChildInstructionCount();
            for (int i = 0; i < n3; ++i) {
                Instruction instruction5 = instruction2.getChildInstruction(i);
                arrayList3.add(this.analyzeCode(instruction5, annotationEnvironment, null, arrayList, arrayList2));
            }
            return this.unionValues(annotationEnvironment, arrayList3);
        }
        if (instruction2 instanceof ChooseInstruction) {
            object5 = ((ChooseInstruction)instruction2).m_cases;
            for (int i = 0; i < ((Object)object5).length; ++i) {
                object3 = this.analyzeCode(((ChooseInstruction.Case)object5[i]).getHandler(), annotationEnvironment, null, arrayList, arrayList2);
                arrayList3.add(object3);
            }
            Instruction instruction6 = ((ChooseInstruction)instruction2).getDefaultHandler();
            if (instruction6 != null) {
                arrayList3.add(this.analyzeCode(instruction6, annotationEnvironment, null, arrayList, arrayList2));
            }
            return this.unionValues(annotationEnvironment, arrayList3);
        }
        if (instruction2 instanceof LambdaInstruction) {
            object5 = (LambdaInstruction)instruction2;
            return LambdaMetaAnnotation.newA((LambdaInstruction)object5, this, annotationEnvironment);
        }
        if (instruction2 instanceof StreamInstruction) {
            return StreamMetaAnnotation.newStream((StreamInstruction)instruction2, annotationEnvironment, this);
        }
        if (instruction2 instanceof ApplyInstruction) {
            return this.analyzeLambdaApplication((ApplyInstruction)instruction2, annotationEnvironment, arrayList, arrayList2);
        }
        if (instruction2 == null) {
            throw new RuntimeException();
        }
        object5 = this.getAnnotator().analyzeExpression(annotationEnvironment, instruction2, object2);
        if (object5 == null) {
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                IAnnotation iAnnotation;
                object3 = instruction2.getChildInstruction(i);
                if (object3 instanceof IdentifierInstruction || object3 instanceof LiteralInstruction || (iAnnotation = this.analyzeCode((Instruction)object3, annotationEnvironment, null, arrayList, arrayList2)) == null) continue;
                s_logger.logp(Level.WARNING, s_className, "analyzeCode", "non-null annotation for unsupported special form child in " + instruction2);
            }
        }
        return object5;
    }

    private IAnnotation analyzeFunctionCall(Instruction instruction2, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
        Function function2 = annotationEnvironment.getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
        int n2 = functionCallInstruction.getChildInstructionCount();
        Object e = arrayList.get(arrayList.size() - 1);
        IAnnotation iAnnotation = this.analyzeFunction(new FunctionCallSpec(functionCallInstruction, annotationEnvironment), annotationEnvironment, arrayList, arrayList2);
        if (!arrayList.get(arrayList.size() - 1).equals(e)) {
            throw new RuntimeException();
        }
        return iAnnotation;
    }

    public IAnnotation analyzeSyntheticFunctionCall(Function function2, Object[] objectArray, AnnotationEnvironment annotationEnvironment) {
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iAnnotationArray[i] = annotationEnvironment.get(objectArray[i]);
        }
        return this.analyzeFunction(function2, iAnnotationArray);
    }

    public IAnnotation analyzeSyntheticLambdaApplication(String string2, LambdaInstruction lambdaInstruction, IAnnotation[] iAnnotationArray, AnnotationEnvironment annotationEnvironment) {
        LambdaApplySpec lambdaApplySpec = new LambdaApplySpec(string2, lambdaInstruction, iAnnotationArray, true);
        lambdaInstruction.typeCheckReduced(annotationEnvironment.getTypeEnvironment(), annotationEnvironment.getBindingEnvironment(), new LinkedList());
        return this.analyzeFunction(lambdaApplySpec, annotationEnvironment, new ArrayList(), new ArrayList());
    }

    public IAnnotation analyzeLambdaApplication(ApplyInstruction applyInstruction, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        Object object2 = ((IdentifierInstruction)applyInstruction.getLambda()).getVariable();
        LambdaMetaAnnotation lambdaMetaAnnotation = (LambdaMetaAnnotation)annotationEnvironment.get(object2);
        return lambdaMetaAnnotation.analyzeApplication(annotationEnvironment.get(applyInstruction.getOperands()), annotationEnvironment, arrayList, arrayList2);
    }

    private IAnnotation analyzeFunction(ICallSpec iCallSpec, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        int n2 = arrayList2.size();
        int n3 = arrayList.size();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analyzing '" + iCallSpec + "' sp=" + n3 + " pending stacks=" + n2);
        }
        IFunctionAnnotationInfo iFunctionAnnotationInfo = null;
        boolean bl = this.m_functionInfo.containsKey(iCallSpec);
        iFunctionAnnotationInfo = bl ? (IFunctionAnnotationInfo)this.m_functionInfo.get(iCallSpec) : iCallSpec.newInfo(this, annotationEnvironment);
        FunctionCallStackItem functionCallStackItem = new FunctionCallStackItem(iCallSpec, iFunctionAnnotationInfo);
        arrayList.add(functionCallStackItem);
        if (!bl) {
            Object object2;
            int n4 = -1;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                try {
                    object2 = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream((OutputStream)object2);
                    new Error().printStackTrace(printStream);
                    StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(((ByteArrayOutputStream)object2).toString()));
                    while (streamTokenizer.nextToken() != -1) {
                    }
                    n4 = streamTokenizer.lineno();
                    s_logger.logp(Level.FINER, s_className, "analyzeFunction", "stack-depth=" + n4);
                }
                catch (Exception exception) {
                    s_logger.logp(Level.SEVERE, s_className, "analyzeFunction", "", exception);
                }
            }
            if (n3 > this.m_currentFunctionStacklimit && iCallSpec instanceof FunctionCallSpec && this.m_annotator.isFunctionReturnNotAnnotated((FunctionCallSpec)iCallSpec)) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "analyzeFunction", "postponing analysis of " + iFunctionAnnotationInfo.getFunctionName() + " function stack position = " + n3);
                }
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "analyzeFunction", "postponing analysis of " + iCallSpec + " function stack position = " + n3);
                    s_logger.logp(Level.FINER, s_className, "analyzeFunction", " real stack depth = " + n4);
                }
                object2 = new PostponedFunction();
                ((PostponedFunction)object2).env = annotationEnvironment;
                ((PostponedFunction)object2).fcs = iCallSpec;
                arrayList.remove(n3);
                ((PostponedFunction)object2).functionStack = new ArrayList(arrayList);
                this.m_postponedFunctions.add(object2);
                return null;
            }
            if ((double)n3 > 1.15 * (double)this.m_currentFunctionStacklimit) {
                s_logger.logp(Level.WARNING, s_className, "analyzeFunction", "Function stack limit exceeded by 15% " + n3 + " / " + this.m_currentFunctionStacklimit);
            }
            this.m_functionInfo.put(iCallSpec, iFunctionAnnotationInfo);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysing " + functionCallStackItem);
            }
            object2 = this.analyzeCode(iFunctionAnnotationInfo.getBody(), iFunctionAnnotationInfo.getEnvironment(), null, arrayList, arrayList2);
            arrayList.remove(arrayList.size() - 1);
            iFunctionAnnotationInfo.setResultAnnotation((IAnnotation)object2);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysis complete for " + functionCallStackItem);
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", " result: " + object2);
            }
        } else if (iFunctionAnnotationInfo.isComplete()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysis already complete for " + functionCallStackItem);
            }
            arrayList.remove(arrayList.size() - 1);
        } else {
            IAnnotation iAnnotation;
            arrayList2.add(new ArrayList(arrayList));
            arrayList.remove(arrayList.size() - 1);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysis already pending for " + functionCallStackItem);
            }
            if ((iAnnotation = iFunctionAnnotationInfo.getResultAnnotation()) == null) {
                return null;
            }
            throw new XylemError("ERR_SYSTEM", "recursive function returns cursor !" + iFunctionAnnotationInfo);
        }
        IAnnotation iAnnotation = iFunctionAnnotationInfo.getResultAnnotation();
        if (iAnnotation != null) {
            iAnnotation = iAnnotation.cloneAsFunctionReturn(new ArrayList(arrayList.subList(arrayList.size() - 1, arrayList.size())));
        }
        iAnnotation = this.backpatchPendingFunctions(functionCallStackItem, iAnnotation, arrayList, arrayList2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "analyzeFunction", "result for '" + functionCallStackItem + ":");
            s_logger.logp(Level.FINER, s_className, "analyzeFunction", " " + iAnnotation);
        }
        return iAnnotation;
    }

    private IAnnotation backpatchPendingFunctions(FunctionCallStackItem functionCallStackItem, IAnnotation iAnnotation, ArrayList arrayList, ArrayList arrayList2) {
        int n2 = arrayList.size();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "backpatching " + functionCallStackItem + " ... ");
        }
        FunctionCallStackItem.backpatchFunctionCalls(Collections.singletonList(functionCallStackItem));
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList = (ArrayList)iterator.next();
            if (arrayList.size() <= n2 || arrayList.get(n2) != functionCallStackItem) continue;
            FunctionCallStackItem functionCallStackItem2 = (FunctionCallStackItem)arrayList.get(arrayList.size() - 1);
            List list = arrayList.subList(n2, arrayList.size());
            if (((Object)functionCallStackItem.getCallSpec()).equals(functionCallStackItem2.getCallSpec())) {
                if (iAnnotation != null) {
                    iAnnotation = iAnnotation.cloneAsFunctionReturn(new ArrayList(list.subList(0, 1)));
                }
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "call stack is complete, backpatching " + functionCallStackItem.getFunctionInfo() + " depth = " + list);
                }
                FunctionCallStackItem.backpatchFunctionCalls(list);
                iterator.remove();
                functionCallStackItem.getFunctionInfo().setComplete();
                continue;
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "call stack is incomplete, not backpatching yet");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "... finished backpatching " + functionCallStackItem);
        }
        return iAnnotation;
    }

    public void analyzePostponedFunctions() {
        while (!this.m_postponedFunctions.isEmpty()) {
            PostponedFunction postponedFunction = (PostponedFunction)this.m_postponedFunctions.remove(0);
            this.m_currentFunctionStacklimit = postponedFunction.functionStack.size() + 100;
            ArrayList arrayList = new ArrayList();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzePostponedFunctions", "resuming analysis of " + postponedFunction.fcs);
            }
            IAnnotation iAnnotation = this.analyzeFunction(postponedFunction.fcs, postponedFunction.env, postponedFunction.functionStack, arrayList);
            while (!postponedFunction.functionStack.isEmpty()) {
                FunctionCallStackItem functionCallStackItem = (FunctionCallStackItem)postponedFunction.functionStack.remove(postponedFunction.functionStack.size() - 1);
                iAnnotation = this.backpatchPendingFunctions(functionCallStackItem, iAnnotation, postponedFunction.functionStack, arrayList);
            }
            if (iAnnotation != null) {
                throw new XylemError("ERR_SYSTEM", "Annotator lied, postponed function " + postponedFunction.fcs + " returns annotation '" + iAnnotation + " (annotator said it wouldn't)");
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "analyzePostponedFunctions", "finished resumed analysis of " + postponedFunction.fcs);
        }
    }

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, List list) {
        if (list.size() == 1) {
            return (IAnnotation)list.iterator().next();
        }
        HashSet hashSet = new HashSet(list);
        hashSet.remove(null);
        if (hashSet.size() == 0) {
            return null;
        }
        Object e = hashSet.iterator().next();
        if (e instanceof MetaAnnotation) {
            return ((MetaAnnotation)e).unionValues(annotationEnvironment, list);
        }
        return this.m_annotator.unionValues(annotationEnvironment, list);
    }

    public FunctionAnnotationInfo[] getEntryPoints() {
        ArrayList<IFunctionAnnotationInfo> arrayList = new ArrayList<IFunctionAnnotationInfo>();
        for (IFunctionAnnotationInfo iFunctionAnnotationInfo : this.m_functionInfo.values()) {
            if (!(iFunctionAnnotationInfo instanceof FunctionAnnotationInfo) || !iFunctionAnnotationInfo.getEnvironment().hasAnnotations() || iFunctionAnnotationInfo.isCallAnnotated()) continue;
            arrayList.add(iFunctionAnnotationInfo);
        }
        return arrayList.toArray(new FunctionAnnotationInfo[0]);
    }

    private static class PostponedFunction {
        private ICallSpec fcs;
        private AnnotationEnvironment env;
        private ArrayList functionStack;

        private PostponedFunction() {
        }
    }
}

