/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.NullAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationEnvironment {
    private static final Logger s_logger = LoggerUtil.getLogger(AnnotationEnvironment.class);
    private static final String s_className = AnnotationEnvironment.class.getName();
    private AnnotationTable m_table;
    private HashMap m_env = new HashMap();
    private HashMap m_literals = new HashMap();
    private HashMap m_infos = new HashMap();
    private boolean m_hasAnnotations = false;
    private IFunctionAnnotationInfo m_functionInfo;

    public AnnotationEnvironment(AnnotationTable annotationTable) {
        this.m_table = annotationTable;
    }

    public Function getEnclosingFunction() {
        return this.m_functionInfo.getEnclosingFunction();
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.getEnclosingFunction().getTypeEnvironment();
    }

    public BindingEnvironment getBindingEnvironment() {
        return this.getEnclosingFunction().getBindingEnvironment();
    }

    public AnnotationTable getTable() {
        return this.m_table;
    }

    public boolean hasAnnotations() {
        return this.m_hasAnnotations;
    }

    public IAnnotation get(Object object2) {
        return (IAnnotation)this.m_env.get(object2);
    }

    public IAnnotation[] get(Instruction[] instructionArray) {
        IAnnotation[] iAnnotationArray = new IAnnotation[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            iAnnotationArray[i] = this.get(instructionArray[i]);
        }
        return iAnnotationArray;
    }

    public IAnnotation[] get(Object[] objectArray) {
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iAnnotationArray[i] = this.get(objectArray[i]);
        }
        return iAnnotationArray;
    }

    public IAnnotation get(Instruction instruction2) {
        if (instruction2 instanceof LiteralInstruction) {
            return this.m_table.getAnnotator().analyzeExpression(this, instruction2, null);
        }
        if (!(instruction2 instanceof IdentifierInstruction)) {
            throw new XylemError("ERR_SYSTEM", "Annnotations may only be bound to reduced code");
        }
        return this.get(((IdentifierInstruction)instruction2).getVariable());
    }

    public void setAlias(Object object2, IdentifierInstruction identifierInstruction) {
        this.setAlias(object2, identifierInstruction.getVariable());
    }

    public void setAlias(Object object2, Object object3) {
        if (this.m_env.containsKey(object2)) {
            throw new XylemError("ERR_SYSTEM", "Can't alias '" + object2 + "' to '" + object3 + "' " + "because '" + object2 + "' is already bound (to " + this.m_env.get(object2) + ").");
        }
        if (!this.m_env.containsKey(object3)) {
            throw new XylemError("ERR_SYSTEM", "Can't alias '" + object2 + "' to '" + object3 + "' because '" + object3 + "' is not bound.");
        }
        IAnnotation iAnnotation = this.get(object3);
        this.m_env.put(object2, iAnnotation);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "setAlias", "alias(" + object2 + ")=>" + object3);
        }
    }

    public void set(Object object2, IAnnotation iAnnotation) {
        IAnnotation iAnnotation2;
        if (iAnnotation != null && !(iAnnotation instanceof NullAnnotation)) {
            this.m_hasAnnotations = true;
            iAnnotation.setVariable(object2);
        }
        if ((iAnnotation2 = this.m_env.put(object2, iAnnotation)) != null) {
            this.m_env.put(object2, iAnnotation2);
            throw new XylemError("ERR_SYSTEM", "Annotation for '" + object2 + "' is already bound to '" + iAnnotation2 + "'");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "set", "annot(" + object2 + ")=>" + iAnnotation);
        }
    }

    public void setComputedLiteral(Instruction instruction2, Object object2) {
        HashSet<Object> hashSet;
        if (instruction2 instanceof IdentifierInstruction) {
            instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction2, this.getBindingEnvironment());
        }
        if ((hashSet = (HashSet<Object>)this.m_literals.get(instruction2)) == null) {
            hashSet = new HashSet<Object>();
            this.m_literals.put(instruction2, hashSet);
        }
        hashSet.add(object2);
    }

    public Set getComputedLiteral(Instruction instruction2) {
        if (instruction2 instanceof LiteralInstruction) {
            return Collections.singleton(((LiteralInstruction)instruction2).getValue());
        }
        if (!(instruction2 instanceof IdentifierInstruction)) {
            throw new XylemError("ERR_SYSTEM", "Literals may only be resolved against reduced code");
        }
        instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction2, this.getBindingEnvironment());
        return (Set)this.m_literals.get(instruction2);
    }

    public void setFunctionInfo(IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        this.m_functionInfo = iFunctionAnnotationInfo;
    }

    public IFunctionAnnotationInfo getFunctionInfo() {
        return this.m_functionInfo;
    }

    public void addInfo(Object object2, Object object3, Object object4) {
        Object object5;
        HashMap<Object, Object> hashMap = (HashMap<Object, Object>)this.m_infos.get(object2);
        if (hashMap == null) {
            hashMap = new HashMap<Object, Object>();
            this.m_infos.put(object2, hashMap);
        }
        if ((object5 = hashMap.put(object3, object4)) != null) {
            // empty if block
        }
    }

    public Object getInfo(Object object2, Object object3) {
        Map map2 = (Map)this.m_infos.get(object2);
        if (map2 == null) {
            return null;
        }
        return map2.get(object3);
    }

    public void debug() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "debug", "ENVIRONMENT:");
            for (Object k : this.m_env.keySet()) {
                s_logger.logp(Level.FINE, s_className, "debug", "  " + k + " => " + this.m_env.get(k));
            }
        }
    }
}

