/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import java.io.IOException;
import java.io.ObjectOutput;

public class WriteObjectFileHelper {
    protected ObjectOutput m_out;
    protected ITypeStore m_typeStore;

    public WriteObjectFileHelper(ITypeStore iTypeStore, ObjectOutput objectOutput) {
        this.m_out = objectOutput;
        this.m_typeStore = iTypeStore;
    }

    public void writeString(String string2) throws IOException {
        this.m_out.writeUTF(string2);
    }

    public void writeBindingName(Object object2) throws IOException {
        if (object2 instanceof String) {
            this.m_out.writeByte(1);
            this.writeString((String)object2);
        } else if (object2 instanceof Integer) {
            this.m_out.writeByte(2);
            this.m_out.writeInt((Integer)object2);
        } else {
            this.m_out.writeByte(3);
            this.m_out.writeObject(object2);
        }
    }

    public void writeInstructionTag(Instruction instruction2) throws IOException {
        this.writeString(instruction2.getClass().getName());
    }

    public void writeInt(int n2) throws IOException {
        this.m_out.writeInt(n2);
    }

    public void writeByte(int n2) throws IOException {
        this.m_out.writeByte(n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.m_out.writeBoolean(bl);
    }

    public void writeInstruction(Instruction instruction2) throws IOException {
        this.writeInstructionTag(instruction2);
        instruction2.write(this);
    }

    public void writeType(Type type2) throws IOException {
        if (type2 instanceof StreamType) {
            this.writeByte(1);
            this.writeType(((StreamType)type2).getElementType());
        } else if (type2 instanceof SlotType) {
            this.writeByte(2);
            this.writeType(((SlotType)type2).getElementType());
        } else if (type2 instanceof TupleType) {
            this.writeByte(3);
            TupleType tupleType = (TupleType)type2;
            Type[] typeArray = tupleType.getElementTypes();
            int n2 = typeArray.length;
            this.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.writeType(typeArray[i]);
            }
        } else if (type2 instanceof LambdaType) {
            this.writeByte(4);
            LambdaType lambdaType = (LambdaType)type2;
            this.writeBoolean(lambdaType.isPure());
            this.writeType(lambdaType.getReturnType());
            Type[] typeArray = lambdaType.getElementTypes();
            int n3 = typeArray.length;
            this.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                this.writeType(typeArray[i]);
            }
        } else if (IntType.s_intType.equals(type2)) {
            this.writeByte(5);
        } else if (ShortType.s_shortType.equals(type2)) {
            this.writeByte(6);
        } else if (LongType.s_longType.equals(type2)) {
            this.writeByte(7);
        } else if (FloatType.s_floatType.equals(type2)) {
            this.writeByte(8);
        } else if (DoubleType.s_doubleType.equals(type2)) {
            this.writeByte(9);
        } else if (CharType.s_charType.equals(type2)) {
            this.writeByte(10);
        } else if (ByteType.s_byteType.equals(type2)) {
            this.writeByte(11);
        } else if (BigIntegerType.s_bigIntegerType.equals(type2)) {
            this.writeByte(12);
        } else if (DecimalType.s_decimalType.equals(type2)) {
            this.writeByte(13);
        } else if (UnitType.s_unitType.equals(type2)) {
            this.writeByte(14);
        } else if (JavaObjectType.s_javaStringType.equals(type2)) {
            this.writeByte(15);
        } else if (type2 instanceof TypeVariable) {
            this.writeByte(16);
            this.m_out.writeObject(type2);
        } else if (type2 instanceof NamedType) {
            int n4;
            this.writeByte(17);
            NamedType namedType = (NamedType)type2;
            this.writeString(namedType.getName());
            this.writeBoolean(namedType.getModule() != null);
            if (namedType.getModule() != null) {
                this.writeString(namedType.getModule());
            }
            if ((n4 = namedType.getChildTypeCount()) > 0) {
                this.writeTypes(namedType.getTypeParameters());
            } else {
                this.writeInt(0);
            }
        } else if (type2 instanceof JavaObjectType) {
            this.writeByte(18);
            this.writeString(((JavaObjectType)type2).getClassName());
        } else {
            this.writeByte(19);
            this.writeObject(type2);
        }
    }

    public void writeTypeSpecificBindingSet(Binding[] bindingArray) throws IOException {
        int n2 = bindingArray.length;
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeBindingName(bindingArray[i].getName());
            this.writeType(bindingArray[i].getBindingType());
        }
    }

    public void writeTypes(Type[] typeArray) throws IOException {
        int n2 = typeArray.length;
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeType(typeArray[i]);
        }
    }

    public void writeObject(Object object2) throws IOException {
        this.m_out.writeObject(object2);
    }

    public void writeBindingNames(Binding[] bindingArray) throws IOException {
        int n2 = bindingArray.length;
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeBindingName(bindingArray[i].getName());
        }
    }

    public void writeBindingNames(Object[] objectArray) throws IOException {
        int n2 = objectArray.length;
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeBindingName(objectArray[i]);
        }
    }

    public void close() throws IOException {
        this.m_out.close();
        this.m_out = null;
    }

    public void writeTypeLambda(TypeLambda typeLambda) throws IOException {
        this.writeObject(typeLambda);
    }
}

