/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.ILUBResolver;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.LUBConstraint;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ForwardTypeReference;
import com.ibm.xltxe.rnm1.xylem.types.JavaArrayType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class TypeEnvironment
implements Serializable {
    private static final long serialVersionUID = 6412426351623830994L;
    protected HashMap m_typeVariableAssignments;
    protected HashMap m_typeVariableEquivalenceClasses;
    public TypeEnvironment m_original;
    protected Module m_program;
    public Instruction m_parseInstruction;

    public String toString() {
        return this.m_typeVariableAssignments.toString();
    }

    public TypeEnvironment(Module module) {
        this.m_program = module;
        this.m_typeVariableAssignments = new HashMap(5, 10.0f);
        this.m_typeVariableEquivalenceClasses = new HashMap(5, 10.0f);
        this.m_original = this;
    }

    public Module getModule() {
        return this.m_program;
    }

    public Object clone() {
        TypeEnvironment typeEnvironment = new TypeEnvironment(this.m_program, this);
        return typeEnvironment;
    }

    public TypeEnvironment copy() {
        TypeEnvironment typeEnvironment = new TypeEnvironment(this.m_program);
        try {
            typeEnvironment.incorporate(this);
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
            throw new RuntimeException();
        }
        return typeEnvironment;
    }

    protected TypeEnvironment(Module module, TypeEnvironment typeEnvironment) {
        this.m_original = typeEnvironment.m_original;
        this.m_program = module;
        this.m_typeVariableAssignments = (HashMap)typeEnvironment.m_typeVariableAssignments.clone();
        this.m_typeVariableEquivalenceClasses = (HashMap)typeEnvironment.m_typeVariableEquivalenceClasses.clone();
    }

    public Type resolveTypeVariable(TypeVariable typeVariable) {
        Type type2 = (Type)this.m_typeVariableAssignments.get(typeVariable);
        if (type2 == null && this.m_original != this && this.m_original != null) {
            type2 = this.m_original.resolveTypeVariable(typeVariable);
        }
        return type2;
    }

    public boolean areTypeVariablesInSameEquivalenceClass(TypeVariable typeVariable, TypeVariable typeVariable2) {
        Type type2 = (Type)this.m_typeVariableAssignments.get(typeVariable);
        Type type3 = (Type)this.m_typeVariableAssignments.get(typeVariable2);
        if (type2 == null && type3 == null) {
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable);
            Set set3 = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable2);
            if (set2 == null || set3 == null) {
                return false;
            }
            return set2.contains(typeVariable2);
        }
        return false;
    }

    protected final void markTypeVariablesAsEquivalent(TypeVariable typeVariable, TypeVariable typeVariable2, Instruction instruction2) throws TypeCheckException {
        Type type2 = (Type)this.m_typeVariableAssignments.get(typeVariable);
        Type type3 = (Type)this.m_typeVariableAssignments.get(typeVariable2);
        if (type2 == null && type3 == null) {
            HashSet<TypeVariable> hashSet = (HashSet<TypeVariable>)this.m_typeVariableEquivalenceClasses.get(typeVariable);
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable2);
            if (hashSet == null) {
                if (set2 == null) {
                    hashSet = new HashSet<TypeVariable>();
                    hashSet.add(typeVariable);
                    hashSet.add(typeVariable2);
                    this.m_typeVariableEquivalenceClasses.put(typeVariable, hashSet);
                    this.m_typeVariableEquivalenceClasses.put(typeVariable2, hashSet);
                    return;
                }
                set2.add(typeVariable);
                this.m_typeVariableEquivalenceClasses.put(typeVariable, set2);
                return;
            }
            if (set2 == null) {
                hashSet.add(typeVariable2);
                this.m_typeVariableEquivalenceClasses.put(typeVariable2, hashSet);
                return;
            }
            hashSet.addAll(set2);
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                this.m_typeVariableEquivalenceClasses.put(iterator.next(), hashSet);
            }
            return;
        }
        if (type2 != null && type3 != null) {
            this.unify(type2, type3, instruction2);
            return;
        }
        if (type2 == null && type3 != null) {
            Set set3 = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable);
            if (set3 == null) {
                this.assignTypeVariable(typeVariable, type3);
                return;
            }
            this.assignTypeToEquivalenceClass(set3, type3);
            return;
        }
        if (type2 != null && type3 == null) {
            Set set4 = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable2);
            if (set4 == null) {
                this.assignTypeVariable(typeVariable2, type2);
                return;
            }
            this.assignTypeToEquivalenceClass(set4, type2);
            return;
        }
    }

    protected final void assignTypeToEquivalenceClass(Set set2, Type type2) {
        for (Object e : set2) {
            if (!(type2 instanceof StreamType) || ((StreamType)type2).getElementType().equals(e)) {
                // empty if block
            }
            this.assignTypeVariable((TypeVariable)e, type2);
            this.m_typeVariableEquivalenceClasses.remove(e);
        }
    }

    final void assignTypeVariable(TypeVariable typeVariable, Type type2) {
        if (TypeEnvironment.contains(type2, typeVariable)) {
            throw new XylemError("ERR_SYSTEM", "One type contains another: " + type2 + " contains " + typeVariable);
        }
        this.m_typeVariableAssignments.put(typeVariable, type2);
    }

    static final boolean contains(Type type2, TypeVariable typeVariable) {
        if (type2.equals(typeVariable)) {
            return true;
        }
        int n2 = type2.getChildTypeCount();
        for (int i = 0; i < n2; ++i) {
            if (!TypeEnvironment.contains(type2.getChildType(i), typeVariable)) continue;
            return true;
        }
        return false;
    }

    public boolean resolveLUBConstraints(Set hashSet, ILUBResolver iLUBResolver, boolean bl) throws TypeCheckException {
        if (hashSet.isEmpty()) {
            return true;
        }
        HashSet hashSet2 = new HashSet();
        hashSet2.addAll(hashSet);
        hashSet = hashSet2;
        Set set2 = iLUBResolver.getTops();
        do {
            LUBConstraint lUBConstraint;
            int n2 = hashSet.size();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                lUBConstraint = (LUBConstraint)iterator.next();
                HashSet hashSet3 = new HashSet();
                Type type2 = null;
                for (Object e : lUBConstraint.m_set) {
                    Type type3 = ((Type)e).resolveType(this);
                    if (type3 != null) {
                        if (!set2.contains(type2 = type2 != null ? iLUBResolver.lub(type2, type3) : type3)) continue;
                        break;
                    }
                    Object v = this.m_typeVariableEquivalenceClasses.get(lUBConstraint.m_t);
                    Object v2 = this.m_typeVariableEquivalenceClasses.get(e);
                    if (v != null && v2 != null && v.equals(v2)) continue;
                    hashSet3.add(e);
                }
                if (type2 != null && (set2.contains(type2) || hashSet3.isEmpty())) {
                    this.unify(lUBConstraint.m_t, type2, null);
                    iterator.remove();
                    continue;
                }
                lUBConstraint.m_set = hashSet3;
                if (hashSet3.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                if (type2 == null) continue;
                hashSet3.add(type2);
            }
            if (n2 != hashSet.size() || n2 <= 0) continue;
            if (bl) {
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    lUBConstraint = (LUBConstraint)iterator.next();
                    if (lUBConstraint.m_t.resolveType(this) == null) {
                        this.unify(lUBConstraint.m_t, iLUBResolver.getDefaultTop(), null);
                    }
                    iterator.remove();
                }
                return true;
            }
            return false;
        } while (!hashSet.isEmpty());
        this.sanityCheck();
        return true;
    }

    public void unify(Type type2, Type type3, Instruction instruction2) throws TypeCheckException {
        String string2 = this.unifyQuietly(type2, type3, instruction2);
        if (string2 != null) {
            throw new TypeCheckException(string2, instruction2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String unifyQuietly(Type type2, Type type3, Instruction instruction2) throws TypeCheckException {
        if (type2 == null) return XylemMsg.createXylemMessage("ERR_SYSTEM", instruction2.getClass().getSimpleName() + " null-valued type in unification of '" + type2 + "','" + type3 + "'");
        if (type3 == null) {
            return XylemMsg.createXylemMessage("ERR_SYSTEM", instruction2.getClass().getSimpleName() + " null-valued type in unification of '" + type2 + "','" + type3 + "'");
        }
        if (type2 instanceof TypeVariable) {
            if (type3 instanceof TypeVariable) {
                this.markTypeVariablesAsEquivalent((TypeVariable)type2, (TypeVariable)type3, instruction2);
                return null;
            }
            Type type4 = (Type)this.m_typeVariableAssignments.get(type2);
            if (type4 != null) {
                return this.unifyQuietly(type4, type3, instruction2);
            }
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(type2);
            if (set2 == null) {
                this.assignTypeVariable((TypeVariable)type2, type3);
                return null;
            }
            this.assignTypeToEquivalenceClass(set2, type3);
            return null;
        }
        if (type3 instanceof TypeVariable) {
            Type type5 = (Type)this.m_typeVariableAssignments.get(type3);
            if (type5 != null) {
                return this.unifyQuietly(type2, type5, instruction2);
            }
            Set set3 = (Set)this.m_typeVariableEquivalenceClasses.get(type3);
            if (set3 == null) {
                this.assignTypeVariable((TypeVariable)type3, type2);
                return null;
            }
            this.assignTypeToEquivalenceClass(set3, type2);
            return null;
        }
        if (type2.getClass() == type3.getClass()) {
            return type2.unifyQuietly(this, type3, instruction2);
        }
        if (type2.equals(type3)) return null;
        if (type2 instanceof ForwardTypeReference) {
            return XylemMsg.createXylemMessage("ERR_SYSTEM", instruction2.getClass().getSimpleName() + " unresolved forward referenced type " + type2 + ".");
        }
        if (type3 instanceof ForwardTypeReference) {
            return XylemMsg.createXylemMessage("ERR_SYSTEM", instruction2.getClass().getSimpleName() + " unresolved forward referenced type " + type3 + ".");
        }
        if (type2 instanceof JavaArrayType && type3 instanceof JavaObjectType && ((JavaObjectType)type3).getClassName().equals("java.lang.Object")) {
            return null;
        }
        String string2 = instruction2 instanceof FunctionCallInstruction ? "(" + ((FunctionCallInstruction)instruction2).getFunction() + ")" : "";
        String string3 = instruction2 != null ? "(" + instruction2.getSourceLineNumber() + ")" : "";
        String string4 = instruction2 != null ? instruction2.getClass().getSimpleName() : "";
        return XylemMsg.createXylemMessage("ERR_SYSTEM", "\n" + string4 + string2 + string3 + " expected value of type " + type3.prettyPrint() + " but found type " + type2.prettyPrint() + " instead");
    }

    protected void sanityCheck() {
    }

    public void redirectFrom(TypeEnvironment typeEnvironment) {
        this.m_typeVariableAssignments = typeEnvironment.m_typeVariableAssignments;
        this.m_typeVariableEquivalenceClasses = typeEnvironment.m_typeVariableEquivalenceClasses;
    }

    public void incorporate(TypeEnvironment typeEnvironment) throws TypeCheckException {
        Type type2;
        if (typeEnvironment.m_typeVariableAssignments == this.m_typeVariableAssignments) {
            return;
        }
        for (Object object2 : typeEnvironment.m_typeVariableAssignments.keySet()) {
            type2 = (Type)typeEnvironment.m_typeVariableAssignments.get(object2);
            this.unify((Type)object2, type2, null);
        }
        for (Object object2 : typeEnvironment.m_typeVariableEquivalenceClasses.values()) {
            type2 = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Type type3 = (Type)iterator.next();
                if (type2 == null) {
                    type2 = type3;
                    continue;
                }
                this.unify(type2, type3, null);
            }
        }
    }
}

