/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;

public class TopLevelModuleImportDirective
extends ModuleImportDirective {
    private static final long serialVersionUID = -7849431194450199173L;
    protected String m_moduleName;

    public TopLevelModuleImportDirective() {
    }

    public TopLevelModuleImportDirective(String string2, ModuleSignature moduleSignature, String string3) {
        super(string2, moduleSignature);
        this.m_moduleName = string3;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    @Override
    public Instruction translateFunctionCall(ModuleFunctionCallInstruction moduleFunctionCallInstruction, Module module) {
        return new FunctionCallInstruction(TopLevelModuleImportDirective.translateFunctionName(moduleFunctionCallInstruction.getFunction(), module.getModuleImportDirective(moduleFunctionCallInstruction.getModule())), moduleFunctionCallInstruction.m_parameters);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("import-module", n2);
        prettyPrinter.print(" " + this.getLocalName());
        prettyPrinter.print(this.m_signature);
        prettyPrinter.printFormClose(n2);
    }

    public void setSignature(ModuleSignature moduleSignature) {
        this.m_signature = moduleSignature;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        super.read(readObjectFileHelper);
        this.m_moduleName = readObjectFileHelper.readString();
        this.m_signature = readObjectFileHelper.m_mss.resolveModuleSignature(this.m_moduleName);
        if (this.m_signature == null) {
            throw new XylemError("ERR_SYSTEM", " no sig for '" + this.m_moduleName + "'");
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_moduleName);
    }
}

