/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IdentityHashMap;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public final class ReductionHelper {
    protected IdentityHashMap m_convertedBindings;
    protected HashMap m_subexpressions;
    protected HashMap m_postConversionSubexpressions;
    public TypeEnvironment m_typeEnvironment;
    public Type m_type;
    private static ThreadLocal tLocal = new ThreadLocal();

    public static Instruction oneTimeReduceAndTypeCheck(TypeEnvironment typeEnvironment, Instruction instruction2, LinkedList linkedList) {
        Instruction instruction3 = new ReductionHelper(typeEnvironment).reduce(instruction2, instruction2.getBindingEnvironment());
        try {
            instruction3.typeCheck(typeEnvironment, instruction2.getBindingEnvironment(), linkedList);
        }
        catch (TypeCheckException typeCheckException) {
            throw new XylemError("ERR_SYSTEM", "Should not happen--reduction should be type preserving");
        }
        return instruction3;
    }

    public ReductionHelper(TypeEnvironment typeEnvironment) {
        this.m_convertedBindings = new IdentityHashMap();
        this.m_subexpressions = new HashMap(64);
        this.m_postConversionSubexpressions = new HashMap(64);
        this.m_typeEnvironment = typeEnvironment;
    }

    public IBinding lookupConvertedBinding(IBinding iBinding) {
        if (iBinding == null) {
            throw new RuntimeException();
        }
        IBinding iBinding2 = (IBinding)this.m_convertedBindings.get(iBinding);
        if (iBinding2 != null) {
            return iBinding2;
        }
        return iBinding;
    }

    public void registerConvertedBinding(IBinding iBinding, IBinding iBinding2) {
        if (iBinding2 == null) {
            throw new RuntimeException();
        }
        this.m_convertedBindings.put(iBinding, iBinding2);
    }

    public Object upgradeBinding(IBinding iBinding) {
        Object object2 = this.generateReducedIdentifier(iBinding.getName());
        this.m_convertedBindings.put(iBinding, iBinding);
        iBinding.setName(object2);
        return object2;
    }

    public Object generateReducedIdentifier(Object object2) {
        return ReductionHelper.generateIntermediateIdentifier2();
    }

    public static void resetIntermediateIdentifierCounter(int n2) {
        Counter counter = new Counter();
        counter.set(n2);
        tLocal.set(counter);
    }

    public static int getIntermediateIdentifierCount() {
        Counter counter = (Counter)tLocal.get();
        if (counter == null) {
            return 0;
        }
        return counter.get();
    }

    public static Integer generateIntermediateIdentifier2() {
        Counter counter = (Counter)tLocal.get();
        if (counter == null) {
            counter = new Counter();
            tLocal.set(counter);
        } else {
            counter.add();
        }
        return new Integer(counter.get());
    }

    public static Object newIdentifier(int n2) {
        Counter counter = (Counter)tLocal.get();
        if (counter == null) {
            counter = new Counter();
            tLocal.set(counter);
        }
        if (counter.get() < n2) {
            counter.set(n2);
        }
        return new Integer(n2);
    }

    public IBinding lookupSubexpression(Instruction instruction2) {
        return (IBinding)this.m_subexpressions.get(instruction2);
    }

    public void registerSubexpression(IBinding iBinding, Instruction instruction2, Instruction instruction3) {
        this.m_subexpressions.put(instruction2, iBinding);
        this.m_postConversionSubexpressions.put(instruction3, iBinding);
    }

    public Object clone() {
        return new ReductionHelper(this);
    }

    protected ReductionHelper(ReductionHelper reductionHelper) {
        this.m_convertedBindings = (IdentityHashMap)reductionHelper.m_convertedBindings.clone();
        this.m_subexpressions = (HashMap)reductionHelper.m_subexpressions.clone();
        this.m_postConversionSubexpressions = (HashMap)reductionHelper.m_postConversionSubexpressions.clone();
        this.m_typeEnvironment = reductionHelper.m_typeEnvironment;
        if (this.m_typeEnvironment == null) {
            throw new RuntimeException();
        }
    }

    public Instruction reduceToBasicInstruction(Instruction[] instructionArray, Instruction instruction2, BindingEnvironment bindingEnvironment) {
        if (instruction2 instanceof LiteralInstruction) {
            return instruction2;
        }
        IBinding iBinding = this.reduceToIdentifier(instructionArray, instruction2, "", bindingEnvironment);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
        identifierInstruction.m_hasBeenTypechecked = true;
        identifierInstruction.setCachedType(iBinding.getBindingType());
        return identifierInstruction;
    }

    public IBinding reduceToIdentifier(Instruction[] instructionArray, Instruction instruction2, Object object2, BindingEnvironment bindingEnvironment) {
        return this.reduceToIdentifier(instructionArray, instruction2, object2, bindingEnvironment, null);
    }

    public IBinding reduceToIdentifier(Instruction[] instructionArray, Instruction instruction2, Object object2, BindingEnvironment bindingEnvironment, LetInstruction letInstruction) {
        LetInstruction letInstruction2;
        if (instruction2 instanceof IdentifierInstruction) {
            return this.lookupConvertedBinding(((IdentifierInstruction)instruction2).getBinding());
        }
        IBinding iBinding = this.lookupSubexpression(instruction2);
        if (iBinding != null) {
            return iBinding;
        }
        instruction2.generateReducedForm(this, instructionArray, bindingEnvironment);
        instruction2.m_hasBeenTypechecked = false;
        Instruction instruction3 = instructionArray[0];
        if (instruction3 instanceof IdentifierInstruction) {
            return bindingEnvironment.getVariableBinding(((IdentifierInstruction)instruction3).getVariable());
        }
        iBinding = (IBinding)this.m_postConversionSubexpressions.get(instruction3);
        if (iBinding != null) {
            return iBinding;
        }
        Object object3 = this.generateReducedIdentifier(object2);
        if (letInstruction != null) {
            letInstruction2 = letInstruction;
            letInstruction2.m_bindingEnvironment = null;
            letInstruction2.getBinding().setName(object3);
            letInstruction2.resetCachedValueType();
            bindingEnvironment.setVariableBinding(letInstruction2.getBinding());
            letInstruction2.setValue(instruction3);
            letInstruction2.setBody(null);
        } else {
            letInstruction2 = new LetInstruction(object3, instruction3, null);
            bindingEnvironment.setVariableBinding(letInstruction2.getBinding());
            letInstruction2.resetCachedValueType();
            letInstruction2.setCachedType(this.m_type);
            letInstruction2.m_hasBeenTypechecked = true;
        }
        if (instructionArray[2] != null) {
            ((LetInstruction)instructionArray[2]).setBody(letInstruction2);
        } else {
            instructionArray[1] = letInstruction2;
        }
        instructionArray[2] = letInstruction2;
        this.registerSubexpression(letInstruction2.getBinding(), instruction2, instruction3);
        return letInstruction2.getBinding();
    }

    public Instruction reduce(Instruction instruction2, BindingEnvironment bindingEnvironment) {
        Instruction[] instructionArray = new Instruction[3];
        this.m_type = instruction2.getCachedType();
        instruction2.generateReducedForm(this, instructionArray, bindingEnvironment);
        instruction2.m_hasBeenTypechecked = false;
        if (instructionArray[2] != null) {
            ((LetInstruction)instructionArray[2]).setBody(instructionArray[0]);
        } else {
            instructionArray[1] = instructionArray[0];
        }
        return instructionArray[1];
    }

    private static class Counter {
        private int num = 1;

        private Counter() {
        }

        public int get() {
            return this.num;
        }

        public void add() {
            ++this.num;
        }

        public void set(int n2) {
            this.num = n2;
        }
    }
}

