/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;

public class ReadObjectFileHelper {
    protected ObjectInput m_in;
    protected ITypeStore m_typeStore;
    protected ModuleSignatureStore m_mss;
    private HashMap m_instructionClasses = new HashMap();

    public ReadObjectFileHelper(ITypeStore iTypeStore, ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) {
        this.m_in = objectInput;
        this.m_typeStore = iTypeStore;
        this.m_mss = moduleSignatureStore;
    }

    public String readString() throws IOException {
        return this.m_in.readUTF();
    }

    public Object readBindingName() throws Exception {
        switch (this.m_in.readByte()) {
            case 1: {
                return this.readString();
            }
            case 2: {
                return ReductionHelper.newIdentifier(this.m_in.readInt());
            }
        }
        return this.m_in.readObject();
    }

    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    public int readByte() throws IOException {
        return this.m_in.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    public Instruction readInstruction(BindingEnvironment bindingEnvironment) throws Exception {
        String string2 = this.readString();
        Class clazz = (Class)this.m_instructionClasses.get(string2);
        if (clazz == null) {
            clazz = ObjectFactory.findProviderClass(string2, Module.class.getClassLoader(), true);
            this.m_instructionClasses.put(string2, clazz);
        }
        Instruction instruction2 = (Instruction)clazz.newInstance();
        instruction2.read(this, bindingEnvironment);
        return instruction2;
    }

    public Type readType() throws Exception {
        byte by2 = this.m_in.readByte();
        switch (by2) {
            case 1: {
                return this.readType().getStreamType();
            }
            case 2: {
                return new SlotType(this.readType());
            }
            case 3: {
                int n2 = this.m_in.readInt();
                Type[] typeArray = new Type[n2];
                for (int i = 0; i < n2; ++i) {
                    typeArray[i] = this.readType();
                }
                return new TupleType(typeArray);
            }
            case 4: {
                boolean bl = this.readBoolean();
                Type type2 = this.readType();
                int n3 = this.m_in.readInt();
                Type[] typeArray = new Type[n3];
                for (int i = 0; i < n3; ++i) {
                    typeArray[i] = this.readType();
                }
                return new LambdaType(typeArray, type2, bl);
            }
            case 5: {
                return IntType.s_intType;
            }
            case 6: {
                return ShortType.s_shortType;
            }
            case 7: {
                return LongType.s_longType;
            }
            case 8: {
                return FloatType.s_floatType;
            }
            case 9: {
                return DoubleType.s_doubleType;
            }
            case 10: {
                return CharType.s_charType;
            }
            case 11: {
                return ByteType.s_byteType;
            }
            case 12: {
                return BigIntegerType.s_bigIntegerType;
            }
            case 13: {
                return DecimalType.s_decimalType;
            }
            case 14: {
                return UnitType.s_unitType;
            }
            case 15: {
                return JavaObjectType.s_javaStringType;
            }
            case 16: {
                return (TypeVariable)this.m_in.readObject();
            }
            case 17: {
                String string2 = this.readString();
                String string3 = this.readBoolean() ? this.readString() : null;
                Type[] typeArray = this.readTypes();
                return new NamedType(string2, string3, (Type[])(typeArray.length > 0 ? typeArray : null));
            }
            case 18: {
                String string4 = this.readString();
                return new JavaObjectType(string4);
            }
            case 19: {
                return (Type)this.m_in.readObject();
            }
        }
        throw new UnsupportedOperationException("" + by2);
    }

    public Binding[] readTypeSpecificBindingSet() throws Exception {
        return this.readTypeSpecificBindingSet(null);
    }

    public Binding[] readTypeSpecificBindingSet(ISpecialForm iSpecialForm) throws Exception {
        int n2 = this.readInt();
        Binding[] bindingArray = new Binding[n2];
        for (int i = 0; i < n2; ++i) {
            bindingArray[i] = new Binding(this.readBindingName(), this.readType(), iSpecialForm);
        }
        return bindingArray;
    }

    public Type[] readTypes() throws Exception {
        int n2 = this.readInt();
        Type[] typeArray = new Type[n2];
        for (int i = 0; i < n2; ++i) {
            typeArray[i] = this.readType();
        }
        return typeArray;
    }

    public Object readObject() throws Exception {
        return this.m_in.readObject();
    }

    public Object[] readBindingNames() throws Exception {
        int n2 = this.readInt();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.readBindingName();
        }
        return objectArray;
    }

    public void close() throws IOException {
        this.m_in.close();
        this.m_in = null;
    }

    public TypeLambda readTypeLambda() throws Exception {
        return (TypeLambda)this.m_in.readObject();
    }
}

