/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.fcg.bcel.FcgClassGenBCEL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.MixedModeFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.optimizers.SplitFunctions;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Program
extends Module {
    private static final long serialVersionUID = 6499428922689211647L;
    protected HashSet m_baseParameters = new HashSet();
    protected String m_generatedBaseClass = null;
    protected String m_className = "";
    private static final Logger s_logger = LoggerUtil.getLogger(Program.class);
    private static final String s_className = Program.class.getName();
    public static final boolean TIMESTAMPED_DUMPS = HiddenOptions.wasSpecified("timestamped-dumps");

    public Program(ModuleSignature moduleSignature) {
        super(moduleSignature.getName(), null, moduleSignature);
    }

    public Program() {
    }

    protected void generateRequiredFunctions(FcgCodeGenHelper fcgCodeGenHelper) {
        CodeGenerationOptimizationStyle[] codeGenerationOptimizationStyleArray = fcgCodeGenHelper.getSettings().getCodeGenOptimizationStyles();
        Iterator<Function> iterator = this.exportedFunctionsIterator();
        block2: while (iterator.hasNext()) {
            Object object2;
            Function function2 = iterator.next();
            if (function2.m_isClassMethod) continue;
            Type[] typeArray = new Type[function2.m_parameters.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = function2.m_parameters[i].getBindingType();
            }
            TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
            Type type2 = function2.getReturnType().resolveType(typeEnvironment);
            fcgCodeGenHelper.requestFunctionGeneration(new ConventionalFunctionGenerationStyle(function2));
            if (fcgCodeGenHelper.getSettings().isMixedModeModuleCompilation()) {
                fcgCodeGenHelper.requestFunctionGeneration(new MixedModeFunctionGenerationStyle(function2));
            }
            try {
                BindingEnvironment bindingEnvironment = function2.getBindingEnvironment();
                object2 = function2.getBody();
                for (int i = 0; i < codeGenerationOptimizationStyleArray.length; ++i) {
                    CodeGenerationOptimizationStyle codeGenerationOptimizationStyle = codeGenerationOptimizationStyleArray[i];
                    FunctionGenerationStyle functionGenerationStyle = codeGenerationOptimizationStyle.getSupportedFunctionGenerationStyle(function2);
                    if (functionGenerationStyle == null) continue;
                    fcgCodeGenHelper.requestFunctionGeneration(functionGenerationStyle);
                    continue block2;
                }
            }
            catch (Exception exception) {
                FFDCUtil.log(exception, this);
                object2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"could not codegen for '" + function2.getName() + "' "});
                s_logger.logp(Level.WARNING, s_className, "generateRequiredFunctions", (String)object2, exception);
            }
        }
    }

    public void setGeneratedBaseClass(String string2) {
        this.m_generatedBaseClass = string2;
    }

    public void setClassName(String string2) {
        this.m_className = string2;
    }

    @Override
    protected String innerToString() {
        return "program";
    }

    public static final void dumpXylemFile(Module module, File file, String string2, String string3) {
        Program.dumpXylemFile(module, file, string2 + "-" + string3);
    }

    public static final void dumpXylemFile(Module module, URL uRL, String string2, boolean bl) {
        File file = new File(uRL.getPath());
        String string3 = file.getName();
        string3 = string3.substring(0, string3.lastIndexOf(".cxo"));
        file = file.getParentFile();
        Program.dumpXylemFile(module, file, string3 + "-" + string2);
    }

    public static final void dumpXylemFile(Module module, File file, String string2) {
        try {
            file = file.getAbsoluteFile();
            File file2 = new File(file, string2 + (TIMESTAMPED_DUMPS ? "." + System.currentTimeMillis() : "") + ".xylem");
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                file3.mkdirs();
            }
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(";;;; Xylem code; roughly follows -*- Scheme -*- syntax.");
            module.dump(printWriter);
            printWriter.close();
            s_logger.logrb(Level.INFO, s_className, "dumpXylemFile", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{file2.getCanonicalPath()});
        }
        catch (IOException iOException) {
            String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"I/O error"});
            s_logger.logp(Level.WARNING, s_className, "dumpXylemFile", string3, iOException);
        }
    }

    public void generateCode(FcgCodeGenHelper fcgCodeGenHelper, SessionContext sessionContext) throws IOException {
        ArrayList arrayList = new ArrayList(this.m_adts.values());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object2, Object object3) {
                return ((AbstractDataType)object2).getName().compareTo(((AbstractDataType)object3).getName());
            }
        });
        ArrayList arrayList2 = new ArrayList(this.m_classes.values());
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object2, Object object3) {
                return ((ClassType)object2).getName().compareTo(((ClassType)object3).getName());
            }
        });
        this.generateRequiredFunctions(fcgCodeGenHelper);
        HashSet<String> hashSet = new HashSet<String>();
        HashMap hashMap = new HashMap(63);
        block4: while (!fcgCodeGenHelper.functionGenerationRequestsIsEmpty()) {
            Iterator iterator = fcgCodeGenHelper.functionGenerationRequestsIterator();
            Object object2 = (FunctionGenerationStyle)iterator.next();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "generateCode", "generating f=" + ((FunctionGenerationStyle)object2).getSignature() + " using fgs=" + object2.getClass());
            }
            iterator.remove();
            if (hashSet.contains(((FunctionGenerationStyle)object2).getSignature())) continue;
            hashSet.add(((FunctionGenerationStyle)object2).getSignature());
            Function function2 = ((FunctionGenerationStyle)object2).getFunction();
            while (true) {
                CodeGenerationSettings codeGenerationSettings;
                fcgCodeGenHelper.startFunction((FunctionGenerationStyle)object2);
                if (!hashMap.isEmpty()) {
                    hashMap = new HashMap(63);
                }
                CodeGenerationTracker codeGenerationTracker = new CodeGenerationTracker(hashMap, function2, fcgCodeGenHelper.getSettings().getCodeGenOptimizationStyles(), sessionContext);
                try {
                    ((FunctionGenerationStyle)object2).generateFunction(fcgCodeGenHelper, codeGenerationTracker);
                    continue block4;
                }
                catch (FcgClassGenBCEL.FcgMethodSizeException fcgMethodSizeException) {
                    codeGenerationSettings = fcgCodeGenHelper.getSettings();
                    if (codeGenerationSettings.getBCELAutoSplitFunctions()) {
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "generateCode", "Automatically splitting function " + function2.getName() + " with bcel size " + fcgMethodSizeException.size);
                        }
                        fcgCodeGenHelper.setAutosplitterInvoked(true);
                        new SplitFunctions((Module)this, codeGenerationSettings.getOrderSafeSplit()).splitOnce(function2);
                        continue;
                    }
                    throw fcgMethodSizeException;
                }
                catch (ClassGenException classGenException) {
                    codeGenerationSettings = fcgCodeGenHelper.getSettings();
                    if (codeGenerationSettings.getBCELAutoSplitFunctions()) {
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "generateCode", "Automatically splitting function " + function2.getName() + " due to bcel error " + classGenException);
                        }
                        fcgCodeGenHelper.setAutosplitterInvoked(true);
                        new SplitFunctions((Module)this, codeGenerationSettings.getOrderSafeSplit()).splitOnce(function2);
                        continue;
                    }
                    throw classGenException;
                }
                catch (FcgClassGenBCEL.FcgConstantPoolSizeException fcgConstantPoolSizeException) {
                    codeGenerationSettings = fcgCodeGenHelper.getSettings();
                    if (codeGenerationSettings.getBCELAutoSplitFunctions()) {
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "generateCode", "Creating a new partition ");
                        }
                        fcgCodeGenHelper.setAutosplitterInvoked(true);
                        fcgCodeGenHelper.generateCTorWithSessionContextParam(fcgCodeGenHelper.startFunctionGeneration());
                        fcgCodeGenHelper.completeClassGeneration(fcgCodeGenHelper.startFunctionGeneration());
                        fcgCodeGenHelper.startFunctionGenerationInNewPartition();
                        continue;
                    }
                    throw new RuntimeException(XylemMsg.createXylemMessage("ERR_SYSTEM", fcgConstantPoolSizeException.getMessage()));
                }
                break;
            }
        }
        for (Object object2 : arrayList) {
            ((AbstractDataType)object2).generateCode(fcgCodeGenHelper);
        }
        fcgCodeGenHelper.generateLambdaTypes();
        fcgCodeGenHelper.finish();
    }

    public static final void dumpXylemFunctions(Function[] functionArray, File file, String string2, String string3) {
        Program.dumpXylemFunctions(functionArray, file, string2 + "-" + string3);
    }

    public static final void dumpXylemFunctions(Function[] functionArray, File file, String string2) {
        try {
            File file2 = new File(file, string2 + ".xylem");
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            PrettyPrinter prettyPrinter = new PrettyPrinter(printWriter);
            for (int i = 0; i < functionArray.length; ++i) {
                functionArray[i].toString(prettyPrinter, 0);
            }
            printWriter.close();
            s_logger.logrb(Level.INFO, s_className, "dumpXylemFunctions", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{file2.getCanonicalPath()});
        }
        catch (IOException iOException) {
            String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"I/O error"});
            s_logger.logp(Level.SEVERE, s_className, "dumpXylemFunctions", string3, iOException);
        }
    }

    @Override
    protected void write(ObjectOutput objectOutput) throws IOException {
        Object object2;
        Object object32;
        WriteObjectFileHelper writeObjectFileHelper = new WriteObjectFileHelper(this, objectOutput);
        writeObjectFileHelper.writeString(this.m_name);
        this.m_signature.write(writeObjectFileHelper);
        Program.writeTypes(this, writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_modules.size());
        for (Object object32 : this.m_modules.values()) {
            writeObjectFileHelper.writeString(((Module)object32).m_signature.getName());
            ((Module)object32).m_signature.write(writeObjectFileHelper);
        }
        for (Object object32 : this.m_modules.values()) {
            Module.writeModule(objectOutput, (Module)object32);
        }
        object32 = this.getFunctions();
        writeObjectFileHelper.writeInt(object32.size());
        Iterator<Object> iterator = object32.iterator();
        while (iterator.hasNext()) {
            object2 = (Function)iterator.next();
            ((Function)object2).write(writeObjectFileHelper);
        }
        object2 = this.getTypeAliases();
        writeObjectFileHelper.writeInt(object2.size());
        iterator = object2.iterator();
        Set set2 = this.getTypeAliasNames();
        Iterator iterator2 = set2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator2.next();
            writeObjectFileHelper.writeString(string2);
            Type type2 = (Type)iterator.next();
            writeObjectFileHelper.writeType(type2);
        }
    }

    @Override
    protected void read(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        Object object2;
        int n2;
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(this, objectInput, moduleSignatureStore);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading program");
        }
        this.m_name = readObjectFileHelper.readString();
        this.m_signature = new ModuleSignature();
        this.m_signature.read(readObjectFileHelper);
        moduleSignatureStore.registerModuleSignature(this.m_name, this.m_signature);
        Program.readTypes(this, readObjectFileHelper);
        int n3 = readObjectFileHelper.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading " + n3 + " signatures");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = new ModuleSignature();
            String string2 = readObjectFileHelper.readString();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "read", "reading " + string2 + " signature");
            }
            ((ModuleSignature)object2).read(readObjectFileHelper);
            moduleSignatureStore.registerModuleSignature(string2, (ModuleSignature)object2);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading " + n3 + " modules");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = Module.readModule(objectInput, moduleSignatureStore);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "read", "read " + ((AbstractTypeStore)object2).getName() + " signature");
            }
            this.addModule((Module)object2);
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = new Function();
            ((Function)object2).read(readObjectFileHelper);
            this.addFunction((Function)object2);
        }
        n3 = readObjectFileHelper.readInt();
        for (int i = 0; i < n3; ++i) {
            object2 = readObjectFileHelper.readString();
            Type type2 = readObjectFileHelper.readType();
            this.addTypeAlias((String)object2, type2);
        }
        ModuleLinker.reflattenModules(this);
    }
}

