/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xci.Cursor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;

public class PrettyPrinter {
    protected StringWriter m_sw;
    protected PrintWriter m_pw;
    protected int m_pos = 0;
    protected int m_lineWidth = 150;
    protected boolean m_lastIndent = false;
    protected boolean m_lastNewline = false;
    protected HashSet m_moduleSignatures = new HashSet();
    public static final boolean PRINTANNOTATIONS = HiddenOptions.optionValueIs("printAnnotations", "on");

    public PrettyPrinter() {
        this.m_sw = new StringWriter();
        this.m_pw = new PrintWriter(this.m_sw);
    }

    public PrettyPrinter(Writer writer) {
        this.m_pw = new PrintWriter(writer);
    }

    public void addModuleSignature(ModuleSignature moduleSignature) {
        this.m_moduleSignatures.add(moduleSignature);
    }

    public String dumpModuleSignatures() {
        this.m_pw.flush();
        this.m_sw = new StringWriter();
        this.m_pw = new PrintWriter(this.m_sw);
        for (ModuleSignature moduleSignature : this.m_moduleSignatures) {
            moduleSignature.toString(this, 0);
        }
        this.m_pw.flush();
        return this.m_sw.toString();
    }

    public void printIdentifier(IBinding iBinding, int n2) {
        String string2 = PrettyPrinter.prettyPrintIdentifier(iBinding.getName());
        string2 = this.getAnnotations(iBinding, string2);
        this.printToken(string2, n2);
    }

    public String getAnnotations(IBinding iBinding, String string2) {
        if (PRINTANNOTATIONS) {
            Cursor.Profile profile;
            Cursor.Profile profile2;
            ForkInformation forkInformation = iBinding.getForkInformation();
            if (forkInformation == null) {
                profile2 = Cursor.Profile.NONE;
                profile = Cursor.Profile.NONE;
            } else {
                profile2 = forkInformation._profile;
                if (profile2 == null) {
                    profile2 = Cursor.Profile.NONE;
                }
                if ((profile = forkInformation._profile) == null) {
                    profile = Cursor.Profile.NONE;
                }
            }
            string2 = string2 + "%" + profile2 + "%" + profile + "%" + iBinding.getVariableUse();
        }
        return string2;
    }

    public void printIdentifier(Object object2, int n2) {
        this.printToken(PrettyPrinter.prettyPrintIdentifier(object2), n2);
    }

    public void printAnnotatedIdentifier(Object object2, int n2, int n3) {
        this.printToken(PrettyPrinter.prettyPrintAnnotatedIdentifier(object2, n2), n3);
    }

    public static String prettyPrintIdentifier(Object object2) {
        String string2 = object2 instanceof Number ? "#" + object2 : object2.toString();
        return string2;
    }

    public static String prettyPrintAnnotatedIdentifier(Object object2, int n2) {
        return object2 instanceof Number ? "#" + object2 + "#(" + n2 + ")" : object2.toString() + "#(" + n2 + ")";
    }

    public void printToken(String string2, int n2) {
        if (string2.length() + this.m_pos > this.m_lineWidth) {
            this.newline();
            this.indent(n2);
        } else if (!this.m_lastIndent && !string2.equals(")")) {
            this.space();
        }
        this.print(string2);
    }

    public void printToken(int n2, int n3) {
        String string2 = Integer.toString(n2);
        if (string2.length() + this.m_pos > this.m_lineWidth) {
            this.newline();
            this.indent(n3);
        } else if (!this.m_lastIndent && !string2.equals(")")) {
            this.space();
        }
        this.print(string2);
    }

    public void indent(int n2) {
        if (!this.m_lastNewline) {
            this.newline();
        }
        for (int i = 0; i < n2; ++i) {
            this.m_pw.print("  ");
        }
        this.m_pos += 2 * n2;
        this.m_lastIndent = true;
    }

    public void print(Object object2) {
        this.print(object2.toString());
    }

    public void print(String string2) {
        this.m_lastIndent = false;
        this.m_lastNewline = false;
        this.m_pos += string2 == null ? 0 : string2.length();
        this.m_pw.print(string2);
    }

    public void printlnFormOpen(String string2, int n2) {
        this.indent(n2);
        this.print("(");
        this.print(string2);
        this.newline();
    }

    public void printFormOpenIdentifier(Object object2, int n2) {
        this.printFormOpen(object2 == null ? "!null!" : (object2 instanceof Number ? "#" + object2 : object2.toString()), n2);
    }

    public void printFormOpenIdentifier(IBinding iBinding, int n2) {
        Object object2 = iBinding.getName();
        String string2 = object2 == null ? "!null!" : (object2 instanceof Number ? "#" + object2 : object2.toString());
        string2 = this.getAnnotations(iBinding, string2);
        this.printFormOpen(string2, n2);
    }

    public void printFormOpen(String string2, int n2) {
        this.indent(n2);
        this.print("(");
        this.print(string2);
    }

    public void printFormClose(int n2) {
        this.printToken(")", n2);
    }

    public void println(String string2) {
        this.m_pw.println(string2);
        this.m_pos = 0;
        this.m_lastIndent = false;
    }

    public void space() {
        this.m_pw.print(' ');
        ++this.m_pos;
        this.m_lastIndent = false;
        this.m_lastNewline = false;
    }

    public void newline() {
        this.m_pw.println();
        this.m_pos = 0;
        this.m_lastIndent = false;
        this.m_lastNewline = true;
    }

    public String toString() {
        this.m_pw.flush();
        return this.m_sw.toString();
    }

    public void close() {
        this.m_pw.close();
    }

    public void comment(String string2, int n2) {
        this.newline();
        this.indent(n2);
        this.println(string2);
    }

    public void print(ModuleSignature moduleSignature) {
        if (moduleSignature == null) {
            this.println("!NULL-SIG!:");
        } else {
            this.m_moduleSignatures.add(moduleSignature);
            this.print(moduleSignature.prettyPrint());
        }
    }

    public void printComment(String string2, int n2) {
        string2 = string2.replace('\r', ' ');
        int n3 = 0;
        while (n3 < string2.length()) {
            int n4 = string2.indexOf(10, n3);
            if (n4 < 0) {
                n4 = string2.length();
            }
            this.println("");
            this.printToken(";; " + string2.substring(n3, n4), n2);
            n3 = n4 + 1;
        }
    }
}

