/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BaseDesugarer;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnionInjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnionMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.UnionType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class PolymorphicADTDesugarer
extends BaseDesugarer {
    public PolymorphicADTDesugarer(Module module) {
        super(module);
    }

    @Override
    public Type convertType(Type type2) {
        if (type2 == null) {
            throw new RuntimeException();
        }
        Type type3 = type2;
        if (this.getCurrentFunction() != null) {
            type2 = type2.resolveType(this.getCurrentFunction().getTypeEnvironment());
        }
        if (type2 instanceof TupleType) {
            TupleType tupleType = (TupleType)type2;
            Type[] typeArray = tupleType.getElementTypes();
            Type[] typeArray2 = new Type[typeArray.length];
            for (int i = 0; i < typeArray2.length; ++i) {
                typeArray2[i] = this.convertType(typeArray[i]);
            }
            return PolymorphicADTDesugarer.generateType(this.m_prog, typeArray2, "tuple");
        }
        if (type2 instanceof UnionType) {
            UnionType unionType = (UnionType)type2;
            Type[] typeArray = unionType.getElementTypes();
            Type[] typeArray3 = new Type[typeArray.length];
            for (int i = 0; i < typeArray3.length; ++i) {
                typeArray3[i] = this.convertType(typeArray[i]);
            }
            return PolymorphicADTDesugarer.generateUnionType(this.m_prog, typeArray3, "union");
        }
        return super.convertType(type3);
    }

    @Override
    public Instruction optimizeStep2(Instruction instruction2) {
        if (instruction2 instanceof TupleInstruction) {
            TupleInstruction tupleInstruction = (TupleInstruction)instruction2;
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(tupleInstruction))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            instruction2 = new ConstructorInstantiationInstruction(abstractDataType.getName(), tupleInstruction.m_parameters);
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction2 instanceof TupleMatchInstruction) {
            TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction2;
            Instruction instruction3 = tupleMatchInstruction.getToMatch();
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(instruction3))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            MatchInstruction.DeconstructionMatch deconstructionMatch = new MatchInstruction.DeconstructionMatch(abstractDataType.m_constructors[0], tupleMatchInstruction.getVariableNames(), (Instruction)LiteralInstruction.booleanFalseLiteral());
            instruction2 = new MatchInstruction(instruction3, new MatchInstruction.Match[]{deconstructionMatch}, null);
            instruction2.setSourceFilename(tupleMatchInstruction.getSourceFilename());
            instruction2.setSourceLineNumber(tupleMatchInstruction.getSourceLineNumber());
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
            deconstructionMatch.setHandler(tupleMatchInstruction.getBody());
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction2 instanceof UnionInjectInstruction) {
            UnionInjectInstruction unionInjectInstruction = (UnionInjectInstruction)instruction2;
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(unionInjectInstruction))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            AbstractDataType.Constructor constructor = abstractDataType.getConstructor(unionInjectInstruction.getIndex());
            instruction2 = new ConstructorInstantiationInstruction(constructor, new Instruction[]{unionInjectInstruction.getOperand()});
        } else if (instruction2 instanceof UnionMatchInstruction) {
            int n2;
            UnionMatchInstruction unionMatchInstruction = (UnionMatchInstruction)instruction2;
            Instruction instruction4 = unionMatchInstruction.getToMatch();
            AbstractDataType abstractDataType = ((NamedType)this.convertType(this.resolveType(instruction4))).resolveNameToADT(this.getCurrentFunction().getTypeEnvironment());
            boolean[] blArray = new boolean[abstractDataType.getConstructorCount()];
            MatchInstruction.Match[] matchArray = new MatchInstruction.DeconstructionMatch[unionMatchInstruction.getChildInstructionCount() - 1];
            for (n2 = 0; n2 < matchArray.length; ++n2) {
                IBinding[] iBindingArray = unionMatchInstruction.getChildInstructionBindings(n2 + 1);
                Type type2 = this.convertType(iBindingArray[0].getBindingType());
                AbstractDataType.Constructor constructor = null;
                for (int i = 0; i < blArray.length; ++i) {
                    if (blArray[i] || !type2.equals(abstractDataType.getConstructor(i).getParameterTypes()[0])) continue;
                    constructor = abstractDataType.getConstructor(i);
                    blArray[i] = true;
                    break;
                }
                if (constructor == null) {
                    new XylemError("ERR_SYSTEM", "UnionMatchInstruction has a type not in a UnionType: " + iBindingArray[0].getBindingType().prettyPrint());
                }
                matchArray[n2] = new MatchInstruction.DeconstructionMatch(constructor, new Object[]{iBindingArray[0].getName()}, (Instruction)LiteralInstruction.booleanFalseLiteral());
            }
            instruction2 = new MatchInstruction(instruction4, matchArray, null);
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
            for (n2 = 0; n2 < matchArray.length; ++n2) {
                matchArray[n2].setHandler(unionMatchInstruction.getChildInstruction(n2 + 1));
            }
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction2 instanceof ProcessStreamInstruction) {
            ProcessStreamInstruction processStreamInstruction = (ProcessStreamInstruction)instruction2;
            processStreamInstruction.setStateADTType(this.resolveType(processStreamInstruction.getBody()));
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction2 instanceof ParallelForEachInstruction) {
            ParallelForEachInstruction parallelForEachInstruction = (ParallelForEachInstruction)instruction2;
            parallelForEachInstruction.setBodyADTType(this.resolveType(parallelForEachInstruction.getBody()));
            instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
        } else if (instruction2 instanceof MatchInstruction) {
            MatchInstruction matchInstruction = (MatchInstruction)instruction2;
            matchInstruction.desugarADTLambdas(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), this);
        } else if (instruction2 instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction2;
            constructorInstantiationInstruction.desugarADTLambdas(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), this);
        } else {
            return super.optimizeStep2(instruction2);
        }
        return instruction2;
    }
}

