/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(Optimizer.class);
    private static final String s_className = Optimizer.class.getName();
    protected Function m_currentFunction = null;
    protected boolean m_skipStringStreams = true;

    protected Instruction optimizeStep(Instruction instruction2) {
        return instruction2;
    }

    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        return this.optimizeStep(instruction2);
    }

    public Instruction optimize(Instruction instruction2) {
        Instruction instruction3 = this.optimizeStep(instruction2, null, -1);
        if (instruction3 == null) {
            return instruction2;
        }
        if (instruction3 != instruction2) {
            return instruction3;
        }
        this.optimizeChildren(instruction2);
        return instruction2;
    }

    public void optimizeFunction(Function function2) {
        Function function3 = this.m_currentFunction;
        this.m_currentFunction = function2;
        try {
            function2.m_body = this.optimize(function2.getBody());
        }
        catch (StackOverflowError stackOverflowError) {
            FFDCUtil.log(stackOverflowError, this);
            try {
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Stack Overflow caught optimizing " + function2.getName()});
                s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", string2, stackOverflowError);
                File file = new File("stacktrace.txt");
                stackOverflowError.printStackTrace(new PrintStream(new FileOutputStream(file)));
                s_logger.logrb(Level.INFO, s_className, "optimizeFunction", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{file.getCanonicalPath()});
                Program.dumpXylemFunctions(new Function[]{function2}, null, "stackoverflow");
                throw new Error(string2);
            }
            catch (IOException iOException) {
                String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"I/O error"});
                s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", string3, iOException);
                throw new Error(string3);
            }
        }
        catch (Exception exception) {
            FFDCUtil.log(exception, this);
            String string4 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{exception.getClass().getName() + " encountered in " + this.getClass().getName() + " in function " + function2.getName()});
            s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", string4, exception);
            throw new RuntimeException(string4);
        }
        this.m_currentFunction = function3;
    }

    protected void optimizeChildren(Instruction instruction2) {
        int n2;
        if (this.m_skipStringStreams && instruction2 instanceof StreamInstruction && ((StreamInstruction)instruction2).isString()) {
            return;
        }
        ArrayList<OptimizationStep> arrayList = new ArrayList<OptimizationStep>();
        int n3 = instruction2.getChildInstructionCount();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            arrayList.add(new OptimizationStep(instruction2, instruction2.getChildInstruction(n2), n2));
        }
        while (!arrayList.isEmpty()) {
            int n4;
            n2 = arrayList.size() - 1;
            OptimizationStep optimizationStep = (OptimizationStep)arrayList.remove(n2);
            Instruction instruction3 = optimizationStep.getParent();
            Instruction instruction4 = optimizationStep.getCurrent();
            Instruction instruction5 = this.optimizeStep(instruction4, instruction3, n4 = optimizationStep.getPosition());
            if (instruction5 == null) continue;
            if (instruction5 != instruction4) {
                instruction3.setChildInstruction(n4, instruction5);
                instruction4.m_bindingEnvironment = null;
                continue;
            }
            if (this.m_skipStringStreams && instruction4 instanceof StreamInstruction && ((StreamInstruction)instruction4).isString()) continue;
            int n5 = instruction4.getChildInstructionCount();
            arrayList.ensureCapacity(n2 + n5);
            for (int i = n5 - 1; i >= 0; --i) {
                arrayList.add(new OptimizationStep(instruction4, instruction4.getChildInstruction(i), i));
            }
        }
    }

    protected Instruction doTypeCheck(Instruction instruction2, Instruction instruction3, BindingEnvironment bindingEnvironment) {
        try {
            LinkedList<Function> linkedList = new LinkedList<Function>();
            linkedList.add(this.m_currentFunction);
            instruction3.typeCheck(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, linkedList);
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
            System.out.println(">> function: " + this.m_currentFunction);
            System.out.println(">> original: " + instruction2);
            System.out.println(">> replacement: " + instruction3);
            throw new RuntimeException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
        return instruction3;
    }

    public Type resolveType(Instruction instruction2) {
        TypeEnvironment typeEnvironment = this.m_currentFunction.getTypeEnvironment();
        BindingEnvironment bindingEnvironment = instruction2.getBindingEnvironment();
        if (bindingEnvironment == null) {
            return instruction2.getType(typeEnvironment, this.m_currentFunction.getBindingEnvironment()).resolveType(typeEnvironment);
        }
        return instruction2.getCachedType().resolveType(typeEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_currentFunction.getTypeEnvironment().getModule();
    }

    public Function getCurrentFunction() {
        return this.m_currentFunction;
    }

    static class OptimizationStep {
        private Instruction m_parent;
        private Instruction m_current;
        private int m_position;

        public OptimizationStep(Instruction instruction2, Instruction instruction3, int n2) {
            this.m_parent = instruction2;
            this.m_current = instruction3;
            this.m_position = n2;
        }

        public Instruction getParent() {
            return this.m_parent;
        }

        public Instruction getCurrent() {
            return this.m_current;
        }

        public int getPosition() {
            return this.m_position;
        }
    }
}

