/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IObjectFilePersistence;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModuleSignature
extends AbstractTypeStore
implements Serializable,
IObjectFilePersistence {
    private static final long serialVersionUID = -497906467738812098L;
    public HashMap<String, FunctionSignature> m_functionSignatures = new HashMap();
    protected HashMap<String, ModuleImportDirective> m_moduleImportDirectives = new HashMap();

    public ModuleSignature(String string2) {
        this.m_name = string2;
    }

    public ModuleSignature() {
    }

    public void addModuleImportDirective(ModuleImportDirective moduleImportDirective) {
        this.m_moduleImportDirectives.put(moduleImportDirective.getLocalName(), moduleImportDirective);
    }

    public ModuleSignature getModuleSignature(String string2) {
        ModuleImportDirective moduleImportDirective = this.m_moduleImportDirectives.get(string2);
        if (moduleImportDirective == null) {
            for (ModuleImportDirective moduleImportDirective2 : this.m_moduleImportDirectives.values()) {
                ModuleSignature moduleSignature = moduleImportDirective2.getSignature();
                ModuleSignature moduleSignature2 = moduleSignature.getModuleSignature(string2);
                if (moduleSignature2 == null) continue;
                return moduleSignature2;
            }
            return null;
        }
        return moduleImportDirective.getSignature();
    }

    public void addFunctionSignature(FunctionSignature functionSignature) {
        this.m_functionSignatures.put(functionSignature.getFunctionName(), functionSignature);
    }

    public void removeFunctionSignature(String string2) {
        this.m_functionSignatures.remove(string2);
    }

    public boolean containsFunction(String string2) {
        return this.m_functionSignatures.containsKey(string2);
    }

    public FunctionSignature getFunctionSignature(String string2) {
        return this.m_functionSignatures.get(string2);
    }

    public Map<String, FunctionSignature> getFunctionSignatureMap() {
        return this.m_functionSignatures;
    }

    public String prettyPrint() {
        return this.m_name;
    }

    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("module-signature", n2 + 0);
        prettyPrinter.printToken(this.m_name, n2);
        Iterator iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            AbstractDataType abstractDataType = (AbstractDataType)iterator.next();
            prettyPrinter.printFormOpen("declare-datatype", n2 + 1);
            prettyPrinter.printToken(abstractDataType.getName(), n2 + 1);
            prettyPrinter.printFormClose(n2 + 1);
        }
        iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            ((AbstractDataType)iterator.next()).toString(prettyPrinter, n2 + 1);
        }
        for (FunctionSignature functionSignature : this.m_functionSignatures.values()) {
            functionSignature.toString(prettyPrinter, 1);
        }
        prettyPrinter.printFormClose(n2 + 0);
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        this.write(new WriteObjectFileHelper(this, objectOutput));
    }

    public void read(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        this.read(new ReadObjectFileHelper(this, objectInput, moduleSignatureStore));
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeString(this.m_name);
        writeObjectFileHelper.writeInt(this.m_moduleImportDirectives.size());
        for (ModuleImportDirective object22 : this.m_moduleImportDirectives.values()) {
            object22.write(writeObjectFileHelper);
        }
        ModuleSignature.writeTypes(this, writeObjectFileHelper);
        Collection<FunctionSignature> collection2 = this.m_functionSignatures.values();
        writeObjectFileHelper.writeInt(collection2.size());
        for (FunctionSignature functionSignature : collection2) {
            functionSignature.write(writeObjectFileHelper);
        }
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        int n2;
        this.m_name = readObjectFileHelper.readString();
        int n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            TopLevelModuleImportDirective topLevelModuleImportDirective = new TopLevelModuleImportDirective();
            topLevelModuleImportDirective.read(readObjectFileHelper);
            this.addModuleImportDirective(topLevelModuleImportDirective);
        }
        ModuleSignature.readTypes(this, readObjectFileHelper);
        n2 = readObjectFileHelper.readInt();
        for (int i = 0; i < n2; ++i) {
            FunctionSignature functionSignature = new FunctionSignature();
            functionSignature.read(readObjectFileHelper);
            this.addFunctionSignature(functionSignature);
        }
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    public ModuleSignature cloneModule() {
        ModuleSignature moduleSignature = new ModuleSignature(this.m_name);
        moduleSignature.m_adtDefinitions = (ArrayList)this.m_adtDefinitions.clone();
        moduleSignature.m_adts = (HashMap)this.m_adts.clone();
        moduleSignature.m_compoundTypes = (HashMap)this.m_compoundTypes.clone();
        moduleSignature.m_constructors = (HashMap)this.m_constructors.clone();
        moduleSignature.m_functionSignatures = (HashMap)this.m_functionSignatures.clone();
        return moduleSignature;
    }
}

