/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.FunctorApplicationDirective;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.IdentityHashMap;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ModuleLinker {
    protected static void flattenADTs(Program program, ITypeStore iTypeStore, String string2, IdentityHashMap identityHashMap) {
        CompoundType compoundType;
        Iterator iterator = iTypeStore.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            compoundType = (AbstractDataType)iterator.next();
            if (identityHashMap.containsKey(compoundType)) continue;
            identityHashMap.put(compoundType, compoundType);
            program.addAbstractDataType((AbstractDataType)compoundType);
        }
        iterator = iTypeStore.getClassesIterator();
        while (iterator.hasNext()) {
            compoundType = (ClassType)iterator.next();
            if (identityHashMap.containsKey(compoundType)) continue;
            identityHashMap.put(compoundType, compoundType);
            for (ClassType.Method method : ((ClassType)compoundType).m_methods.values()) {
                method.setFunction(ModuleImportDirective.translateFunctionName(method.getFunction(), string2));
            }
            program.addClass((ClassType)compoundType);
        }
    }

    protected static void flattenModule(Program program, Module module, ArrayList arrayList, HashSet hashSet, Collection collection2, IdentityHashMap identityHashMap, final boolean bl) {
        Serializable serializable;
        Object object22;
        if (!bl) {
            ModuleLinker.flattenADTs(program, module, module.getName(), identityHashMap);
            ModuleLinker.flattenADTs(program, module.m_signature, module.getName(), identityHashMap);
        }
        Iterator<Object> iterator = module.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            object22 = module.m_modules.get(iterator.next());
            ModuleLinker.flattenModule(program, (Module)object22, arrayList, hashSet, collection2, identityHashMap, false);
            iterator.remove();
        }
        for (Object object22 : module.getFunctors()) {
            ModuleLinker.convertFunctor(program, (Functor)object22);
        }
        for (Object object22 : module.getModuleImportDirectives()) {
            if (object22 instanceof FunctorApplicationDirective) {
                serializable = (FunctorApplicationDirective)object22;
                arrayList.add(serializable);
                hashSet.add(module.getFunctor(((FunctorApplicationDirective)serializable).m_functorName));
            } else if (object22 instanceof TopLevelModuleImportDirective) {
                ModuleLinker.flattenADTs(program, ((ModuleImportDirective)object22).getSignature(), ((TopLevelModuleImportDirective)object22).getModuleName(), identityHashMap);
                continue;
            }
            ModuleLinker.flattenADTs(program, ((ModuleImportDirective)object22).getSignature(), "", identityHashMap);
        }
        module.getFunctors().clear();
        iterator = module.getFunctions().iterator();
        object22 = new IdentityHashMap();
        while (iterator.hasNext()) {
            serializable = (Function)iterator.next();
            ((Function)serializable).m_name = ModuleImportDirective.translateFunctionName(((Function)serializable).getName(), module);
            new TailRecursiveOptimizer((IdentityHashMap)object22){
                Module m_m;
                final /* synthetic */ IdentityHashMap val$convertedFCIs;
                {
                    this.val$convertedFCIs = identityHashMap;
                }

                @Override
                protected Instruction optimizeStep2(Instruction instruction2) {
                    if (!bl && instruction2 instanceof FunctionCallInstruction) {
                        if (this.val$convertedFCIs.containsKey(instruction2)) {
                            return instruction2;
                        }
                        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                        functionCallInstruction.setFunction(ModuleImportDirective.translateFunctionName(functionCallInstruction.getFunction(), this.m_m));
                        this.val$convertedFCIs.put(functionCallInstruction, functionCallInstruction);
                    } else if (instruction2 instanceof ModuleFunctionCallInstruction) {
                        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction2;
                        ModuleImportDirective moduleImportDirective = this.m_m.getModuleImportDirective(moduleFunctionCallInstruction.getModule());
                        if (moduleImportDirective == null) {
                            throw new XylemError("ERR_SYSTEM", "module import not found for moulde '" + moduleFunctionCallInstruction.getModule() + "' in " + moduleFunctionCallInstruction);
                        }
                        Instruction instruction3 = moduleImportDirective.translateFunctionCall(moduleFunctionCallInstruction, this.m_m);
                        Instruction.propagateInfo(instruction2, instruction3);
                        return instruction3;
                    }
                    return instruction2;
                }

                Optimizer init(Module module) {
                    this.m_m = module;
                    return this;
                }
            }.init(module).optimizeFunction((Function)serializable);
            iterator.remove();
            collection2.add(serializable);
        }
        module.m_moduleDefinitions.clear();
        module.m_functors.clear();
    }

    public static void flattenModules(Program program) {
        ModuleLinker.flattenModules(program, false);
    }

    public static void reflattenModules(Program program) {
        ModuleLinker.flattenModules(program, true);
    }

    private static void flattenModules(Program program, boolean bl) {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        ArrayList arrayList2 = new ArrayList();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        ModuleLinker.flattenModule(program, program, arrayList, hashSet, arrayList2, identityHashMap, bl);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            program.addFunction((Function)iterator.next());
        }
        for (Object object2 : hashSet) {
            ModuleSignature[] moduleSignatureArray = ((Functor)object2).getParameters();
            Object object3 = ((Functor)object2).getParameterNames();
            HashSet<FunctorApplicationDirective> hashSet2 = new HashSet<FunctorApplicationDirective>();
            for (FunctorApplicationDirective functorApplicationDirective : arrayList) {
                if (!functorApplicationDirective.m_functorName.equals(((Functor)object2).getName())) continue;
                hashSet2.add(functorApplicationDirective);
            }
            for (int i = 0; i < moduleSignatureArray.length; ++i) {
                for (FunctionSignature functionSignature : ((ModuleSignature)moduleSignatureArray[i]).m_functionSignatures.values()) {
                    Binding[] bindingArray = new Binding[functionSignature.m_parameterTypes.length + 1];
                    Instruction[] instructionArray = new Instruction[functionSignature.m_parameterTypes.length];
                    for (int j = 0; j < instructionArray.length; ++j) {
                        bindingArray[j] = new Binding((Object)("param" + j), functionSignature.m_parameterTypes[j]);
                        instructionArray[j] = new IdentifierInstruction(bindingArray[j].getName());
                    }
                    bindingArray[functionSignature.m_parameterTypes.length] = new Binding((Object)"__functorinstance__", IntType.s_intType);
                    String string2 = ((Functor)object2).getName() + "$functor$" + (String)object3[i] + "$" + functionSignature.getFunctionName();
                    Iterator iterator2 = hashSet2.iterator();
                    int n2 = 0;
                    MatchInstruction.Match[] matchArray = new MatchInstruction.Match[hashSet2.size()];
                    while (iterator2.hasNext()) {
                        FunctorApplicationDirective functorApplicationDirective = (FunctorApplicationDirective)iterator2.next();
                        matchArray[n2++] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(functorApplicationDirective.m_index), new FunctionCallInstruction(functorApplicationDirective.m_modulesToApply[i] + "$" + functionSignature.getFunctionName(), instructionArray).cloneWithoutTypeInformation());
                    }
                    program.addFunction(new Function(string2, bindingArray, new MatchInstruction((Instruction)new IdentifierInstruction("__functorinstance__"), matchArray, null)));
                }
            }
        }
        iterator = program.getClassesIterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = (ClassType)iterator.next();
            for (Object object3 : ((ClassType)object2).m_methods.values()) {
                program.forceFunctionGeneration(program.getFunction(((ClassType.Method)object3).getFunction()));
            }
            program.addClass((ClassType)object2);
        }
        program.clearTypeInformation(false);
    }

    protected static void convertFunctor(Program program, Functor functor) {
        Module module = functor.getBody();
        Iterator<Function> iterator = module.getFunctions().iterator();
        while (iterator.hasNext()) {
            Function function2 = iterator.next();
            function2.m_name = ModuleImportDirective.translateFunctionName(function2.getName(), module);
            Binding[] bindingArray = new Binding[function2.m_parameters.length + 1];
            System.arraycopy(function2.m_parameters, 0, bindingArray, 0, function2.m_parameters.length);
            bindingArray[function2.m_parameters.length] = new Binding((Object)"__functorinstance__", IntType.s_intType);
            function2.m_parameters = bindingArray;
            new TailRecursiveOptimizer(){
                Module m_m;

                @Override
                protected Instruction optimizeStep2(Instruction instruction2) {
                    if (instruction2 instanceof FunctionCallInstruction) {
                        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                        Instruction[] instructionArray = new Instruction[functionCallInstruction.m_parameters.length + 1];
                        System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 0, functionCallInstruction.m_parameters.length);
                        instructionArray[functionCallInstruction.m_parameters.length] = new IdentifierInstruction("__functorinstance__");
                        return new FunctionCallInstruction(ModuleImportDirective.translateFunctionName(functionCallInstruction.getFunction(), this.m_m), instructionArray);
                    }
                    if (instruction2 instanceof ModuleFunctionCallInstruction) {
                        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction2;
                        ModuleImportDirective moduleImportDirective = this.m_m.getModuleImportDirective(moduleFunctionCallInstruction.getModule());
                        return moduleImportDirective.translateFunctionCall(moduleFunctionCallInstruction, this.m_m);
                    }
                    return instruction2;
                }

                Optimizer init(Module module) {
                    this.m_m = module;
                    return this;
                }
            }.init(module).optimizeFunction(function2);
            program.addFunction(function2);
            iterator.remove();
        }
    }
}

