/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.ILUBResolver;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.LocalModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeSpecializationDerivative;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.VirtualDataTypeMap;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.exec.DynamicContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Module
extends AbstractTypeStore
implements Serializable {
    private static final long serialVersionUID = 3362968532062637990L;
    private static final Logger s_logger = LoggerUtil.getLogger(Module.class);
    private static final String s_className = Module.class.getName();
    protected HashMap<String, Function> m_functions = new HashMap();
    protected HashMap<String, Module> m_modules = new HashMap();
    protected ArrayList<String> m_moduleDefinitions = new ArrayList();
    protected ArrayList m_fixup = new ArrayList();
    public ILUBResolver m_lubResolver;
    public ModuleSignature m_signature;
    protected Module m_parent;
    protected HashMap m_moduleImportDirectives = new HashMap();
    protected HashMap<String, Functor> m_functors = new HashMap();
    protected VirtualDataTypeMap m_vdtmap = new VirtualDataTypeMap();
    public boolean m_flatTypeNamespace;
    private boolean m_stripInputTypeAnnotationsSpecified = false;
    private boolean m_preserveInputTypeAnnotationsSpecified = false;
    private HashMap m_partialInformation = new HashMap();
    boolean typeAliasesExpanded = true;

    public void setPartialInformation(String string2, Set set2) {
        this.m_partialInformation.put(string2, set2);
    }

    public Set getPartialInformation(String string2) {
        return (Set)this.m_partialInformation.get(string2);
    }

    public Module() {
    }

    public Module(String string2, Module module) {
        this(string2, module, new ModuleSignature(""));
    }

    public Module(String string2, Module module, ModuleSignature moduleSignature) {
        this.m_name = string2;
        this.m_signature = moduleSignature;
        this.m_parent = module;
    }

    public void addModule(Module module) {
        if (module == this) {
            throw new XylemError("ERR_SYSTEM", "can't add '" + this.getName() + "' to self");
        }
        this.m_moduleDefinitions.add(module.getName());
        this.m_modules.put(module.getName(), module);
        module.m_parent = this;
        this.addModuleImportDirective(new LocalModuleImportDirective(module.getName(), module.m_signature));
    }

    public void addModuleImportDirective(ModuleImportDirective moduleImportDirective) {
        this.m_moduleImportDirectives.put(moduleImportDirective.getLocalName(), moduleImportDirective);
    }

    public Object evaluate(DynamicContext dynamicContext) {
        Environment environment = new Environment(dynamicContext);
        Object object2 = this.evaluate(environment, null);
        environment.release(object2);
        return object2;
    }

    public Object debug(IDebuggerInterceptor iDebuggerInterceptor, DynamicContext dynamicContext) {
        Environment environment = new Environment(dynamicContext);
        Object object2 = this.evaluate(environment, iDebuggerInterceptor);
        environment.release(object2);
        return object2;
    }

    public Object evaluate(Environment environment, IDebuggerInterceptor iDebuggerInterceptor) {
        Function function2 = this.getFunction("main");
        if (function2 == null) {
            throw new XylemError("ERR_SYSTEM", "not found 'main'");
        }
        return function2.getBody().evaluate(environment, function2, iDebuggerInterceptor, false);
    }

    public void addFunctor(Functor functor) {
        this.m_functors.put(functor.getName(), functor);
    }

    public Collection getFunctors() {
        return this.m_functors.values();
    }

    public Functor getFunctor(String string2) {
        return this.m_functors.get(string2);
    }

    public VirtualDataTypeMap getVDTMap() {
        return this.m_vdtmap;
    }

    public void setVDTMap(VirtualDataTypeMap virtualDataTypeMap) {
        this.m_vdtmap = virtualDataTypeMap;
    }

    public void addFunction(Function function2, boolean bl) {
        Function function3;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addFunction", "adding function " + function2.getName());
        }
        if ((function3 = this.m_functions.get(function2.getName())) == function2) {
            return;
        }
        if (function3 != null && bl) {
            s_logger.logrb(Level.WARNING, s_className, "addFunction", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"function with name " + function2.getName() + " already exists"});
        }
        this.m_functions.put(function2.getName(), function2);
    }

    public void addFunction(Function function2) {
        this.addFunction(function2, true);
    }

    public Function getFunction(String string2) {
        return this.m_functions.get(string2);
    }

    public Function getPublicFunction(String string2) {
        if (this.m_signature.containsFunction(string2)) {
            return this.getFunction(string2);
        }
        return null;
    }

    public FunctionSignature getFunctionSignature(String string2) {
        return this.m_signature.getFunctionSignature(string2);
    }

    public Module getModule(String string2) {
        return this.m_modules.get(string2);
    }

    public Collection<Module> getModules() {
        return this.m_modules.values();
    }

    public ModuleImportDirective getModuleImportDirective(String string2) {
        return (ModuleImportDirective)this.m_moduleImportDirectives.get(string2);
    }

    public Collection getModuleImportDirectives() {
        return this.m_moduleImportDirectives.values();
    }

    public ModuleSignature getModuleSignature(String string2) {
        Module module = this.getModule(string2);
        if (module != null) {
            return module.m_signature;
        }
        ModuleImportDirective moduleImportDirective = (ModuleImportDirective)this.m_moduleImportDirectives.get(string2);
        if (moduleImportDirective == null) {
            for (ModuleImportDirective moduleImportDirective2 : this.m_moduleImportDirectives.values()) {
                ModuleSignature moduleSignature = moduleImportDirective2.getSignature();
                ModuleSignature moduleSignature2 = moduleSignature.getModuleSignature(string2);
                if (moduleSignature2 == null) continue;
                return moduleSignature2;
            }
            return null;
        }
        return moduleImportDirective.getSignature();
    }

    public Module getParent() {
        return this.m_parent;
    }

    public Program getProgram() {
        for (Module module = this; module != null; module = module.getParent()) {
            if (!(module instanceof Program)) continue;
            return (Program)module;
        }
        throw new XylemError("ERR_SYSTEM", "modules must be descended from a program");
    }

    public Function[] getSimilarFunctions(String string2) {
        LinkedList<Function> linkedList = new LinkedList<Function>();
        for (String functionArray2 : this.m_functions.keySet()) {
            if (-1 == functionArray2.indexOf(string2) || -1 != functionArray2.indexOf(string2 + "s")) continue;
            linkedList.add(this.m_functions.get(functionArray2));
        }
        Function[] functionArray = new Function[linkedList.size()];
        linkedList.toArray(functionArray);
        return functionArray;
    }

    public void renameFunction(Function function2, String string2) {
        this.m_functions.remove(function2.getName());
        function2.m_name = string2;
        this.addFunction(function2, false);
    }

    public Collection<Function> getFunctions() {
        return this.m_functions.values();
    }

    public Set<String> getFunctionNames() {
        return this.m_functions.keySet();
    }

    public void forceFunctionGeneration(Function function2) {
        if (function2.isPolymorphic()) {
            throw new IllegalArgumentException("Cannot force function " + function2.getName() + " to be generated because it is polymorphic");
        }
        this.m_signature.addFunctionSignature(new FunctionSignature(function2));
    }

    public void reduce() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "reduce", "Reducing module " + this.m_name);
        }
        Iterator<String> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            Module module = this.m_modules.get(iterator.next());
            module.reduce();
        }
        for (Functor serializable2 : this.m_functors.values()) {
            serializable2.reduce();
        }
        ArrayList<Function> arrayList = new ArrayList<Function>(this.m_functions.values());
        Module.sortFunctionList(arrayList);
        for (Function function2 : arrayList) {
            function2.reduce();
        }
    }

    public void clearTypeInformation() {
        this.clearTypeInformation(true);
    }

    public void clearTypeInformation(boolean bl) {
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            Module object2 = this.m_modules.get(iterator.next());
            object2.clearTypeInformation(bl);
        }
        for (Functor functor : this.m_functors.values()) {
            functor.clearTypeInformation();
        }
        for (Function function2 : this.m_functions.values()) {
            function2.clearTypeInformation(bl);
        }
    }

    public void addToFixupList(FunctionCallInstruction functionCallInstruction, Function function2) {
        this.m_fixup.add(new Object[]{functionCallInstruction, function2});
    }

    public void typeCheck() throws TypeCheckException {
        this.typeCheck(true);
    }

    public void typeCheck(boolean bl) throws TypeCheckException {
        Function function2;
        FunctionCallInstruction functionCallInstruction;
        int n2;
        Object object2;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheck", "Started type checking module " + this.m_name);
        }
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            Module serializable2 = this.m_modules.get(iterator.next());
            serializable2.typeCheck(bl);
        }
        for (Functor functor : this.m_functors.values()) {
            functor.typeCheck();
        }
        this.m_fixup.clear();
        LinkedList linkedList = new LinkedList();
        iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            if (object3 instanceof String) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + object3 + " in module " + this.m_name + " is required by the module signature but was not defined"), null);
            }
            object2 = (Function)object3;
            if (((Function)object2).hasBeenTypeChecked()) continue;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "typeCheck", "pre type checking function " + ((Function)object2).getName());
            }
            ((Function)object2).typeCheck(this, null, linkedList);
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
            s_logger.logp(Level.FINEST, s_className, "typeCheck", "post type checking function " + ((Function)object2).getName());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "typeCheck", "Finished type checking functions for module " + this.m_name + ", going on to fixup");
        }
        for (n2 = 0; !this.m_fixup.isEmpty() && n2 < 100; ++n2) {
            object2 = new ArrayList(this.m_fixup);
            this.m_fixup.clear();
            iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                functionCallInstruction = (FunctionCallInstruction)objectArray[0];
                function2 = (Function)objectArray[1];
                Function.pushFunction(function2, linkedList);
                if (functionCallInstruction.fixupPartiallySpecializedFunctions(function2) || function2.isPolymorphic()) {
                    iterator.remove();
                }
                Function.popFunction(function2, linkedList);
            }
            this.m_fixup.addAll(object2);
        }
        if (n2 >= 100) {
            object2 = new StringBuffer();
            for (Object[] objectArray : this.m_fixup) {
                functionCallInstruction = (FunctionCallInstruction)objectArray[0];
                function2 = (Function)objectArray[1];
                if (((StringBuffer)object2).length() > 0) {
                    ((StringBuffer)object2).append(", ");
                }
                ((StringBuffer)object2).append(functionCallInstruction);
                ((StringBuffer)object2).append(" in function ");
                ((StringBuffer)object2).append(function2.getName() + " : " + new FunctionSignature(function2));
            }
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unable to infer types for function calls: " + object2), null);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "typeCheck", "Finished fixing up functions for module " + this.m_name + ", going on to remove unused functions");
        }
        if (bl) {
            this.removeDeadFunctions();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "typeCheck", "Finished removing unused and un-type-specialized functions for module " + this.m_name);
            }
        }
        for (Function function3 : this.m_functions.values()) {
            if (!function3.hasBeenTypeChecked()) continue;
            function3.standardizeTypes(true);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheck", "Finished type checking module " + this.m_name);
        }
    }

    public void typeCheckReduced() throws TypeCheckException {
        Serializable serializable;
        if (this.m_name != null && this.m_name.length() > 0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheckReduced", "Started type checking reduced module " + this.m_name);
        }
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable = this.m_modules.get(iterator.next());
            ((Module)serializable).typeCheckReduced();
        }
        serializable = new LinkedList();
        iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (!(object2 instanceof Function)) {
                s_logger.logrb(Level.WARNING, s_className, "typeCheckReduced", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"unimplemented exported function " + object2});
                Program.dumpXylemFile(this, new File("."), this.getName());
                continue;
            }
            Function function2 = (Function)object2;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "typeCheckReduced", "typeChecking function " + function2.getName() + " (" + object2.getClass() + ")");
            }
            if (function2.hasBeenTypeChecked()) continue;
            function2.typeCheckReduced(this, (LinkedList)serializable);
        }
        if (this.m_name != null && this.m_name.length() > 0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "typeCheckReduced", "Finished type checking reduced module " + this.m_name);
        }
    }

    public void instantiateReducedPolymorphicFunctions() {
        Serializable serializable;
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            serializable = this.m_modules.get(iterator.next());
            ((Module)serializable).instantiateReducedPolymorphicFunctions();
        }
        serializable = new HashSet();
        iterator = this.exportedFunctionsIterator();
        boolean bl = false;
        while (true) {
            HashSet hashSet = new HashSet();
            while (iterator.hasNext()) {
                Function function2 = (Function)iterator.next();
                if (bl) {
                    try {
                        function2.typeCheckReduced(this, new LinkedList());
                    }
                    catch (TypeCheckException typeCheckException) {
                        typeCheckException.printStackTrace();
                        throw new RuntimeException();
                    }
                }
                function2.instantiateReducedPolymorphicFunctions(hashSet, new HashSet(), (Set)((Object)serializable));
                function2.m_returnType = function2.getBody().getType(function2.getTypeEnvironment(), function2.getBindingEnvironment());
                if (bl) {
                    TypeSpecializationDerivative typeSpecializationDerivative = (TypeSpecializationDerivative)function2.getDerivationKey();
                    for (int i = 0; i < function2.m_parameters.length; ++i) {
                        try {
                            function2.getTypeEnvironment().unify(function2.m_parameters[i].getBindingType(), typeSpecializationDerivative.m_originalTypeVariables[i], null);
                            continue;
                        }
                        catch (TypeCheckException typeCheckException) {
                            typeCheckException.printStackTrace();
                            throw new RuntimeException();
                        }
                    }
                }
                function2.standardizeTypes(true);
            }
            if (hashSet.isEmpty()) {
                return;
            }
            iterator = hashSet.iterator();
            bl = true;
        }
    }

    public void removeDeadFunctions() {
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<Function> iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            hashSet.add(((Function)object2).getName());
            this.accumulateCalledFunctions(hashSet, ((Function)object2).getBody());
        }
        object2 = this.m_functions.values().iterator();
        while (object2.hasNext()) {
            Function function2 = (Function)object2.next();
            if (hashSet.contains(function2.getName())) continue;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "removeDeadFunctions", "function " + function2.getName() + " is not being called; removing");
            }
            object2.remove();
            if (function2.getOriginalFunction() == null) continue;
            function2.getOriginalFunction().m_derivatives.remove(function2.getDerivationKey());
        }
    }

    protected void accumulateCalledFunctions(HashSet<String> hashSet, Instruction instruction2) {
        HashSet hashSet2 = new HashSet();
        instruction2.accumulateFunctionsCalled(hashSet2);
        for (String string2 : hashSet2) {
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            this.accumulateCalledFunctions(hashSet, this.m_functions.get(string2).getBody());
        }
    }

    public void removeFunctionDerivativeInformation() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "removeFunctionDerivativeInformation", "removing function derivative information from program");
        }
        for (Function function2 : this.m_functions.values()) {
            function2.removeDerivativeInformation();
        }
    }

    protected String innerToString() {
        return "module";
    }

    public void dump(PrintWriter printWriter) {
        PrettyPrinter prettyPrinter = new PrettyPrinter(printWriter);
        this.toString(prettyPrinter, 0);
        printWriter.println(prettyPrinter.dumpModuleSignatures());
        printWriter.flush();
    }

    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen(this.innerToString(), n2 + 0);
        if (this.getName() != null && this.getName().length() > 0) {
            prettyPrinter.print(" " + this.getName());
        }
        if (this.m_signature != null && this.m_signature.m_name.length() != 0) {
            prettyPrinter.m_moduleSignatures.add(this.m_signature);
            prettyPrinter.print("@" + this.m_signature.m_name);
        }
        this.prettyPrintModuleInternals(prettyPrinter, n2);
        prettyPrinter.printFormClose(n2 + 0);
    }

    public void prettyPrintModuleInternals(PrettyPrinter prettyPrinter, int n2) {
        Iterator<Object> iterator = this.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            Module object22 = this.m_modules.get(iterator.next());
            object22.toString(prettyPrinter, n2 + 1);
        }
        for (Functor functor : this.m_functors.values()) {
            functor.toString(prettyPrinter, n2 + 1);
        }
        for (ModuleImportDirective moduleImportDirective : this.m_moduleImportDirectives.values()) {
            moduleImportDirective.toString(prettyPrinter, n2 + 1);
        }
        iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            ((AbstractDataType)iterator.next()).toString(prettyPrinter, n2 + 1);
        }
        if (this.m_signature != null) {
            iterator = this.m_signature.getAbstractDataTypesIterator();
            while (iterator.hasNext()) {
                AbstractDataType abstractDataType = (AbstractDataType)iterator.next();
                abstractDataType.toString(prettyPrinter, n2 + 1);
            }
        }
        Function[] functionArray = this.m_functions.values().toArray(new Function[0]);
        Arrays.sort(functionArray, new Comparator<Function>(){

            @Override
            public int compare(Function function2, Function function3) {
                String string2 = function2.getName();
                String string3 = function3.getName();
                return string2.compareTo(string3);
            }
        });
        for (int i = 0; i < functionArray.length; ++i) {
            Function function2 = functionArray[i];
            if (function2.getName().equals("main")) continue;
            function2.toString(prettyPrinter, n2 + 1);
        }
        if (this.m_functions.containsKey("main")) {
            this.m_functions.get("main").toString(prettyPrinter, n2 + 1);
        }
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    public Iterator<Function> exportedFunctionsIterator() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        for (String string2 : this.m_signature.m_functionSignatures.keySet()) {
            Function function2 = this.m_functions.get(string2);
            assert (function2 != null);
            arrayList.add(function2);
        }
        Module.sortFunctionList(arrayList);
        return arrayList.iterator();
    }

    public void exportAllFunctions() {
        for (Function function2 : this.m_functions.values()) {
            this.m_signature.addFunctionSignature(new FunctionSignature(function2));
        }
    }

    public void exportAllSymbols() {
        this.exportAllFunctions();
        Iterator<Object> iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            Object object2 = (AbstractDataType)iterator.next();
            this.m_signature.addAbstractDataType((AbstractDataType)object2);
        }
        this.clearADTs();
        for (Object object2 : this.m_classes.values()) {
            this.m_signature.addClass((ClassType)object2);
        }
        this.m_classes.clear();
        for (Object object2 : this.m_genericADTs.keySet()) {
            AbstractDataTypeLambda abstractDataTypeLambda = (AbstractDataTypeLambda)this.m_genericADTs.get(object2);
            this.m_signature.addGenericAbstractDataType((String)object2, abstractDataTypeLambda.getTypeParameters(), abstractDataTypeLambda.m_constructors);
        }
        this.m_genericADTs.clear();
        for (Object object2 : this.m_typeLambdas.keySet()) {
            this.m_signature.addTypeLambda((String)object2, (TypeLambda)this.m_typeLambdas.get(object2));
        }
        this.m_typeLambdas.clear();
        for (Object object2 : this.m_moduleImportDirectives.values()) {
            this.m_signature.addModuleImportDirective((ModuleImportDirective)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void optimize(Optimizer optimizer) {
        if (!this.typeAliasesExpanded) {
            throw new XylemError("ERR_SYSTEM", "Internal compiler error: type aliases must be expanded before transforming code");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "optimize", "running optimizer " + optimizer);
        }
        for (Module object22 : this.m_modules.values()) {
            object22.optimize(optimizer);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.m_functions.keySet());
        int n2 = 0;
        HashSet<Object> hashSet = new HashSet<Object>();
        while (true) {
            Object object22;
            void var3_5;
            for (Object object22 : var3_5) {
                Function function2 = this.m_functions.get(object22);
                optimizer.optimizeFunction(function2);
                hashSet.add(object22);
                ++n2;
            }
            object22 = new TreeSet();
            ((TreeSet)object22).addAll(this.m_functions.keySet());
            ((AbstractSet)object22).removeAll(hashSet);
            if (((TreeSet)object22).isEmpty()) break;
            Object object3 = object22;
        }
    }

    public void formalizeSignature(String string2) {
        this.m_signature.setName(string2);
        for (FunctionSignature functionSignature : this.m_signature.m_functionSignatures.values()) {
            Function function2 = this.getFunction(functionSignature.getFunctionName());
            functionSignature.m_returnType = function2.getReturnType().resolveType(function2.getTypeEnvironment());
        }
    }

    public static void sortFunctionList(List<Function> list) {
        Collections.sort(list, new Comparator<Function>(){

            @Override
            public int compare(Function function2, Function function3) {
                String string2 = function2.getName();
                String string3 = function3.getName();
                return string2.compareTo(string3);
            }
        });
    }

    protected void write(ObjectOutput objectOutput) throws IOException {
        Object object2;
        Object object32;
        WriteObjectFileHelper writeObjectFileHelper = new WriteObjectFileHelper(this, objectOutput);
        writeObjectFileHelper.writeString(this.m_name);
        Module.writeTypes(this, writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_moduleImportDirectives.size());
        for (Object object32 : this.m_moduleImportDirectives.values()) {
            ((ModuleImportDirective)object32).write(writeObjectFileHelper);
        }
        object32 = this.getFunctions();
        writeObjectFileHelper.writeInt(object32.size());
        Iterator<Object> iterator = object32.iterator();
        while (iterator.hasNext()) {
            object2 = (Function)iterator.next();
            ((Function)object2).write(writeObjectFileHelper);
        }
        object2 = this.getTypeAliases();
        writeObjectFileHelper.writeInt(object2.size());
        iterator = object2.iterator();
        Set set2 = this.getTypeAliasNames();
        Iterator iterator2 = set2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator2.next();
            writeObjectFileHelper.writeString(string2);
            Type type2 = (Type)iterator.next();
            writeObjectFileHelper.writeType(type2);
        }
    }

    public static Module loadCompiled(File file, String string2, ModuleSignatureStore moduleSignatureStore) throws Exception {
        if (moduleSignatureStore == null) {
            moduleSignatureStore = new ModuleSignatureStore(new ArrayList<URL>());
        }
        File file2 = new File(file, string2 + ".cxi");
        FileInputStream fileInputStream = new FileInputStream(file2);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        ModuleSignature moduleSignature = new ModuleSignature();
        moduleSignature.read(objectInputStream, moduleSignatureStore);
        fileInputStream.close();
        moduleSignatureStore.registerModuleSignature(string2, moduleSignature);
        File file3 = new File(file, string2 + ".cxo");
        fileInputStream = new FileInputStream(file3);
        objectInputStream = new ObjectInputStream(fileInputStream);
        Module module = Module.readModule(objectInputStream, moduleSignatureStore);
        module.m_signature = moduleSignature;
        fileInputStream.close();
        module.typeCheckReduced();
        return module;
    }

    public static Module loadCompiled(URL uRL, ModuleSignatureStore moduleSignatureStore) throws Exception {
        File file = new File(uRL.getPath());
        String string2 = file.getName();
        string2 = string2.substring(0, string2.lastIndexOf(".cxo"));
        file = file.getParentFile();
        return Module.loadCompiled(file, string2, moduleSignatureStore);
    }

    public static void saveCompiled(Module module, URL uRL) throws Exception {
        File file = new File(uRL.getPath());
        String string2 = file.getName();
        string2 = string2.substring(0, string2.lastIndexOf(".cxo"));
        file = file.getParentFile();
        Module.saveCompiled(module, file, string2);
    }

    public static void saveCompiled(Module module, File file, String string2) throws Exception {
        File file2 = new File(file, string2 + ".cxo");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
        Module.writeModule(objectOutputStream, module);
        objectOutputStream.flush();
        objectOutputStream.close();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "saveCompiled", "wrote:" + file2);
        }
        File file3 = new File(file, string2 + ".cxi");
        objectOutputStream = new ObjectOutputStream(new FileOutputStream(file3));
        module.m_signature.write(objectOutputStream);
        objectOutputStream.flush();
        objectOutputStream.close();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "saveCompiled", "wrote:" + file3);
        }
    }

    public static Module readModule(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        String string2 = objectInput.readUTF();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "readModule", "reading module or program class = " + string2);
        }
        Module module = (Module)ObjectFactory.newInstance(string2, Module.class.getClassLoader(), true);
        module.read(objectInput, moduleSignatureStore);
        return module;
    }

    public static void writeModule(ObjectOutput objectOutput, Module module) throws IOException {
        objectOutput.writeUTF(module.getClass().getName());
        module.write(objectOutput);
    }

    protected void read(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        Object object2;
        int n2;
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(this, objectInput, moduleSignatureStore);
        this.m_name = readObjectFileHelper.readString();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "read", "reading module m_name=" + this.m_name);
        }
        this.m_signature = moduleSignatureStore.resolveModuleSignature(this.getName());
        Module.readTypes(this, readObjectFileHelper);
        int n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = new TopLevelModuleImportDirective();
            ((TopLevelModuleImportDirective)object2).read(readObjectFileHelper);
            this.addModuleImportDirective((ModuleImportDirective)object2);
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = new Function();
            ((Function)object2).read(readObjectFileHelper);
            this.addFunction((Function)object2);
        }
        n3 = readObjectFileHelper.readInt();
        for (int i = 0; i < n3; ++i) {
            object2 = readObjectFileHelper.readString();
            Type type2 = readObjectFileHelper.readType();
            this.addTypeAlias((String)object2, type2);
        }
    }

    @Override
    public AbstractDataType getAbstractDataType(String string2) {
        AbstractDataType abstractDataType;
        block2: {
            ModuleImportDirective moduleImportDirective;
            abstractDataType = super.getAbstractDataType(string2);
            if (abstractDataType == null) {
                abstractDataType = this.m_signature.getAbstractDataType(string2);
            }
            if (abstractDataType != null) break block2;
            Iterator iterator = this.getModuleImportDirectives().iterator();
            while (iterator.hasNext() && (abstractDataType = (moduleImportDirective = (ModuleImportDirective)iterator.next()).getSignature().getAbstractDataType(string2)) == null) {
            }
        }
        return abstractDataType;
    }

    @Override
    public AbstractDataType.Constructor getConstructor(String string2) {
        if (this.m_constructors.containsKey(string2)) {
            return (AbstractDataType.Constructor)this.m_constructors.get(string2);
        }
        AbstractDataType.Constructor constructor = this.m_signature.getConstructor(string2);
        if (constructor != null) {
            return constructor;
        }
        for (ModuleImportDirective moduleImportDirective : this.getModuleImportDirectives()) {
            constructor = moduleImportDirective.getSignature().getConstructor(string2);
            if (constructor == null) continue;
            return constructor;
        }
        for (int i = 0; i < this.m_moduleDefinitions.size(); ++i) {
            Module module = this.m_modules.get(this.m_moduleDefinitions.get(i));
            constructor = module.getConstructor(string2);
            if (constructor == null) continue;
            return constructor;
        }
        return null;
    }

    public CompoundType lookupCompoundType(String string2, String string3) {
        return this.matchesName(string2) ? this.lookupCompoundType(string3) : this.getModuleSignature(string2).lookupCompoundType(string3);
    }

    @Override
    public CompoundType lookupCompoundType(String string2) {
        CompoundType compoundType = super.lookupCompoundType(string2);
        if (compoundType != null) {
            return compoundType;
        }
        compoundType = this.m_signature.lookupCompoundType(string2);
        if (compoundType != null) {
            return compoundType;
        }
        for (ModuleImportDirective moduleImportDirective : this.getModuleImportDirectives()) {
            if (moduleImportDirective == null) {
                throw new XylemError("ERR_SYSTEM", "Internal compiler error");
            }
            ModuleSignature moduleSignature = moduleImportDirective.getSignature();
            if (moduleSignature == null && !this.m_flatTypeNamespace) continue;
            if (moduleSignature == null) {
                throw new XylemError("ERR_SYSTEM", "Internal compiler error: null signature for module-import directive " + moduleImportDirective.getLocalName() + " while looking for compound type " + string2);
            }
            compoundType = moduleImportDirective.getSignature().lookupCompoundType(string2);
            if (compoundType == null) continue;
            return compoundType;
        }
        return null;
    }

    @Override
    public Type lookupTypeAlias(String string2) {
        if (this.m_typeAliases.containsKey(string2)) {
            return (Type)this.m_typeAliases.get(string2);
        }
        Type type2 = this.m_signature.lookupTypeAlias(string2);
        if (type2 != null) {
            return type2;
        }
        for (ModuleImportDirective moduleImportDirective : this.getModuleImportDirectives()) {
            if (moduleImportDirective.getSignature() == null && !this.m_flatTypeNamespace) continue;
            if (moduleImportDirective.getSignature() == null) {
                throw new XylemError("ERR_SYSTEM", "signature not found for module import " + moduleImportDirective.getLocalName());
            }
            type2 = moduleImportDirective.getSignature().lookupTypeAlias(string2);
            if (type2 == null) continue;
            return type2;
        }
        return null;
    }

    @Override
    public void addGenericAbstractDataType(String string2, TypeVariable[] typeVariableArray, AbstractDataType.Constructor[] constructorArray) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "adding generic ADT " + string2 + " to module " + this.m_name);
        }
        super.addGenericAbstractDataType(string2, typeVariableArray, constructorArray);
        this.m_signature.addGenericAbstractDataType(string2, typeVariableArray, constructorArray);
    }

    @Override
    public AbstractDataType instantiateGenericADT(String string2, Type[] typeArray) {
        return this.instantiateGenericADT(null, string2, typeArray);
    }

    public AbstractDataType instantiateGenericADT(String string2, String string3, Type[] typeArray) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "instantiateGenericADT", "instantiating generic ADT " + string2 + "." + string3 + " in module " + this.m_name);
        }
        AbstractDataTypeLambda abstractDataTypeLambda = this.matchesName(string2) ? this.getGenericADT(string3) : this.getModuleSignature(string2).getGenericADT(string3);
        return this.instantiateGenericADT(abstractDataTypeLambda, typeArray);
    }

    @Override
    public AbstractDataTypeLambda getGenericADT(String string2) {
        Iterator<Module> iterator;
        Object object2;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "getGenericADT", "getting generic ADT " + string2 + " from module " + this.m_name);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            object2 = this.m_genericADTs.values().iterator();
            while (object2.hasNext()) {
                iterator = (AbstractDataTypeLambda)object2.next();
                s_logger.logp(Level.FINEST, s_className, "getGenericADT", "generic ADT " + ((CompoundType)((Object)iterator)).getName() + " is in module " + this.m_name);
            }
            for (AbstractDataTypeLambda abstractDataTypeLambda : this.m_signature.m_genericADTs.values()) {
                s_logger.logp(Level.FINEST, s_className, "getGenericADT", "generic ADT " + abstractDataTypeLambda.getName() + " is in module signature " + this.m_signature.getName());
            }
        }
        if ((object2 = super.getGenericADT(string2)) != null) {
            return object2;
        }
        object2 = this.m_signature.getGenericADT(string2);
        if (object2 != null) {
            return object2;
        }
        iterator = this.m_modules.values().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().getGenericADT(string2);
            if (object2 == null) continue;
            return object2;
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "getGenericADT", "did not find generic ADT " + string2 + " in module " + this.m_name);
        }
        return null;
    }

    public TypeLambda lookupTypeLambda(String string2, String string3) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "lookupTypeLambda", "looking for type-lambda " + string2 + "." + string3 + " in module " + this.m_name);
        }
        TypeLambda typeLambda = this.matchesName(string2) ? this.lookupTypeLambda(string3) : this.lookupTypeLambdaInSig(string2, string3);
        return typeLambda;
    }

    TypeLambda lookupTypeLambdaInSig(String string2, String string3) {
        ModuleSignature moduleSignature = this.getModuleSignature(string2);
        if (moduleSignature == null) {
            throw new XylemError("ERR_SYSTEM", "Module signature " + string2 + " was null when looking for type-lambda " + string3 + " in " + this.getName());
        }
        return moduleSignature.lookupTypeLambda(string3);
    }

    @Override
    public TypeLambda lookupTypeLambda(String string2) {
        TypeLambda typeLambda = super.lookupTypeLambda(string2);
        return typeLambda == null ? this.m_signature.lookupTypeLambda(string2) : typeLambda;
    }

    public void expandTypeAliases() {
        Iterator<Module> iterator = this.m_modules.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().expandTypeAliases();
        }
        for (AbstractDataTypeLambda abstractDataTypeLambda : this.m_genericADTs.values()) {
            for (int i = 0; i < abstractDataTypeLambda.m_constructors.length; ++i) {
                Binding[] bindingArray = abstractDataTypeLambda.m_constructors[i].m_parameters;
                for (int j = 0; j < bindingArray.length; ++j) {
                    bindingArray[j].m_type = bindingArray[j].m_type.expandTypeAliases(this);
                }
            }
        }
        this.typeAliasesExpanded = true;
    }

    public boolean getStripInputTypeAnnotationsSpecified() {
        return this.m_stripInputTypeAnnotationsSpecified;
    }

    public void setStripInputTypeAnnotationsSpecified() {
        this.m_stripInputTypeAnnotationsSpecified = true;
    }

    public boolean getPreserveInputTypeAnnotationsSpecified() {
        return this.m_preserveInputTypeAnnotationsSpecified;
    }

    public void setPreserveInputTypeAnnotationsSpecified() {
        this.m_preserveInputTypeAnnotationsSpecified = true;
    }

    public Module cloneModule() {
        Module module = new Module(this.m_name, this.m_parent == null ? null : this.m_parent.cloneModule(), this.m_signature == null ? null : this.m_signature.cloneModule());
        Iterator<String> iterator = this.m_functions.keySet().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = iterator.next();
            module.m_functions.put(string2, this.m_functions.get(string2).cloneFunction());
        }
        module.m_adtDefinitions = (ArrayList)this.m_adtDefinitions.clone();
        module.m_adts = (HashMap)this.m_adts.clone();
        module.m_compoundTypes = (HashMap)this.m_compoundTypes.clone();
        module.m_constructors = (HashMap)this.m_constructors.clone();
        module.m_moduleImportDirectives = (HashMap)this.m_moduleImportDirectives.clone();
        module.m_typeAliases = (HashMap)this.m_typeAliases.clone();
        module.m_genericADTs = (HashMap)this.m_genericADTs.clone();
        module.m_typeLambdas = (HashMap)this.m_typeLambdas.clone();
        return module;
    }
}

