/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class IdentityHashMap
implements Map {
    private static final int CHAIN_SIZE = 3;
    private static final int INITIAL_SIZE = 17;
    private static final float MAX_LOAD = 2.0f;
    private int m_numEntries = 0;
    private MapEntry[][] m_buckets;

    public IdentityHashMap() {
        this.clear();
    }

    private void rehash() {
        MapEntry[][] mapEntryArray = new MapEntry[this.m_buckets.length * 2][];
        for (int i = 0; i < this.m_buckets.length; ++i) {
            if (this.m_buckets[i] == null) continue;
            for (int j = 0; j < this.m_buckets[i].length; ++j) {
                if (this.m_buckets[i][j] == null) continue;
                this.put(this.m_buckets[i][j].getKey(), this.m_buckets[i][j].getValue(), mapEntryArray, true);
            }
        }
        this.m_buckets = mapEntryArray;
    }

    private int whichBucket(int n2, int n3) {
        int n4 = Math.abs(n2 % n3);
        return n4;
    }

    @Override
    public int size() {
        return this.m_numEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.m_numEntries == 0;
    }

    @Override
    public boolean containsKey(Object object2) {
        int n2 = System.identityHashCode(object2);
        MapEntry[] mapEntryArray = this.m_buckets[this.whichBucket(n2, this.m_buckets.length)];
        if (mapEntryArray == null) {
            return false;
        }
        for (int i = 0; i < mapEntryArray.length; ++i) {
            if (mapEntryArray[i] == null || mapEntryArray[i].getKey() != object2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object2) {
        for (int i = 0; i < this.m_buckets.length; ++i) {
            if (this.m_buckets[i] == null) continue;
            for (int j = 0; j < this.m_buckets[i].length; ++j) {
                if (this.m_buckets[i][j] == null || object2 != this.m_buckets[i][j].getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public Object get(Object object2) {
        int n2 = System.identityHashCode(object2);
        MapEntry[] mapEntryArray = this.m_buckets[this.whichBucket(n2, this.m_buckets.length)];
        if (mapEntryArray == null) {
            return null;
        }
        for (int i = 0; i < mapEntryArray.length; ++i) {
            if (mapEntryArray[i] == null || mapEntryArray[i].getKey() != object2) continue;
            return mapEntryArray[i].getValue();
        }
        return null;
    }

    public Object put(Object object2, Object object3) {
        if ((float)(this.m_numEntries + 1) >= 2.0f * (float)this.m_buckets.length) {
            this.rehash();
        }
        return this.put(object2, object3, this.m_buckets, false);
    }

    private Object put(Object object2, Object object3, MapEntry[][] mapEntryArray, boolean bl) {
        int n2 = System.identityHashCode(object2);
        int n3 = this.whichBucket(n2, mapEntryArray.length);
        MapEntry[] mapEntryArray2 = mapEntryArray[n3];
        if (mapEntryArray2 == null) {
            MapEntry[] mapEntryArray3 = new MapEntry[3];
            mapEntryArray[n3] = mapEntryArray3;
            mapEntryArray2 = mapEntryArray3;
        }
        int n4 = -1;
        for (int i = 0; i < mapEntryArray2.length; ++i) {
            if (mapEntryArray2[i] == null) {
                if (n4 != -1) continue;
                n4 = i;
                continue;
            }
            if (mapEntryArray2[i].getKey() != object2) continue;
            Object object4 = mapEntryArray2[i].getValue();
            mapEntryArray2[i].setValue(object3);
            return object4;
        }
        if (n4 == -1) {
            MapEntry[] mapEntryArray4 = new MapEntry[mapEntryArray2.length * 2];
            n4 = mapEntryArray2.length;
            System.arraycopy(mapEntryArray2, 0, mapEntryArray4, 0, n4);
            mapEntryArray[n3] = mapEntryArray4;
            mapEntryArray2 = mapEntryArray4;
        }
        mapEntryArray2[n4] = new MapEntry(object2, object3);
        if (!bl) {
            ++this.m_numEntries;
        }
        return null;
    }

    private void remove(int n2, int n3) {
        if (this.m_buckets[n2][n3] != null) {
            this.m_buckets[n2][n3] = null;
            --this.m_numEntries;
        }
    }

    public Object remove(Object object2) {
        int n2 = System.identityHashCode(object2);
        MapEntry[] mapEntryArray = this.m_buckets[this.whichBucket(n2, this.m_buckets.length)];
        if (mapEntryArray == null) {
            return null;
        }
        for (int i = 0; i < mapEntryArray.length; ++i) {
            if (mapEntryArray[i] == null || mapEntryArray[i].getKey() != object2) continue;
            Object object3 = mapEntryArray[i].getValue();
            mapEntryArray[i] = null;
            --this.m_numEntries;
            return object3;
        }
        return null;
    }

    private void removeValue(Object object2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            MapEntry mapEntry = (MapEntry)iterator.next();
            Object object3 = mapEntry.getValue();
            if (object3 != object2) continue;
            iterator.remove();
            return;
        }
    }

    public void putAll(Map map2) {
        for (Object k : map2.keySet()) {
            this.put(k, map2.get(k));
        }
    }

    public Object clone() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        identityHashMap.putAll((Map)this);
        return identityHashMap;
    }

    @Override
    public void clear() {
        this.m_buckets = new MapEntry[17][];
        this.m_numEntries = 0;
    }

    public Set keySet() {
        return new IdentityKeySet(this);
    }

    public Collection values() {
        return new IdentityValueSet(this);
    }

    public Set entrySet() {
        return new IdentityEntrySet(this);
    }

    private Iterator iterator() {
        return new IdentityEntryIterator(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("NumEntries:" + this.m_numEntries + "\n");
        for (int i = 0; i < this.m_buckets.length; ++i) {
            stringBuffer.append("\n" + i + ": ");
            MapEntry[] mapEntryArray = this.m_buckets[i];
            if (mapEntryArray == null) {
                stringBuffer.append("NULL");
                continue;
            }
            stringBuffer.append("[");
            for (int j = 0; j < mapEntryArray.length; ++j) {
                if (mapEntryArray[j] == null) {
                    stringBuffer.append(" (NULL) ");
                    continue;
                }
                stringBuffer.append(" (" + mapEntryArray[j].getKey() + "," + mapEntryArray[j].getValue() + ") ");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void dump() {
        System.out.println("NumEntries:" + this.m_numEntries);
        for (int i = 0; i < this.m_buckets.length; ++i) {
            System.out.print(i + ": ");
            MapEntry[] mapEntryArray = this.m_buckets[i];
            if (mapEntryArray == null) {
                System.out.println("NULL");
                continue;
            }
            System.out.print("[");
            for (int j = 0; j < mapEntryArray.length; ++j) {
                if (mapEntryArray[j] == null) {
                    System.out.print(" (NULL) ");
                    continue;
                }
                System.out.print(" (" + mapEntryArray[j].getKey() + "," + mapEntryArray[j].getValue() + ") ");
            }
            System.out.println("]");
        }
    }

    public static void main(String[] stringArray) {
        Iterator iterator;
        int n2;
        IdentityHashMap identityHashMap = new IdentityHashMap();
        IdentityHashMap identityHashMap2 = new IdentityHashMap();
        for (n2 = 0; n2 < 50; ++n2) {
            iterator = new Integer(n2);
            identityHashMap.put(iterator, new Integer(n2 + 1));
            identityHashMap.dump();
            System.out.println("----------------------");
        }
        identityHashMap.clear();
        for (n2 = 0; n2 < 50; ++n2) {
            iterator = new Integer(n2);
            identityHashMap.put(iterator, iterator);
            identityHashMap2.put(iterator, iterator);
            identityHashMap.dump();
            System.out.println("----------------------");
        }
        IdentityHashMap identityHashMap3 = new IdentityHashMap();
        identityHashMap3.putAll((Map)identityHashMap);
        iterator = identityHashMap3.entrySet().iterator();
        while (iterator.hasNext()) {
            System.out.print(":" + iterator.next() + ":");
        }
        System.out.println();
        iterator = identityHashMap3.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.print(":" + iterator.next() + ":");
        }
        System.out.println();
        iterator = identityHashMap3.values().iterator();
        while (iterator.hasNext()) {
            System.out.print(":" + iterator.next() + ":");
        }
        System.out.println();
        System.out.println();
        Collection collection2 = identityHashMap.values();
        collection2.retainAll(identityHashMap3.values());
        collection2.removeAll(identityHashMap3.keySet());
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            System.out.print(":" + iterator.next() + ":");
        }
        System.out.println();
    }

    private class IdentityEntrySet
    extends IdentitySet {
        public IdentityEntrySet(IdentityHashMap identityHashMap2) {
            super(identityHashMap2);
        }

        @Override
        public boolean contains(Object object2) {
            if (!(object2 instanceof MapEntry)) {
                return false;
            }
            Object object3 = ((MapEntry)object2).getKey();
            return this.store.containsKey(object3);
        }

        @Override
        public boolean remove(Object object2) {
            if (!(object2 instanceof MapEntry)) {
                return false;
            }
            Object object3 = ((MapEntry)object2).getKey();
            if (!this.store.containsKey(object3)) {
                return false;
            }
            this.store.remove(object3);
            return true;
        }

        @Override
        public Iterator iterator() {
            return new IdentityEntryIterator(this.store);
        }
    }

    private class IdentityValueSet
    extends IdentitySet {
        public IdentityValueSet(IdentityHashMap identityHashMap2) {
            super(identityHashMap2);
        }

        @Override
        public boolean contains(Object object2) {
            return this.store.containsValue(object2);
        }

        @Override
        public boolean remove(Object object2) {
            if (!this.store.containsValue(object2)) {
                return false;
            }
            this.store.removeValue(object2);
            return true;
        }

        @Override
        public Iterator iterator() {
            return new IdentityValueIterator(this.store);
        }
    }

    private class IdentityKeySet
    extends IdentitySet {
        public IdentityKeySet(IdentityHashMap identityHashMap2) {
            super(identityHashMap2);
        }

        @Override
        public boolean contains(Object object2) {
            return this.store.containsKey(object2);
        }

        @Override
        public boolean remove(Object object2) {
            if (!this.store.containsKey(object2)) {
                return false;
            }
            this.store.remove(object2);
            return true;
        }

        @Override
        public Iterator iterator() {
            return new IdentityKeyIterator(this.store);
        }
    }

    private abstract class IdentitySet
    implements Set {
        protected IdentityHashMap store;

        public IdentitySet(IdentityHashMap identityHashMap2) {
            this.store = identityHashMap2;
        }

        @Override
        public int size() {
            return this.store.size();
        }

        @Override
        public boolean isEmpty() {
            return this.store.isEmpty();
        }

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract Iterator iterator();

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            Object object2;
            if (objectArray.length < this.store.size()) {
                object2 = objectArray.getClass().getComponentType();
                objectArray = (Object[])Array.newInstance(object2, this.store.size());
            }
            object2 = this.iterator();
            int n2 = 0;
            while (object2.hasNext()) {
                objectArray[n2] = object2.next();
                ++n2;
            }
            return objectArray;
        }

        @Override
        public boolean add(Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public boolean containsAll(Collection collection2) {
            for (Object e : collection2) {
                if (!this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection collection2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection2) {
            boolean bl = false;
            for (Object e : this) {
                if (collection2.contains(e)) continue;
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection collection2) {
            boolean bl = false;
            for (Object e : collection2) {
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }

        @Override
        public void clear() {
            this.store.clear();
        }
    }

    private class IdentityValueIterator
    extends IdentityEntryIterator
    implements Iterator {
        public IdentityValueIterator(IdentityHashMap identityHashMap2) {
            super(identityHashMap2);
        }

        @Override
        public Object next() {
            MapEntry mapEntry = (MapEntry)super.next();
            return mapEntry.getValue();
        }
    }

    private class IdentityKeyIterator
    extends IdentityEntryIterator
    implements Iterator {
        public IdentityKeyIterator(IdentityHashMap identityHashMap2) {
            super(identityHashMap2);
        }

        @Override
        public Object next() {
            MapEntry mapEntry = (MapEntry)super.next();
            return mapEntry.getKey();
        }
    }

    private class IdentityEntryIterator
    implements Iterator {
        private int i = 0;
        private int j = 0;
        private int numSeen = 0;
        protected IdentityHashMap store;

        public IdentityEntryIterator(IdentityHashMap identityHashMap2) {
            this.store = identityHashMap2;
        }

        @Override
        public boolean hasNext() {
            return this.numSeen < this.store.size();
        }

        public Object next() {
            MapEntry mapEntry = null;
            block0: while (mapEntry == null) {
                if (this.i >= IdentityHashMap.this.m_buckets.length) {
                    throw new NoSuchElementException();
                }
                MapEntry[] mapEntryArray = this.store.m_buckets[this.i];
                while (mapEntryArray == null) {
                    ++this.i;
                    if (this.i >= IdentityHashMap.this.m_buckets.length) {
                        throw new NoSuchElementException();
                    }
                    mapEntryArray = this.store.m_buckets[this.i];
                }
                mapEntry = this.j >= mapEntryArray.length ? null : mapEntryArray[this.j];
                while (mapEntry == null) {
                    ++this.j;
                    if (this.j >= mapEntryArray.length) {
                        this.j = 0;
                        ++this.i;
                        continue block0;
                    }
                    mapEntry = mapEntryArray[this.j];
                }
            }
            ++this.numSeen;
            ++this.j;
            return mapEntry;
        }

        @Override
        public void remove() {
            this.store.remove(this.i, this.j - 1);
            --this.numSeen;
        }
    }

    public class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Object object2, Object object3) {
            this.key = object2;
            this.value = object3;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object2) {
            Object object3 = this.value;
            this.value = object2;
            return object3;
        }
    }
}

