/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IdentifierConsolidator {
    private static final Logger s_logger = LoggerUtil.getLogger(IdentifierConsolidator.class);
    private static final String s_className = IdentifierConsolidator.class.getName();
    protected ArrayList<Object> m_objects = new ArrayList();
    protected ArrayList<Instruction> m_instructions = new ArrayList();
    protected ArrayList<Object> m_lambdaObjects = new ArrayList();
    protected ArrayList<IdentifierInstruction> m_lambdaInstructions = new ArrayList();
    protected HashMap<Object, Instruction> m_paramInstructions = new HashMap();
    protected int m_counter = 0;
    protected int m_lambdaCounter = 0;

    public void reset() {
        this.m_counter = 0;
        this.m_lambdaCounter = 0;
    }

    public int nextIdentifier() {
        if (this.m_counter == this.m_objects.size()) {
            Integer n2 = new Integer(this.m_counter);
            this.m_objects.add(n2);
            this.m_instructions.add(new IdentifierInstruction(n2));
        }
        return this.m_counter++;
    }

    public int nextLambdaIdentifier() {
        if (this.m_lambdaCounter == this.m_lambdaObjects.size()) {
            String string2 = "lambda_param_" + this.m_lambdaCounter;
            this.m_lambdaObjects.add(string2);
            this.m_lambdaInstructions.add(new IdentifierInstruction(string2));
        }
        return this.m_lambdaCounter++;
    }

    public Object getIdentifierName(int n2) {
        return this.m_objects.get(n2);
    }

    public Object getLambdaIdentifierName(int n2) {
        return this.m_lambdaObjects.get(n2);
    }

    public IdentifierInstruction getIdentifierInstruction(int n2) {
        return (IdentifierInstruction)this.m_instructions.get(n2);
    }

    public IdentifierInstruction getLambdaIdentifierInstruction(int n2) {
        return this.m_lambdaInstructions.get(n2);
    }

    public void processModule(Module module) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "processModule", "Starting consolidation");
        }
        Iterator<Function> iterator = module.getFunctions().iterator();
        while (iterator.hasNext()) {
            this.processFunction(iterator.next());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "processModule", "Finished with consolidation");
        }
    }

    public void processFunction(Function function2) {
        this.reset();
        Module module = function2.getTypeEnvironment().getModule();
        HashMap<Object, IdentifierInstruction> hashMap = new HashMap<Object, IdentifierInstruction>(64);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < function2.m_parameters.length; ++i) {
            Object object2 = function2.m_parameters[i].getName();
            if (object2 instanceof Integer) {
                int n2 = this.nextIdentifier();
                IdentifierInstruction identifierInstruction = this.getIdentifierInstruction(n2);
                Object object3 = this.getIdentifierName(n2);
                hashMap.put(object2, identifierInstruction);
                object2 = object3;
                function2.m_parameters[i].setName(object2);
                continue;
            }
            hashSet.add(object2);
        }
        function2.clearReducedTypeInformation();
        function2.setBody(this.process(function2.getBody(), hashSet, hashMap));
        try {
            function2.typeCheckReduced(module, new LinkedList());
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
        }
    }

    public Instruction processLambda(LambdaInstruction lambdaInstruction, BindingEnvironment bindingEnvironment) {
        this.reset();
        HashSet hashSet = new HashSet();
        lambdaInstruction.accumulateFreeBindings(hashSet, bindingEnvironment);
        HashMap<Object, IdentifierInstruction> hashMap = new HashMap<Object, IdentifierInstruction>(64);
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (IBinding iBinding : hashSet) {
            hashSet2.add(iBinding.getName());
        }
        for (int i = 0; i < lambdaInstruction.getParameters().length; ++i) {
            Object object2 = lambdaInstruction.getParameters()[i].getName();
            int n2 = this.nextLambdaIdentifier();
            IdentifierInstruction identifierInstruction = this.getLambdaIdentifierInstruction(n2);
            Object object3 = this.getLambdaIdentifierName(n2);
            hashMap.put(object2, identifierInstruction);
            object2 = object3;
            lambdaInstruction.getParameters()[i].setName(object2);
            bindingEnvironment.setVariableBinding(lambdaInstruction.getParameters()[i]);
        }
        LambdaInstruction lambdaInstruction2 = lambdaInstruction;
        lambdaInstruction2.setBody(this.process(lambdaInstruction2.getBody(), hashSet2, hashMap));
        return lambdaInstruction2;
    }

    protected Instruction processLetChain(LetInstruction letInstruction, Set set2, HashMap hashMap) {
        Instruction instruction2;
        Instruction instruction3;
        IdentifierInstruction identifierInstruction;
        LetInstruction letInstruction2;
        Instruction instruction4 = letInstruction2 = new LetInstruction("", null, null);
        while (true) {
            int n2 = this.nextIdentifier();
            Object object2 = letInstruction.getVariable();
            identifierInstruction = this.getIdentifierInstruction(n2);
            Object object3 = this.getIdentifierName(n2);
            instruction3 = this.process(letInstruction.getValue(), set2, hashMap);
            instruction4.setValue(instruction3);
            hashMap.put(object2, identifierInstruction);
            instruction4.setName(object3);
            if (!(letInstruction.getBody() instanceof LetInstruction)) break;
            letInstruction = (LetInstruction)letInstruction.getBody();
            instruction2 = new LetInstruction("", null, null);
            instruction4.setBody(instruction2);
            instruction4 = instruction2;
        }
        instruction2 = letInstruction.getBody();
        Instruction instruction5 = this.process(instruction2, set2, hashMap);
        instruction4.setBody(instruction5);
        Instruction.propagateInfo(instruction2, letInstruction2);
        Instruction.propagateInfo(instruction2, identifierInstruction);
        Instruction.propagateInfo(instruction2, instruction3);
        return letInstruction2;
    }

    public Instruction process(Instruction instruction2, Set set2, HashMap hashMap) {
        Object object2;
        if (instruction2 instanceof StreamInstruction && ((StreamInstruction)instruction2).isStoredAsString()) {
            return instruction2;
        }
        if (instruction2 instanceof LetInstruction) {
            return this.processLetChain((LetInstruction)instruction2, set2, hashMap);
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return this.processIdentifier((IdentifierInstruction)instruction2, set2, hashMap);
        }
        int n2 = instruction2.getChildInstructionCount();
        if (n2 == 0) {
            return instruction2;
        }
        Instruction instruction3 = null;
        if (instruction2 instanceof ISpecialForm) {
            instruction3 = instruction2.cloneShallow();
            ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction2);
            object2 = (ISpecialForm)((Object)instruction3);
            for (int i = 0; i < n2; ++i) {
                IBinding[] iBindingArray = iSpecialForm.getChildInstructionBindings(i);
                IBinding[] iBindingArray2 = object2.getChildInstructionBindings(i);
                if (iBindingArray == null) continue;
                for (int j = 0; j < iBindingArray.length; ++j) {
                    Object object3 = iBindingArray[j].getName();
                    if (iSpecialForm.getClass().getName().endsWith("MatchXDMItemInstruction") && "_".equals(object3)) continue;
                    int n3 = this.nextIdentifier();
                    IdentifierInstruction identifierInstruction = this.getIdentifierInstruction(n3);
                    Object object4 = this.getIdentifierName(n3);
                    hashMap.put(object3, identifierInstruction);
                    iBindingArray2[j].setName(object4);
                }
            }
        }
        for (int i = n2 - 1; i >= 0; --i) {
            object2 = instruction2.getChildInstruction(i);
            Instruction instruction4 = this.process((Instruction)object2, set2, hashMap);
            if (instruction4 == object2) continue;
            if (instruction3 == null) {
                instruction3 = instruction2.cloneShallow();
            }
            instruction3.setChildInstruction(i, instruction4);
        }
        if (instruction3 != null) {
            return instruction3;
        }
        return instruction2;
    }

    protected Instruction processIdentifier(IdentifierInstruction identifierInstruction, Set set2, HashMap hashMap) {
        Object object2 = identifierInstruction.getVariable();
        if (set2.contains(object2)) {
            Instruction instruction2 = this.m_paramInstructions.get(object2);
            if (instruction2 == null) {
                this.m_paramInstructions.put(object2, identifierInstruction);
                instruction2 = identifierInstruction;
            }
            return instruction2;
        }
        Instruction instruction3 = (Instruction)hashMap.get(object2);
        if (instruction3 == null) {
            throw new XylemError("ERR_SYSTEM", "unbound(?):" + identifierInstruction);
        }
        return instruction3;
    }
}

