/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import java.io.IOException;

public class FunctorApplicationDirective
extends ModuleImportDirective {
    private static final long serialVersionUID = -6949170961858987141L;
    protected String m_functorName;
    protected Object[] m_modulesToApply;
    private static int s_applications = 0;
    protected int m_index = s_applications++;

    public FunctorApplicationDirective() {
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_functorName = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeString(this.m_functorName);
    }

    public FunctorApplicationDirective(String string2, ModuleSignature moduleSignature, String string3, Object[] objectArray) {
        super(string2, moduleSignature);
        this.m_functorName = string3;
        this.m_modulesToApply = objectArray;
    }

    @Override
    public Instruction translateFunctionCall(ModuleFunctionCallInstruction moduleFunctionCallInstruction, Module module) {
        Instruction[] instructionArray = moduleFunctionCallInstruction.m_parameters;
        Instruction[] instructionArray2 = new Instruction[instructionArray.length + 1];
        System.arraycopy(instructionArray, 0, instructionArray2, 0, instructionArray.length);
        instructionArray2[instructionArray.length] = LiteralInstruction.integerLiteral(this.m_index);
        return new FunctionCallInstruction(FunctorApplicationDirective.translateFunctionName(moduleFunctionCallInstruction.getFunction(), this.m_functorName), instructionArray2);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("apply-functor", n2);
        prettyPrinter.print(" " + this.getLocalName() + "@");
        prettyPrinter.print(this.m_signature);
        prettyPrinter.print(" " + this.m_functorName);
        for (int i = 0; i < this.m_modulesToApply.length; ++i) {
            prettyPrinter.print(" " + this.m_modulesToApply[i]);
        }
        prettyPrinter.printFormClose(n2);
    }
}

