/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Functor
implements Serializable {
    private static final long serialVersionUID = 3253739645996929876L;
    private static final Logger s_logger = LoggerUtil.getLogger(Functor.class);
    private static final String s_className = Functor.class.getName();
    protected ModuleSignature[] m_parameters;
    protected String[] m_parameterNames;
    protected Module m_body;
    protected String m_name;
    protected ModuleSignature m_signature;

    public Functor(String string2, Module module, ModuleSignature[] moduleSignatureArray, String[] stringArray, ModuleSignature moduleSignature) {
        this.m_name = string2;
        this.m_body = module;
        this.m_parameters = moduleSignatureArray;
        this.m_signature = moduleSignature;
        this.m_parameterNames = stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_body.addModuleImportDirective(new FunctorParameterDirective(stringArray[i], moduleSignatureArray[i]));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Module getBody() {
        return this.m_body;
    }

    public ModuleSignature[] getParameters() {
        return this.m_parameters;
    }

    public String[] getParameterNames() {
        return this.m_parameterNames;
    }

    public ModuleSignature getSignature() {
        return this.m_signature;
    }

    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("functor", n2);
        prettyPrinter.printToken("(" + this.m_name, n2 + 1);
        prettyPrinter.print("@");
        prettyPrinter.print(this.m_signature);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            prettyPrinter.printToken(this.m_parameterNames[i], n2 + 2);
            prettyPrinter.print("@");
            prettyPrinter.print(this.m_parameters[i]);
        }
        prettyPrinter.printFormClose(n2 + 1);
        this.m_body.prettyPrintModuleInternals(prettyPrinter, n2);
        prettyPrinter.printFormClose(n2);
    }

    public void typeCheck() throws TypeCheckException {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "typeCheck", "Type checking functor " + this.m_name);
        }
        this.m_body.typeCheck();
    }

    public void clearTypeInformation() {
        this.m_body.clearTypeInformation(true);
    }

    public void reduce() {
        this.m_body.reduce();
    }

    public class FunctorParameterDirective
    extends ModuleImportDirective {
        private static final long serialVersionUID = 1617730064793711035L;

        FunctorParameterDirective(String string2, ModuleSignature moduleSignature) {
            super(string2, moduleSignature);
        }

        @Override
        public Instruction translateFunctionCall(ModuleFunctionCallInstruction moduleFunctionCallInstruction, Module module) {
            Instruction[] instructionArray = moduleFunctionCallInstruction.m_parameters;
            Instruction[] instructionArray2 = new Instruction[instructionArray.length + 1];
            System.arraycopy(instructionArray, 0, instructionArray2, 0, instructionArray.length);
            instructionArray2[instructionArray.length] = new IdentifierInstruction("__functorinstance__");
            return new FunctionCallInstruction(Functor.this.m_name + "$functor$" + this.m_localName + "$" + moduleFunctionCallInstruction.getFunction(), instructionArray2);
        }

        @Override
        public void toString(PrettyPrinter prettyPrinter, int n2) {
        }
    }
}

