/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;

public class FunctionSignature {
    protected String m_functionName;
    protected Type m_returnType;
    protected Type[] m_parameterTypes;
    protected Object[] m_parameterNames;
    public String[] m_defaultValues;

    public FunctionSignature() {
    }

    public FunctionSignature(String string2, Object[] objectArray, Type[] typeArray, Type type2) {
        this.m_functionName = string2;
        if (this.m_functionName == null) {
            throw new NullPointerException();
        }
        this.m_parameterTypes = typeArray;
        this.m_parameterNames = objectArray;
        this.m_returnType = type2;
    }

    public FunctionSignature(Function function2) {
        this.m_functionName = function2.getName();
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        this.m_returnType = function2.getReturnType();
        Binding[] bindingArray = function2.m_parameters;
        this.m_parameterTypes = new Type[bindingArray.length];
        this.m_parameterNames = new Object[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            this.m_parameterTypes[i] = bindingArray[i].getBindingType();
            this.m_parameterNames[i] = bindingArray[i].getName();
        }
        if (function2.m_defaultValues != null) {
            this.m_defaultValues = (String[])function2.m_defaultValues.clone();
        }
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public void setFunctionName(String string2) {
        this.m_functionName = string2;
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Type type2) {
        this.m_returnType = type2;
    }

    public Type[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public Object[] getParameterNames() {
        return this.m_parameterNames;
    }

    public void setParameterType(int n2, Type type2) {
        this.m_parameterTypes[n2] = type2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.m_functionName);
        if (this.m_returnType != null) {
            stringBuffer.append("@");
            stringBuffer.append(this.m_returnType.prettyPrint());
        }
        int n2 = this.m_parameterTypes.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(PrettyPrinter.prettyPrintIdentifier(this.m_parameterNames[i]));
            stringBuffer.append('@');
            stringBuffer.append(this.m_parameterTypes[i].prettyPrint());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("declare-function", n2);
        prettyPrinter.printToken(this.m_functionName, n2 + 1);
        if (this.m_returnType != null) {
            prettyPrinter.print("@");
            prettyPrinter.print(this.m_returnType.prettyPrint());
        }
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            prettyPrinter.printIdentifier(this.m_parameterNames[i], n2 + 1);
            Type type2 = this.m_parameterTypes[i];
            prettyPrinter.print("@");
            prettyPrinter.print(type2.prettyPrint());
        }
        prettyPrinter.printFormClose(n2);
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature functionSignature = (FunctionSignature)object2;
        if (!functionSignature.m_functionName.equals(this.m_functionName) || functionSignature.m_parameterTypes.length != this.m_parameterTypes.length) {
            return false;
        }
        if (this.m_returnType == null && functionSignature.m_returnType != null || functionSignature.m_returnType == null && this.m_returnType != null) {
            return false;
        }
        if (this.m_returnType != functionSignature.m_returnType && !this.m_returnType.equals(functionSignature.m_returnType)) {
            return false;
        }
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            if (this.m_parameterTypes[i].equals(functionSignature.m_parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_functionName.hashCode() + this.m_parameterTypes.length;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        writeObjectFileHelper.writeString(this.m_functionName);
        writeObjectFileHelper.writeBindingNames(this.m_parameterNames);
        writeObjectFileHelper.writeTypes(this.m_parameterTypes);
        writeObjectFileHelper.writeType(this.m_returnType);
        writeObjectFileHelper.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
        if (this.m_defaultValues != null) {
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                writeObjectFileHelper.writeBoolean(this.m_defaultValues[i] != null);
                if (this.m_defaultValues[i] == null) continue;
                writeObjectFileHelper.writeString(this.m_defaultValues[i]);
            }
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_functionName = readObjectFileHelper.readString();
        if (this.m_functionName == null) {
            throw new RuntimeException();
        }
        this.m_parameterNames = readObjectFileHelper.readBindingNames();
        this.m_parameterTypes = readObjectFileHelper.readTypes();
        this.m_returnType = readObjectFileHelper.readType();
        int n2 = readObjectFileHelper.readInt();
        if (n2 > 0) {
            this.m_defaultValues = new String[n2];
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                if (!readObjectFileHelper.readBoolean()) continue;
                this.m_defaultValues[i] = readObjectFileHelper.readString();
            }
        }
    }
}

