/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class FunctionInstantiation
implements Serializable {
    private static final long serialVersionUID = -209181267043783730L;
    public Type m_returnType;
    public Type[] m_parameterTypes;
    public Function m_function;
    public Map m_templateToInstantiation;
    public TypeEnvironment m_targetTypeEnvironment;
    public Type[] m_resolvedParameterTypes;
    public BindingEnvironment m_targetBindingEnvironment;
    FunctionInstantiation m_original;
    protected FunctionCallInstruction m_fci;
    public static final boolean s_enableProfiling = false;
    private static final HashMap s_profileData = new HashMap();

    public static void profileHit(String string2) {
        Integer n2 = (Integer)s_profileData.get(string2);
        int n3 = n2 == null ? 0 : n2;
        s_profileData.put(string2, new Integer(n3 + 1));
    }

    public FunctionInstantiation(Function function2, Type[] typeArray, Type type2, Map map2, TypeEnvironment typeEnvironment, FunctionCallInstruction functionCallInstruction, BindingEnvironment bindingEnvironment) {
        this.m_function = function2;
        this.m_parameterTypes = typeArray;
        this.m_returnType = type2;
        this.m_templateToInstantiation = map2;
        this.m_targetTypeEnvironment = typeEnvironment;
        this.m_original = this;
        this.m_fci = functionCallInstruction;
        this.m_targetBindingEnvironment = bindingEnvironment;
    }

    public FunctionInstantiation(FunctionInstantiation functionInstantiation) {
        this.m_function = functionInstantiation.m_function;
        this.m_returnType = functionInstantiation.m_returnType;
        this.m_parameterTypes = functionInstantiation.m_parameterTypes;
        this.m_original = functionInstantiation;
        this.m_resolvedParameterTypes = new Type[functionInstantiation.m_parameterTypes.length];
        for (int i = 0; i < functionInstantiation.m_parameterTypes.length; ++i) {
            Type type2 = functionInstantiation.m_parameterTypes[i].resolveType(functionInstantiation.m_targetTypeEnvironment);
            if (type2 == null) {
                throw new RuntimeException();
            }
            this.m_resolvedParameterTypes[i] = type2;
        }
    }

    public int hashCode() {
        return this.m_parameterTypes.length + this.m_function.getName().hashCode();
    }

    public boolean equals(Object object2) {
        if (this.m_resolvedParameterTypes == null) {
            return this == object2;
        }
        if (object2 == null || !(object2 instanceof FunctionInstantiation)) {
            return false;
        }
        FunctionInstantiation functionInstantiation = (FunctionInstantiation)object2;
        if (functionInstantiation.m_function != this.m_function) {
            return false;
        }
        return this.toString().equals(functionInstantiation.toString());
    }

    public void doFinalTypeCheck() throws TypeCheckException {
        this.makeTypeEnvironment();
    }

    protected TypeEnvironment makeTypeEnvironment() throws TypeCheckException {
        Type type2;
        TypeEnvironment typeEnvironment = (TypeEnvironment)this.m_function.getTypeEnvironment().clone();
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            type2 = this.m_parameterTypes[i];
            this.m_function.unifyParameter(typeEnvironment, this.m_targetBindingEnvironment, type2, this.m_fci.m_parameters, i, this.m_fci, true);
        }
        if (this.m_templateToInstantiation != null) {
            Type type3 = this.m_function.getReturnType().duplicateType(this.m_templateToInstantiation);
            type2 = this.m_function.getReturnType().resolveType(typeEnvironment);
            if (type2 != null) {
                this.m_targetTypeEnvironment.unify(type2, type3, null);
            }
        }
        return typeEnvironment;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_function.getName());
        stringBuffer.append('(');
        for (int i = 0; i < this.m_resolvedParameterTypes.length; ++i) {
            stringBuffer.append(this.m_resolvedParameterTypes[i]);
            if (i == this.m_resolvedParameterTypes.length - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

