/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.FunctionInstantiation;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.LUBConstraint;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.TypeSpecializationDerivative;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Function
implements Serializable,
IContext {
    private static final long serialVersionUID = -7216470938089112997L;
    private static final char ESCAPE_DELIM_CHAR = '$';
    protected String m_name;
    protected Instruction m_body;
    public Binding[] m_parameters;
    public String[] m_defaultValues;
    private TypeEnvironment m_typeEnvironment;
    public BindingEnvironment m_bindingEnvironment;
    protected Type m_returnType;
    private HashSet m_constraints;
    public String m_comment;
    public HashMap m_resolvedConstraintTypes = new HashMap();
    protected HashMap m_derivatives = new HashMap();
    protected Function m_original = null;
    protected Object m_derivationKey = null;
    protected boolean m_memoizeResult = false;
    protected boolean m_inlineHint = false;
    protected boolean m_impure = false;
    protected TypeEnvironment m_inProgressTypeEnvironment;
    public boolean m_supportsStreamOptimization = false;
    public boolean m_checkedStreamOptimization = false;
    public boolean m_inSupportsStreamCall = false;
    public boolean m_supportsStreamInADTOptimization = false;
    public boolean m_supportsStreamInObjectlessADT = false;
    public boolean m_checkedStreamInADTOptimization = false;
    public boolean m_inSupportsStreamInADTCall = false;
    public int m_definitionLineNumber;
    public URL m_definitionURL;
    public boolean m_isClassMethod = false;
    public int m_stackFrameSize;
    public Instruction.TraceBackObject m_creationTraceException;
    int m_foundForkCount = 0;
    private static final Logger s_logger = LoggerUtil.getLogger(Function.class);
    private static final String s_className = Function.class.getName();
    private boolean m_checkedRecursiveness = false;
    private boolean m_isRecursiveF = false;
    private static int s_fixups = 0;
    protected String m_memoizedVarName;
    protected String m_memoizedCheckVarName;

    public Function() {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
    }

    @Override
    public URL getDefinitionURL() {
        return this.m_definitionURL;
    }

    @Override
    public int getDefinitionLineNumber() {
        return this.m_definitionLineNumber;
    }

    public static void pushFunction(Function function2, LinkedList linkedList) {
        linkedList.add(function2);
    }

    public static LinkedList isInCycle(Function function2, LinkedList linkedList) {
        LinkedList<Function> linkedList2 = null;
        for (Function function3 : linkedList) {
            if (function3 == function2) {
                linkedList2 = new LinkedList<Function>();
                continue;
            }
            if (linkedList2 == null) continue;
            linkedList2.add(function3);
        }
        return linkedList2;
    }

    public boolean isRecursive() {
        if (this.m_checkedRecursiveness) {
            return this.m_isRecursiveF;
        }
        HashSet hashSet = new HashSet();
        this.getBody().accumulateFunctionsCalled(hashSet);
        this.m_isRecursiveF = hashSet.contains(this.getName());
        this.m_checkedRecursiveness = true;
        return this.m_isRecursiveF;
    }

    public static Function getCurrentFunction(LinkedList linkedList) {
        if (linkedList.isEmpty()) {
            return null;
        }
        return (Function)linkedList.getLast();
    }

    public static void popFunction(Function function2, LinkedList linkedList) {
        if (linkedList.removeLast() != function2) {
            throw new RuntimeException("Error: function stack is inconsistent");
        }
    }

    private void init(String string2, Binding[] bindingArray, Instruction instruction2, URL uRL, int n2) {
        this.m_name = string2;
        this.m_parameters = bindingArray;
        this.m_body = instruction2;
        this.m_returnType = new TypeVariable();
        this.m_constraints = new HashSet();
        this.m_definitionURL = uRL;
        this.m_definitionLineNumber = n2;
    }

    public Function(String string2, Binding[] bindingArray, Instruction instruction2) {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
        this.init(string2, bindingArray, instruction2, null, 0);
    }

    public Function(String string2, Binding[] bindingArray, Instruction instruction2, URL uRL, int n2) {
        if (Instruction.USEINSTRUCTIONCREATIONTRACE) {
            this.m_creationTraceException = new Instruction.TraceBackObject("Creation Trace");
        }
        this.init(string2, bindingArray, instruction2, uRL, n2);
    }

    public void setMemoizeResult(boolean bl) {
        this.m_memoizeResult = bl;
    }

    public boolean getMemoizeResult() {
        return this.m_memoizeResult;
    }

    public void setImpurity(boolean bl) {
        this.m_impure = bl;
    }

    public boolean isImpure() {
        return this.m_impure;
    }

    public void setInlineHint(boolean bl) {
        this.m_inlineHint = bl;
    }

    public boolean getInlineHint() {
        return this.m_inlineHint;
    }

    public Function cloneFunctionForFixup(Object object2) {
        return this.cloneFunctionForFixup(object2, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateNewFixupName() {
        Class<Function> clazz = Function.class;
        synchronized (Function.class) {
            int n2 = s_fixups++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return "$fixup$" + n2 + "$" + this.m_name;
        }
    }

    public Function cloneFunctionForFixup(Object object2, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        String string2 = this.generateNewFixupName();
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            serializable = this.m_parameters[i];
            bindingArray[i] = new Binding(((Binding)serializable).m_name, ((Binding)serializable).m_type, ((Binding)serializable).m_typeEnvironment);
        }
        Instruction instruction2 = this.m_body;
        if (bl2) {
            instruction2 = bl3 ? instruction2.cloneReduced() : instruction2.cloneWithoutTypeInformation();
        }
        serializable = new Function(string2, bindingArray, instruction2);
        ((Function)serializable).m_comment = this.m_comment;
        this.registerDerivative(object2, (Function)serializable);
        ((Function)serializable).setImpurity(this.isImpure());
        ((Function)serializable).m_constraints = new HashSet();
        HashMap hashMap = new HashMap();
        if (this.m_constraints != null && !this.m_constraints.isEmpty()) {
            for (Serializable serializable2 : this.m_constraints) {
                Iterator iterator = ((LUBConstraint)serializable2).m_set.iterator();
                HashSet<Type> hashSet = new HashSet<Type>();
                while (iterator.hasNext()) {
                    Type type2 = (Type)iterator.next();
                    hashSet.add(bl ? type2.duplicateType(hashMap) : type2);
                }
                ((Function)serializable).m_constraints.add(new LUBConstraint(bl ? ((LUBConstraint)serializable2).m_t.duplicateType(hashMap) : ((LUBConstraint)serializable2).m_t, hashSet));
            }
        }
        if (!this.m_resolvedConstraintTypes.isEmpty()) {
            for (Serializable serializable2 : this.m_resolvedConstraintTypes.keySet()) {
                ((Function)serializable).m_resolvedConstraintTypes.put(bl ? ((Type)serializable2).duplicateType(hashMap) : serializable2, this.m_resolvedConstraintTypes.get(serializable2));
            }
        }
        if (!hashMap.isEmpty() && bl) {
            if (!bl2) {
                throw new XylemError("ERR_SYSTEM", "not compatible renameTypeVars && !cloneBody");
            }
            ((Function)serializable).m_body.replaceTypeVariables(hashMap);
        }
        return serializable;
    }

    public void setComment(String string2) {
        this.m_comment = string2;
    }

    public String getComment() {
        return this.m_comment;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction2) {
        this.m_body = instruction2;
    }

    public boolean hasBeenTypeChecked() {
        return this.m_typeEnvironment != null;
    }

    public void typeCheck(final Module module, Instruction instruction2, LinkedList linkedList) throws TypeCheckException {
        if (this.m_typeEnvironment != null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_name + " has already been type checked"), instruction2);
        }
        LinkedList linkedList2 = Function.isInCycle(this, linkedList);
        if (linkedList2 != null) {
            if (this.m_returnType == null) {
                this.m_returnType = new TypeVariable();
            }
            for (Function function2 : linkedList2) {
                this.m_inProgressTypeEnvironment.incorporate(function2.m_inProgressTypeEnvironment);
                function2.m_inProgressTypeEnvironment.redirectFrom(this.m_inProgressTypeEnvironment);
            }
        } else {
            FunctionSignature functionSignature;
            if (!this.m_body.typeAliasesExpanded) {
                this.m_body.expandTypeAliases(module);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "typeCheck", "type checking function " + this.m_name + " with " + this.m_parameters.length + " parameters.");
            }
            if ((functionSignature = module.getFunctionSignature(this.m_name)) != null) {
                functionSignature.m_parameterTypes = Type.map(new Type.Mapping(){

                    @Override
                    public Type apply(Type type2) {
                        return type2.expandTypeAliases(module);
                    }
                }, functionSignature.m_parameterTypes);
                functionSignature.m_returnType = functionSignature.m_returnType.expandTypeAliases(module);
            }
            BindingEnvironment bindingEnvironment = new BindingEnvironment();
            this.m_inProgressTypeEnvironment = new TypeEnvironment(module);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].m_type = this.m_parameters[i].m_type.expandTypeAliases(module);
                this.m_parameters[i].m_typeEnvironment = this.m_inProgressTypeEnvironment;
                if (bindingEnvironment.getVariableBinding(this.m_parameters[i].getName()) != null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter name " + this.m_parameters[i].getName() + " is used more than once"), instruction2);
                }
                bindingEnvironment.setVariableBinding(this.m_parameters[i]);
                if (functionSignature == null) continue;
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_parameters[i].getBindingType(), functionSignature.getParameterTypes()[i], null);
                    continue;
                }
                catch (TypeCheckException typeCheckException) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter " + this.m_parameters[i].getName() + "@" + this.m_parameters[i].getBindingType() + " of function " + this.m_name + " does not match the type@" + functionSignature.getParameterTypes()[i] + " given in the module signature " + functionSignature.getFunctionName()), null);
                }
            }
            Function.pushFunction(this, linkedList);
            this.m_body.typeCheck(this.m_inProgressTypeEnvironment, bindingEnvironment, linkedList);
            if (this.m_returnType != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, this.m_body.getCachedType(), null);
                }
                catch (TypeCheckException typeCheckException) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_body.getCachedType().resolveType(this.m_inProgressTypeEnvironment) + " of function " + this.m_name + " does not match the type " + this.m_returnType + " given in the module signature"), null);
                }
            } else {
                this.m_returnType = this.m_body.getCachedType();
            }
            if (functionSignature != null && functionSignature.getReturnType() != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, functionSignature.getReturnType(), null);
                }
                catch (TypeCheckException typeCheckException) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_returnType + " of function " + this.m_name + " does not match the type " + functionSignature.getReturnType() + " given in the module signature"), null);
                }
            }
            Function.popFunction(this, linkedList);
            this.m_typeEnvironment = this.m_inProgressTypeEnvironment;
            this.m_bindingEnvironment = bindingEnvironment;
            for (Type type2 : this.m_resolvedConstraintTypes.keySet()) {
                Type type3 = (Type)this.m_resolvedConstraintTypes.get(type2);
                this.m_typeEnvironment.unify(type2, type3, null);
            }
            if (this.m_constraints != null) {
                this.m_typeEnvironment.resolveLUBConstraints(this.m_constraints, module.m_lubResolver, true);
                this.recordLUBConstraintResults(this.m_typeEnvironment);
                this.m_constraints = null;
            }
            this.standardizeTypes(false);
        }
    }

    public void standardizeTypes(boolean bl) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type type2 = this.m_parameters[i].getBindingType().resolveTypeAsMuchAsPossible(this.m_typeEnvironment, hashSet);
            this.m_parameters[i].setType(type2);
        }
        this.m_returnType = this.m_returnType.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, hashSet);
        if (bl) {
            this.m_body.standardizeTypes(hashSet, this.m_typeEnvironment);
        }
    }

    public void typeCheckReduced(Module module, LinkedList linkedList) throws TypeCheckException {
        LinkedList linkedList2 = Function.isInCycle(this, linkedList);
        if (linkedList2 != null) {
            if (this.m_returnType == null) {
                this.m_returnType = new TypeVariable();
            }
            for (Function function2 : linkedList2) {
                this.m_inProgressTypeEnvironment.incorporate(function2.m_inProgressTypeEnvironment);
                function2.m_inProgressTypeEnvironment.redirectFrom(this.m_inProgressTypeEnvironment);
            }
        } else {
            FunctionSignature functionSignature = module.getFunctionSignature(this.m_name);
            BindingEnvironment bindingEnvironment = new BindingEnvironment();
            bindingEnvironment.prepareHashMap();
            this.m_inProgressTypeEnvironment = new TypeEnvironment(module);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].m_typeEnvironment = this.m_inProgressTypeEnvironment;
                bindingEnvironment.setVariableBinding(this.m_parameters[i]);
                if (functionSignature == null) continue;
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_parameters[i].getBindingType(), functionSignature.getParameterTypes()[i], null);
                    continue;
                }
                catch (TypeCheckException typeCheckException) {
                    FFDCUtil.log(typeCheckException, this);
                    String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Parameter '" + this.m_parameters[i].getName() + "' of function '" + this.m_name + "' does not match the type given in the module signature"});
                    s_logger.logp(Level.SEVERE, s_className, "typeCheckReduced", string2, typeCheckException);
                    throw new TypeCheckException(string2, null);
                }
            }
            Function.pushFunction(this, linkedList);
            this.m_body.typeCheckReduced(this.m_inProgressTypeEnvironment, bindingEnvironment, linkedList);
            TypeEnvironment typeEnvironment = this.m_inProgressTypeEnvironment;
            if (this.m_returnType != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, this.m_body.getType(typeEnvironment, bindingEnvironment), null);
                }
                catch (TypeCheckException typeCheckException) {
                    String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"The return type " + this.m_body.getType(typeEnvironment, bindingEnvironment).resolveType(this.m_inProgressTypeEnvironment) + " of function " + this.m_name + " does not match the type " + this.m_returnType + " given in the module signature"});
                    s_logger.logp(Level.SEVERE, s_className, "typeCheckReduced", string3, typeCheckException);
                    throw new TypeCheckException(string3, null);
                }
            } else {
                this.m_returnType = this.m_body.getType(typeEnvironment, bindingEnvironment);
            }
            if (functionSignature != null && functionSignature.getReturnType() != null) {
                this.m_inProgressTypeEnvironment.unify(this.m_returnType, functionSignature.getReturnType(), null);
            }
            Function.popFunction(this, linkedList);
            this.m_typeEnvironment = this.m_inProgressTypeEnvironment;
            this.m_bindingEnvironment = bindingEnvironment;
            this.standardizeTypes(false);
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Type type2) {
        this.m_returnType = type2;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String string2) {
        this.m_name = string2;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    public void unifyParameter(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Type type2, Instruction[] instructionArray, int n2, FunctionCallInstruction functionCallInstruction, boolean bl) throws TypeCheckException {
        Type type3 = this.m_parameters[n2].getBindingType();
        this.unifyParameter(typeEnvironment, bindingEnvironment, type2, type3, instructionArray, n2, functionCallInstruction, bl);
    }

    public void unifyParameter(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Type type2, Type type3, Instruction[] instructionArray, int n2, FunctionCallInstruction functionCallInstruction, boolean bl) throws TypeCheckException {
        if (type2 == null) {
            throw new RuntimeException();
        }
        Type[] typeArray = new Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            Type type4 = (bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType()).resolveType(typeEnvironment);
            if (type4 == null) continue;
            typeArray[i] = type4;
        }
        typeEnvironment.unify(type2, type3, functionCallInstruction);
    }

    public FunctionInstantiation instantiate(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Instruction[] instructionArray, FunctionCallInstruction functionCallInstruction, LinkedList linkedList, boolean bl) throws TypeCheckException {
        Object object2;
        Type type2;
        Type type3;
        if (instructionArray.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Incorrect number of parameters to " + this.m_name + "\n  expected " + this.m_parameters.length + ", found " + instructionArray.length), functionCallInstruction);
        }
        Function function2 = this;
        Type[] typeArray = new HashMap();
        Object object3 = new Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            Type type4 = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            type3 = function2.m_parameters[i].m_type;
            Type type5 = type2 = function2.m_parameters[i].m_typeEnvironment == null ? null : type3.resolveType(function2.m_parameters[i].m_typeEnvironment);
            if (type2 != null) {
                type3 = type2;
            }
            if (bl) continue;
            type3 = type3.duplicateType((Map)typeArray);
            this.unifyParameter(typeEnvironment, bindingEnvironment, type4, type3, instructionArray, i, functionCallInstruction, bl);
            object3[i] = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            object2 = function2.m_resolvedConstraintTypes.keySet().iterator();
            while (object2.hasNext()) {
                Type type6 = (Type)object2.next();
                Type type7 = (Type)function2.m_resolvedConstraintTypes.get(type6);
                typeEnvironment.unify(type6.duplicateType((Map)typeArray), type7, null);
            }
        }
        if (this.isPolymorphic()) {
            typeArray = new Type[instructionArray.length];
            for (int i = 0; i < instructionArray.length; ++i) {
                Type type8;
                typeArray[i] = type8 = (bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType()).resolveType(typeEnvironment);
            }
            object3 = new TypeSpecializationDerivative(typeArray);
            if (!((TypeSpecializationDerivative)object3).equals(this.m_derivationKey)) {
                Function function3 = TypeSpecializationDerivative.specializeTypes(this, typeArray);
                functionCallInstruction.setFunction(function3.getName());
                function2 = function3;
                typeEnvironment.getModule().addFunction(function2);
            }
        }
        object3 = Function.getCurrentFunction(linkedList);
        if (function2.isPolymorphic()) {
            if (object3 == null) {
                typeEnvironment.getModule().addToFixupList(functionCallInstruction, (Function)object3);
            } else if (!((Function)object3).isPolymorphic()) {
                typeEnvironment.getModule().addToFixupList(functionCallInstruction, (Function)object3);
            }
        }
        if (!function2.hasBeenTypeChecked()) {
            if (bl) {
                function2.typeCheckReduced(typeEnvironment.getModule(), linkedList);
            } else {
                function2.typeCheck(typeEnvironment.getModule(), functionCallInstruction, linkedList);
            }
        }
        HashMap hashMap = new HashMap();
        typeArray = new Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            type3 = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            type2 = function2.m_parameters[i].m_type;
            Object object4 = object2 = function2.m_parameters[i].m_typeEnvironment == null ? null : type2.resolveType(function2.m_parameters[i].m_typeEnvironment);
            if (object2 != null) {
                type2 = object2;
            }
            if (bl) continue;
            type2 = type2.duplicateType(hashMap);
            this.unifyParameter(typeEnvironment, bindingEnvironment, type3, type2, instructionArray, i, functionCallInstruction, bl);
            typeArray[i] = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            for (Type type7 : function2.m_resolvedConstraintTypes.keySet()) {
                Type type9 = (Type)function2.m_resolvedConstraintTypes.get(type7);
                typeEnvironment.unify(type7.duplicateType(hashMap), type9, null);
            }
        }
        Type type10 = function2.m_returnType;
        if (function2.m_typeEnvironment != null && (type3 = type10.resolveType(function2.m_typeEnvironment)) != null) {
            type10 = type3;
        }
        if (!bl) {
            type10 = type10.duplicateType(hashMap);
        }
        if (!type10.isFullySpecified()) {
            typeEnvironment.getModule().addToFixupList(functionCallInstruction, (Function)object3);
        }
        return new FunctionInstantiation(function2, typeArray, type10, hashMap, typeEnvironment, functionCallInstruction, bindingEnvironment);
    }

    public Type instantiateReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, FunctionCallInstruction functionCallInstruction, LinkedList linkedList) throws TypeCheckException {
        Function function2 = this;
        if (!function2.hasBeenTypeChecked()) {
            function2.typeCheckReduced(typeEnvironment.getModule(), linkedList);
        }
        if (function2.isPolymorphic()) {
            HashMap hashMap = new HashMap();
            Instruction[] instructionArray = functionCallInstruction.m_parameters;
            for (int i = 0; i < function2.m_parameters.length; ++i) {
                Binding binding = function2.m_parameters[i];
                Type type2 = binding.getBindingType();
                Type type3 = type2.duplicateType(hashMap);
                typeEnvironment.unify(instructionArray[i].getType(typeEnvironment, bindingEnvironment), type3, functionCallInstruction);
            }
            return function2.m_returnType.duplicateType(hashMap);
        }
        return function2.m_returnType;
    }

    public Type instantiateReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Instruction[] instructionArray, FunctionCallInstruction functionCallInstruction, Set set2, Set set3, Set set4) {
        Function function2 = this;
        if (this.isPolymorphic()) {
            Type type2;
            Type type3;
            int n2;
            Type[] typeArray = new Type[instructionArray.length];
            TypeEnvironment typeEnvironment2 = (TypeEnvironment)this.m_typeEnvironment.clone();
            for (n2 = 0; n2 < instructionArray.length; ++n2) {
                Type type4 = instructionArray[n2].getType(typeEnvironment, bindingEnvironment).resolveTypeAsMuchAsPossible(typeEnvironment, new HashSet());
                try {
                    type3 = this.m_parameters[n2].getBindingType();
                    typeEnvironment2.unify(type4, type3, functionCallInstruction);
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                    throw new RuntimeException();
                }
                typeArray[n2] = type4;
            }
            for (n2 = 0; n2 < instructionArray.length; ++n2) {
                typeArray[n2] = typeArray[n2].resolveType(typeEnvironment2);
                if (typeArray[n2] == null) {
                    throw new XylemError("ERR_SYSTEM", "Some type could not be inferred in " + this);
                }
                try {
                    typeEnvironment.unify(typeArray[n2], instructionArray[n2].getType(typeEnvironment, bindingEnvironment), functionCallInstruction);
                    continue;
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                    throw new RuntimeException();
                }
            }
            Function function3 = TypeSpecializationDerivative.specializeTypes(this, typeArray);
            functionCallInstruction.setFunction(function3.getName());
            typeEnvironment.getModule().addFunction(function3);
            if (!function3.hasBeenTypeChecked()) {
                try {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "instantiateReduced", "Type-checking new function '" + function3.getName() + "'");
                    }
                    function3.typeCheckReduced(typeEnvironment.getModule(), new LinkedList());
                    set2.add(function3);
                    for (int i = 0; i < instructionArray.length; ++i) {
                        type3 = this.m_parameters[i].getBindingType();
                        function3.m_typeEnvironment.unify(type3, typeArray[i], functionCallInstruction);
                    }
                    function3.standardizeTypes(true);
                    function3.instantiateReducedPolymorphicFunctions(set2, set3, set4);
                }
                catch (Exception exception) {
                    FFDCUtil.log(exception, this);
                    s_logger.logrb(Level.SEVERE, s_className, "instantiateReduced", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)exception);
                    throw new RuntimeException(exception);
                }
            }
            if ((type3 = (type2 = function3.m_returnType).resolveType(typeEnvironment2)) == null) {
                throw new XylemError("ERR_SYSTEM", "An error occurred trying to process function " + function3.getName());
            }
            return type3;
        }
        if (!set3.contains(function2)) {
            function2.instantiateReducedPolymorphicFunctions(set2, set3, set4);
        }
        Type type5 = function2.m_returnType;
        return type5.resolveType(function2.m_typeEnvironment);
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.m_typeEnvironment;
    }

    public BindingEnvironment getBindingEnvironment() {
        return this.m_bindingEnvironment;
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printComment("============================================", n2);
        if (null != this.m_comment) {
            prettyPrinter.printComment(this.m_comment, n2);
        }
        prettyPrinter.printFormOpen("function", n2);
        if (this.m_memoizeResult) {
            prettyPrinter.printToken("memoize", n2);
        }
        if (this.m_impure) {
            prettyPrinter.printToken("impure", n2);
        }
        if (this.m_inlineHint) {
            prettyPrinter.printToken("inline", n2);
        }
        prettyPrinter.printToken("(" + this.m_name, n2 + 1);
        if (!(this.m_returnType == null || this.m_typeEnvironment == null && this.m_returnType instanceof TypeVariable)) {
            Type type2 = this.m_returnType;
            if (this.m_typeEnvironment != null) {
                type2 = this.m_returnType.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, new HashSet());
            }
            prettyPrinter.print("@");
            prettyPrinter.print(type2.prettyPrint());
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            prettyPrinter.println("");
            prettyPrinter.print("      ");
            prettyPrinter.printIdentifier(this.m_parameters[i], n2 + 2);
            Type type3 = this.m_parameters[i].getBindingType();
            if (type3 == null) continue;
            if (this.m_typeEnvironment != null) {
                type3 = type3.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, new HashSet());
            }
            prettyPrinter.print("@");
            prettyPrinter.print(type3.prettyPrint());
        }
        prettyPrinter.printFormClose(n2 + 1);
        this.m_body.toString(prettyPrinter, n2 + 1);
        prettyPrinter.printFormClose(n2);
    }

    public String generateFunctionName(CodeGeneration codeGeneration) {
        return Function.generateFunctionName(codeGeneration, this.getName());
    }

    public static final String generateFunctionName(CodeGeneration codeGeneration, String string2) {
        if (codeGeneration.getSettings().isObfuscateFunctionNames()) {
            String string3 = codeGeneration.getObfuscatedFunctionName(string2);
            return string3;
        }
        return Function.generateFunctionName(string2);
    }

    public static final String generateFunctionName(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < n2; ++i) {
            char c2 = string2.charAt(i);
            if (c2 != '$' && c2 < '\u0080' && (Character.isJavaIdentifierStart(c2) || Character.isJavaIdentifierPart(c2))) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('$').append("0x").append(Integer.toHexString(c2)).append('$');
        }
        return stringBuffer.toString();
    }

    public void clearTypeInformation() {
        this.clearTypeInformation(true);
    }

    public void clearTypeInformation(boolean bl) {
        this.m_bindingEnvironment = null;
        this.m_typeEnvironment = null;
        this.m_body.clearTypeInformation();
        if (bl && this.m_returnType != null && this.m_returnType instanceof TypeVariable) {
            this.m_returnType = null;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
        }
        this.m_inProgressTypeEnvironment = null;
    }

    public void clearReducedTypeInformation() {
        this.m_bindingEnvironment = null;
        this.m_typeEnvironment = null;
        if (this.m_returnType != null && this.m_returnType instanceof TypeVariable) {
            this.m_returnType = null;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
        }
        this.m_inProgressTypeEnvironment = null;
    }

    public void reduce() {
        if (this.m_typeEnvironment == null) {
            return;
        }
        this.m_bindingEnvironment = new BindingEnvironment();
        this.m_bindingEnvironment.prepareHashMap();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
            this.m_bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        ReductionHelper reductionHelper = new ReductionHelper(this.m_typeEnvironment);
        this.m_body = reductionHelper.reduce(this.m_body, this.m_bindingEnvironment);
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap) {
        this.determineDataDependencies(bindingArray, hashMap, this.getBindingEnvironment());
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, BindingEnvironment bindingEnvironment) {
        try {
            this.m_body.determineDataDependencies(bindingArray, hashMap, null, -1, bindingEnvironment);
        }
        catch (RuntimeException runtimeException) {
            FFDCUtil.log(runtimeException, this);
            String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"error encountering getting data dependancies for " + this.getName()});
            s_logger.logp(Level.SEVERE, s_className, "determineDataDependencies", string2, runtimeException);
            throw runtimeException;
        }
    }

    public void recordLUBConstraintResults(TypeEnvironment typeEnvironment) {
        Iterator iterator = this.m_constraints.iterator();
        while (iterator.hasNext()) {
            LUBConstraint lUBConstraint = (LUBConstraint)iterator.next();
            Type type2 = lUBConstraint.m_t.resolveType(typeEnvironment);
            if (type2 == null) continue;
            this.m_resolvedConstraintTypes.put(lUBConstraint.m_t, type2);
            iterator.remove();
        }
    }

    public Function lookupDerivative(Object object2) {
        return (Function)this.m_derivatives.get(object2);
    }

    public void registerDerivative(Object object2, Function function2) {
        function2.m_derivationKey = object2;
        function2.m_original = this;
        this.m_derivatives.put(object2, function2);
    }

    public boolean isDerivative() {
        return this.m_derivationKey != null;
    }

    public Object getDerivationKey() {
        return this.m_derivationKey;
    }

    public Function getOriginalFunction() {
        return this.m_original;
    }

    public boolean isPolymorphic() {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (this.m_parameters[i].m_type.isFullySpecified()) continue;
            return true;
        }
        return false;
    }

    public void setConstraints(HashSet hashSet) {
        this.m_constraints = hashSet;
    }

    public HashSet getConstraints() {
        return this.m_constraints;
    }

    public boolean resolveConstraints(boolean bl) throws TypeCheckException {
        if (!this.isPolymorphic() && this.m_constraints != null) {
            if (this.m_typeEnvironment.resolveLUBConstraints(this.m_constraints, this.m_typeEnvironment.getModule().m_lubResolver, bl)) {
                this.recordLUBConstraintResults(this.m_typeEnvironment);
                return true;
            }
            return false;
        }
        return true;
    }

    public String getMemoVarName(FcgCodeGenHelper fcgCodeGenHelper) {
        if (this.m_memoizedVarName == null) {
            Type type2 = this.m_returnType.resolveType(this.m_typeEnvironment);
            FcgType fcgType = type2.getFCGType(fcgCodeGenHelper);
            this.m_memoizedVarName = fcgCodeGenHelper.generateNewMemberVariableName();
            this.m_memoizedVarName = this.m_memoizedVarName + "_memo_cached_value";
            fcgCodeGenHelper.allocateThreadLocalVariable(this.m_memoizedVarName, fcgType);
        }
        return fcgCodeGenHelper.generateThreadLocalVarReference(this.m_memoizedVarName);
    }

    public String getMemoCheckVarName(FcgCodeGenHelper fcgCodeGenHelper) {
        if (this.m_memoizedCheckVarName == null) {
            this.m_memoizedCheckVarName = fcgCodeGenHelper.generateNewMemberVariableName();
            this.m_memoizedCheckVarName = this.m_memoizedCheckVarName + "_memo_cached_guard";
            fcgCodeGenHelper.allocateThreadLocalVariable(this.m_memoizedCheckVarName, FcgType.BOOLEAN);
        }
        return fcgCodeGenHelper.generateThreadLocalVarReference(this.m_memoizedCheckVarName);
    }

    public void switchOverTypeEnvironment(TypeEnvironment typeEnvironment) {
        this.m_typeEnvironment = typeEnvironment;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeString(this.m_name);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
        writeObjectFileHelper.writeBoolean(this.m_memoizeResult);
        writeObjectFileHelper.writeBoolean(this.m_impure);
        writeObjectFileHelper.writeBoolean(this.m_inlineHint);
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeType(this.m_returnType);
        writeObjectFileHelper.writeBoolean(this.m_isClassMethod);
        writeObjectFileHelper.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
        if (this.m_defaultValues != null) {
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                writeObjectFileHelper.writeBoolean(this.m_defaultValues[i] != null);
                if (this.m_defaultValues[i] == null) continue;
                writeObjectFileHelper.writeString(this.m_defaultValues[i]);
            }
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_name = readObjectFileHelper.readString();
        this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet();
        this.m_memoizeResult = readObjectFileHelper.readBoolean();
        this.m_impure = readObjectFileHelper.readBoolean();
        this.m_inlineHint = readObjectFileHelper.readBoolean();
        this.m_body = readObjectFileHelper.readInstruction(null);
        this.m_returnType = readObjectFileHelper.readType();
        this.m_isClassMethod = readObjectFileHelper.readBoolean();
        int n2 = readObjectFileHelper.readInt();
        if (n2 > 0) {
            this.m_defaultValues = new String[n2];
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                if (!readObjectFileHelper.readBoolean()) continue;
                this.m_defaultValues[i] = readObjectFileHelper.readString();
            }
        }
    }

    public void instantiateReducedPolymorphicFunctions(Set set2, Set set3, Set set4) {
        if (set4.contains(this)) {
            return;
        }
        set4.add(this);
        set3.add(this);
        this.m_body.instantiateReducedPolymorphicFunctions(set2, this.m_typeEnvironment, this.m_bindingEnvironment, set3, set4);
        set3.remove(this);
    }

    public void removeDerivativeInformation() {
        this.m_derivationKey = null;
        this.m_original = null;
        this.m_derivatives = new HashMap();
    }

    public Function cloneFunction() {
        Function function2 = new Function();
        function2.setName(this.m_name);
        function2.setBody(this.m_body.cloneWithoutTypeInformation());
        function2.setReturnType(this.m_returnType);
        function2.m_parameters = Binding.cloneBindings(this.m_parameters);
        function2.m_memoizeResult = this.m_memoizeResult;
        function2.m_impure = this.m_impure;
        function2.m_inlineHint = this.m_inlineHint;
        function2.m_isClassMethod = this.m_isClassMethod;
        function2.m_defaultValues = this.m_defaultValues;
        return function2;
    }

    public int getStackFrameSize() {
        return this.m_stackFrameSize;
    }

    public void setStackFrameSize(int n2) {
        this.m_stackFrameSize = n2;
    }

    public int getFoundForkCount() {
        return this.m_foundForkCount;
    }

    public void setFoundForkCount(int n2) {
        this.m_foundForkCount = n2;
    }
}

