/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xml.ras.LoggerUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BindingEnvironment
implements Serializable {
    private static final long serialVersionUID = 4270935933497681989L;
    protected HashMap<Object, IBinding> m_variableTypes;
    public BindingEnvironment m_parent;
    private static final Logger s_logger = LoggerUtil.getLogger(BindingEnvironment.class);
    private static final String s_className = BindingEnvironment.class.getName();

    public BindingEnvironment() {
        this(null);
    }

    public BindingEnvironment(BindingEnvironment bindingEnvironment) {
        this.m_parent = bindingEnvironment;
    }

    public int getSize() {
        return this.m_variableTypes != null ? this.m_variableTypes.size() : 0;
    }

    public void prepareHashMap() {
        this.prepareHashMap(64);
    }

    public void prepareHashMap(int n2) {
        this.m_variableTypes = new HashMap(n2);
    }

    public BindingEnvironment(BindingEnvironment bindingEnvironment, IBinding iBinding) {
        this.m_parent = bindingEnvironment;
        this.m_variableTypes = new HashMap(2);
        this.setVariableBinding(iBinding);
    }

    public void setVariableBinding(IBinding iBinding) {
        if (this.m_variableTypes == null) {
            this.m_variableTypes = new HashMap();
        }
        this.m_variableTypes.put(iBinding.getName(), iBinding);
    }

    public IBinding getVariableBinding(Object object2) {
        IBinding iBinding;
        block2: {
            BindingEnvironment bindingEnvironment = this;
            do {
                iBinding = null;
                if (bindingEnvironment.m_variableTypes != null) {
                    iBinding = bindingEnvironment.m_variableTypes.get(object2);
                }
                if (iBinding != null || bindingEnvironment.m_parent == null) break block2;
            } while ((bindingEnvironment = bindingEnvironment.m_parent) != null);
            return null;
        }
        return iBinding;
    }

    public void accumulateAvailableBindings(Set set2) {
        if (this.m_variableTypes != null) {
            set2.addAll(this.m_variableTypes.values());
        }
        if (this.m_parent != null) {
            this.m_parent.accumulateAvailableBindings(set2);
        }
    }

    public String toString() {
        if (null == this.m_variableTypes) {
            return "#" + this.hashCode() + ": []";
        }
        return "#" + this.hashCode() + ": " + new TreeSet<Object>(this.m_variableTypes.keySet()).toString();
    }

    public void dump() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder("<BE.dump> " + this + "\n");
            for (Object object2 : this.m_variableTypes.keySet()) {
                stringBuilder.append("  key=" + object2 + " value='" + this.m_variableTypes.get(object2) + "'\n");
            }
            stringBuilder.append("</BE.dump>");
            s_logger.logp(Level.FINEST, s_className, "dump", stringBuilder.toString());
        }
    }

    public void unregisterBinding(Object object2) {
        this.m_variableTypes.remove(object2);
    }
}

