/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.Serializable;

public final class Binding
implements IBinding,
Serializable {
    private static final long serialVersionUID = -6921253073966497695L;
    protected Object m_name;
    protected Type m_type;
    protected TypeEnvironment m_typeEnvironment;
    protected ISpecialForm m_origin;
    private int m_stackFramePos;
    private int m_useCount;
    private ForkInformation _forkInformation;

    public Binding(Object object2, Type type2, ISpecialForm iSpecialForm) {
        this.m_type = type2;
        this.m_origin = iSpecialForm;
        this.setName(object2);
        this.m_useCount = 0;
        assert (this.initBogusStackframePos());
    }

    public Binding(Object object2, Type type2, TypeEnvironment typeEnvironment) {
        this.m_type = type2;
        this.m_typeEnvironment = typeEnvironment;
        this.setName(object2);
        this.m_useCount = 0;
        assert (this.initBogusStackframePos());
    }

    protected boolean initBogusStackframePos() {
        this.m_stackFramePos = -3333333;
        return true;
    }

    public Binding(Object object2, ISpecialForm iSpecialForm) {
        this(object2, (Type)new TypeVariable(), iSpecialForm);
    }

    public Binding(Object object2) {
        this(object2, (Type)new TypeVariable(), (ISpecialForm)null);
    }

    public Binding(Object object2, Type type2) {
        this(object2, type2, (ISpecialForm)null);
    }

    @Override
    public int compareTo(Object object2) {
        return Binding.compare(this, object2);
    }

    public static int compare(IBinding iBinding, Object object2) {
        if (!(object2 instanceof IBinding)) {
            throw new XylemError("ERR_SYSTEM", "Can't compare a binding to a non-binding!");
        }
        Object object3 = iBinding.getName();
        Object object4 = ((IBinding)object2).getName();
        if (object3 instanceof Integer && object4 instanceof Integer) {
            return ((Integer)object3).compareTo((Integer)object4);
        }
        if (object3 instanceof String && object4 instanceof String) {
            return ((String)object3).compareTo((String)object4);
        }
        if (object3 instanceof Integer) {
            return -1;
        }
        return 1;
    }

    public static Binding[] getBindings(Object[] objectArray) {
        Binding[] bindingArray = new Binding[objectArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(objectArray[i]);
        }
        return bindingArray;
    }

    public static Binding[] getBindings(Type[] typeArray) {
        Binding[] bindingArray = new Binding[typeArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding((Object)("a" + i), typeArray[i]);
        }
        return bindingArray;
    }

    public static Binding[] getBindings2(Type[] typeArray) {
        Binding[] bindingArray = new Binding[typeArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding((Object)ReductionHelper.generateIntermediateIdentifier2(), typeArray[i]);
        }
        return bindingArray;
    }

    public static Binding[] cloneBindings(IBinding[] iBindingArray) {
        Binding[] bindingArray = new Binding[iBindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(iBindingArray[i].getName(), iBindingArray[i].getBindingType());
        }
        return bindingArray;
    }

    public static Object[] getNames(IBinding[] iBindingArray) {
        Object[] objectArray = new Object[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            objectArray[i] = iBindingArray[i].getName();
        }
        return objectArray;
    }

    public static Instruction[] getIdentifiers(IBinding[] iBindingArray) {
        Instruction[] instructionArray = new IdentifierInstruction[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            instructionArray[i] = new IdentifierInstruction(iBindingArray[i].getName());
        }
        return instructionArray;
    }

    public static String generateVariableName(IBinding iBinding, CodeGeneration codeGeneration) {
        Object object2 = iBinding.getName();
        return codeGeneration.getSafeName(object2.toString());
    }

    public static Type resolveBindingType(IBinding iBinding, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
        return type2.resolveType(typeEnvironment);
    }

    @Override
    public Object getName() {
        return this.m_name;
    }

    @Override
    public void setName(Object object2) {
        if (object2 == null) {
            throw new XylemError("ERR_SYSTEM", "You almost certainly don't mean to make a binding with name null.");
        }
        if (!(object2 instanceof String) && !(object2 instanceof Integer)) {
            throw new XylemError("ERR_SYSTEM", "You almost certainly did not mean to make a binding name using a " + object2.getClass());
        }
        if (object2 instanceof Binding) {
            object2 = ((Binding)object2).getName();
        }
        this.m_name = object2;
    }

    @Override
    public Type getBindingType() {
        return this.m_type;
    }

    @Override
    public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    public void setType(Type type2) {
        this.m_type = type2;
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.m_typeEnvironment;
    }

    public void setTypeEnvironment(TypeEnvironment typeEnvironment) {
        this.m_typeEnvironment = typeEnvironment;
    }

    public Object clone() {
        return new Binding(this.m_name, this.m_type, this.m_typeEnvironment);
    }

    public String toString() {
        return "[" + this.hashCode() + "] " + this.m_name + ": " + this.m_type;
    }

    @Override
    public LetInstruction getLet() {
        return null;
    }

    @Override
    public ISpecialForm getOrigin() {
        return this.m_origin;
    }

    public static final Type[] getTypeArrayFromBindingArray(IBinding[] iBindingArray) {
        Type[] typeArray = new Type[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            typeArray[i] = iBindingArray[i].getBindingType();
        }
        return typeArray;
    }

    @Override
    public int getVariableUse() {
        return this.m_useCount;
    }

    @Override
    public void incrementVariableUse() {
        if (this.m_useCount == 0) {
            this.m_useCount = 1;
        } else if (this.m_useCount == 1 || this.m_useCount == 2) {
            this.m_useCount = 3;
        }
    }

    @Override
    public void passingIterator() {
        if (this.m_useCount == 0) {
            this.m_useCount = 2;
        }
    }

    @Override
    public int getStackFramePos() {
        return this.m_stackFramePos;
    }

    @Override
    public void setStackFramePos(int n2) {
        this.m_stackFramePos = n2;
    }

    @Override
    public void setForkInformation(ForkInformation forkInformation) {
        this._forkInformation = forkInformation;
    }

    @Override
    public ForkInformation getForkInformation() {
        return this._forkInformation;
    }
}

