/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class BaseDesugarer
extends Optimizer {
    protected Module m_prog;

    public BaseDesugarer(Module module) {
        this.m_prog = module;
    }

    protected void convertADTs() {
        boolean bl;
        HashSet<AbstractDataType> hashSet = new HashSet<AbstractDataType>();
        do {
            Iterator iterator = new ArrayList(this.m_prog.getAbstractDataTypes()).iterator();
            bl = false;
            while (iterator.hasNext()) {
                AbstractDataType abstractDataType = (AbstractDataType)iterator.next();
                if (hashSet.contains(abstractDataType)) continue;
                for (int i = 0; i < abstractDataType.m_constructors.length; ++i) {
                    AbstractDataType.Constructor constructor = abstractDataType.m_constructors[i];
                    for (int j = 0; j < constructor.m_parameters.length; ++j) {
                        Binding binding = constructor.m_parameters[j];
                        binding.setType(this.convertType(binding.getBindingType()));
                    }
                }
                hashSet.add(abstractDataType);
                bl = true;
            }
        } while (bl);
    }

    protected void convertFunctionSignatures() {
        Iterator<Function> iterator = this.m_prog.m_functions.values().iterator();
        while (iterator.hasNext()) {
            Function function2;
            this.m_currentFunction = function2 = iterator.next();
            FunctionSignature functionSignature = this.m_prog.getFunctionSignature(this.m_currentFunction.getName());
            for (int i = 0; i < function2.m_parameters.length; ++i) {
                Binding binding = function2.m_parameters[i];
                Type type2 = this.convertType(binding.getBindingType());
                binding.setType(type2);
                if (functionSignature == null) continue;
                functionSignature.setParameterType(i, type2);
            }
            function2.setReturnType(this.convertType(function2.getReturnType()));
            if (functionSignature != null) {
                functionSignature.m_returnType = function2.getReturnType();
            }
            this.m_currentFunction = null;
        }
    }

    public void desugar() {
        this.convertADTs();
        this.convertFunctionSignatures();
        this.m_prog.optimize(this);
        this.m_prog.clearTypeInformation(true);
        try {
            this.m_prog.typeCheckReduced();
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
        }
    }

    public static String generateTypeName(Type[] typeArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append("_");
            stringBuffer.append(typeArray[i].toString());
        }
        return stringBuffer.toString().replace('[', 'Z').replace(']', 'Z').replace('.', '_').replace(' ', '_').replace('-', '_').replace('>', '_').replace('(', 'Z').replace(')', 'Z').replace(',', '_').replace('/', '_');
    }

    public static Type generateType(Module module, Type[] typeArray, String string2) {
        String string3 = BaseDesugarer.generateTypeName(typeArray, string2);
        AbstractDataType abstractDataType = (AbstractDataType)module.lookupCompoundType(string3);
        if (abstractDataType == null) {
            Binding[] bindingArray = new Binding[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                bindingArray[i] = new Binding((Object)("x" + i), typeArray[i]);
            }
            AbstractDataType.Constructor constructor = new AbstractDataType.Constructor(string3, bindingArray);
            abstractDataType = new ConstructorDataType(string3, new AbstractDataType.Constructor[]{constructor});
            module.addAbstractDataType(abstractDataType);
        }
        return new NamedType(abstractDataType.getName());
    }

    public static Type generateUnionType(Module module, Type[] typeArray, String string2) {
        String string3 = BaseDesugarer.generateTypeName(typeArray, string2);
        AbstractDataType abstractDataType = (AbstractDataType)module.lookupCompoundType(string3);
        if (abstractDataType != null) {
            return new NamedType(abstractDataType.getName());
        }
        AbstractDataType.Constructor[] constructorArray = new AbstractDataType.Constructor[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Binding binding = new Binding((Object)("x" + i), typeArray[i]);
            constructorArray[i] = new AbstractDataType.Constructor(string3 + "_" + i, new Binding[]{binding});
        }
        abstractDataType = new ConstructorDataType(string3, constructorArray);
        module.addAbstractDataType(abstractDataType);
        return new NamedType(abstractDataType.getName());
    }

    public Type[] convertTypes(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.convertType(typeArray[i]);
        }
        return typeArray2;
    }

    public Type convertType(Type type2) {
        Type type3;
        if (type2 == null) {
            throw new RuntimeException();
        }
        Type type4 = type3 = this.getCurrentFunction() == null ? type2 : type2.resolveType(this.getCurrentFunction().getTypeEnvironment());
        if (type3 instanceof NamedType) {
            Module module;
            AbstractDataTypeLambda abstractDataTypeLambda;
            NamedType namedType = (NamedType)type3;
            if (namedType.getTypeParameters() != null && (abstractDataTypeLambda = ((AbstractTypeStore)(module = this.m_prog)).getGenericADT(namedType.getName())) != null) {
                return abstractDataTypeLambda.applyADT(module, this.convertTypes(namedType.getTypeParameters())).getNamedType();
            }
            return type3;
        }
        if (type3 == null) {
            String string2 = "Couldn't figure out a type in function " + this.m_currentFunction.getName();
            throw new XylemError("ERR_SYSTEM", string2);
        }
        int n2 = type3.getChildTypeCount();
        for (int i = 0; i < n2; ++i) {
            type3.setChildType(i, this.convertType(type3.getChildType(i)));
        }
        return type3;
    }

    @Override
    public Instruction optimize(Instruction instruction2) {
        Instruction instruction3;
        if (!(instruction2 instanceof LetInstruction)) {
            this.optimizeChildren(instruction2);
        }
        if ((instruction3 = this.optimizeStep(instruction2, null, -1)) == null) {
            return instruction2;
        }
        return instruction3;
    }

    @Override
    protected void optimizeChildren(Instruction instruction2) {
        if (instruction2 instanceof LetInstruction) {
            this.optimizeStep(instruction2, null, -1);
        } else {
            int n2 = instruction2.getChildInstructionCount();
            for (int i = 0; i < n2; ++i) {
                Instruction instruction3;
                Instruction instruction4 = instruction2.getChildInstruction(i);
                this.optimizeChildren(instruction4);
                if (instruction4 instanceof LetInstruction || (instruction3 = this.optimizeStep(instruction4, instruction2, i)) == null || instruction3 == instruction4) continue;
                instruction2.setChildInstruction(i, instruction3);
                instruction4.m_bindingEnvironment = null;
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        Instruction instruction4;
        if (!(instruction2 instanceof LetInstruction)) {
            return this.optimizeStep2(instruction2);
        }
        Instruction instruction5 = null;
        LetInstruction letInstruction = (LetInstruction)instruction2;
        while (true) {
            Instruction instruction6 = letInstruction.getValue();
            this.optimizeChildren(instruction6);
            Instruction instruction7 = this.optimizeStep2(instruction6);
            letInstruction.setValue(instruction7);
            instruction4 = letInstruction.getBody();
            if (!(instruction4 instanceof LetInstruction)) break;
            instruction3 = letInstruction;
            n2 = 1;
            letInstruction = (LetInstruction)instruction4;
        }
        this.optimizeChildren(instruction4);
        letInstruction.setBody(this.optimizeStep2(instruction4));
        return instruction5;
    }

    public Instruction optimizeStep2(Instruction instruction2) {
        if (instruction2 instanceof LambdaInstruction) {
            LambdaInstruction lambdaInstruction = (LambdaInstruction)instruction2;
            Binding[] bindingArray = (Binding[])lambdaInstruction.getChildInstructionBindings(0);
            int n2 = bindingArray.length;
            for (int i = 0; i < n2; ++i) {
                bindingArray[i].setType(this.convertType(bindingArray[i].getBindingType()));
            }
        } else {
            int n3 = instruction2.getTypeParameterCount();
            for (int i = 0; i < n3; ++i) {
                if (instruction2.getTypeParameter(i) == null) {
                    System.out.println("Instruction " + instruction2 + " parameter " + i + " (" + instruction2.getChildInstruction(i) + ") is null");
                    throw new RuntimeException();
                }
                instruction2.setTypeParameter(i, this.convertType(instruction2.getTypeParameter(i)));
            }
        }
        return instruction2;
    }

    public static void main(String[] stringArray) {
        Module module = new Module(stringArray[0], null);
        BaseDesugarer baseDesugarer = new BaseDesugarer(module);
        baseDesugarer.desugar();
    }
}

