/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractTypeStore
implements ITypeStore {
    private static final Logger s_logger = LoggerUtil.getLogger(AbstractTypeStore.class);
    private static final String s_className = AbstractTypeStore.class.getName();
    protected HashMap m_classes = new HashMap();
    protected HashMap m_compoundTypes = new HashMap();
    protected HashMap m_constructors = new HashMap();
    protected HashMap m_adts = new HashMap();
    protected HashMap m_typeAliases = new HashMap();
    protected ArrayList m_adtDefinitions = new ArrayList();
    protected HashMap m_genericADTs = new HashMap();
    protected HashMap m_typeLambdas = new HashMap();
    protected String m_name = "";
    Comparator m_comp = new Comparator(){

        public int compare(Object object2, Object object3) {
            return ((AbstractDataType)object2).getName().compareTo(((AbstractDataType)object3).getName());
        }
    };

    @Override
    public final void addAbstractDataType(AbstractDataType abstractDataType) {
        int n2 = Collections.binarySearch(this.m_adtDefinitions, abstractDataType, this.m_comp);
        if (n2 >= 0) {
            this.m_adtDefinitions.set(n2, abstractDataType);
        } else {
            this.m_adtDefinitions.add(-n2 - 1, abstractDataType);
        }
        this.m_adts.put(abstractDataType.getName(), abstractDataType);
        this.m_compoundTypes.put(abstractDataType.getName(), abstractDataType);
        for (int i = 0; i < abstractDataType.m_constructors.length; ++i) {
            this.m_constructors.put(abstractDataType.m_constructors[i].getName(), abstractDataType.m_constructors[i]);
        }
        abstractDataType.setTypeStore(this);
    }

    @Override
    public AbstractDataType.Constructor getConstructor(String string2) {
        return (AbstractDataType.Constructor)this.m_constructors.get(string2);
    }

    @Override
    public CompoundType lookupCompoundType(String string2) {
        return (CompoundType)this.m_compoundTypes.get(string2);
    }

    @Override
    public AbstractDataType getAbstractDataType(String string2) {
        for (AbstractDataType abstractDataType : this.getAbstractDataTypes()) {
            if (!abstractDataType.getName().equals(string2)) continue;
            return abstractDataType;
        }
        return null;
    }

    @Override
    public final Iterator getAbstractDataTypesIterator() {
        return this.m_adtDefinitions.iterator();
    }

    public final List getAbstractDataTypes() {
        return Collections.unmodifiableList(this.m_adtDefinitions);
    }

    @Override
    public int getAbstractDataTypesCount() {
        return this.m_adtDefinitions.size();
    }

    @Override
    public void addTypeAlias(String string2, Type type2) {
        if (this.m_typeAliases.containsKey(string2)) {
            this.m_typeAliases.remove(string2);
        }
        this.m_typeAliases.put(string2, type2);
    }

    @Override
    public Type lookupTypeAlias(String string2) {
        return (Type)this.m_typeAliases.get(string2);
    }

    public Collection getTypeAliases() {
        return this.m_typeAliases.values();
    }

    public Set getTypeAliasNames() {
        return this.m_typeAliases.keySet();
    }

    @Override
    public void addClass(ClassType classType) {
        this.m_classes.put(classType.getName(), classType);
        this.m_compoundTypes.put(classType.getName(), classType);
        classType.setTypeStore(this);
    }

    @Override
    public int getClassesCount() {
        return this.m_classes.size();
    }

    @Override
    public Iterator getClassesIterator() {
        return this.m_classes.values().iterator();
    }

    public static void readTypes(ITypeStore iTypeStore, ReadObjectFileHelper readObjectFileHelper) throws Exception {
        Object object2;
        int n2;
        CompoundType compoundType;
        int n3;
        int n4 = readObjectFileHelper.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "readTypes", "There are " + n4 + " ADTs");
        }
        for (n3 = 0; n3 < n4; ++n3) {
            compoundType = new ConstructorDataType();
            ((ConstructorDataType)compoundType).read(readObjectFileHelper);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "readTypes", "Adding a CDT: " + compoundType);
            }
            iTypeStore.addAbstractDataType((AbstractDataType)compoundType);
        }
        n4 = readObjectFileHelper.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            compoundType = new ClassType();
            ((ClassType)compoundType).read(readObjectFileHelper);
            iTypeStore.addClass((ClassType)compoundType);
        }
        n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = readObjectFileHelper.readString();
            TypeLambda typeLambda = readObjectFileHelper.readTypeLambda();
            iTypeStore.addTypeLambda((String)object2, typeLambda);
        }
        n4 = readObjectFileHelper.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "readTypes", "There are " + n4 + " generic ADTs");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = AbstractDataTypeLambda.read_static(iTypeStore.getName(), readObjectFileHelper);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "readTypes", "Adding a generic ADT: " + object2);
            }
            iTypeStore.addGenericAbstractDataType(((CompoundType)object2).getName(), ((AbstractDataTypeLambda)object2).getTypeParameters(), ((AbstractDataTypeLambda)object2).m_constructors);
        }
    }

    public static void writeTypes(ITypeStore iTypeStore, WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator = iTypeStore.getAbstractDataTypesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getAbstractDataTypesCount());
        while (iterator.hasNext()) {
            object4 = (AbstractDataType)iterator.next();
            ((CompoundType)object4).write(writeObjectFileHelper);
        }
        iterator = iTypeStore.getClassesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getClassesCount());
        while (iterator.hasNext()) {
            object4 = (ClassType)iterator.next();
            ((ClassType)object4).write(writeObjectFileHelper);
        }
        object4 = iTypeStore.getTypeLambdaNamesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getTypeLambdasCount());
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            writeObjectFileHelper.writeString((String)object3);
            object2 = iTypeStore.lookupTypeLambda((String)object3);
            writeObjectFileHelper.writeTypeLambda((TypeLambda)object2);
        }
        object3 = iTypeStore.getGenericAbstractDataTypesIterator();
        writeObjectFileHelper.writeInt(iTypeStore.getGenericAbstractDataTypesCount());
        while (object3.hasNext()) {
            object2 = iTypeStore.getGenericADT((String)object3.next());
            ((AbstractDataTypeLambda)object2).write(writeObjectFileHelper);
        }
    }

    @Override
    public TypeLambda lookupTypeLambda(String string2) {
        return (TypeLambda)this.m_typeLambdas.get(string2);
    }

    @Override
    public void addTypeLambda(String string2, TypeLambda typeLambda) {
        this.m_typeLambdas.put(string2, typeLambda);
    }

    @Override
    public int getTypeLambdasCount() {
        return this.m_typeLambdas.size();
    }

    @Override
    public Iterator getTypeLambdaNamesIterator() {
        return this.m_typeLambdas.keySet().iterator();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String string2) {
        this.m_name = string2;
    }

    public boolean matchesName(String string2) {
        return string2 == null || string2.length() == 0 || string2.equals(this.m_name);
    }

    @Override
    public void addGenericAbstractDataType(String string2, TypeVariable[] typeVariableArray, AbstractDataType.Constructor[] constructorArray) {
        if (this.m_genericADTs.containsKey(string2)) {
            throw new XylemError("ERR_SYSTEM", "Tried to redefine generic abstract data type " + string2 + " in type store " + this.getName());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "Hashcode: " + this.hashCode() + " (" + this.getClass().toString() + ")");
            s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "Adding generic ADT " + string2 + " to type store " + this.getName());
        }
        AbstractDataTypeLambda abstractDataTypeLambda = new AbstractDataTypeLambda(this.getName(), string2, typeVariableArray, constructorArray);
        this.m_genericADTs.put(string2, abstractDataTypeLambda);
        abstractDataTypeLambda.setTypeStore(this);
        for (int i = 0; i < constructorArray.length; ++i) {
            if (this.m_constructors.get(constructorArray[i].getName()) != null && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "addGenericAbstractDataType", "WARNING: variant type " + constructorArray[i].getName() + " shadows a previous definition!");
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "addGenericAbstractDataType", "Adding generic constructor " + constructorArray[i].getName());
            }
            this.m_constructors.put(constructorArray[i].getName(), constructorArray[i]);
        }
    }

    @Override
    public AbstractDataTypeLambda getGenericADT(String string2) {
        return (AbstractDataTypeLambda)this.m_genericADTs.get(string2);
    }

    public AbstractDataType instantiateGenericADT(String string2, Type[] typeArray) {
        AbstractDataTypeLambda abstractDataTypeLambda = this.getGenericADT(string2);
        if (abstractDataTypeLambda == null) {
            throw new RuntimeException("Tried to instantiate a non-existant generic ADT: " + string2);
        }
        return this.instantiateGenericADT(abstractDataTypeLambda, typeArray);
    }

    public AbstractDataType instantiateGenericADT(AbstractDataTypeLambda abstractDataTypeLambda, Type[] typeArray) {
        if (abstractDataTypeLambda == null) {
            throw new XylemError("ERR_SYSTEM", "generic adt was null");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "instantiateGenericADT", "Instantiating generic ADT " + abstractDataTypeLambda.getName() + " in type store " + this.getName());
        }
        AbstractDataType abstractDataType = abstractDataTypeLambda.applyADT(this, typeArray);
        this.addAbstractDataType(abstractDataType);
        return abstractDataType;
    }

    @Override
    public Iterator getGenericAbstractDataTypesIterator() {
        return this.m_genericADTs.keySet().iterator();
    }

    @Override
    public int getGenericAbstractDataTypesCount() {
        return this.m_genericADTs.size();
    }

    protected void clearADTs() {
        this.m_adts.clear();
        this.m_adtDefinitions.clear();
        this.m_constructors.clear();
    }
}

