/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem;

import java.io.PrintWriter;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class PrettyPrinter {
    protected HashMap m_prefixes = new HashMap();
    protected PrintWriter m_pw;
    protected int m_indent = 0;
    protected int m_lineMax = 100;
    protected int m_pos = 0;
    protected int m_uniquePrefixCount = 0;
    public boolean m_suppressNewlines = false;

    public PrettyPrinter(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    public String generateUniquePrefix() {
        String string2;
        while (this.m_prefixes.containsKey(string2 = "ns" + ++this.m_uniquePrefixCount)) {
        }
        return string2;
    }

    public void printQName(QName qName) {
        String string2 = qName.getNamespaceURI();
        if (string2 == null || string2.length() == 0) {
            this.printToken(qName.getLocalPart());
            return;
        }
        String string3 = qName.getPrefix();
        if (string3 == null || string3.length() == 0) {
            string3 = this.generateUniquePrefix();
        }
        if (!this.m_prefixes.containsKey(string3)) {
            this.m_prefixes.put(string3, string2);
        } else if (!this.m_prefixes.get(string3).equals(string2)) {
            string3 = this.generateUniquePrefix();
            this.m_prefixes.put(string3, string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(':');
        stringBuffer.append(qName.getLocalPart());
        this.printToken(stringBuffer.toString());
    }

    public void printToken(String string2) {
        int n2 = string2.length() + 1;
        if (n2 + this.m_pos > this.m_lineMax) {
            this.newline();
        }
        this.m_pw.print(string2);
        this.m_pw.print(' ');
        this.m_pos += n2;
    }

    public void indent() {
        ++this.m_indent;
    }

    public void outdent() {
        --this.m_indent;
    }

    public void newline() {
        if (this.m_suppressNewlines || this.m_pos == this.m_indent * 2) {
            return;
        }
        this.m_pw.println();
        this.m_pos = 0;
        for (int i = 0; i < this.m_indent; ++i) {
            this.m_pw.print("  ");
            this.m_pos += 2;
        }
    }

    public String generatePrefixes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : this.m_prefixes.keySet()) {
            if (k.equals("xs") || k.equals("xdt")) continue;
            Object v = this.m_prefixes.get(k);
            stringBuffer.append("namespace ");
            stringBuffer.append(k);
            stringBuffer.append(" = \"");
            stringBuffer.append(v);
            stringBuffer.append('\"');
            if (!this.m_suppressNewlines) {
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

