/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.analysis;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.analysis.Annotation;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.EmptyXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.SequenceXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XTypeStore;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotator;
import com.ibm.xltxe.rnm1.xylem.annot.IConverter;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import java.util.Collections;
import java.util.List;

public class Analyzer
implements IAnnotator {
    protected XTypeStore m_typeStore;
    private static final NamedType s_xdtType = new NamedType("XPath20Datum");
    private static final StreamType s_xdtStream = new StreamType(s_xdtType);

    public Analyzer(XTypeStore xTypeStore) {
        this.m_typeStore = xTypeStore;
    }

    @Override
    public IAnnotation analyzeExpression(AnnotationEnvironment annotationEnvironment, Instruction instruction2, Object object2) {
        BindingEnvironment bindingEnvironment;
        TypeEnvironment typeEnvironment = annotationEnvironment.getTypeEnvironment();
        Type type2 = instruction2.getType(typeEnvironment, bindingEnvironment = annotationEnvironment.getBindingEnvironment()).resolveType(typeEnvironment);
        if (type2.equals(s_xdtStream)) {
            if (instruction2 instanceof StreamInstruction) {
                StreamInstruction streamInstruction = (StreamInstruction)instruction2;
                XType xType = EmptyXType.s_emptyXType;
                for (int i = 0; i < streamInstruction.getChildInstructionCount(); ++i) {
                    Instruction instruction3 = streamInstruction.getChildInstruction(i);
                    Annotation annotation = (Annotation)annotationEnvironment.get(instruction3);
                    if (annotation == null || annotation.getXType() == null) {
                        return null;
                    }
                    xType = xType instanceof EmptyXType ? annotation.getXType() : new SequenceXType(xType, annotation.getXType());
                }
                return new Annotation(xType);
            }
            if (instruction2 instanceof ApplyInstruction) {
                ApplyInstruction applyInstruction = (ApplyInstruction)instruction2;
            } else if (instruction2 instanceof IdentifierInstruction) {
                IAnnotation iAnnotation = annotationEnvironment.get(instruction2);
                return iAnnotation;
            }
        } else if (type2.equals(s_xdtType) && instruction2 instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction2;
            XPathDataTypeLiteralInstruction xPathDataTypeLiteralInstruction = (XPathDataTypeLiteralInstruction)NavigationUtilities.resolveReducedIdentifier(constructorInstantiationInstruction.m_parameters[constructorInstantiationInstruction.m_parameters.length - 1], bindingEnvironment);
            return new Annotation(xPathDataTypeLiteralInstruction.getXType());
        }
        return null;
    }

    @Override
    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, List list) {
        return null;
    }

    @Override
    public IAnnotation interceptFunctionCall(AnnotationEnvironment annotationEnvironment, FunctionCallInstruction functionCallInstruction) {
        FunctionDeclaration functionDeclaration;
        BindingEnvironment bindingEnvironment;
        TypeEnvironment typeEnvironment = annotationEnvironment.getTypeEnvironment();
        Type type2 = functionCallInstruction.getType(typeEnvironment, bindingEnvironment = annotationEnvironment.getBindingEnvironment()).resolveType(typeEnvironment);
        if (type2.equals(s_xdtStream) && (functionDeclaration = this.m_typeStore.lookupFunction(functionCallInstruction.getFunction())) != null) {
            return new Annotation(functionDeclaration.getReturnType());
        }
        return null;
    }

    @Override
    public void preAnalysis(Program program) {
    }

    @Override
    public IConverter getConverter() {
        return new IConverter(){

            @Override
            public Instruction convert(Instruction instruction2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
                return instruction2;
            }

            @Override
            public List getBindingList(Object object2, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
                return null;
            }

            public List getIdentifierList(Object object2, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
                return Collections.singletonList(new IdentifierInstruction(object2));
            }

            @Override
            public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            }

            @Override
            public void addConversionSupport(Module module) {
            }

            @Override
            public void preConversion(Program program) {
            }

            @Override
            public Type getValueType(IAnnotation iAnnotation, ConversionEngine conversionEngine) {
                return null;
            }

            @Override
            public void insertLoopBinding(IAnnotation iAnnotation, IAnnotation iAnnotation2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            }

            @Override
            public void insertValueDecomposition(Object object2, IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            }
        };
    }

    @Override
    public boolean isFunctionReturnNotAnnotated(FunctionCallSpec functionCallSpec) {
        return false;
    }
}

