/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.partialeval;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.ArithmeticInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;

public class ArithmeticEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction2, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        ArithmeticInstruction arithmeticInstruction = (ArithmeticInstruction)instruction2;
        Instruction instruction3 = arithmeticInstruction.getOperand1();
        Instruction instruction4 = arithmeticInstruction.getOperand2();
        Type type2 = partialInformationCollector.resolveType(instruction3);
        Type type3 = partialInformationCollector.resolveType(instruction4);
        if (!(type2 instanceof INumericalType)) {
            type2 = DoubleType.s_doubleType;
            instruction3 = letChainManager.insertBody2(new CoerceInstruction(instruction3, type2), letInstruction);
            arithmeticInstruction.setChildInstruction(0, instruction3);
        }
        if (!(type3 instanceof INumericalType)) {
            type3 = DoubleType.s_doubleType;
            instruction4 = letChainManager.insertBody2(new CoerceInstruction(instruction4, type3), letInstruction);
            arithmeticInstruction.setChildInstruction(1, instruction4);
        }
        if (IntType.s_intType.equals(type2) && IntType.s_intType.equals(type3) || DoubleType.s_doubleType.equals(type2) && DoubleType.s_doubleType.equals(type3)) {
            int n2 = 0;
            switch (arithmeticInstruction.getOperation()) {
                case 4: {
                    n2 = 0;
                    break;
                }
                case 5: {
                    n2 = 1;
                    break;
                }
                case 30: {
                    n2 = 2;
                    break;
                }
                case 31: {
                    n2 = 3;
                    break;
                }
                case 33: {
                    n2 = 4;
                }
            }
            return new PartialEvaluationResult((Instruction)new PrimitiveArithmeticInstruction(instruction3, instruction4, n2), true);
        }
        partialInformationCollector.partiallyEvaluate(instruction3, letChainManager);
        partialInformationCollector.partiallyEvaluate(instruction4, letChainManager);
        return PartialEvaluationResult.s_emptyResult;
    }
}

