/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.nodeconstructors.CreateTextInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.AtomizationToStringInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ConstructXDMItemAtomInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ConstructXDMItemNodeInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ContextItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.GetStringValueXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.ItemKind;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.XDMSequenceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import java.util.LinkedList;
import java.util.logging.Logger;

public class XDMSequenceOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(XDMSequenceOptimizer.class);
    private static final String s_className = XDMSequenceOptimizer.class.getName();
    int nestCount = 0;
    public boolean LOG = HiddenOptions.optionValueIs("CursorAnalyzerLog", "on");
    int paramPushDepth = 0;
    boolean isParamPush = false;
    static final String INDENTSTRING = "  ";
    BindingEnvironment lambdaFreeBindings = null;

    private final boolean log(String string2) {
        System.out.print(string2);
        return true;
    }

    private final boolean logln(String string2) {
        System.out.println(string2);
        return true;
    }

    private final boolean logIndent() {
        if (this.LOG) {
            int n2;
            for (n2 = 0; n2 < this.nestCount; ++n2) {
                this.log(INDENTSTRING);
            }
            if (this.isParamPush) {
                for (n2 = 0; n2 < this.paramPushDepth; ++n2) {
                    this.log("*");
                }
                this.log("->");
                this.isParamPush = false;
            }
        }
        return true;
    }

    @Override
    public Instruction optimize(Instruction instruction2) {
        return super.optimize(instruction2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimizeFunction(Function function2) {
        BindingEnvironment bindingEnvironment = this.lambdaFreeBindings;
        try {
            this.lambdaFreeBindings = null;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("function declaration: " + function2.getName() + "@" + function2.getReturnType());
            }
            ++this.nestCount;
            super.optimizeFunction(function2);
            --this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("leaving optimizeFunction: " + function2.getName() + " - stackFrameSize: " + function2.getStackFrameSize() + " (bindingsEnvSize: " + function2.getBindingEnvironment().getSize());
            }
        }
        finally {
            this.lambdaFreeBindings = bindingEnvironment;
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (this.LOG) {
            this.logIndent();
        }
        instruction2 = instruction2 instanceof FunctionCallInstruction ? this.processFunctionCallInstruction(instruction2) : (instruction2 instanceof ModuleFunctionCallInstruction ? this.processModuleFunctionCallInstruction(instruction2) : (instruction2 instanceof IdentifierInstruction ? this.processIdentifierInstruction(instruction2) : (instruction2 instanceof IBinding ? this.processIBinding(instruction2) : (instruction2 instanceof MatchXDMItemInstruction ? this.processMatchXDMItemInstruction(instruction2) : (instruction2 instanceof MatchInstruction ? this.processMatchInstruction(instruction2) : (instruction2 instanceof ConstructXDMItemNodeInstruction ? instruction2.getChildInstruction(0) : (instruction2 instanceof AtomizationToStringInstruction ? this.processAtomizationToStringInstruction(instruction2) : this.processOtherInstruction(instruction2))))))));
        return instruction2 != null ? super.optimizeStep(instruction2) : instruction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instruction processOtherInstruction(Instruction instruction2) {
        GetAxisCursorInstruction getAxisCursorInstruction;
        if (this.LOG) {
            this.log(instruction2.getClass().getSimpleName());
        }
        if (this.LOG) {
            this.logType(instruction2);
        }
        if (instruction2 instanceof GetTypedAxisCursorInstruction) {
            if (this.LOG) {
                this.log(" - ");
            }
            getAxisCursorInstruction = (GetTypedAxisCursorInstruction)instruction2;
            if (this.LOG) {
                this.log(getAxisCursorInstruction.toString());
            }
        } else if (instruction2 instanceof GetAxisCursorInstruction) {
            if (this.LOG) {
                this.log(" - ");
            }
            getAxisCursorInstruction = (GetAxisCursorInstruction)instruction2;
            if (this.LOG) {
                this.log(getAxisCursorInstruction.toString());
            }
        }
        if (instruction2.getChildInstructionCount() == 0 && this.LOG) {
            this.log(": " + instruction2.toString().trim());
        }
        this.getAndLogBindingEnvironment(instruction2);
        if (this.LOG) {
            this.logln("");
        }
        if (instruction2 instanceof ISpecialForm) {
            this.processSpecialForms(instruction2);
            return null;
        }
        ++this.paramPushDepth;
        ++this.nestCount;
        try {
            boolean bl = false;
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                this.isParamPush = true;
                Instruction instruction3 = instruction2.getChildInstruction(i);
                this.optimize(instruction3);
            }
        }
        finally {
            --this.nestCount;
            --this.paramPushDepth;
        }
        return null;
    }

    private final boolean logType(Instruction instruction2) {
        if (this.LOG) {
            this.log("@");
            Type type2 = this.extractType(instruction2);
            if (null != type2) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private String getTypeString(Instruction instruction2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@");
        Type type2 = this.extractType(instruction2);
        if (null != type2) {
            stringBuffer.append(type2.toString());
        } else {
            stringBuffer.append("??");
        }
        return stringBuffer.toString();
    }

    private Type extractType(Instruction instruction2) {
        Type type2 = instruction2.getCachedType();
        if (type2 == null) {
            BindingEnvironment bindingEnvironment = instruction2.getBindingEnvironment();
            if (bindingEnvironment == null) {
                bindingEnvironment = this.m_currentFunction.getBindingEnvironment();
            }
            if (bindingEnvironment == null) {
                return null;
            }
            assert (bindingEnvironment != null);
            TypeEnvironment typeEnvironment = this.m_currentFunction.getTypeEnvironment();
            assert (typeEnvironment != null);
            type2 = instruction2.getType(typeEnvironment, bindingEnvironment);
        }
        return type2;
    }

    private Instruction processMatchXDMItemInstruction(Instruction instruction2) {
        MatchXDMItemInstruction matchXDMItemInstruction = (MatchXDMItemInstruction)instruction2;
        if (this.LOG) {
            this.logln(instruction2.getClass().getSimpleName());
        }
        Instruction instruction3 = matchXDMItemInstruction.getToMatch();
        ++this.nestCount;
        if (this.LOG) {
            this.logIndent();
        }
        if (this.LOG) {
            this.logln("toMatch: ");
        }
        this.optimize(instruction3);
        --this.nestCount;
        ++this.nestCount;
        MatchXDMItemInstruction.Match[] matchArray = matchXDMItemInstruction.getMatches();
        for (int i = 0; i < matchArray.length; ++i) {
            MatchXDMItemInstruction.DeconstructionMatch deconstructionMatch = (MatchXDMItemInstruction.DeconstructionMatch)matchArray[i];
            Binding[] bindingArray = deconstructionMatch.getBindings();
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.log("case ");
            }
            if (this.LOG) {
                this.log(deconstructionMatch.getItemKind().getName());
            }
            for (int j = 0; j < bindingArray.length; ++j) {
                Binding binding = bindingArray[j];
                if (!this.LOG) continue;
                this.log(" binding: " + binding.getName() + "@" + binding.getBindingType());
            }
            if (this.LOG) {
                this.logln(":");
            }
            ++this.nestCount;
            Instruction instruction4 = deconstructionMatch.getHandler();
            this.optimize(instruction4);
            --this.nestCount;
        }
        Instruction instruction5 = matchXDMItemInstruction.getDefault();
        if (null != instruction5) {
            ++this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("otherwise:");
            }
            this.optimize(instruction5);
            --this.nestCount;
        }
        --this.nestCount;
        return null;
    }

    private Instruction processMatchInstruction(Instruction instruction2) {
        MatchInstruction matchInstruction = (MatchInstruction)instruction2;
        if (this.LOG) {
            this.logln(instruction2.getClass().getSimpleName());
        }
        Instruction instruction3 = matchInstruction.getToMatch();
        ++this.nestCount;
        if (this.LOG) {
            this.logIndent();
        }
        if (this.LOG) {
            this.logln("toMatch: ");
        }
        this.optimize(instruction3);
        --this.nestCount;
        ++this.nestCount;
        MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
        for (int i = 0; i < matchArray.length; ++i) {
            Object object2;
            MatchInstruction.Match match = matchArray[i];
            if (match instanceof MatchInstruction.DeconstructionMatch) {
                object2 = (MatchInstruction.DeconstructionMatch)match;
                Binding[] bindingArray = ((MatchInstruction.DeconstructionMatch)object2).getBindings();
                if (this.LOG) {
                    this.logIndent();
                }
                if (this.LOG) {
                    this.log("case ");
                }
                if (this.LOG) {
                    this.log(((MatchInstruction.DeconstructionMatch)object2).m_constructorName);
                }
                for (int j = 0; j < bindingArray.length; ++j) {
                    Binding binding = bindingArray[j];
                    if (!this.LOG) continue;
                    this.log(" binding: " + binding.getName() + "@" + binding.getBindingType());
                }
                if (this.LOG) {
                    this.logln(":");
                }
            } else if (match instanceof MatchInstruction.LiteralMatch) {
                object2 = (MatchInstruction.LiteralMatch)match;
                if (this.LOG) {
                    this.logIndent();
                }
                if (this.LOG) {
                    this.log("case ");
                }
                if (this.LOG) {
                    this.log(((MatchInstruction.LiteralMatch)object2).getLiteral().toString());
                }
                if (this.LOG) {
                    this.logln(":");
                }
            }
            ++this.nestCount;
            object2 = match.getHandler();
            this.optimize((Instruction)object2);
            --this.nestCount;
        }
        Instruction instruction4 = matchInstruction.getDefault();
        if (null != instruction4) {
            ++this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("otherwise:");
            }
            this.optimize(instruction4);
            --this.nestCount;
        }
        --this.nestCount;
        return null;
    }

    private Instruction processIBinding(Instruction instruction2) {
        IBinding iBinding = (IBinding)((Object)instruction2);
        LetInstruction letInstruction = iBinding.getLet();
        if (letInstruction != null) {
            Type type2;
            Instruction instruction3;
            IBinding iBinding2;
            Instruction instruction4;
            int n2;
            Instruction instruction5 = letInstruction.getValue();
            if (instruction5 instanceof ContextItemInstruction) {
                IBinding iBinding3;
                ContextItemInstruction contextItemInstruction = (ContextItemInstruction)instruction5;
                Instruction instruction6 = contextItemInstruction.getChildInstruction(0);
                if (instruction6 instanceof IdentifierInstruction && null != (iBinding3 = this.getBindingFromIdentifier((IdentifierInstruction)instruction6))) {
                    LetInstruction letInstruction2;
                    Type type3;
                    IBinding iBinding4;
                    Instruction instruction7;
                    XDMSequenceInstruction xDMSequenceInstruction;
                    int n3;
                    Instruction instruction8;
                    LetInstruction letInstruction3;
                    Type type4 = this.getBindingType(iBinding3, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                    if (type4 instanceof XDMItemType) {
                        letInstruction.setValue(instruction6);
                    } else if (type4 instanceof XDMSequenceType && (letInstruction3 = iBinding3.getLet()) != null && (instruction8 = letInstruction3.getValue()) instanceof XDMSequenceInstruction && (n3 = (xDMSequenceInstruction = (XDMSequenceInstruction)instruction8).getChildInstructionCount()) == 1 && (instruction7 = xDMSequenceInstruction.getChildInstruction(0)) instanceof IdentifierInstruction && (iBinding4 = this.getBindingFromIdentifier((IdentifierInstruction)instruction7)) != null && (type3 = this.getBindingType(iBinding4, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment())) instanceof XDMItemType && (letInstruction2 = iBinding4.getLet()) != null) {
                        Instruction instruction9 = letInstruction2.getValue();
                        if (iBinding instanceof LetInstruction && iBinding4 instanceof LetInstruction) {
                            Instruction instruction10 = instruction9;
                            LetInstruction letInstruction4 = (LetInstruction)iBinding;
                            letInstruction4.setValue(instruction10.cloneReduced());
                        }
                    }
                }
            } else if (instruction5 instanceof XDMSequenceInstruction && (n2 = (instruction4 = instruction5).getChildInstructionCount()) == 1 && null != (iBinding2 = this.getBindingFromIdentifier((IdentifierInstruction)(instruction3 = instruction4.getChildInstruction(0)))) && (type2 = this.getBindingType(iBinding2, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment())) instanceof XDMSequenceType) {
                letInstruction.setValue(instruction3);
            }
        }
        if (this.LOG) {
            this.log(instruction2.getClass().getSimpleName() + ": " + iBinding.getName());
        }
        if (this.LOG) {
            this.logIBindingType(iBinding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
        }
        return instruction2;
    }

    private BindingEnvironment getAndLogBindingEnvironment(Instruction instruction2) {
        BindingEnvironment bindingEnvironment = instruction2.getBindingEnvironment();
        if (bindingEnvironment != null) {
            if (this.LOG) {
                this.log("  bindingsEnvSize: " + bindingEnvironment.getSize());
            }
            if (this.LOG) {
                this.log("  bindingsEnv: " + bindingEnvironment.toString());
            }
        } else {
            if (this.LOG) {
                this.log("  null binding environment");
            }
            if (bindingEnvironment == null) {
                bindingEnvironment = instruction2.evaluateBindingEnvironment(this.m_currentFunction);
            }
            if (this.LOG && bindingEnvironment != null) {
                this.log("  using current function binding env");
            }
        }
        return bindingEnvironment;
    }

    private void processSpecialForms(Instruction instruction2) {
        ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction2);
        ++this.nestCount;
        boolean bl = false;
        for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
            if (iSpecialForm.isChildInstructionBody(i)) {
                this.processISpecialFormMaybe(instruction2);
            }
            Instruction instruction3 = instruction2.getChildInstruction(i);
            this.optimize(instruction3);
        }
        --this.nestCount;
    }

    private Instruction processIdentifierInstruction(Instruction instruction2) {
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
        IBinding iBinding = this.getBindingFromIdentifier(identifierInstruction);
        if (iBinding != null) {
            int n2 = iBinding.getVariableUse();
            iBinding.incrementVariableUse();
            if (this.LOG) {
                this.log(instruction2.getClass().getSimpleName() + ": " + iBinding.getName());
            }
            if (this.LOG) {
                this.logIBindingType(iBinding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
            }
            if (this.LOG) {
                this.logln(" - VariableUsage: " + n2 + " -> " + iBinding.getVariableUse());
            }
        } else if (this.LOG) {
            this.logln("optimizeStep (Can't find IBinding): " + instruction2.getClass().getSimpleName() + ": " + identifierInstruction.getVariable());
        }
        return instruction2;
    }

    private IBinding getBindingFromIdentifier(IdentifierInstruction identifierInstruction) {
        Object object2;
        Function function2 = this.getCurrentFunction();
        IBinding iBinding = null;
        if (null != this.lambdaFreeBindings) {
            object2 = identifierInstruction.getVariable();
            iBinding = this.lambdaFreeBindings.getVariableBinding(object2);
        }
        if (iBinding == null && (iBinding = identifierInstruction.getBinding()) == null) {
            object2 = function2.getBindingEnvironment();
            if (object2 == null) {
                return null;
            }
            assert (object2 != null);
            Object object3 = identifierInstruction.getVariable();
            iBinding = ((BindingEnvironment)object2).getVariableBinding(object3);
        }
        return iBinding;
    }

    private Type getBindingType(IBinding iBinding, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = iBinding.getBindingType();
        if (type2 == null) {
            type2 = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
        }
        return type2;
    }

    private final boolean logIBindingType(IBinding iBinding, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        this.log("@");
        Type type2 = iBinding.getBindingType();
        if (type2 != null) {
            this.log(type2.toString());
        } else {
            type2 = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
            if (type2 != null) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private Instruction processModuleFunctionCallInstruction(Instruction instruction2) {
        String string2;
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction2;
        Function function2 = this.getCurrentFunction();
        TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
        Module module = typeEnvironment.getModule().getProgram().getModule(moduleFunctionCallInstruction.getModule());
        Function function3 = this.resolveFunction(typeEnvironment, moduleFunctionCallInstruction);
        if (this.LOG) {
            this.logln(instruction2.getClass().getSimpleName() + this.getTypeString(instruction2) + ": " + module.getName() + ":" + function3.getName());
        }
        Instruction[] instructionArray = moduleFunctionCallInstruction.getParameters();
        ++this.paramPushDepth;
        this.processParams(instructionArray);
        --this.paramPushDepth;
        Instruction instruction3 = this.optimizeFunctionCallForSequenceParams(moduleFunctionCallInstruction, function2, function3, module, instructionArray);
        if (instruction3 != instruction2) {
            moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction3;
            instructionArray = moduleFunctionCallInstruction.getParameters();
            function3 = this.resolveFunction(typeEnvironment, moduleFunctionCallInstruction);
            instruction2 = instruction3;
            instruction2.typeCheckReduced(typeEnvironment, function2.getBindingEnvironment(), new LinkedList());
        }
        if ((instruction3 = this.optimizeFunctionCallForSepParams(moduleFunctionCallInstruction, function2, function3, typeEnvironment.getModule(), instructionArray)) != instruction2) {
            moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction3;
            function3 = this.resolveFunction(typeEnvironment, moduleFunctionCallInstruction);
            instruction2 = instruction3;
            instruction2.typeCheckReduced(typeEnvironment, function2.getBindingEnvironment(), new LinkedList());
        }
        if (instruction2 instanceof FunctionCallInstruction && "create-string-item".equals(string2 = (moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction2).getFunction())) {
            instruction2 = this.processCreateStringItemCall(moduleFunctionCallInstruction);
        }
        return instruction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instruction processFunctionCallInstruction(Instruction instruction2) {
        int n2 = this.paramPushDepth;
        this.paramPushDepth = 0;
        try {
            Function function2 = this.getCurrentFunction();
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
            if (typeEnvironment == null) {
                Instruction instruction3 = instruction2;
                return instruction3;
            }
            Function function3 = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
            if (this.LOG) {
                this.logln(instruction2.getClass().getSimpleName() + this.getTypeString(instruction2) + ": " + function3.getName());
            }
            Instruction[] instructionArray = functionCallInstruction.getParameters();
            ++this.paramPushDepth;
            this.processParams(instructionArray);
            --this.paramPushDepth;
            Instruction instruction4 = this.optimizeFunctionCallForSequenceParams(functionCallInstruction, function2, function3, typeEnvironment.getModule(), instructionArray);
            if (instruction4 != instruction2) {
                functionCallInstruction = (FunctionCallInstruction)instruction4;
                instructionArray = functionCallInstruction.getParameters();
                function3 = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
                instruction2 = instruction4;
                instruction2.typeCheckReduced(typeEnvironment, function2.getBindingEnvironment(), new LinkedList());
            }
            if ((instruction4 = this.optimizeFunctionCallForSepParams(functionCallInstruction, function2, function3, typeEnvironment.getModule(), instructionArray)) != instruction2) {
                functionCallInstruction = (FunctionCallInstruction)instruction4;
                function3 = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
                instruction2 = instruction4;
                instruction2.typeCheckReduced(typeEnvironment, function2.getBindingEnvironment(), new LinkedList());
            }
            if (instruction2 instanceof FunctionCallInstruction) {
                functionCallInstruction = (FunctionCallInstruction)instruction2;
                String string2 = functionCallInstruction.getFunction();
                if (string2.equals("xslt2$create-string-item")) {
                    instruction2 = this.processCreateStringItemCall(functionCallInstruction);
                } else if (string2.equals("xslt2$fn:string-1")) {
                    instruction2 = this.processFnString1Call(functionCallInstruction);
                } else if (string2.equals("xslt2$fn:string-0")) {
                    instruction2 = this.processFnString02Call(functionCallInstruction);
                } else if (string2.equals("xslt2$fn:string-2")) {
                    instruction2 = this.processFnString02Call(functionCallInstruction);
                } else if (string2.equals("xslt2$value-of-bc-item")) {
                    instruction2 = this.processValueOfBCItemCall(functionCallInstruction);
                } else if (string2.equals("xslt2$context-item-expression")) {
                    instruction2 = this.processContextItemExpressionCall(functionCallInstruction);
                } else if (string2.equals("xslt2$do-check-undefined-context")) {
                    instruction2 = this.processDoCheckUndefinedContextCall(functionCallInstruction);
                } else if (string2.equals("xslt2$do-check-final-step-result-item-result")) {
                    instruction2 = this.processDoCheckFinalStepResultItemResultCall(functionCallInstruction);
                }
            }
        }
        finally {
            this.paramPushDepth = n2;
        }
        return instruction2;
    }

    private Instruction processAtomizationToStringInstruction(Instruction instruction2) {
        FunctionCallInstruction functionCallInstruction;
        FunctionCallInstruction functionCallInstruction2;
        Instruction instruction3 = this.findValueSource(instruction2.getChildInstruction(0));
        if (instruction3 instanceof FunctionCallInstruction && (functionCallInstruction2 = (FunctionCallInstruction)instruction3).getFunction().equals("xslt2$value-of-bc-item") && (instruction3 = this.findValueSource(functionCallInstruction2.getChildInstruction(0))) instanceof FunctionCallInstruction && (functionCallInstruction = (FunctionCallInstruction)instruction3).getFunction().equals("xslt2$fn:string-1")) {
            instruction2.setChildInstruction(0, functionCallInstruction.getChildInstruction(0));
        }
        return instruction2;
    }

    private Instruction processContextItemExpressionCall(Instruction instruction2) {
        PrimitiveArithmeticInstruction primitiveArithmeticInstruction;
        Instruction instruction3 = this.findValueSource(instruction2.getChildInstruction(1));
        if (instruction3 instanceof PrimitiveArithmeticInstruction && (primitiveArithmeticInstruction = (PrimitiveArithmeticInstruction)instruction3).getOperation() == 0) {
            boolean bl = true;
            for (int i = 0; i < 2; ++i) {
                Instruction instruction4;
                Instruction instruction5 = primitiveArithmeticInstruction.getChildInstruction(i);
                Instruction instruction6 = this.findValueSource(instruction5);
                if (instruction6 instanceof LiteralInstruction) {
                    instruction4 = (LiteralInstruction)instruction6;
                    if (((LiteralInstruction)instruction4).getType() == IntType.s_intType && (Integer)((LiteralInstruction)instruction4).getValue() >= 0) continue;
                    bl = false;
                    continue;
                }
                if (instruction6 instanceof IteratorInstruction && instruction5 instanceof IdentifierInstruction) {
                    Object object2;
                    instruction4 = (IteratorInstruction)instruction6;
                    Object object3 = ((IteratorInstruction)instruction4).getIndexVar();
                    if (object3.equals(object2 = ((IdentifierInstruction)instruction5).getVariable())) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (bl) {
                instruction2 = instruction2.getChildInstruction(0);
            }
        }
        return instruction2;
    }

    private Instruction processDoCheckUndefinedContextCall(Instruction instruction2) {
        PrimitiveArithmeticInstruction primitiveArithmeticInstruction;
        Instruction instruction3 = instruction2.getChildInstruction(0);
        Instruction instruction4 = this.findValueSource(instruction3);
        if (instruction3 instanceof IdentifierInstruction && ((IdentifierInstruction)instruction3).getVariable().equals("__contextposition__") && instruction4 == null) {
            instruction2 = LiteralInstruction.booleanTrueLiteral();
        } else if (instruction4 instanceof PrimitiveArithmeticInstruction && (primitiveArithmeticInstruction = (PrimitiveArithmeticInstruction)instruction4).getOperation() == 0) {
            boolean bl = true;
            for (int i = 0; i < 2; ++i) {
                Instruction instruction5;
                Instruction instruction6 = primitiveArithmeticInstruction.getChildInstruction(i);
                Instruction instruction7 = this.findValueSource(instruction6);
                if (instruction7 instanceof LiteralInstruction) {
                    instruction5 = (LiteralInstruction)instruction7;
                    if (((LiteralInstruction)instruction5).getType() == IntType.s_intType && (Integer)((LiteralInstruction)instruction5).getValue() >= 0) continue;
                    bl = false;
                    continue;
                }
                if (instruction7 instanceof IteratorInstruction && instruction6 instanceof IdentifierInstruction) {
                    Object object2;
                    instruction5 = (IteratorInstruction)instruction7;
                    Object object3 = ((IteratorInstruction)instruction5).getIndexVar();
                    if (object3.equals(object2 = ((IdentifierInstruction)instruction6).getVariable())) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (bl) {
                instruction2 = LiteralInstruction.booleanTrueLiteral();
            }
        }
        return instruction2;
    }

    private Instruction processValueOfBCItemCall(Instruction instruction2) {
        ConstructXDMItemAtomInstruction constructXDMItemAtomInstruction;
        Instruction instruction3 = this.findValueSource(instruction2.getChildInstruction(0));
        if (instruction3 instanceof ConstructXDMItemAtomInstruction && (constructXDMItemAtomInstruction = (ConstructXDMItemAtomInstruction)instruction3).getItemKind() == ItemKind.String) {
            instruction2 = new CreateTextInstruction(constructXDMItemAtomInstruction.getChildInstruction(0));
        }
        return instruction2;
    }

    private Instruction processFnString02Call(Instruction instruction2) {
        PrimitiveArithmeticInstruction primitiveArithmeticInstruction;
        Instruction instruction3 = this.findValueSource(instruction2.getChildInstruction(1));
        if (instruction3 instanceof PrimitiveArithmeticInstruction && (primitiveArithmeticInstruction = (PrimitiveArithmeticInstruction)instruction3).getOperation() == 0) {
            boolean bl = true;
            for (int i = 0; i < 2; ++i) {
                Instruction instruction4;
                Instruction instruction5 = primitiveArithmeticInstruction.getChildInstruction(i);
                Instruction instruction6 = this.findValueSource(instruction5);
                if (instruction6 instanceof LiteralInstruction) {
                    instruction4 = (LiteralInstruction)instruction6;
                    if (((LiteralInstruction)instruction4).getType() == IntType.s_intType && (Integer)((LiteralInstruction)instruction4).getValue() >= 0) continue;
                    bl = false;
                    continue;
                }
                if (instruction6 instanceof IteratorInstruction && instruction5 instanceof IdentifierInstruction) {
                    Object object2;
                    instruction4 = (IteratorInstruction)instruction6;
                    Object object3 = ((IteratorInstruction)instruction4).getIndexVar();
                    if (object3.equals(object2 = ((IdentifierInstruction)instruction5).getVariable())) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (bl) {
                instruction2 = new GetStringValueXDMItemInstruction(instruction2.getChildInstruction(0));
            }
        }
        return instruction2;
    }

    private Instruction processFnString1Call(Instruction instruction2) {
        ConstructXDMItemAtomInstruction constructXDMItemAtomInstruction;
        Instruction instruction3 = this.findValueSource(instruction2.getChildInstruction(0));
        if (instruction3 instanceof ConstructXDMItemAtomInstruction && (constructXDMItemAtomInstruction = (ConstructXDMItemAtomInstruction)instruction3).getItemKind() == ItemKind.String) {
            Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
            Integer n3 = ReductionHelper.generateIntermediateIdentifier2();
            constructXDMItemAtomInstruction.setChildInstruction(1, new IdentifierInstruction(n3));
            instruction2 = new LetInstruction(n3, new XPathDataTypeLiteralInstruction(new IdentifierInstruction(n2)), constructXDMItemAtomInstruction);
            instruction2 = new LetInstruction(n2, new StreamInstruction("xs:string"), instruction2);
            instruction2 = new ChooseInstruction(new ChooseInstruction.Case[]{new ChooseInstruction.Case(LiteralInstruction.booleanTrueLiteral(), instruction2)}, null);
        }
        return instruction2;
    }

    private Instruction processDoCheckFinalStepResultItemResultCall(Instruction instruction2) {
        IdentifierInstruction identifierInstruction;
        IBinding iBinding;
        Type type2;
        Instruction instruction3 = this.findValueSource(instruction2.getChildInstruction(0));
        if (instruction3 instanceof XDMSequenceInstruction && instruction3.getChildInstructionCount() == 1 && (type2 = this.getBindingType(iBinding = this.getBindingFromIdentifier(identifierInstruction = (IdentifierInstruction)instruction3.getChildInstruction(0)), this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment())) instanceof XDMItemType) {
            instruction2 = identifierInstruction;
        }
        return instruction2;
    }

    private Instruction processCreateStringItemCall(Instruction instruction2) {
        Instruction instruction3;
        FunctionCallInstruction functionCallInstruction;
        Instruction instruction4 = this.findValueSource(instruction2.getChildInstruction(0));
        if (instruction4 instanceof FunctionCallInstruction && "xslt2$value-of-bc-item".equals((functionCallInstruction = (FunctionCallInstruction)instruction4).getFunction()) && this.isLiteralEmptyStringItem(instruction3 = this.findValueSource(instruction2.getChildInstruction(1)))) {
            Instruction instruction5 = instruction3.getChildInstruction(0);
            instruction2 = new AtomizationToStringInstruction(instruction2.getChildInstruction(0), instruction5);
            Function function2 = this.getCurrentFunction();
            instruction2.typeCheckReduced(function2.getTypeEnvironment(), function2.getBindingEnvironment(), new LinkedList());
        }
        return instruction2;
    }

    boolean isLiteralEmptyStringItem(Instruction instruction2) {
        Instruction instruction3;
        return instruction2 instanceof ConstructXDMItemAtomInstruction && (instruction3 = this.findValueSource(instruction2.getChildInstruction(0))) instanceof StreamInstruction && 0 == instruction3.getChildInstructionCount() && CharType.s_charType == ((StreamInstruction)instruction3).getElementType();
    }

    private Instruction findValueSource(Instruction instruction2) {
        Object object2 = instruction2;
        while (object2 instanceof IdentifierInstruction) {
            if ((object2 = this.getBindingFromIdentifier((IdentifierInstruction)object2)) instanceof LetInstruction) {
                object2 = ((Instruction)object2).getChildInstruction(0);
                continue;
            }
            if (object2 instanceof IBinding) {
                object2 = ((IBinding)object2).getOrigin();
                continue;
            }
            object2 = null;
        }
        return object2;
    }

    private Instruction optimizeFunctionCallForSepParams(Instruction instruction2, Function function2, Function function3, Module module, Instruction[] instructionArray) {
        Binding[] bindingArray;
        String string2;
        Function function4;
        String string3;
        Binding[] bindingArray2 = function3.getParameters();
        if (null != function2 && !(string3 = function3.getName()).endsWith("-default-sep") && (function4 = module.getFunction(string2 = string3 + "-default-sep")) != null && (bindingArray = function4.getParameters()).length == instructionArray.length - 1) {
            Instruction[] instructionArray2 = new Instruction[bindingArray.length];
            boolean bl = false;
            int n2 = 0;
            for (int i = 0; i < bindingArray2.length; ++i) {
                LetInstruction letInstruction;
                Instruction instruction3 = instructionArray[i];
                if (n2 < instructionArray2.length) {
                    instructionArray2[n2] = instruction3;
                }
                ++n2;
                Binding binding = bindingArray2[i];
                Type type2 = this.getBindingType(binding, function2.getTypeEnvironment(), function2.getBindingEnvironment());
                if (!(type2 instanceof XDMItemType)) continue;
                if (false | this.LOG) {
                    System.out.println("*** Testing to see if we can call: " + function4.getName());
                }
                Binding binding2 = bindingArray[i];
                Type type3 = this.getBindingType(binding2, function2.getTypeEnvironment(), function2.getBindingEnvironment());
                if (!(instruction3 instanceof IdentifierInstruction)) continue;
                IdentifierInstruction identifierInstruction = (IdentifierInstruction)instructionArray[i];
                IBinding iBinding = this.getBindingFromIdentifier(identifierInstruction);
                if (iBinding == null) {
                    if (false | this.LOG) {
                        System.out.println("*** !!No binding for parm " + i + " for: " + function4.getName());
                    }
                    bl = false;
                    break;
                }
                Type type4 = this.getBindingType(iBinding, function2.getTypeEnvironment(), function2.getBindingEnvironment());
                if (type3.equals(type4) || !(type4 instanceof XDMItemType)) continue;
                if (false | this.LOG) {
                    System.out.println("*** Trying to map parm " + i + " for: " + function4.getName());
                }
                if (null == (letInstruction = iBinding.getLet())) {
                    bl = false;
                    break;
                }
                Instruction instruction4 = letInstruction.getValue();
                if (instruction4 instanceof ConstructXDMItemAtomInstruction) {
                    ConstructXDMItemAtomInstruction constructXDMItemAtomInstruction = (ConstructXDMItemAtomInstruction)instruction4;
                    int n3 = constructXDMItemAtomInstruction.getChildInstructionCount();
                    if (n3 == 2) {
                        Instruction instruction5 = constructXDMItemAtomInstruction.getChildInstruction(0);
                        if (instruction5 instanceof IdentifierInstruction) {
                            IBinding iBinding2 = this.getBindingFromIdentifier((IdentifierInstruction)instruction5);
                            Type type5 = this.getBindingType(iBinding2, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                            if (type5 instanceof StreamType && ((StreamType)type5).getElementType().equals(CharType.s_charType, function2.getTypeEnvironment())) {
                                LetInstruction letInstruction2;
                                if (false | this.LOG) {
                                    System.out.println("*** Success map parm " + i + " for: " + function4.getName());
                                }
                                if ((letInstruction2 = iBinding2.getLet()) == null) {
                                    bl = false;
                                    break;
                                }
                                Instruction instruction6 = letInstruction2.getValue();
                                if (instruction6 instanceof StreamInstruction) {
                                    StreamInstruction streamInstruction = (StreamInstruction)instruction6;
                                    if (streamInstruction.getElementType().equals(CharType.s_charType)) {
                                        String string4 = streamInstruction.getStringContent();
                                        if (string4 != null && string4.equals(" ")) {
                                            bl = true;
                                            --n2;
                                            continue;
                                        }
                                        bl = false;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            if (bl) {
                if (false | this.LOG) {
                    System.out.println("*** Success specialized call to: " + function4.getName());
                }
                if (instruction2 instanceof ModuleFunctionCallInstruction) {
                    instruction2 = new ModuleFunctionCallInstruction(module.getName(), function4.getName(), instructionArray2);
                } else {
                    FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                    instruction2 = new FunctionCallInstruction(function4.getName(), instructionArray2, functionCallInstruction.getType(function2.getTypeEnvironment(), function2.getBindingEnvironment()));
                }
            } else if (false | this.LOG) {
                System.out.println("*** Can't do specialized call to: " + string3);
            }
        }
        return instruction2;
    }

    private Instruction optimizeFunctionCallForSequenceParams(Instruction instruction2, Function function2, Function function3, Module module, Instruction[] instructionArray) {
        String string2;
        Binding[] bindingArray = function3.getParameters();
        if (null != function2 && !(string2 = function3.getName()).endsWith("-item")) {
            String string3 = string2 + "-item";
            if (string3.endsWith("castToDouble-item")) {
                return instruction2;
            }
            Function function4 = module.getFunction(string3);
            if (function4 != null) {
                Binding[] bindingArray2;
                boolean bl = false;
                Instruction[] instructionArray2 = new Instruction[instructionArray.length];
                if (false | this.LOG) {
                    System.out.println("*** Testing to see if we can call: " + function4.getName());
                }
                if ((bindingArray2 = function4.getParameters()).length == instructionArray.length) {
                    for (int i = 0; i < bindingArray.length; ++i) {
                        LetInstruction letInstruction;
                        Instruction instruction3;
                        Binding binding = bindingArray[i];
                        Type type2 = this.getBindingType(binding, function2.getTypeEnvironment(), function2.getBindingEnvironment());
                        instructionArray2[i] = instruction3 = instructionArray[i];
                        if (!(type2 instanceof XDMSequenceType)) continue;
                        Binding binding2 = bindingArray2[i];
                        Type type3 = this.getBindingType(binding2, function2.getTypeEnvironment(), function2.getBindingEnvironment());
                        if (!(instruction3 instanceof IdentifierInstruction)) continue;
                        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instructionArray[i];
                        IBinding iBinding = this.getBindingFromIdentifier(identifierInstruction);
                        if (iBinding == null) {
                            if (false | this.LOG) {
                                System.out.println("*** !!No binding for parm " + i + " for: " + function4.getName());
                            }
                            bl = false;
                            break;
                        }
                        Type type4 = this.getBindingType(iBinding, function2.getTypeEnvironment(), function2.getBindingEnvironment());
                        if (type3.equals(type4) || !(type3 instanceof XDMItemType) || !(type4 instanceof XDMSequenceType)) continue;
                        if (false | this.LOG) {
                            System.out.println("*** Trying to map parm " + i + " for: " + function4.getName());
                        }
                        if (null == (letInstruction = iBinding.getLet())) {
                            bl = false;
                            break;
                        }
                        LetInstruction letInstruction2 = iBinding.getLet();
                        if (letInstruction2 != null) {
                            Instruction instruction4 = letInstruction2.getValue();
                            if (instruction4 instanceof XDMSequenceInstruction) {
                                XDMSequenceInstruction xDMSequenceInstruction = (XDMSequenceInstruction)instruction4;
                                int n2 = xDMSequenceInstruction.getChildInstructionCount();
                                if (n2 == 1) {
                                    Instruction instruction5 = xDMSequenceInstruction.getChildInstruction(0);
                                    if (instruction5 instanceof IdentifierInstruction) {
                                        IBinding iBinding2 = this.getBindingFromIdentifier((IdentifierInstruction)instruction5);
                                        Type type5 = this.getBindingType(iBinding2, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
                                        if (type5 instanceof XDMItemType) {
                                            if (false | this.LOG) {
                                                System.out.println("*** Success map parm " + i + " for: " + function4.getName());
                                            }
                                            bl = true;
                                            instructionArray2[i] = instruction5;
                                            continue;
                                        }
                                        bl = false;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (bl) {
                        if (false | this.LOG) {
                            System.out.println("*** Success specialized call to: " + function4.getName());
                        }
                        if (instruction2 instanceof ModuleFunctionCallInstruction) {
                            instruction2 = new ModuleFunctionCallInstruction(module.getName(), function4.getName(), instructionArray2);
                        } else {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                            instruction2 = new FunctionCallInstruction(function4.getName(), instructionArray2, functionCallInstruction.getType(function2.getTypeEnvironment(), function2.getBindingEnvironment()));
                        }
                    } else if (false | this.LOG) {
                        System.out.println("*** Can't do specialized call to: " + string2);
                    }
                }
            }
        }
        return instruction2;
    }

    private void processParams(Instruction[] instructionArray) {
        for (int i = 0; i < instructionArray.length; ++i) {
            this.isParamPush = true;
            Instruction instruction2 = instructionArray[i];
            this.optimize(instruction2);
        }
    }

    private Function resolveFunction(TypeEnvironment typeEnvironment, ModuleFunctionCallInstruction moduleFunctionCallInstruction) {
        Module module = typeEnvironment.getModule().getProgram().getModule(moduleFunctionCallInstruction.getModule());
        if (module == null) {
            return null;
        }
        return module.getPublicFunction(moduleFunctionCallInstruction.getFunction());
    }

    @Override
    protected void optimizeChildren(Instruction instruction2) {
        ++this.nestCount;
        super.optimizeChildren(instruction2);
        --this.nestCount;
    }

    private void processISpecialFormMaybe(Instruction instruction2) {
        if (instruction2 instanceof ISpecialForm) {
            int n2 = instruction2.getChildInstructionCount();
            for (int i = 0; i < n2; ++i) {
                IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(i + 1);
                if (null == iBindingArray) continue;
                for (int j = 0; j < iBindingArray.length; ++j) {
                    IBinding iBinding = iBindingArray[j];
                    if (this.LOG) {
                        this.logIndent();
                    }
                    if (!this.LOG) continue;
                    this.logln("ISpecialForm binding: " + iBinding.getName() + this.getTypeString(instruction2));
                }
                break;
            }
        }
    }

    public static void doOptimization(Module module) {
        module.optimize(new XDMSequenceOptimizer());
    }

    class InstructionEntryModel
    extends EntryModel {
        Instruction instruction;

        InstructionEntryModel() {
        }
    }

    class FunctionEntryModel
    extends EntryModel {
        Function function;

        FunctionEntryModel() {
        }
    }

    class EntryModel {
        ForkInformation[] argumentModels;

        EntryModel() {
        }
    }
}

