/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.IShallowImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoopInvariantOptimizer
extends PostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LoopInvariantOptimizer.class);
    private static final String s_className = LoopInvariantOptimizer.class.getName();
    protected HashMap m_cache = new HashMap();
    protected boolean m_doLoopInvariantOptimization = true;

    public void disableLoopInvariantOptimization() {
        this.m_doLoopInvariantOptimization = false;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (instruction2 instanceof IteratorInstruction) {
            Instruction instruction3;
            IteratorInstruction iteratorInstruction = (IteratorInstruction)instruction2;
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            Instruction instruction4 = iteratorInstruction;
            Instruction instruction5 = instruction3 = iteratorInstruction.getBody();
            boolean bl = true;
            ArrayList<LetInstruction> arrayList = new ArrayList<LetInstruction>();
            ArrayList<LetInstruction> arrayList2 = new ArrayList<LetInstruction>();
            ArrayList<Binding> arrayList3 = new ArrayList<Binding>();
            while (instruction3 instanceof LetInstruction) {
                LetInstruction letInstruction = (LetInstruction)instruction3;
                Type type2 = letInstruction.getValue().getType(typeEnvironment, bindingEnvironment);
                if (letInstruction.getValue().isStatic(bindingEnvironment)) {
                    arrayList.add(letInstruction);
                    arrayList2.add(letInstruction);
                    bl = false;
                } else if (type2 instanceof XDMSequenceType || type2 instanceof XDMItemType || type2 instanceof IForkReleaseManaged && ((IForkReleaseManaged)((Object)type2)).mustForkAndRelease() || letInstruction.getValue() instanceof IImperativeInstruction || letInstruction.getValue() instanceof IShallowImperativeInstruction) {
                    arrayList.add(letInstruction);
                    arrayList3.add(new Binding(letInstruction.getName(), type2));
                } else {
                    Set set2 = NavigationUtilities.resolveFreeBindingsForReducedExpression(letInstruction.getValue(), instruction5, bindingEnvironment);
                    IteratorInstruction iteratorInstruction2 = iteratorInstruction;
                    IBinding[] iBindingArray = iteratorInstruction2.getChildInstructionBindings(this.findBodyIndex(iteratorInstruction));
                    int n2 = iBindingArray.length;
                    ArrayList<IBinding> arrayList4 = new ArrayList<IBinding>(n2);
                    for (int i = 0; i < iBindingArray.length; ++i) {
                        arrayList4.add(iBindingArray[i]);
                    }
                    arrayList4.removeAll(set2);
                    HashSet hashSet = new HashSet();
                    letInstruction.getValue().accumulateFreeBindings(hashSet, bindingEnvironment);
                    int n3 = hashSet.size();
                    HashSet hashSet2 = hashSet;
                    hashSet2.removeAll(arrayList);
                    hashSet2.removeAll(set2);
                    if (arrayList4.size() == n2 && hashSet2.size() == n3) {
                        arrayList2.add(letInstruction);
                    } else {
                        arrayList.add(letInstruction);
                    }
                }
                instruction3 = letInstruction.getBody();
            }
            iteratorInstruction.setChildInstruction(this.findBodyIndex(iteratorInstruction), OptimizerUtilities.reconstructLets(instruction3, arrayList, false));
            if (!bl) {
                iteratorInstruction = (IteratorInstruction)iteratorInstruction.cloneWithNewNames();
            }
            instruction4 = OptimizerUtilities.reconstructLets(iteratorInstruction, arrayList2, !bl);
            if (!bl) {
                instruction4 = ReducedForm.reduceFragment(instruction4);
                instruction4.typeCheckReduced(typeEnvironment, bindingEnvironment, new LinkedList());
            }
            if (instruction4 instanceof LetInstruction) {
                return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction4, null);
            }
            return instruction4;
        }
        return super.optimizeStep(instruction2);
    }

    public static Instruction generateFunctionCallBody(Instruction instruction2, List list, Function function2, Map map2) {
        Object object2;
        Object object32;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.entering(s_className, "generateFunctionCallBody");
        }
        if (instruction2 instanceof FunctionCallInstruction) {
            return instruction2;
        }
        BindingEnvironment bindingEnvironment = function2.getBindingEnvironment();
        Instruction instruction3 = instruction2.generateCanonicalForm(bindingEnvironment);
        String string2 = instruction3.toString();
        String string3 = "";
        Set set2 = instruction2.accumulateFreeBindingsInOrder(bindingEnvironment);
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object32 = (IBinding)iterator.next();
            if (set2.contains(object32)) {
                string2 = string2 + "_" + n2;
            }
            ++n2;
        }
        for (Object object32 : set2) {
            object2 = object32.getBindingType();
            if (object2 == null) {
                object2 = object32.getLet().getValue().getType(function2.getTypeEnvironment(), bindingEnvironment);
            }
            string2 = string2 + "_" + object2.toString();
        }
        if (!map2.containsKey(string2)) {
            object32 = function2.getTypeEnvironment();
            string3 = OptimizerUtilities.generateIntermediateIdentifier("repeatedFunction");
            object2 = new Binding[set2.size()];
            int n3 = 0;
            for (IBinding iBinding : set2) {
                Type type2 = iBinding.getBindingType();
                if (type2 == null) {
                    type2 = iBinding.getLet().getValue().getType(function2.getTypeEnvironment(), bindingEnvironment);
                }
                object2[n3] = new Binding(iBinding.getName(), type2);
                ++n3;
            }
            Function function3 = function2.cloneFunctionForFixup(null, false, false, true);
            function3.setBody(instruction2.cloneWithNewNames());
            function3.m_parameters = object2;
            function3.setName(string3);
            ((TypeEnvironment)object32).getModule().addFunction(function3);
            map2.put(string2, string3);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "generateFunctionCallBody", "Cache Add");
            }
        } else {
            string3 = (String)map2.get(string2);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "generateFunctionCallBody", "Cache hit! on " + string3 + " in " + function2.getName());
            }
        }
        object32 = new LinkedList<IdentifierInstruction>();
        object2 = set2.iterator();
        while (object2.hasNext()) {
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(((IBinding)object2.next()).getName());
            ((LinkedList)object32).add(identifierInstruction);
        }
        return new FunctionCallInstruction(string3, (List)object32);
    }

    int findBodyIndex(Instruction instruction2) {
        int n2 = instruction2.getChildInstructionCount();
        ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction2);
        while (!iSpecialForm.isChildInstructionBody(--n2)) {
        }
        return n2;
    }
}

