/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MakeInstructionReport;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.xdm.MatchXDMItemInstruction;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MixedModeModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.util.misc.IntStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataFlowAnalyzer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(DataFlowAnalyzer.class);
    private static final String s_className = DataFlowAnalyzer.class.getName();
    Set<Function> foundFunctions = new HashSet<Function>();
    int nestCount = 0;
    Stack<Integer> variableCountStack = new Stack();
    public boolean LOG = HiddenOptions.optionValueIs("CursorAnalyzerLog", "on");
    int paramPushDepth = 0;
    boolean isParamPush = false;
    static final String INDENTSTRING = "  ";
    BindingEnvironment lambdaFreeBindings = null;
    IntStack foundForkCountStack = new IntStack(128);
    public Set<Class<? extends Instruction>> instructionsThatTakeCursors = new HashSet<Class<? extends Instruction>>();
    public Map<Instruction, ForkInformation> cursorCreationsInformations = new HashMap<Instruction, ForkInformation>();

    private final boolean log(String string2) {
        if (this.LOG) {
            System.out.print(string2);
        }
        return true;
    }

    private final boolean logln(String string2) {
        if (this.LOG) {
            System.out.println(string2);
        }
        return true;
    }

    private final boolean logIndent() {
        if (this.LOG) {
            int n2;
            for (n2 = 0; n2 < this.nestCount; ++n2) {
                this.log(INDENTSTRING);
            }
            if (this.isParamPush) {
                for (n2 = 0; n2 < this.paramPushDepth; ++n2) {
                    this.log("*");
                }
                this.log("->");
                this.isParamPush = false;
            }
        }
        return true;
    }

    @Override
    public Instruction optimize(Instruction instruction2) {
        return super.optimize(instruction2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimizeFunction(Function function2) {
        BindingEnvironment bindingEnvironment = this.lambdaFreeBindings;
        try {
            int n2;
            this.lambdaFreeBindings = null;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("function declaration: " + function2.getName() + "@" + function2.getReturnType());
            }
            ++this.nestCount;
            this.foundForkCountStack.push(0);
            Binding[] bindingArray = function2.getParameters();
            if (null != bindingArray) {
                for (n2 = 0; n2 < bindingArray.length; ++n2) {
                    Binding binding = bindingArray[n2];
                    binding.setStackFramePos(n2);
                    if (this.LOG) {
                        this.logIndent();
                    }
                    if (!this.LOG) continue;
                    this.logln("->argument declaration: " + binding.getClass().getSimpleName() + ": " + binding.getName() + " - StackFramePos: " + binding.getStackFramePos());
                }
                this.variableCountStack.push(bindingArray.length);
            } else {
                this.variableCountStack.push(0);
            }
            super.optimizeFunction(function2);
            n2 = this.variableCountStack.pop();
            function2.setStackFrameSize(n2);
            function2.setFoundForkCount(this.foundForkCountStack.pop());
            --this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("leaving optimizeFunction: " + function2.getName() + " - stackFrameSize: " + function2.getStackFrameSize() + " (bindingsEnvSize: " + function2.getBindingEnvironment().getSize());
            }
        }
        finally {
            this.lambdaFreeBindings = bindingEnvironment;
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (this.LOG) {
            this.logIndent();
        }
        this.tryToAddToStaticAnalysisTable(instruction2);
        if (instruction2 instanceof FunctionCallInstruction) {
            instruction2 = this.processFunctionCallInstruction(instruction2);
        } else if (instruction2 instanceof ModuleFunctionCallInstruction) {
            instruction2 = this.processModuleFunctionCallInstruction(instruction2);
        } else if (instruction2 instanceof IdentifierInstruction) {
            instruction2 = this.processIdentifierInstruction(instruction2);
        } else if (instruction2 instanceof IBinding) {
            instruction2 = this.processIBinding(instruction2);
        } else {
            if (instruction2.constructsCursor()) {
                this.foundForkCountStack.push(this.foundForkCountStack.pop() + 1);
            }
            instruction2 = instruction2 instanceof MatchXDMItemInstruction ? this.processMatchXDMItemInstruction(instruction2) : (instruction2 instanceof MatchInstruction ? this.processMatchInstruction(instruction2) : (instruction2 instanceof LambdaInstruction ? this.processLambda(instruction2) : (instruction2 instanceof ApplyInstruction ? this.processOtherInstruction(instruction2) : (instruction2 instanceof IteratorInstruction ? this.processIterator((IteratorInstruction)instruction2) : this.processOtherInstruction(instruction2)))));
        }
        return instruction2 != null ? super.optimizeStep(instruction2) : instruction2;
    }

    private void tryToAddToStaticAnalysisTable(Instruction instruction2) {
        ArrayList<MakeInstructionReport.InstructionInfo> arrayList = MakeInstructionReport._instructionTable;
        if (arrayList != null) {
            MakeInstructionReport.InstructionInfo instructionInfo = MakeInstructionReport.findInstructionInfo(arrayList, instruction2);
            if (instructionInfo == null) {
                String string2 = MakeInstructionReport.tryToGetFILKeyword(instruction2);
                if (!string2.contains("$fixup$")) {
                    s_logger.logrb(Level.WARNING, s_className, "tryToAddToStaticAnalysisTable", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM", new Object[]{"Count not find InstructionInfo for " + instruction2.getClass().getSimpleName() + " " + instruction2.innerToString()});
                }
            } else {
                Type type2 = instruction2.evaluateType(this.m_currentFunction);
                String string3 = type2.toString().trim();
                if (instructionInfo.runtimeTypes == null) {
                    instructionInfo.runtimeTypes = string3;
                } else if (!instructionInfo.runtimeTypes.contains(string3)) {
                    instructionInfo.runtimeTypes = instructionInfo.runtimeTypes + "|" + string3;
                }
                int n2 = 0;
                int n3 = instruction2.getChildInstructionCount();
                for (int i = 0; i < n3; ++i) {
                    Object object2;
                    Instruction instruction3 = instruction2.getChildInstruction(i);
                    if (instruction2 instanceof ISpecialForm && (object2 = (ISpecialForm)((Object)instruction2)).isChildInstructionBody(i)) {
                        instructionInfo.hasBody = true;
                        IBinding[] iBindingArray = object2.getChildInstructionBindings(i);
                        if (iBindingArray != null) {
                            for (int j = 0; j < iBindingArray.length; ++j) {
                                IBinding iBinding = iBindingArray[j];
                                Type type3 = iBinding.getBindingType(this.m_currentFunction.getTypeEnvironment(), instruction2.evaluateBindingEnvironment(this.m_currentFunction));
                                String string4 = type3.toString().trim() + "(SB)";
                                this.setParamStringInReport(instructionInfo, n2, string4);
                                if (++n2 >= MakeInstructionReport.MAXPARAMSTORECORD) break;
                            }
                        }
                        if (n2 < MakeInstructionReport.MAXPARAMSTORECORD) continue;
                        break;
                    }
                    object2 = this.extractType(instruction3);
                    this.setParamStringInReport(instructionInfo, n2, object2.toString().trim());
                    if (++n2 >= MakeInstructionReport.MAXPARAMSTORECORD) break;
                }
                if (instructionInfo.numberOfParams != n2) {
                    instructionInfo.numberOfParams = instructionInfo.numberOfParams == -1 ? n2 : -100;
                }
            }
        }
    }

    private void setParamStringInReport(MakeInstructionReport.InstructionInfo instructionInfo, int n2, String string2) {
        String string3 = instructionInfo.params[n2];
        if (string3 == null) {
            string3 = string2;
        } else if (!string3.contains(string2)) {
            string3 = string3 + "|" + string2;
        }
        if (n2 == MakeInstructionReport.MAXPARAMSTORECORD - 1) {
            string3 = string3 + "...";
        }
        instructionInfo.params[n2] = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instruction processOtherInstruction(Instruction instruction2) {
        GetAxisCursorInstruction getAxisCursorInstruction;
        if (this.LOG) {
            this.log(instruction2.getClass().getSimpleName());
        }
        if (this.LOG) {
            this.logType(instruction2);
        }
        if (instruction2 instanceof GetTypedAxisCursorInstruction) {
            if (this.LOG) {
                this.log(" - ");
            }
            getAxisCursorInstruction = (GetTypedAxisCursorInstruction)instruction2;
            if (this.LOG) {
                this.log(getAxisCursorInstruction.toString());
            }
        } else if (instruction2 instanceof GetAxisCursorInstruction) {
            if (this.LOG) {
                this.log(" - ");
            }
            getAxisCursorInstruction = (GetAxisCursorInstruction)instruction2;
            if (this.LOG) {
                this.log(getAxisCursorInstruction.toString());
            }
        }
        if (instruction2.getChildInstructionCount() == 0 && this.LOG) {
            this.log(": " + instruction2.toString().trim());
        }
        this.getAndLogBindingEnvironment(instruction2);
        if (this.LOG) {
            this.logln("");
        }
        if (instruction2 instanceof ISpecialForm) {
            this.processSpecialForms(instruction2);
            return null;
        }
        ++this.paramPushDepth;
        ++this.nestCount;
        try {
            boolean bl = false;
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                this.isParamPush = true;
                Instruction instruction3 = instruction2.getChildInstruction(i);
                Type type2 = this.extractType(instruction3);
                if (type2.toString().trim().equals("XDMSequence")) {
                    bl = true;
                }
                this.optimize(instruction3);
            }
            if (bl && !this.instructionsThatTakeCursors.contains(instruction2.getClass())) {
                this.instructionsThatTakeCursors.add(instruction2.getClass());
            }
        }
        finally {
            --this.nestCount;
            --this.paramPushDepth;
        }
        return null;
    }

    private final boolean logType(Instruction instruction2) {
        if (this.LOG) {
            this.log("@");
            Type type2 = this.extractType(instruction2);
            if (null != type2) {
                this.log(type2.toString());
            } else {
                this.log("??");
            }
        }
        return true;
    }

    private String getTypeString(Instruction instruction2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@");
        Type type2 = this.extractType(instruction2);
        if (null != type2) {
            stringBuffer.append(type2.toString());
        } else {
            stringBuffer.append("??");
        }
        return stringBuffer.toString();
    }

    private Type extractType(Instruction instruction2) {
        Type type2 = instruction2.getCachedType();
        if (type2 == null) {
            BindingEnvironment bindingEnvironment = instruction2.getBindingEnvironment();
            if (bindingEnvironment == null) {
                bindingEnvironment = this.m_currentFunction.getBindingEnvironment();
            }
            assert (bindingEnvironment != null);
            TypeEnvironment typeEnvironment = this.m_currentFunction.getTypeEnvironment();
            assert (typeEnvironment != null);
            type2 = instruction2.getType(typeEnvironment, bindingEnvironment);
        }
        return type2;
    }

    private Instruction processMatchXDMItemInstruction(Instruction instruction2) {
        MatchXDMItemInstruction matchXDMItemInstruction = (MatchXDMItemInstruction)instruction2;
        if (this.LOG) {
            this.logln(instruction2.getClass().getSimpleName());
        }
        Instruction instruction3 = matchXDMItemInstruction.getToMatch();
        ++this.nestCount;
        if (this.LOG) {
            this.logIndent();
        }
        if (this.LOG) {
            this.logln("toMatch: ");
        }
        this.optimize(instruction3);
        --this.nestCount;
        ++this.nestCount;
        MatchXDMItemInstruction.Match[] matchArray = matchXDMItemInstruction.getMatches();
        for (int i = 0; i < matchArray.length; ++i) {
            MatchXDMItemInstruction.DeconstructionMatch deconstructionMatch = (MatchXDMItemInstruction.DeconstructionMatch)matchArray[i];
            Binding[] bindingArray = deconstructionMatch.getBindings();
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.log("case ");
            }
            if (this.LOG) {
                this.log(deconstructionMatch.getItemKind().getName());
            }
            for (int j = 0; j < bindingArray.length; ++j) {
                Binding binding = bindingArray[j];
                if (this.LOG) {
                    this.log(" binding: " + binding.getName() + "@" + binding.getBindingType() + " - StackFramePos: " + this.variableCountStack.peek());
                }
                binding.setStackFramePos(this.variableCountStack.peek());
                this.variableCountStack.set(this.variableCountStack.size() - 1, this.variableCountStack.peek() + 1);
            }
            if (this.LOG) {
                this.logln(":");
            }
            ++this.nestCount;
            Instruction instruction4 = deconstructionMatch.getHandler();
            this.optimize(instruction4);
            --this.nestCount;
        }
        Instruction instruction5 = matchXDMItemInstruction.getDefault();
        if (null != instruction5) {
            ++this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("otherwise:");
            }
            this.optimize(instruction5);
            --this.nestCount;
        }
        --this.nestCount;
        return null;
    }

    private Instruction processMatchInstruction(Instruction instruction2) {
        MatchInstruction matchInstruction = (MatchInstruction)instruction2;
        if (this.LOG) {
            this.logln(instruction2.getClass().getSimpleName());
        }
        Instruction instruction3 = matchInstruction.getToMatch();
        ++this.nestCount;
        if (this.LOG) {
            this.logIndent();
        }
        if (this.LOG) {
            this.logln("toMatch: ");
        }
        this.optimize(instruction3);
        --this.nestCount;
        ++this.nestCount;
        MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
        for (int i = 0; i < matchArray.length; ++i) {
            Object object2;
            MatchInstruction.Match match = matchArray[i];
            if (match instanceof MatchInstruction.DeconstructionMatch) {
                object2 = (MatchInstruction.DeconstructionMatch)match;
                Binding[] bindingArray = ((MatchInstruction.DeconstructionMatch)object2).getBindings();
                if (this.LOG) {
                    this.logIndent();
                }
                if (this.LOG) {
                    this.log("case ");
                }
                if (this.LOG) {
                    this.log(((MatchInstruction.DeconstructionMatch)object2).m_constructorName);
                }
                for (int j = 0; j < bindingArray.length; ++j) {
                    Binding binding = bindingArray[j];
                    if (this.LOG) {
                        this.log(" binding: " + binding.getName() + "@" + binding.getBindingType() + " - StackFramePos: " + this.variableCountStack.peek());
                    }
                    binding.setStackFramePos(this.variableCountStack.peek());
                    this.variableCountStack.set(this.variableCountStack.size() - 1, this.variableCountStack.peek() + 1);
                }
                if (this.LOG) {
                    this.logln(":");
                }
            } else if (match instanceof MatchInstruction.LiteralMatch) {
                object2 = (MatchInstruction.LiteralMatch)match;
                if (this.LOG) {
                    this.logIndent();
                }
                if (this.LOG) {
                    this.log("case ");
                }
                if (this.LOG) {
                    this.log(((MatchInstruction.LiteralMatch)object2).getLiteral().toString());
                }
                if (this.LOG) {
                    this.logln(":");
                }
            }
            ++this.nestCount;
            object2 = match.getHandler();
            this.optimize((Instruction)object2);
            --this.nestCount;
        }
        Instruction instruction4 = matchInstruction.getDefault();
        if (null != instruction4) {
            ++this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("otherwise:");
            }
            this.optimize(instruction4);
            --this.nestCount;
        }
        --this.nestCount;
        return null;
    }

    private Instruction processIBinding(Instruction instruction2) {
        IBinding iBinding = (IBinding)((Object)instruction2);
        if (this.LOG) {
            this.log(instruction2.getClass().getSimpleName() + ": " + iBinding.getName());
        }
        if (this.LOG) {
            this.logIBindingType(iBinding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
        }
        if (this.LOG) {
            this.logln(" - StackFramePos: " + this.variableCountStack.peek());
        }
        iBinding.setStackFramePos(this.variableCountStack.peek());
        this.variableCountStack.push(this.variableCountStack.pop() + 1);
        return instruction2;
    }

    private Instruction processIterator(IteratorInstruction iteratorInstruction) {
        Object object2;
        if (this.LOG) {
            this.log(iteratorInstruction.getClass().getSimpleName());
        }
        if (this.LOG) {
            this.logType(iteratorInstruction);
        }
        if (iteratorInstruction.getChildInstructionCount() == 0 && this.LOG) {
            this.log(": " + iteratorInstruction.toString().trim());
        }
        this.getAndLogBindingEnvironment(iteratorInstruction);
        Instruction instruction2 = iteratorInstruction.getBody();
        ArrayList arrayList = new ArrayList();
        assert (iteratorInstruction instanceof ISpecialForm);
        if (iteratorInstruction instanceof ISpecialForm) {
            this.processSpecialForms(iteratorInstruction);
            int n2 = iteratorInstruction.getChildInstructionCount();
            for (int i = 0; i < n2; ++i) {
                object2 = iteratorInstruction.getChildInstructionBindings(i + 1);
                if (object2 == null) continue;
                Collections.addAll(arrayList, object2);
            }
        }
        IBinding[] iBindingArray = arrayList.toArray(new IBinding[0]);
        BindingEnvironment bindingEnvironment = instruction2.evaluateBindingEnvironment(this.m_currentFunction);
        assert (bindingEnvironment != null);
        object2 = FindFreeVariables.findFreeBindings(instruction2, bindingEnvironment);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            IBinding iBinding = (IBinding)iterator.next();
            Boolean bl = false;
            if (null != iBindingArray) {
                for (int i = 0; i < iBindingArray.length; ++i) {
                    IBinding iBinding2 = iBindingArray[i];
                    if (iBinding2 != iBinding) continue;
                    bl = true;
                    break;
                }
            }
            if (bl.booleanValue()) continue;
            iBinding.passingIterator();
        }
        return null;
    }

    private BindingEnvironment getAndLogBindingEnvironment(Instruction instruction2) {
        BindingEnvironment bindingEnvironment = instruction2.getBindingEnvironment();
        if (bindingEnvironment != null) {
            if (this.LOG) {
                this.log("  bindingsEnvSize: " + bindingEnvironment.getSize());
            }
            if (this.LOG) {
                this.log("  bindingsEnv: " + bindingEnvironment.toString());
            }
        } else {
            if (this.LOG) {
                this.log("  null binding environment");
            }
            if (bindingEnvironment == null) {
                bindingEnvironment = instruction2.evaluateBindingEnvironment(this.m_currentFunction);
            }
            if (this.LOG && bindingEnvironment != null) {
                this.log("  using current function binding env");
            }
        }
        return bindingEnvironment;
    }

    private void processSpecialForms(Instruction instruction2) {
        ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction2);
        ++this.nestCount;
        boolean bl = false;
        for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
            Instruction instruction3;
            Type type2;
            if (iSpecialForm.isChildInstructionBody(i)) {
                this.processISpecialFormMaybe(instruction2);
            }
            if ((type2 = this.extractType(instruction3 = instruction2.getChildInstruction(i))).toString().trim().equals("XDMSequence")) {
                bl = true;
            }
            this.optimize(instruction3);
        }
        if (bl && !this.instructionsThatTakeCursors.contains(instruction2.getClass())) {
            this.instructionsThatTakeCursors.add(instruction2.getClass());
        }
        --this.nestCount;
    }

    private Instruction processIdentifierInstruction(Instruction instruction2) {
        Object object2;
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
        Function function2 = this.getCurrentFunction();
        IBinding iBinding = null;
        if (null != this.lambdaFreeBindings) {
            object2 = identifierInstruction.getVariable();
            iBinding = this.lambdaFreeBindings.getVariableBinding(object2);
        }
        if (iBinding == null && (iBinding = identifierInstruction.getBinding()) == null) {
            object2 = function2.getBindingEnvironment();
            assert (object2 != null);
            Object object3 = identifierInstruction.getVariable();
            iBinding = ((BindingEnvironment)object2).getVariableBinding(object3);
        }
        if (iBinding != null) {
            int n2 = iBinding.getVariableUse();
            iBinding.incrementVariableUse();
            if (this.LOG) {
                this.log(instruction2.getClass().getSimpleName() + ": " + iBinding.getName());
            }
            if (this.LOG) {
                this.logIBindingType(iBinding, this.m_currentFunction.getTypeEnvironment(), this.m_currentFunction.getBindingEnvironment());
            }
            if (this.LOG) {
                this.logln(" - StackFramePos: " + iBinding.getStackFramePos());
            }
            if (this.LOG) {
                this.logln(" - VariableUsage: " + n2 + " -> " + iBinding.getVariableUse());
            }
        } else if (this.LOG) {
            this.logln("optimizeStep (Can't find IBinding): " + instruction2.getClass().getSimpleName() + ": " + identifierInstruction.getVariable());
        }
        return instruction2;
    }

    private final boolean logIBindingType(IBinding iBinding, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (this.LOG) {
            this.log("@");
            Type type2 = iBinding.getBindingType();
            if (type2 != null) {
                this.log(type2.toString());
            } else {
                type2 = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
                if (type2 != null) {
                    this.log(type2.toString());
                } else {
                    this.log("??");
                }
            }
        }
        return true;
    }

    private Instruction processModuleFunctionCallInstruction(Instruction instruction2) {
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction2;
        Function function2 = this.getCurrentFunction();
        TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
        Module module = typeEnvironment.getModule().getProgram().getModule(moduleFunctionCallInstruction.getModule());
        Function function3 = this.resolveFunction(typeEnvironment, moduleFunctionCallInstruction);
        if (this.LOG) {
            this.logln(instruction2.getClass().getSimpleName() + this.getTypeString(instruction2) + ": " + module.getName() + ":" + function3.getName());
        }
        Instruction[] instructionArray = moduleFunctionCallInstruction.getParameters();
        ++this.paramPushDepth;
        this.processParams(instructionArray);
        --this.paramPushDepth;
        if (null == function3) {
            if (!XStarCompiler.MIXEDMODE) {
                assert (false);
            } else {
                assert (moduleFunctionCallInstruction instanceof MixedModeModuleFunctionCallInstruction);
                if (this.LOG) {
                    this.logln("Found mixed mode call: " + moduleFunctionCallInstruction.getFunction() + " ...skipping");
                }
            }
        } else if (!this.foundFunctions.contains(function3)) {
            this.foundFunctions.add(function3);
            if (null == function3) {
                this.logln("I screwed up... can't find function: " + moduleFunctionCallInstruction.getFunction());
            } else {
                this.optimizeFunction(function3);
            }
        }
        return instruction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instruction processFunctionCallInstruction(Instruction instruction2) {
        int n2 = this.paramPushDepth;
        this.paramPushDepth = 0;
        try {
            Function function2 = this.getCurrentFunction();
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
            Function function3 = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
            if (this.LOG) {
                this.logln(instruction2.getClass().getSimpleName() + this.getTypeString(instruction2) + ": " + function3.getName());
            }
            Instruction[] instructionArray = functionCallInstruction.getParameters();
            ++this.paramPushDepth;
            this.processParams(instructionArray);
            --this.paramPushDepth;
            if (!this.foundFunctions.contains(function3)) {
                this.foundFunctions.add(function3);
                if (null == function3) {
                    if (this.LOG) {
                        this.logln("I screwed up... can't find function: " + functionCallInstruction.getFunction());
                    }
                } else {
                    this.optimizeFunction(function3);
                }
            }
        }
        finally {
            this.paramPushDepth = n2;
        }
        return instruction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instruction processLambda(Instruction instruction2) {
        IBinding[] iBindingArray;
        BindingEnvironment bindingEnvironment;
        if (this.LOG) {
            this.log("LAMBDA: ");
        }
        if ((bindingEnvironment = instruction2.getBindingEnvironment()) != null) {
            if (this.LOG) {
                this.log("  bindingsEnvSize: " + bindingEnvironment.getSize());
            }
            if (this.LOG) {
                this.log("  bindingsEnv: " + bindingEnvironment.toString());
            }
        } else {
            if (this.LOG) {
                this.log("  null binding environment");
            }
            if (bindingEnvironment == null) {
                bindingEnvironment = this.m_currentFunction.getBindingEnvironment();
            }
            if (bindingEnvironment != null && this.LOG) {
                this.log("  using current function binding env");
            }
        }
        assert (bindingEnvironment != null);
        Function function2 = this.getCurrentFunction();
        LambdaInstruction lambdaInstruction = (LambdaInstruction)instruction2;
        Set<IBinding> set2 = FindFreeVariables.findFreeBindings(lambdaInstruction, bindingEnvironment);
        lambdaInstruction.setFreeBindings(set2, function2);
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment();
        for (IBinding iBinding : iBindingArray = lambdaInstruction.getClosureInternalBindings()) {
            bindingEnvironment2.setVariableBinding(iBinding);
        }
        if (this.LOG) {
            this.logIndent();
        }
        TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
        if (this.LOG) {
            this.log("@" + lambdaInstruction.getType(typeEnvironment, bindingEnvironment));
        }
        ++this.nestCount;
        BindingEnvironment bindingEnvironment3 = this.lambdaFreeBindings;
        int n2 = this.paramPushDepth;
        this.paramPushDepth = 0;
        try {
            int n3;
            this.lambdaFreeBindings = bindingEnvironment2;
            if (this.LOG) {
                this.logln(": freeBindings.size=" + set2.size());
            }
            Binding[] bindingArray = lambdaInstruction.getParameters();
            if (this.LOG) {
                this.logln(": params.length=" + bindingArray.length);
            }
            if (null != bindingArray) {
                for (n3 = 0; n3 < bindingArray.length; ++n3) {
                    Binding binding = bindingArray[n3];
                    binding.setStackFramePos(n3);
                    if (this.LOG) {
                        this.logIndent();
                    }
                    if (!this.LOG) continue;
                    this.logln("->argument declaration: " + binding.getClass().getSimpleName() + ": " + binding.getName() + " - StackFramePos: " + binding.getStackFramePos());
                }
                this.variableCountStack.push(bindingArray.length + set2.size());
            } else {
                this.variableCountStack.push(set2.size());
            }
            this.optimizeChildren(instruction2);
            n3 = this.variableCountStack.pop();
            lambdaInstruction.setStackFrameSize(n3);
            --this.nestCount;
            if (this.LOG) {
                this.logIndent();
            }
            if (this.LOG) {
                this.logln("leaving LAMBDA:  - stackFrameSize: " + lambdaInstruction.getStackFrameSize());
            }
        }
        finally {
            this.lambdaFreeBindings = bindingEnvironment3;
            this.paramPushDepth = n2;
        }
        return null;
    }

    private void processParams(Instruction[] instructionArray) {
        for (int i = 0; i < instructionArray.length; ++i) {
            this.isParamPush = true;
            Instruction instruction2 = instructionArray[i];
            this.optimize(instruction2);
        }
    }

    private Function resolveFunction(TypeEnvironment typeEnvironment, ModuleFunctionCallInstruction moduleFunctionCallInstruction) {
        Module module = typeEnvironment.getModule().getProgram().getModule(moduleFunctionCallInstruction.getModule());
        if (module == null) {
            return null;
        }
        return module.getPublicFunction(moduleFunctionCallInstruction.getFunction());
    }

    @Override
    protected void optimizeChildren(Instruction instruction2) {
        ++this.nestCount;
        super.optimizeChildren(instruction2);
        --this.nestCount;
    }

    private void processISpecialFormMaybe(Instruction instruction2) {
        if (instruction2 instanceof ISpecialForm) {
            int n2 = instruction2.getChildInstructionCount();
            for (int i = 0; i < n2; ++i) {
                IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(i + 1);
                if (null == iBindingArray) continue;
                for (int j = 0; j < iBindingArray.length; ++j) {
                    IBinding iBinding = iBindingArray[j];
                    if (this.LOG) {
                        this.logIndent();
                    }
                    if (this.LOG) {
                        this.logln("ISpecialForm binding: " + iBinding.getName() + this.getTypeString(instruction2) + " - StackFramePos: " + this.variableCountStack.peek());
                    }
                    iBinding.setStackFramePos(this.variableCountStack.peek());
                    this.variableCountStack.push(this.variableCountStack.pop() + 1);
                }
                break;
            }
        }
    }

    class InstructionEntryModel
    extends EntryModel {
        Instruction instruction;

        InstructionEntryModel() {
        }
    }

    class FunctionEntryModel
    extends EntryModel {
        Function function;

        FunctionEntryModel() {
        }
    }

    class EntryModel {
        ForkInformation[] argumentModels;

        EntryModel() {
        }
    }
}

