/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers;

import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationSettings;
import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.AutomatonFunctionCallEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.EvaluatorDiscoveringPartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutomatonFunctionCallExtractionOptimizer
extends TailRecursiveOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(AutomatonFunctionCallExtractionOptimizer.class);
    private static final String s_className = AutomatonFunctionCallExtractionOptimizer.class.getName();
    HashMap m_functionInfo = new HashMap();
    HashSet m_affectedFunctions = new HashSet();

    public static final BindingDependencyInfo skipPastLets(BindingDependencyInfo bindingDependencyInfo, Map map2) {
        while (bindingDependencyInfo.m_parent instanceof LetInstruction && bindingDependencyInfo.m_parentIndex == 0) {
            IBinding iBinding = ((LetInstruction)bindingDependencyInfo.m_parent).getBinding();
            List list = (List)map2.get(iBinding);
            if (list == null) {
                return null;
            }
            if (list.size() != 1) {
                return null;
            }
            bindingDependencyInfo = (BindingDependencyInfo)list.get(0);
        }
        return bindingDependencyInfo;
    }

    @Override
    protected Instruction optimizeStep2(Instruction instruction2) {
        if (instruction2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            Function function2 = this.getCurrentFunction().getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
            Object v = this.m_functionInfo.get(function2);
            if (v != null) {
                Info info = (Info)v;
                Function function3 = function2.lookupDerivative(this);
                FunctionCallInstruction functionCallInstruction2 = (FunctionCallInstruction)functionCallInstruction.cloneReduced();
                ArrayList<LetInstruction> arrayList = new ArrayList<LetInstruction>();
                for (int i = 0; i < info.m_fcis.length; ++i) {
                    if (info.m_fcis[i] == null) continue;
                    Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
                    FunctionCallInstruction functionCallInstruction3 = (FunctionCallInstruction)info.m_fcis[i].cloneReduced();
                    functionCallInstruction3.setChildInstruction(0, functionCallInstruction2.getChildInstruction(i));
                    arrayList.add(new LetInstruction(n2, functionCallInstruction3, null));
                    functionCallInstruction2.setChildInstruction(i, new IdentifierInstruction(n2));
                }
                functionCallInstruction2.setFunction(function3.getName());
                ChooseInstruction chooseInstruction = new ChooseInstruction(new ChooseInstruction.Case[]{new ChooseInstruction.Case(LiteralInstruction.booleanTrueLiteral(), OptimizerUtilities.reconstructLets(functionCallInstruction2, arrayList))}, null);
                ((Instruction)chooseInstruction).typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                this.m_affectedFunctions.add(this.getCurrentFunction().getName());
                return chooseInstruction;
            }
        }
        return instruction2;
    }

    @Override
    public void optimizeFunction(Function function2) {
        if (function2.hasBeenTypeChecked()) {
            super.optimizeFunction(function2);
        }
    }

    void doAnalysisPhase(Module module) {
        module.optimize(new Analyzer());
    }

    public static void doOptimization(Module module, Set set2, IntegerSettings integerSettings) {
        final PartialInformationCollector[] partialInformationCollectorArray = new PartialInformationCollector[1];
        final HashSet<String> hashSet = new HashSet<String>(module.getFunctionNames());
        for (int i = 0; i < 10; ++i) {
            XSLTPartialEvaluationSettings xSLTPartialEvaluationSettings;
            AutomatonFunctionCallExtractionOptimizer automatonFunctionCallExtractionOptimizer = new AutomatonFunctionCallExtractionOptimizer();
            automatonFunctionCallExtractionOptimizer.doAnalysisPhase(module);
            if (automatonFunctionCallExtractionOptimizer.m_functionInfo.isEmpty()) {
                if (i > 0) {
                    xSLTPartialEvaluationSettings = new XSLTPartialEvaluationSettings(integerSettings);
                    module.optimize(new XSLTPartialEvaluationOptimizer(set2, xSLTPartialEvaluationSettings));
                }
                return;
            }
            module.optimize(automatonFunctionCallExtractionOptimizer);
            xSLTPartialEvaluationSettings = new XSLTPartialEvaluationSettings(integerSettings);
            module.optimize(new XSLTPartialEvaluationOptimizer(automatonFunctionCallExtractionOptimizer.m_affectedFunctions, xSLTPartialEvaluationSettings){

                @Override
                public void optimizeFunction(Function function2) {
                    if (this.m_entryPoints.contains(function2.getName())) {
                        if (partialInformationCollectorArray[0] == null) {
                            partialInformationCollectorArray[0] = new EvaluatorDiscoveringPartialInformationCollector(function2.getBody(), this.m_evaluators, function2, this.m_settings.getIntegerSettings());
                            partialInformationCollectorArray[0].m_completedFunctions.addAll(hashSet);
                        }
                        partialInformationCollectorArray[0].m_completedFunctions.remove(function2.getName());
                        partialInformationCollectorArray[0].partiallyEvaluateFunction(function2);
                    }
                }
            });
            module.removeDeadFunctions();
        }
    }

    class Analyzer
    extends Optimizer {
        Info m_info;

        Analyzer() {
        }

        @Override
        public void optimizeFunction(Function function2) {
            Object object2;
            if (function2.getBindingEnvironment() == null) {
                return;
            }
            this.m_currentFunction = function2;
            HashMap hashMap = new HashMap();
            function2.determineDataDependencies(function2.m_parameters, hashMap);
            int n2 = function2.m_parameters.length;
            FunctionCallInstruction[] functionCallInstructionArray = new FunctionCallInstruction[n2];
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                List list = (List)hashMap.get(function2.m_parameters[i]);
                if (list == null || list.size() != 1 || (object2 = AutomatonFunctionCallExtractionOptimizer.skipPastLets((BindingDependencyInfo)list.get(0), hashMap)) == null || !(((BindingDependencyInfo)object2).m_parent instanceof FunctionCallInstruction)) continue;
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)((BindingDependencyInfo)object2).m_parent;
                Function function3 = function2.getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
                if (functionCallInstruction.getChildInstructionCount() != 2 || !AutomatonFunctionCallEvaluator.isAutomatonFunctionAugmented(function3)) continue;
                if (functionCallInstruction.getChildInstruction(1).isStatic(function2.getBindingEnvironment())) {
                    functionCallInstructionArray[i] = functionCallInstruction;
                    bl = true;
                    continue;
                }
                if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
                s_logger.logp(Level.FINEST, s_className, "optimizeFunction", "Missed opportunity to extract automaton call: " + function2.getName());
            }
            if (bl) {
                Function function4 = function2.cloneFunctionForFixup(AutomatonFunctionCallExtractionOptimizer.this, true, true, true);
                for (int i = 0; i < n2; ++i) {
                    if (functionCallInstructionArray[i] == null) continue;
                    object2 = this.resolveType(functionCallInstructionArray[i]);
                    function4.m_parameters[i].setType((Type)object2);
                }
                function2.getTypeEnvironment().getModule().addFunction(function4);
                Info info = new Info(functionCallInstructionArray, function2, function4);
                AutomatonFunctionCallExtractionOptimizer.this.m_functionInfo.put(function2, info);
                this.m_info = info;
                this.m_currentFunction = function4;
                function4.setBody(this.optimize(function4.getBody()));
                this.m_info = null;
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction2 instanceof FunctionCallInstruction) {
                for (int i = 0; i < this.m_info.m_fcis.length; ++i) {
                    if (this.m_info.m_fcis[i] == null || !this.m_info.m_originals[i].toString().equals(instruction2.toString())) continue;
                    return new IdentifierInstruction(this.m_currentFunction.m_parameters[i].getName());
                }
            }
            return super.optimizeStep(instruction2, instruction3, n2);
        }
    }

    static class Info {
        FunctionCallInstruction[] m_originals;
        FunctionCallInstruction[] m_fcis;
        Type[] m_types;
        Function m_newFunction;

        Info(FunctionCallInstruction[] functionCallInstructionArray, Function function2, Function function3) {
            this.m_originals = functionCallInstructionArray;
            this.m_fcis = new FunctionCallInstruction[functionCallInstructionArray.length];
            this.m_types = new Type[functionCallInstructionArray.length];
            this.m_newFunction = function3;
            for (int i = 0; i < functionCallInstructionArray.length; ++i) {
                FunctionCallInstruction functionCallInstruction = functionCallInstructionArray[i];
                if (functionCallInstruction == null) continue;
                this.m_fcis[i] = (FunctionCallInstruction)functionCallInstruction.cloneReduced();
                TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
                BindingEnvironment bindingEnvironment = function2.getBindingEnvironment();
                this.m_fcis[i].setChildInstruction(1, NavigationUtilities.resolveReducedIdentifier(functionCallInstruction.getChildInstruction(1), bindingEnvironment).cloneReduced());
                this.m_types[i] = functionCallInstruction.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
            }
        }
    }
}

