/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMSequenceType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.xci.Cursor;
import java.io.IOException;
import java.util.LinkedList;

public class EqualityInstruction
extends BinaryPrimopInstruction {
    protected boolean m_testInequality;

    public EqualityInstruction() {
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        EqualityInstruction equalityInstruction = new EqualityInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_testInequality);
        EqualityInstruction.propagateInfo(this, equalityInstruction);
        return equalityInstruction;
    }

    public EqualityInstruction(Instruction instruction2, Instruction instruction3, boolean bl) {
        super(instruction2, instruction3);
        this.m_testInequality = bl;
    }

    public boolean isTestingInequality() {
        return this.m_testInequality;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        Type type2 = codeGenerationTracker.resolveType(this.m_operand1);
        Type type3 = codeGenerationTracker.resolveType(this.m_operand2);
        FcgType fcgType = type2.getFCGType(fcgCodeGenHelper);
        FcgType fcgType2 = type3.getFCGType(fcgCodeGenHelper);
        if (fcgType == null || fcgType2 == null) {
            throw new StaticError("ERR_SYSTEM", "Cannot compare values of null type");
        }
        if (fcgType != fcgType2) {
            if (fcgType == FcgType.BIG_DECIMAL) {
                codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
                codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
                fcgInstructionList.convertExpr(fcgType2, FcgType.BIG_DECIMAL);
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
                fcgInstructionList.convertExpr(fcgType, FcgType.BIG_DECIMAL);
                codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
            } else if (fcgType == FcgType.BIG_INTEGER && (fcgType2 == FcgType.DOUBLE || fcgType2 == FcgType.FLOAT) || fcgType2 == FcgType.BIG_INTEGER && (fcgType == FcgType.DOUBLE || fcgType == FcgType.FLOAT)) {
                codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
                fcgInstructionList.convertExpr(fcgType, FcgType.BIG_DECIMAL);
                codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
                fcgInstructionList.convertExpr(fcgType2, FcgType.BIG_DECIMAL);
            } else if (fcgType == FcgType.BIG_INTEGER) {
                codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
                codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
                fcgInstructionList.convertExpr(fcgType2, FcgType.BIG_INTEGER);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
                fcgInstructionList.convertExpr(fcgType, FcgType.BIG_INTEGER);
                codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
            } else if (type2 instanceof INumericalType && type3 instanceof INumericalType) {
                if (type2 instanceof IntType && type3 instanceof DoubleType) {
                    CoerceInstruction.generateCoersion(fcgCodeGenHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, fcgInstructionList);
                    codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
                } else {
                    if (!(type3 instanceof IntType) || !(type2 instanceof DoubleType)) throw new StaticError("ERR_SYSTEM", "Don't know how to compare '" + fcgType.getTypeName() + "' to '" + fcgType2.getTypeName() + "'");
                    CoerceInstruction.generateCoersion(fcgCodeGenHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, fcgInstructionList);
                    codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
                }
            } else {
                fcgInstructionList.comment("AZ: Generic equality comparison");
                CoerceInstruction.generateCoersion(fcgCodeGenHelper, this.m_operand1, CharType.s_charType.getStreamType(), codeGenerationTracker, fcgInstructionList);
                CoerceInstruction.generateCoersion(fcgCodeGenHelper, this.m_operand2, CharType.s_charType.getStreamType(), codeGenerationTracker, fcgInstructionList);
            }
        } else {
            codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
            codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
        }
        if (this.m_testInequality) {
            fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_NE);
            return FcgType.BOOLEAN;
        } else {
            fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        }
        return FcgType.BOOLEAN;
    }

    @Override
    public String innerToString() {
        return this.m_testInequality ? "unequal?" : "equal?";
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object2;
        Object object3;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Cursor cursor2 = null;
        Cursor cursor3 = null;
        Type type2 = this.m_operand1.evaluateType(function2);
        Type type3 = this.m_operand2.evaluateType(function2);
        if (type2 == null || type3 == null) {
            throw new RuntimeException();
        }
        if (type2 instanceof INumericalType && type3 instanceof INumericalType || type2 instanceof BooleanType && type3 instanceof BooleanType) {
            object3 = this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object2 = this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
        } else if (type2 instanceof XDMItemType && type3.equals(CharType.s_charType.getStreamType())) {
            cursor2 = (Cursor)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object3 = cursor2 == null ? null : environment.pushForkForRelease(cursor2.fork(false));
            object2 = ((Object)((IStream)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false))).toString();
        } else if (type2.equals(CharType.s_charType.getStreamType()) && type3 instanceof XDMItemType) {
            object2 = ((Object)((IStream)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false))).toString();
            cursor3 = (Cursor)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
            object3 = cursor3 == null ? null : environment.pushForkForRelease(cursor3.fork(false));
        } else if (type2 instanceof XDMItemType && type3 instanceof INumericalType) {
            cursor2 = (Cursor)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object3 = cursor2 == null ? null : environment.pushForkForRelease(cursor2.fork(false));
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
        } else if (type2 instanceof INumericalType && type3 instanceof XDMItemType) {
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
            cursor3 = (Cursor)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
            object3 = cursor3 == null ? null : environment.pushForkForRelease(cursor3.fork(false));
        } else if (type3.equals(CharType.s_charType.getStreamType()) && type2.equals(CharType.s_charType.getStreamType())) {
            object3 = ((Object)((IStream)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false))).toString();
            object2 = ((Object)((IStream)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false))).toString();
        } else if (type3 instanceof XDMItemType && type2 instanceof XDMItemType) {
            cursor2 = (Cursor)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object3 = cursor2 == null ? null : environment.pushForkForRelease(cursor2.fork(false));
            cursor3 = (Cursor)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
            object2 = cursor3 == null ? null : environment.pushForkForRelease(cursor3.fork(false));
        } else if (type3 instanceof XDMSequenceType && type2 instanceof XDMSequenceType) {
            cursor2 = (Cursor)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object3 = cursor2 == null ? null : environment.pushForkForRelease(cursor2.fork(false));
            cursor3 = (Cursor)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
            object2 = cursor3 == null ? null : environment.pushForkForRelease(cursor3.fork(false));
        } else if (type2.equals(BooleanType.s_booleanType)) {
            object3 = this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, BooleanType.s_booleanType, function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
        } else if (type3.equals(BooleanType.s_booleanType)) {
            object3 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, BooleanType.s_booleanType, function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
            object2 = this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
        } else if (type2 instanceof INumericalType) {
            object3 = this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
        } else if (type3 instanceof INumericalType) {
            object3 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
            object2 = this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
        } else {
            object3 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, CharType.s_charType.getStreamType(), function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
            object3 = ((Object)((IStream)object3)).toString();
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, CharType.s_charType.getStreamType(), function2, this.evaluateBindingEnvironment(function2), iDebuggerInterceptor);
            object2 = ((Object)((IStream)object2)).toString();
        }
        boolean bl2 = BasisLibrary.compare(object3, object2, this.m_testInequality ? 1 : 0);
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)bl3);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2, Instruction instruction3) {
        return new EqualityInstruction(instruction2, instruction3, this.m_testInequality);
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        EqualityInstruction equalityInstruction = (EqualityInstruction)object2;
        return this.m_testInequality == equalityInstruction.m_testInequality;
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeBoolean(this.m_testInequality);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_testInequality = readObjectFileHelper.readBoolean();
    }
}

