/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.IOException;
import java.util.LinkedList;

public class ArithmeticInstruction
extends BinaryPrimopInstruction {
    protected int m_operation;

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_operation = readObjectFileHelper.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_operation);
    }

    public ArithmeticInstruction() {
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (IntType.s_intType.equals(this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList).resolveType(typeEnvironment)) && IntType.s_intType.equals(type2.resolveType(typeEnvironment))) {
            return this.setCachedType(IntType.s_intType);
        }
        return this.setCachedType(DoubleType.s_doubleType);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (IntType.s_intType.equals(this.m_operand1.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment)) && IntType.s_intType.equals(this.m_operand2.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment))) {
            return IntType.s_intType;
        }
        return DoubleType.s_doubleType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        Type type2;
        Type type3 = this.m_operand1.getPreTypecheckType(moduleSignature);
        if (type3 == (type2 = this.m_operand1.getPreTypecheckType(moduleSignature))) {
            if (type3 == IntType.s_intType) {
                return IntType.s_intType;
            }
            if (type3 != null && type3 instanceof PrimitiveNumericalType) {
                return DoubleType.s_doubleType;
            }
            return super.getPreTypecheckType(moduleSignature);
        }
        return super.getPreTypecheckType(moduleSignature);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ArithmeticInstruction arithmeticInstruction = new ArithmeticInstruction(this.m_operation, this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        ArithmeticInstruction.propagateInfo(this, arithmeticInstruction);
        return arithmeticInstruction;
    }

    public ArithmeticInstruction(int n2, Instruction instruction2, Instruction instruction3) {
        super(instruction2, instruction3);
        this.m_operation = n2;
    }

    public int getOperation() {
        return this.m_operation;
    }

    public String getOperationAsString() {
        String string2;
        switch (this.m_operation) {
            case 4: {
                string2 = "+";
                break;
            }
            case 5: {
                string2 = "-";
                break;
            }
            case 30: {
                string2 = "*";
                break;
            }
            case 31: {
                string2 = "/";
                break;
            }
            case 33: {
                string2 = "%";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return string2;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgType fcgType;
        codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
        codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
        switch (this.m_operation) {
            case 4: {
                fcgType = fcgInstructionList.binaryOperationExpr(FcgBinOp.PLUS);
                break;
            }
            case 5: {
                fcgType = fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
                break;
            }
            case 30: {
                fcgType = fcgInstructionList.binaryOperationExpr(FcgBinOp.MULTIPLY);
                break;
            }
            case 31: {
                fcgType = fcgInstructionList.binaryOperationExpr(FcgBinOp.DIVIDE);
                break;
            }
            case 33: {
                fcgType = fcgInstructionList.binaryOperationExpr(FcgBinOp.MODULO);
                break;
            }
            default: {
                throw new StaticError("ERR_SYSTEM", "Arithmetic Instruction does not support op " + this.m_operation);
            }
        }
        return fcgType;
    }

    public int getOperationAsXylemOpcode() {
        int n2;
        switch (this.m_operation) {
            case 4: {
                n2 = 0;
                break;
            }
            case 5: {
                n2 = 1;
                break;
            }
            case 30: {
                n2 = 2;
                break;
            }
            case 31: {
                n2 = 3;
                break;
            }
            case 33: {
                n2 = 4;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return n2;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        BindingEnvironment bindingEnvironment = this.evaluateBindingEnvironment(function2);
        Type type2 = this.m_operand1.evaluateType(function2);
        Type type3 = this.m_operand2.evaluateType(function2);
        Object object2 = this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
        Object object3 = this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
        if (!(type2 instanceof INumericalType && type3 instanceof INumericalType && type2.equals(type3, function2.getTypeEnvironment()))) {
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function2, bindingEnvironment, iDebuggerInterceptor);
            object3 = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function2, bindingEnvironment, iDebuggerInterceptor);
            type2 = DoubleType.s_doubleType;
        }
        int n2 = this.getOperationAsXylemOpcode();
        Object object4 = ((INumericalType)((Object)type2)).evaluateOperation(environment, object2, object3, n2);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object4);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("arithmetic", n2);
        prettyPrinter.printToken(this.getOperationAsString(), n2 + 1);
        this.m_operand1.toString(prettyPrinter, n2 + 1);
        this.m_operand2.toString(prettyPrinter, n2 + 1);
        prettyPrinter.printFormClose(n2);
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        ArithmeticInstruction arithmeticInstruction = (ArithmeticInstruction)object2;
        return arithmeticInstruction.m_operation == this.m_operation;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2, Instruction instruction3) {
        return new ArithmeticInstruction(this.m_operation, instruction2, instruction3);
    }
}

