/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XDMTypeUpdater;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionReader;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionRecord;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.ModuleRecord;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverlapDetector {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetector.class);
    private static final String s_className = OverlapDetector.class.getName();

    public static void main(String[] stringArray) {
        Module module;
        Object object2;
        String[] stringArray2;
        SessionContext sessionContext = new SessionContext();
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        xSLTLinkerSettings.setOverlapDetection(true);
        xSLTLinkerSettings.setOverlapDetectionArgLast(true);
        if (stringArray.length == 0) {
            s_logger.logp(Level.WARNING, s_className, "main", "Usage: OverlapDetectionXSLTLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2 = stringArray[n2];
            if (stringArray2.equals("-split")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                    return;
                }
                xSLTCompilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n2++]));
                continue;
            }
            if (stringArray2.equals("-newsplit")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-newsplit requires parameter");
                    return;
                }
                xSLTLinkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(Integer.parseInt(stringArray[n2++]));
                continue;
            }
            if (stringArray2.equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n2;
                continue;
            }
            if (stringArray2.equals("-disablejavac")) {
                xSLTLinkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++n2;
                continue;
            }
            if (stringArray2.equals("-generateBCEL")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(4);
                ++n2;
                continue;
            }
            if (stringArray2.equals("-suppressComments")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++n2;
                continue;
            }
            if (!stringArray2.equals("-command")) break;
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                return;
            }
            try {
                String string2;
                object2 = new ArrayList();
                FileReader fileReader = new FileReader(stringArray[n2]);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    ((ArrayList)object2).add(string2);
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not read command file " + stringArray[n2], iOException);
                return;
            }
            stringArray = ((ArrayList)object2).toArray(stringArray);
            n2 = 0;
            break;
        }
        if ((stringArray.length - n2) % 2 != 0) {
            throw new StaticError("ERR_SYSTEM", "Uneven args starting at " + stringArray[n2]);
        }
        stringArray2 = new String[(stringArray.length - n2) / 2];
        object2 = new File[stringArray2.length];
        for (int i = 0; i < stringArray.length - n2; i += 2) {
            object2[i / 2] = new File(stringArray[i + n2]);
            stringArray2[i / 2] = stringArray[i + n2 + 1];
        }
        try {
            module = XSLTCompiler.loadRuntimeLibrary(false);
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", exception);
            throw new RuntimeException();
        }
        OverlapDetector.detectOverlapAndLink(module, stringArray2, (File[])object2, xSLTCompilerSettings, xSLTLinkerSettings, sessionContext);
    }

    public static void detectOverlapAndLink(Module module, String[] stringArray, File[] fileArray, XSLTCompilerSettings xSLTCompilerSettings, XSLTLinkerSettings xSLTLinkerSettings, SessionContext sessionContext) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        FunctionReader functionReader = new FunctionReader();
        try {
            functionReader.readFunctions(stringArray, fileArray, hashMap, hashMap2);
            Module module2 = new Module(stringArray[0], null, new ModuleSignature(""));
            XDMTypeUpdater[] xDMTypeUpdaterArray = OverlapDetector.mergeXDMTables(module2, stringArray, hashMap2);
            AutoFunctorizingXSLTLinker.Statistics statistics = new AutoFunctorizingXSLTLinker.Statistics(stringArray);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "detectOverlapAndLink", "Detecting overlap");
            }
            OverlapDetector.detectOverlap(module2, hashMap, hashMap2, xDMTypeUpdaterArray, functionReader, statistics);
            statistics.summarize();
            functionReader.finish();
            module2.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", module.m_signature, "xslt1"));
            AutoFunctorizingXSLTLinker.handleStandardExports(module2);
            Iterator iterator = hashMap2.values().iterator();
            while (iterator.hasNext()) {
                ((ModuleRecord)iterator.next()).m_rofh.close();
            }
            hashMap2 = null;
            hashMap = null;
            module2.clearTypeInformation(true);
            module2.removeFunctionDerivativeInformation();
            ParamReferenceIdentifier.fixParamReferences(module2);
            functionReader = null;
            XSLTCompiler.postASTProcessing(module2, null, xSLTCompilerSettings.getPrereductionSplitLimit(), xSLTCompilerSettings.isStreamResultOnly());
            XSLTLinker.s_linker.compileProgram(module2, module, stringArray.length, Arrays.asList(stringArray), module2.getName(), xSLTLinkerSettings, sessionContext);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "detectOverlapAndLink", "Done");
            }
        }
        catch (Throwable throwable) {
            s_logger.logp(Level.SEVERE, s_className, "detectOverlapAndLink", "", throwable);
            if (functionReader != null) {
                functionReader.forceFinish();
            }
            throw new RuntimeException();
        }
    }

    private static XDMTypeUpdater[] mergeXDMTables(Module module, String[] stringArray, HashMap hashMap) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String[] stringArray2;
        XDMTypeUpdater[] xDMTypeUpdaterArray = new XDMTypeUpdater[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = (String[])hashMap.get(stringArray[i]);
            object5 = stringArray2.m_names;
            object4 = stringArray2.m_uris;
            object3 = stringArray2.m_types;
            object2 = new int[((String[])object5).length];
            for (int j = 0; j < ((String[])object5).length; ++j) {
                object2[j] = -1;
                for (int k = 0; k < arrayList.size(); ++k) {
                    if (!XSLTLinker.areStringRefsEqual(arrayList.get(k), object5[j]) || !XSLTLinker.areStringRefsEqual(arrayList2.get(k), object4[j]) || !arrayList3.get(k).equals(new Integer(object3[j]))) continue;
                    object2[j] = k;
                    break;
                }
                if (object2[j] != -1) continue;
                object2[j] = arrayList.size();
                arrayList.add(object5[j]);
                arrayList2.add(object4[j]);
                arrayList3.add(new Integer(object3[j]));
            }
            xDMTypeUpdaterArray[stringArray2.m_index] = new XDMTypeUpdater();
            xDMTypeUpdaterArray[stringArray2.m_index].m_newIndices = object2;
        }
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        stringArray2 = new String[arrayList2.size()];
        arrayList2.toArray(stringArray2);
        object5 = XSLTLinker.makeStringArrayBody(stringArray3);
        object4 = XSLTLinker.makeStringArrayBody(stringArray2);
        object3 = XSLTLinker.makeIntArrayBody(arrayList3);
        try {
            Function function2 = new Function("xdm-names", new Binding[0], (Instruction)object5);
            object2 = function2;
            module.addFunction(function2);
            ((Function)object2).typeCheck(module, null, new LinkedList());
            module.forceFunctionGeneration((Function)object2);
            object2 = new Function("xdm-uris", new Binding[0], (Instruction)object4);
            module.addFunction((Function)object2);
            ((Function)object2).typeCheck(module, null, new LinkedList());
            module.forceFunctionGeneration((Function)object2);
            object2 = new Function("xdm-types", new Binding[0], (Instruction)object3);
            module.addFunction((Function)object2);
            ((Function)object2).typeCheck(module, null, new LinkedList());
            module.forceFunctionGeneration((Function)object2);
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "mergeXDMTables", "", exception);
            throw new Error();
        }
        return xDMTypeUpdaterArray;
    }

    public static void detectOverlap(Module module, HashMap hashMap, HashMap hashMap2, XDMTypeUpdater[] xDMTypeUpdaterArray, FunctionReader functionReader, AutoFunctorizingXSLTLinker.Statistics statistics) throws Exception {
        Object object2;
        Object object32;
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object32 : hashMap.keySet()) {
            object2 = ((FunctionSignature)object32).getFunctionName();
            int n2 = 0;
            while (hashSet.contains(object2)) {
                object2 = (String)object2 + "$" + ++n2;
            }
            hashMap3.put(object32, (String)object2);
            hashSet.add(object2);
        }
        object32 = new ArrayList(hashMap.keySet());
        Collections.sort(object32, FunctionComparator.CMP);
        Iterator<Object> iterator = ((ArrayList)object32).iterator();
        block2: while (iterator.hasNext()) {
            Object object4;
            Object object5;
            object2 = (FunctionSignature)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(object2);
            Iterator iterator2 = arrayList.iterator();
            Instruction[] instructionArray = new Instruction[arrayList.size()];
            Function[] functionArray = new Function[arrayList.size()];
            int[] nArray = new int[arrayList.size()];
            int n3 = 0;
            while (iterator2.hasNext()) {
                object5 = (FunctionRecord)iterator2.next();
                Function function2 = null;
                function2 = functionReader.getFunction((FunctionRecord)object5);
                if (function2.getName().equals("main")) {
                    function2.setName("main-functor");
                } else if (!(function2.getName().equals("setupOutput") || function2.getName().equals("whitespaceRules") || function2.getName().equals("setupCharacterMaps") || function2.getName().equals("get-ns-prefix-counter"))) {
                    if (((FunctionRecord)object5).m_exported) {
                        if (module.getFunction(function2.getName()) != null) continue block2;
                        module.addFunction(function2);
                        module.forceFunctionGeneration(function2);
                        continue block2;
                    }
                    function2.setName((String)hashMap3.get(((FunctionRecord)object5).m_signature));
                }
                object4 = (ModuleRecord)hashMap2.get(((FunctionRecord)object5).m_moduleName);
                nArray[n3] = object4.m_index;
                xDMTypeUpdaterArray[object4.m_index].optimizeFunction(function2);
                new TailRecursiveOptimizer((ModuleRecord)object4, hashMap3){
                    final /* synthetic */ ModuleRecord val$mr;
                    final /* synthetic */ HashMap val$unifiedFunctionNameMap;
                    {
                        this.val$mr = moduleRecord;
                        this.val$unifiedFunctionNameMap = hashMap;
                    }

                    @Override
                    protected Instruction optimizeStep2(Instruction instruction2) {
                        if (instruction2 instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                            FunctionSignature functionSignature = (FunctionSignature)this.val$mr.m_functionNames.get(functionCallInstruction.getFunction());
                            String string2 = (String)this.val$unifiedFunctionNameMap.get(functionSignature);
                            Instruction[] instructionArray = new Instruction[instruction2.getChildInstructionCount() + 1];
                            System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 0, functionCallInstruction.m_parameters.length);
                            instructionArray[functionCallInstruction.m_parameters.length] = new IdentifierInstruction("__functorindex__");
                            functionCallInstruction.m_parameters = instructionArray;
                            functionCallInstruction.setFunction(string2);
                        }
                        return instruction2;
                    }
                }.optimizeFunction(function2);
                functionArray[n3] = function2;
                instructionArray[n3++] = function2.getBody();
            }
            object5 = functionArray[0];
            boolean bl = false;
            if (((Function)object5).getName().equals("build_key")) {
                bl = true;
            }
            object4 = new Binding[((Function)object5).m_parameters.length + 1];
            System.arraycopy(((Function)object5).m_parameters, 0, object4, 0, ((Function)object5).m_parameters.length);
            object4[((Function)object5).m_parameters.length] = new Binding((Object)"__functorindex__", IntType.s_intType);
            ((Function)object5).m_parameters = object4;
            int[] nArray2 = new int[1];
            Instruction instruction2 = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(instructionArray, true, module, (Function)object5, nArray, hashMap2.size(), bl, nArray2);
            statistics.add((FunctionSignature)object2, nArray, nArray2[0]);
            ((Function)object5).setBody(instruction2);
            module.addFunction((Function)object5);
        }
    }
}

