/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

public class OverlapDetectionXSLTCompiler {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTCompiler.class);
    private static final String s_className = OverlapDetectionXSLTCompiler.class.getName();

    public static void main(String[] stringArray) {
        SessionContext sessionContext = new SessionContext();
        CLP cLP = new CLP();
        if (!cLP.parseCommandLine(stringArray)) {
            return;
        }
        try {
            Module module = XSLTCompiler.loadRuntimeLibrary(false);
            for (int i = 0; i < cLP.m_inputFiles.size(); ++i) {
                URL uRL = (URL)cLP.m_inputFiles.get(i);
                Module module2 = OverlapDetectionXSLTCompiler.compileIndividualModule(uRL, module, cLP.m_settings);
                module2.removeDeadFunctions();
                File file = (File)cLP.m_outputFiles.get(i);
                if (cLP.m_dumpXylem) {
                    File file2 = new File(file.getAbsolutePath() + ".xylem");
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "main", "Xylem dump being written to file " + file2);
                    }
                    PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                    module2.dump(printWriter);
                    printWriter.close();
                }
                ParamReferenceIdentifier.createParamReferences(module2);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Writing file " + file.getAbsolutePath());
                }
                OverlapDetectionXSLTCompiler.writeIndividualModule(module2, file, sessionContext);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", exception);
        }
    }

    public static Module compileIndividualModule(URL uRL, Module module, XSLTCompilerSettings xSLTCompilerSettings, SourceLoader sourceLoader, boolean bl) throws Exception {
        Object object2;
        InputSource inputSource;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "compileIndividualModule", "Compiling stylesheet: " + uRL);
        }
        XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings);
        if (null != sourceLoader) {
            xSLTCompiler.setSourceLoader(sourceLoader);
        }
        xSLTCompiler.setRuntimeLibrary(module);
        if (null != sourceLoader && bl) {
            inputSource = sourceLoader.loadSource("", uRL.toString(), null);
        } else {
            object2 = uRL.openStream();
            inputSource = new InputSource((InputStream)object2);
            inputSource.setSystemId(uRL.toString());
        }
        object2 = xSLTCompiler.buildAST(inputSource, uRL.toString());
        Module module2 = xSLTCompiler.translate((XTQProgram)object2);
        module2.typeCheck(false);
        return module2;
    }

    public static Module compileIndividualModule(URL uRL, Module module, XSLTCompilerSettings xSLTCompilerSettings) throws Exception {
        return OverlapDetectionXSLTCompiler.compileIndividualModule(uRL, module, xSLTCompilerSettings, null, false);
    }

    public static void writeIndividualModule(Module module, File file, SessionContext sessionContext) throws Exception {
        Object object2;
        Object object3;
        ArrayList<Function> arrayList = new ArrayList<Function>(module.getFunctions());
        Collections.sort(arrayList, FunctionComparator.CMP);
        Iterator<Object> iterator = arrayList.iterator();
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final HashMap hashMap = new HashMap();
        ArrayList<Record> arrayList2 = new ArrayList<Record>();
        String[] stringArray = new ObjectOutputStream(byteArrayOutputStream);
        WriteObjectFileHelper writeObjectFileHelper = new WriteObjectFileHelper(module, (ObjectOutput)stringArray){

            @Override
            public void writeInstructionTag(Instruction instruction2) throws IOException {
                Integer n2 = (Integer)hashMap.get(instruction2.getClass());
                if (n2 == null) {
                    n2 = new Integer(hashMap.size());
                    hashMap.put(instruction2.getClass(), n2);
                }
                this.writeInt(n2);
                this.writeType(instruction2.getCachedType());
            }
        };
        while (iterator.hasNext()) {
            int n2 = byteArrayOutputStream.size();
            object3 = iterator.next();
            object2 = new FunctionSignature((Function)object3);
            boolean bl = module.m_signature.containsFunction(((Function)object3).getName());
            if (((Function)object3).isDerivative()) {
                ((FunctionSignature)object2).setFunctionName(((Function)object3).getOriginalFunction().getName());
            }
            if (((Function)object3).getName().equals("xdm-names")) {
                object4 = object3;
                continue;
            }
            if (((Function)object3).getName().equals("xdm-uris")) {
                object5 = object3;
                continue;
            }
            if (((Function)object3).getName().equals("xdm-types")) {
                object6 = object3;
                continue;
            }
            ((Function)object3).write(writeObjectFileHelper);
            int n3 = byteArrayOutputStream.size();
            Record record = new Record((FunctionSignature)object2, n2, n3 - n2, ((Function)object3).getName(), bl);
            arrayList2.add(record);
        }
        writeObjectFileHelper.close();
        byteArrayOutputStream.close();
        stringArray = XSLTLinker.retrieveXDMStringArray(object4, sessionContext);
        writeObjectFileHelper = XSLTLinker.retrieveXDMStringArray(object5, sessionContext);
        int[] nArray = XSLTLinker.retrieveXDMIntArray(object6, sessionContext);
        object3 = new ByteArrayOutputStream();
        object2 = new ObjectOutputStream((OutputStream)object3);
        Object object7 = new WriteObjectFileHelper(module, (ObjectOutput)object2);
        ((WriteObjectFileHelper)object7).writeObject(stringArray);
        ((WriteObjectFileHelper)object7).writeObject(writeObjectFileHelper);
        ((WriteObjectFileHelper)object7).writeObject(nArray);
        ((WriteObjectFileHelper)object7).writeInt(arrayList2.size());
        for (Record record : arrayList2) {
            ((WriteObjectFileHelper)object7).writeInt(record.m_offset);
            ((WriteObjectFileHelper)object7).writeInt(record.m_size);
            ((WriteObjectFileHelper)object7).writeString(record.m_originalName);
            ((WriteObjectFileHelper)object7).writeBoolean(record.m_exported);
            record.m_signature.write((WriteObjectFileHelper)object7);
        }
        ((ObjectOutputStream)object2).writeInt(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            ((ObjectOutputStream)object2).writeObject(entry.getValue());
            ((ObjectOutputStream)object2).writeObject(entry.getKey());
        }
        ((WriteObjectFileHelper)object7).close();
        object2 = new FileOutputStream(file);
        object7 = new DataOutputStream((OutputStream)object2);
        byte[] byArray = ((ByteArrayOutputStream)object3).toByteArray();
        ((DataOutputStream)object7).writeInt(byArray.length);
        ((DataOutputStream)object7).flush();
        ((FileOutputStream)object2).write(byArray);
        ((FileOutputStream)object2).write(byteArrayOutputStream.toByteArray());
        ((FilterOutputStream)object7).close();
    }

    static class Record {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        boolean m_exported;

        Record(FunctionSignature functionSignature, int n2, int n3, String string2, boolean bl) {
            this.m_signature = functionSignature;
            this.m_offset = n2;
            this.m_size = n3;
            this.m_originalName = string2;
            this.m_exported = bl;
        }
    }

    private static class CLP
    extends CommandLineParserSingleInputFile {
        ArrayList m_inputFiles = new ArrayList();
        ArrayList m_outputFiles = new ArrayList();
        XSLTCompilerSettings m_settings = new XSLTCompilerSettings();
        boolean m_dumpXylem = false;

        private CLP() {
        }

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: OverlapDetectionXSLTCompiler\n  [-help | -h | -?]          Prints this message\n  [-command commandfile]     Specifies a newline-delimited file with command line args\n  [-version | -showversion]  Prints the Xylem compiler version\n  [-xslt-version 1.0|2.0]    Specifies the version of XSLT to use\n  [-traceserialization]      Makes the translet insert diagnostic PIs into its output\n  [-dumpxylem]               Dumps out generated Xylem IL\n  [-traceimportsandincludes] Prints out the names/sizes of imported/included stylesheets\n  (input.xsl output.o)+      Compiles input.xsl into output.o\n");
                return -1;
            }
            if ("-command".equals(stringArray[n2])) {
                if (n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(stringArray[++n2])) {
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-xslt-version")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                this.m_settings.setVersion(stringArray[n2]);
                if (!stringArray[n2].equals("1.0") && !stringArray[n2].equals("2.0")) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid version: " + stringArray[n2]);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (stringArray[n2].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return n2;
            }
            if (stringArray[n2].equals("-dumpxylem")) {
                this.m_dumpXylem = true;
                return n2;
            }
            if (stringArray[n2].equals("-traceserialization")) {
                this.m_settings.setSerializationTraceEnabled(true);
                return n2;
            }
            if (stringArray[n2].equals("-traceimportsandincludes")) {
                this.m_settings.setTraceImportsAndIncludes(true);
                return n2;
            }
            if (n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "input filename " + stringArray[n2 - 1] + " missing corrsponding output filename");
                return -1;
            }
            this.m_inputFile = this.validateInputFilename(stringArray[n2], false);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_inputFiles.add(this.m_inputFile);
            this.m_outputFiles.add(new File(stringArray[++n2]));
            return n2;
        }
    }
}

