/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XylemXSLTC;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.OverlapDetectionXSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.OverlapDetector;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverlapDetectionXSLTC
extends XylemXSLTC {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTC.class);
    private static final String s_className = OverlapDetectionXSLTC.class.getName();

    public static void main(String[] stringArray) {
        Serializable serializable;
        SessionContext sessionContext = new SessionContext();
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        final boolean[] blArray3 = new boolean[1];
        s_classes = new ArrayList();
        s_resources = new ArrayList();
        XylemXSLTC.XylemXSLTCommandLineParser xylemXSLTCommandLineParser = new XylemXSLTC.XylemXSLTCommandLineParser(){

            @Override
            protected int parseOption(String[] stringArray, int n2) {
                if (stringArray[n2].equals("-nocompile")) {
                    blArray2[0] = true;
                } else if (stringArray[n2].equals("-nolink")) {
                    blArray[0] = true;
                } else if (stringArray[n2].equals("-nocleanxo")) {
                    blArray3[0] = true;
                } else {
                    if (stringArray[n2].equals("-help")) {
                        super.parseOption(stringArray, n2);
                        System.out.println("                  [-nocompile]");
                        System.out.println("                  [-noclean]");
                        System.out.println("                  [-nolink]");
                        return -1;
                    }
                    return super.parseOption(stringArray, n2);
                }
                return n2;
            }
        };
        if (!xylemXSLTCommandLineParser.parseCommandLine(stringArray)) {
            return;
        }
        xylemXSLTCommandLineParser.m_linkerSettings.setOverlapDetection(true);
        xylemXSLTCommandLineParser.m_linkerSettings.setOverlapDetectionArgLast(true);
        if (xylemXSLTCommandLineParser.m_files.size() != xylemXSLTCommandLineParser.m_classNames.size()) {
            String string2 = "missing file or classname argument. Got" + xylemXSLTCommandLineParser.m_files.size() + " files, and " + xylemXSLTCommandLineParser.m_classNames.size() + " classnames )";
            s_logger.logp(Level.SEVERE, s_className, "main", string2);
            throw new RuntimeException(string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<File> arrayList = new ArrayList<File>(xylemXSLTCommandLineParser.m_files.size());
        for (int i = 0; i < xylemXSLTCommandLineParser.m_classNames.size(); ++i) {
            String string3 = (String)xylemXSLTCommandLineParser.m_classNames.get(i);
            serializable = new File(xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), string3 + ".xo");
            arrayList.add((File)serializable);
            if (hashSet.add(string3)) continue;
            String string4 = "Duplicate classname '" + string3 + "' in command line";
            s_logger.logp(Level.SEVERE, s_className, "main", string4);
            throw new RuntimeException(string4);
        }
        try {
            Module module = XSLTCompiler.loadRuntimeLibrary(false);
            if (!blArray2[0]) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Phase I: Compiling individual stylesheets...");
                }
                for (int i = 0; i < xylemXSLTCommandLineParser.m_files.size(); ++i) {
                    serializable = (URL)xylemXSLTCommandLineParser.m_files.get(i);
                    File file = (File)arrayList.get(i);
                    Module module2 = OverlapDetectionXSLTCompiler.compileIndividualModule((URL)serializable, module, xylemXSLTCommandLineParser.m_compilerSettings, s_sourceLoader, s_topResolve);
                    module2.removeDeadFunctions();
                    String string5 = (String)xylemXSLTCommandLineParser.m_classNames.get(i);
                    if (xylemXSLTCommandLineParser.m_linkerSettings.isDumpXylem()) {
                        Program.dumpXylemFile(module2, xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), string5);
                    }
                    ParamReferenceIdentifier.createParamReferences(module2);
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "main", "Writing temp-file file " + file);
                    }
                    OverlapDetectionXSLTCompiler.writeIndividualModule(module2, file, sessionContext);
                }
            }
            if (!blArray[0]) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Phase II: Detect Overlap and Link");
                }
                OverlapDetector.detectOverlapAndLink(module, xylemXSLTCommandLineParser.m_classNames.toArray(new String[0]), arrayList.toArray(new File[0]), xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, sessionContext);
            }
            if (xylemXSLTCommandLineParser.m_jarFileName != null) {
                try {
                    OverlapDetectionXSLTC.outputToJar(xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), xylemXSLTCommandLineParser.m_jarFileName);
                }
                catch (IOException iOException) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "IOException outputting jar file", iOException);
                    System.exit(-1);
                }
            }
        }
        catch (Throwable throwable) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", throwable);
            throw new RuntimeException(throwable.getMessage());
        }
        finally {
            if (!blArray3[0]) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "cleaning up temp files ...");
                }
                for (File file : arrayList) {
                    try {
                        if (file.delete()) continue;
                        throw new RuntimeException();
                    }
                    catch (Exception exception) {
                        s_logger.logp(Level.SEVERE, s_className, "main", "could not delete " + file);
                    }
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
    }
}

