/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof;

import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.FunctionRecord;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.autof.ModuleRecord;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xml.ras.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FunctionReader {
    private static final boolean VERIFY = false;
    private static final Logger s_logger = LoggerUtil.getLogger(FunctionReader.class);
    private static final String s_className = FunctionReader.class.getName();
    List m_functionRecords = new LinkedList();
    HashMap m_moduleMap = new HashMap();
    ModuleRecord[] m_moduleRecords;
    private static final int INITIAL_HIGH_WATER = 0x100000;
    private static final int REFILL_STORE_FACTOR = 10;
    private FunctionStore m_store;
    Thread m_readerThread;
    private ArrayList[] m_functionsToRead;

    public void readFunctions(String[] stringArray, File[] fileArray, HashMap hashMap, HashMap hashMap2) throws Exception {
        this.m_moduleMap = hashMap2;
        this.m_moduleRecords = new ModuleRecord[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            this.readIndividualModule(i, stringArray[i], fileArray[i], hashMap);
        }
        this.m_store = new FunctionStore(0x100000);
        Collections.sort(this.m_functionRecords, FunctionComparator.CMP);
        this.m_readerThread = new Thread(new Reader());
        this.m_readerThread.start();
    }

    public final Function getFunction(FunctionRecord functionRecord) {
        return this.m_store.getStoredFunction(functionRecord);
    }

    private void refillStore() {
        ModuleRecord moduleRecord;
        int n2;
        Object[] objectArray = this.m_store.waitUntilEmptyOrRequired();
        FunctionRecord functionRecord = (FunctionRecord)objectArray[0];
        int n3 = (Integer)objectArray[1];
        Iterator iterator = this.m_functionRecords.iterator();
        if (this.m_functionsToRead == null) {
            this.m_functionsToRead = new ArrayList[this.m_moduleRecords.length];
            for (n2 = 0; n2 < this.m_functionsToRead.length; ++n2) {
                this.m_functionsToRead[n2] = new ArrayList();
            }
        }
        while (iterator.hasNext()) {
            FunctionRecord functionRecord2 = (FunctionRecord)iterator.next();
            moduleRecord = (ModuleRecord)this.m_moduleMap.get(functionRecord2.m_moduleName);
            if ((n3 -= functionRecord2.m_size) < 0 && functionRecord == null) break;
            this.m_functionsToRead[moduleRecord.m_index].add(functionRecord2);
            if (functionRecord2 == functionRecord) {
                functionRecord = null;
            }
            iterator.remove();
        }
        for (n2 = 0; n2 < this.m_moduleRecords.length; ++n2) {
            moduleRecord = this.m_moduleRecords[n2];
            for (FunctionRecord functionRecord3 : this.m_functionsToRead[n2]) {
                Function function2 = new Function();
                try {
                    function2.read(moduleRecord.m_rofh);
                    FunctionSignature functionSignature = new FunctionSignature(function2);
                    functionSignature.setFunctionName(functionRecord3.m_signature.getFunctionName());
                }
                catch (Exception exception) {
                    s_logger.logp(Level.SEVERE, s_className, "refillStore", "error encountered reading '" + functionRecord3 + "' : ", exception);
                    throw new RuntimeException();
                }
                this.m_store.saveFunction(functionRecord3, function2);
            }
            this.m_functionsToRead[n2].clear();
        }
    }

    public void readIndividualModule(int n2, String string2, File file, HashMap hashMap) throws Exception {
        Object object2;
        int n3;
        InputStream inputStream = new FileInputStream(file);
        inputStream = new BufferedInputStream(inputStream, 0x100000);
        int[] nArray = new int[1];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ModuleRecord moduleRecord = new ModuleRecord();
        moduleRecord.m_baseOffset = dataInputStream.readInt() + 4;
        ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream, new ModuleSignatureStore(Collections.EMPTY_LIST));
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "readIndividualModule", "reading xdm tables ...");
        }
        moduleRecord.m_names = (String[])readObjectFileHelper.readObject();
        moduleRecord.m_uris = (String[])readObjectFileHelper.readObject();
        moduleRecord.m_types = (int[])readObjectFileHelper.readObject();
        moduleRecord.m_functionNames = new HashMap();
        int n4 = readObjectFileHelper.readInt();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "readIndividualModule", "reading " + n4 + " function records ");
        }
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = new FunctionRecord();
            ((FunctionRecord)object2).m_offset = readObjectFileHelper.readInt();
            ((FunctionRecord)object2).m_size = readObjectFileHelper.readInt();
            ((FunctionRecord)object2).m_originalName = readObjectFileHelper.readString();
            ((FunctionRecord)object2).m_exported = readObjectFileHelper.readBoolean();
            ((FunctionRecord)object2).m_signature = new FunctionSignature();
            ((FunctionRecord)object2).m_signature.read(readObjectFileHelper);
            ((FunctionRecord)object2).m_moduleName = string2;
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(((FunctionRecord)object2).m_signature);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(((FunctionRecord)object2).m_signature, arrayList);
            }
            arrayList.add(object2);
            moduleRecord.m_functionNames.put(((FunctionRecord)object2).m_originalName, ((FunctionRecord)object2).m_signature);
            this.m_functionRecords.add(object2);
        }
        n3 = objectInputStream.readInt();
        object2 = new HashMap();
        for (int i = 0; i < n3; ++i) {
            Integer n5 = (Integer)objectInputStream.readObject();
            Class clazz = (Class)objectInputStream.readObject();
            ((HashMap)object2).put(n5, clazz);
        }
        ObjectInputStream objectInputStream2 = new ObjectInputStream(inputStream);
        moduleRecord.m_rofh = readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream2, new ModuleSignatureStore(Collections.EMPTY_LIST), (HashMap)object2, nArray){
            final /* synthetic */ HashMap val$instructionNames;
            final /* synthetic */ int[] val$filePosition;
            {
                this.val$instructionNames = hashMap;
                this.val$filePosition = nArray;
                super(iTypeStore, objectInput, moduleSignatureStore);
            }

            @Override
            public Instruction readInstruction(BindingEnvironment bindingEnvironment) throws Exception {
                int n2 = this.readInt();
                Class clazz = (Class)this.val$instructionNames.get(new Integer(n2));
                if (clazz == null) {
                    s_logger.logp(Level.SEVERE, s_className, "readInstruction", "instruction class not found for " + Integer.toHexString(n2) + " at " + Integer.toHexString(this.val$filePosition[0]));
                }
                try {
                    Instruction instruction2 = (Instruction)clazz.newInstance();
                    instruction2.setCachedType(this.readType());
                    instruction2.read(this, bindingEnvironment);
                    return instruction2;
                }
                catch (Exception exception) {
                    s_logger.logp(Level.SEVERE, s_className, "readInstruction", "could not read class " + clazz, exception);
                    throw new Error();
                }
            }
        };
        moduleRecord.m_index = n2;
        this.m_moduleRecords[n2] = moduleRecord;
        this.m_moduleMap.put(string2, moduleRecord);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "readIndividualModule", "done.");
        }
    }

    private void cleanUp() {
        if (!this.m_functionRecords.isEmpty()) {
            this.m_functionRecords = null;
            this.m_store = null;
            this.m_functionsToRead = null;
            this.m_moduleMap = null;
        }
        this.m_readerThread = null;
    }

    public void finish() {
        if (this.m_readerThread != null && this.m_readerThread.isAlive()) {
            try {
                this.m_readerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void forceFinish() {
        if (this.m_readerThread != null) {
            this.m_readerThread.interrupt();
        }
        this.m_readerThread = null;
    }

    class Reader
    implements Runnable {
        Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!FunctionReader.this.m_functionRecords.isEmpty()) {
                    FunctionReader.this.refillStore();
                }
            }
            catch (Throwable throwable) {
                FunctionReader.this.m_readerThread = null;
                FunctionStore functionStore = FunctionReader.this.m_store;
                synchronized (functionStore) {
                    ((FunctionReader)FunctionReader.this).m_store.m_error = true;
                    FunctionReader.this.m_store.notifyAll();
                }
                s_logger.logp(Level.SEVERE, s_className, "run", "exception " + throwable + " in FunctionReader", throwable);
                return;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "run", "All functions read storeHighWater=" + ((FunctionReader)FunctionReader.this).m_store.m_storeHighWater);
            }
            FunctionReader.this.cleanUp();
        }
    }

    private static class FunctionStore {
        int m_storeSize = 0;
        boolean m_error = false;
        int m_storeHighWater = 0x100000;
        HashMap m_functionStore = new HashMap(this.m_storeHighWater);
        private FunctionRecord m_required = null;

        public FunctionStore(int n2) {
            this.m_storeHighWater = n2;
        }

        public synchronized Function getStoredFunction(FunctionRecord functionRecord) {
            Function function2 = null;
            while (true) {
                if ((function2 = (Function)this.m_functionStore.remove(functionRecord)) != null) {
                    this.m_storeSize -= functionRecord.m_size;
                    return function2;
                }
                this.m_required = functionRecord;
                if (this.m_error) {
                    throw new RuntimeException();
                }
                try {
                    this.notifyAll();
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException();
                }
            }
        }

        public synchronized void saveFunction(FunctionRecord functionRecord, Function function2) {
            if (this.m_functionStore.put(functionRecord, function2) != null) {
                throw new StaticError("ERR_SYSTEM", "added function " + functionRecord + " twice!");
            }
            this.m_storeSize += functionRecord.m_size;
            if (this.m_storeSize > this.m_storeHighWater) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "saveFunction", "expanded store to " + this.m_storeSize / 1024 + "k to fit " + this.m_functionStore.size() + " functions");
                }
                this.m_storeHighWater = this.m_storeSize;
            }
            if (this.m_required == functionRecord) {
                this.m_required = null;
                this.notifyAll();
            }
        }

        public synchronized Object[] waitUntilEmptyOrRequired() {
            while (this.m_required == null && this.m_storeSize >= this.m_storeHighWater / 10) {
                if (this.m_error) {
                    throw new RuntimeException();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException();
                }
            }
            return new Object[]{this.m_required, new Integer(this.m_storeHighWater - this.m_storeSize)};
        }
    }
}

