/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CaseClause;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ConditionalExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ExtensionExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FLWORExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.KindTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NameTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NodeTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OrderedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.PathExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.QuantifiedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SequenceTypeOperator;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TreatExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeSwitch;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UnorderedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.ast.res.BaseMsg;
import com.ibm.xltxe.rnm1.xtq.xml.types.AggregateType;
import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.AttributeType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ChoiceType;
import com.ibm.xltxe.rnm1.xtq.xml.types.CollectionType;
import com.ibm.xltxe.rnm1.xtq.xml.types.DecimalType;
import com.ibm.xltxe.rnm1.xtq.xml.types.DocumentType;
import com.ibm.xltxe.rnm1.xtq.xml.types.DoubleType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ElementType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ExtendedTypes;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xml.types.UntypedAtomic;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.VisitorBase;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionOperatorTable;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.Translator2Helper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLTC2Helper;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.Function2TypeChecker;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xci.type.SequenceType;
import com.ibm.xml.xci.type.TypeRegistry;
import java.math.BigDecimal;
import javax.xml.namespace.QName;

public class XPath2TypeChecker
extends Function2TypeChecker {
    static final boolean LOG_REWRITES = HiddenOptions.optionValueIs("logRewrites", "on");
    private static final NodeType NULL_NODE = new NodeType(null, -1);
    private static QName dataFunction = new QName("http://www.w3.org/2005/xpath-functions", "data");

    public XPath2TypeChecker(XPathCompiler xPathCompiler) {
        super(xPathCompiler);
    }

    @Override
    public Type visitExpression(Expr expr) throws TypeCheckError {
        switch (expr.getId()) {
            case 0: 
            case 1: {
                break;
            }
            case 40: {
                return this.sequenceExpression(expr);
            }
            case 101: {
                return this.emptySequence(expr);
            }
            case 186: {
                return this.pattern(expr);
            }
            case 187: {
                return this.pathPattern(expr);
            }
            case 83: 
            case 84: {
                return this.slashSlashPattern(expr);
            }
            case 41: {
                break;
            }
            case 188: {
                return this.stepPattern(expr);
            }
            case 5: {
                return this.stringLiteral(expr);
            }
            case 100: {
                return this.variableOrParameterReference(expr);
            }
            case 57: {
                return this.orExpression(expr);
            }
            case 58: {
                return this.andExpression(expr);
            }
            case 53: {
                return this.quantifiedExpression(expr);
            }
            case 42: {
                return this.forExpression(expr);
            }
            case 56: {
                return this.ifExpression(expr);
            }
            case 65: {
                return this.instanceofExpression(expr);
            }
            case 67: {
                return this.castableAsExpression(expr);
            }
            case 59: {
                return this.comparisonExpression(expr);
            }
            case 60: {
                return this.rangeExpression(expr);
            }
            case 61: {
                return this.additiveExpression(expr);
            }
            case 62: {
                return this.multiplicativeExpression(expr);
            }
            case 69: {
                return this.unaryExpression(expr);
            }
            case 63: {
                return this.unionExpression(expr);
            }
            case 64: {
                return this.intersectOrExceptExpression(expr);
            }
            case 82: {
                return this.pathExpression(expr);
            }
            case 85: {
                return this.stepExpression(expr);
            }
            case 68: {
                return this.castAsExpression(expr);
            }
            case 66: {
                return this.treatAsExpression(expr);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 163: 
            case 167: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 178: 
            case 191: {
                break;
            }
            case 97: {
                return this.integerLiteral(expr);
            }
            case 98: {
                return this.decimalLiteral(expr);
            }
            case 99: {
                return this.doubleLiteral(expr);
            }
            case 105: {
                Type type2 = expr.isRootOnSelfNode() ? TypeConstants.NODE : this.visitFunction((FunctionCall)expr);
                return type2;
            }
            case 228: {
                return this.stringLiteral(expr);
            }
            case 102: {
                return this.contextItemExpression(expr);
            }
            case 108: 
            case 157: {
                return this.elementConstructor(expr);
            }
            case 54: {
                return this.typeswitchExpression(expr);
            }
            case 55: {
                break;
            }
            case 103: {
                return this.orderedExpression(expr);
            }
            case 104: {
                return this.unorderedExpression(expr);
            }
            case 74: {
                return this.extensionExpression(expr);
            }
            default: {
                throw new StaticError(expr);
            }
        }
        return null;
    }

    protected Type binaryOperatorExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = this.getOperatorIndex(operatorExpr);
        PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = this._compiler.getOperatorDeclaration(n2);
        return this.standardPolymorphicFunctionCall(polymorphicFunctionDeclaration, operatorExpr, FunctionOperatorTable.getOperatorCategory(n2), n2, true);
    }

    private int getOperatorIndex(OperatorExpr operatorExpr) {
        switch (operatorExpr.getOperatorType()) {
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 3;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 26: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 15;
            }
            case 15: {
                return 17;
            }
            case 16: {
                return 19;
            }
            case 17: {
                return 16;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 1: {
                return 23;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 25;
            }
        }
        return -1;
    }

    protected Type additiveExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    private Type logicalExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = operatorExpr.getOperandCount();
        if (n2 != 2) {
            throw new StaticError(expr);
        }
        Type type2 = this.visitExpression(operatorExpr.getOperand(0));
        Type type3 = this.visitExpression(operatorExpr.getOperand(1));
        int n3 = this.checkEffectiveBooleanValue(type2);
        int n4 = this.checkEffectiveBooleanValue(type3);
        if (n3 == 0 || n4 == 0 || this._compiler.isStaticTyping() && (n3 == 2 || n4 == 2)) {
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH_OP", (Object)operatorExpr.getOperatorChar(), expr);
            throw new StaticError(errorMsg);
        }
        ASTDecorator2.setType(expr, TypeConstants.BOOLEAN);
        return TypeConstants.BOOLEAN;
    }

    protected Type andExpression(Expr expr) throws TypeCheckError {
        return this.logicalExpression(expr);
    }

    protected Type orExpression(Expr expr) throws TypeCheckError {
        return this.logicalExpression(expr);
    }

    protected Type comparisonExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    @Override
    public Type visitFunction(FunctionCall functionCall) throws TypeCheckError {
        if (functionCall instanceof IdOrKeyFunctionCallPattern) {
            return this.idKeyPattern(functionCall);
        }
        return super.visitFunction(functionCall);
    }

    protected Type idKeyPattern(Expr expr) throws TypeCheckError {
        FunctionCall functionCall = (FunctionCall)expr;
        QName qName = functionCall.getFunctionQName();
        if (qName.getLocalPart().equals("id")) {
            this._compiler.setHasIdCall(true);
            int n2 = functionCall.getOperand(0).getId();
            if (functionCall.getOperandCount() == 1 && (n2 == 5 || n2 == 97 || n2 == 98 || n2 == 99 || n2 == 185 || n2 == 100)) {
                Type type2 = this.visitExpression(functionCall.getOperand(0));
                return Type.NODE;
            }
            throw new StaticError(expr);
        }
        int n3 = functionCall.getOperand(1).getId();
        if (functionCall.getOperandCount() == 2 && functionCall.getOperand(0).getId() == 5 && (n3 == 5 || n3 == 97 || n3 == 98 || n3 == 99 || n3 == 185 || n3 == 100)) {
            Type type3 = this.visitExpression(functionCall.getOperand(1));
            return Type.NODE;
        }
        throw new StaticError(expr);
    }

    protected Type multiplicativeExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    protected Type pattern(Expr expr) throws TypeCheckError {
        if (expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1) {
            return this.unionPattern((OperatorExpr)expr);
        }
        throw new StaticError(expr);
    }

    protected Type unionPattern(OperatorExpr operatorExpr) throws TypeCheckError {
        int n2 = operatorExpr.getOperandCount();
        for (int i = 0; i < n2; ++i) {
            this.visitExpression(operatorExpr.getOperand(i));
        }
        return null;
    }

    protected Type pathPattern(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int n2 = pathExpr.getOperandCount();
        if (n2 == 0 && pathExpr.isAbsolute()) {
            return TypeConstants.DOCUMENT;
        }
        Type type2 = null;
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = pathExpr.getOperand(i);
            type2 = this.visitExpression(expr2);
        }
        return type2;
    }

    protected Type pathExpression(Expr expr) throws TypeCheckError {
        Expr expr2;
        PathExpr pathExpr = (PathExpr)expr;
        int n2 = pathExpr.getOperandCount();
        int n3 = pathExpr.isAbsolute() ? 1 : 0;
        Type type2 = null;
        if (n2 == n3 + 1) {
            expr2 = pathExpr.getOperand(n3);
            type2 = this.visitExpression(expr2);
        } else {
            expr2 = pathExpr.getOperand(n3);
            Type type3 = this.visitExpression(expr2);
            for (int i = n3 + 1; i < n2; ++i) {
                Expr expr3 = pathExpr.getOperand(i);
                type2 = this.visitExpression(expr3);
            }
        }
        ASTDecorator2.setType(pathExpr, type2);
        while (this.rewriteSlashSlash(pathExpr)) {
        }
        return type2;
    }

    private boolean rewriteSlashSlash(PathExpr pathExpr) {
        int n2 = pathExpr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr;
            Object object2;
            Expr expr2 = (Expr)pathExpr.jjtGetChild(i);
            if (!this.isStepExpr(expr2, 6)) continue;
            boolean bl = false;
            StepExpr stepExpr = (StepExpr)expr2;
            boolean bl2 = false;
            if (stepExpr.getNodeTest() != null && (object2 = stepExpr.getNodeTest()) instanceof KindTest && ((KindTest)object2).getKindTestType() == 2) {
                bl2 = true;
            }
            if (!bl2) continue;
            object2 = null;
            int n3 = stepExpr.getPredicateCount();
            if (n3 == 0 && i + 1 < n2 && this.isStepExpr(expr = (Expr)pathExpr.jjtGetChild(i + 1), 1)) {
                object2 = (StepExpr)expr;
                int n4 = ((StepExpr)object2).getPredicateCount();
                if (n4 == 0) {
                    bl = true;
                } else {
                    for (int j = 0; j < n4; ++j) {
                        Expr expr3 = ((StepExpr)object2).getPredicateAt(j);
                        Type type2 = ASTDecorator2.getType(expr3);
                        if (this.isNumericType(type2) || this.isFunction(expr3, dataFunction)) continue;
                        VisitForPositionalQueries visitForPositionalQueries = new VisitForPositionalQueries();
                        visitForPositionalQueries.visitTree(expr3);
                        if (visitForPositionalQueries.accessesContextPosition) continue;
                        bl = true;
                    }
                }
            }
            if (!bl) continue;
            if (LOG_REWRITES) {
                System.out.print("Rewriting '//' expression: " + pathExpr.getXQueryString(true) + " to ");
            }
            ((StepExpr)object2).copyTestValues(stepExpr);
            stepExpr.setAxisType((short)2);
            pathExpr.jjtRemoveChild((Node)object2);
            pathExpr.removeNullChildren();
            if (LOG_REWRITES) {
                System.out.println(pathExpr.getXQueryString(true));
            }
            return true;
        }
        return false;
    }

    private boolean isFunction(Expr expr, QName qName) {
        return expr.getId() == 105 && ((FunctionCall)expr).getFunctionQName().equals(qName);
    }

    private boolean isNumericType(Type type2) {
        return type2 instanceof DecimalType || type2 instanceof DoubleType;
    }

    private boolean isStepExpr(Expr expr, int n2) {
        return expr.getId() == 85 && !((StepExpr)expr).isFilterStep() && ((StepExpr)expr).getAxisType() == n2;
    }

    protected Type sequenceExpression(Expr expr) throws TypeCheckError {
        Type type2;
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = operatorExpr.getOperandCount();
        if (n2 == 0) {
            type2 = TypeConstants.EMPTY;
        } else if (n2 == 1) {
            type2 = this.visitExpression(operatorExpr.getOperand(0));
        } else {
            AggregateType aggregateType = new AggregateType();
            for (int i = 0; i < n2; ++i) {
                Expr expr2 = operatorExpr.getOperand(i);
                aggregateType.addType(this.visitExpression(expr2));
            }
            type2 = aggregateType;
        }
        ASTDecorator2.setType(operatorExpr, type2);
        return type2;
    }

    protected Type contextItemExpression(Expr expr) {
        if (this._staticContext.getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when")) {
            String string2 = this._parser.getExprString();
            ErrorMsg errorMsg = new ErrorMsg("ERR_CONTEXTUNDEFINED_USEWHEN", string2.substring(8, string2.length() - 1));
            throw new StaticError(errorMsg);
        }
        XSequenceType xSequenceType = ExtendedTypes.ITEM_ONE;
        ASTDecorator2.setType(expr, xSequenceType);
        return xSequenceType;
    }

    protected Type stepExpression(Expr expr) throws TypeCheckError {
        StepExpr stepExpr = (StepExpr)expr;
        if (stepExpr.isFilterStep()) {
            return this.filterStepExpression(stepExpr);
        }
        return this.axisStepExpression(stepExpr);
    }

    private Type filterStepExpression(StepExpr stepExpr) throws TypeCheckError {
        Expr expr = null;
        try {
            expr = stepExpr.getPrimaryExpr();
        }
        catch (XPath20Exception xPath20Exception) {
            throw new StaticError(stepExpr);
        }
        int n2 = stepExpr.getPredicateCount();
        Type type2 = null;
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            if (n2 > 0) {
                type2 = new XSequenceType(Type.NODE, OccurrenceIndicator.ZERO_OR_MORE);
            }
        } else {
            type2 = this.visitExpression(expr);
            if (n2 > 0) {
                if (type2 instanceof ItemType) {
                    type2 = new XSequenceType((ItemType)type2, OccurrenceIndicator.ZERO_OR_MORE);
                } else if (type2 instanceof CollectionType) {
                    ((CollectionType)type2).setCanBeEmpty(true);
                }
            }
        }
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = stepExpr.getPredicateAt(i);
            this.predicate(expr2);
        }
        ASTDecorator2.setType(stepExpr, type2);
        return type2;
    }

    private Type axisStepExpression(StepExpr stepExpr) throws TypeCheckError {
        NodeType nodeType = this.getTypeForStep(stepExpr, this._compiler);
        int n2 = nodeType.getId();
        stepExpr.setStepNodeType(n2);
        if (n2 == 7) {
            XSLTCHelper.processingInstructionTestRewrite(stepExpr, this._parser);
        }
        if (n2 == 9) {
            XSLTC2Helper.documentTestRewrite(this._parser, stepExpr, this._parser);
        }
        Type type2 = nodeType.getType();
        int n3 = stepExpr.getPredicateCount();
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            // empty if block
        }
        for (int i = 0; i < n3; ++i) {
            Expr expr = stepExpr.getPredicateAt(i);
            this.predicate(expr);
        }
        ASTDecorator2.setType(stepExpr, type2);
        return type2;
    }

    protected Type stepPattern(Expr expr) throws TypeCheckError {
        StepExpr stepExpr = (StepExpr)expr;
        NodeType nodeType = this.getTypeForStep(stepExpr, this._compiler);
        int n2 = nodeType.getId();
        stepExpr.setStepNodeType(n2);
        int n3 = stepExpr.getPredicateCount();
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                Expr expr2 = stepExpr.getPredicateAt(i);
                this.predicate(expr2);
            }
        }
        return nodeType.getType();
    }

    protected Type emptySequence(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.EMPTY);
        return TypeConstants.EMPTY;
    }

    protected Type stringLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.STRING);
        return TypeConstants.STRING;
    }

    protected Type integerLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.INTEGER);
        return TypeConstants.INTEGER;
    }

    protected Type decimalLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.DECIMAL);
        return TypeConstants.DECIMAL;
    }

    private Type elementConstructor(Expr expr) {
        ElementType elementType = new ElementType(((DirElemConstructor)expr).getQName(), null);
        ASTDecorator2.setType(expr, elementType);
        return elementType;
    }

    protected Type doubleLiteral(Expr expr) {
        ASTDecorator2.setType(expr, Type.DOUBLE);
        return Type.DOUBLE;
    }

    protected Type unaryExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        if (operatorExpr.getOperatorType() == 26) {
            int n2 = this.getOperatorIndex(operatorExpr);
            PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = this._compiler.getOperatorDeclaration(n2);
            return this.standardPolymorphicFunctionCall(polymorphicFunctionDeclaration, operatorExpr, FunctionOperatorTable.getOperatorCategory(n2), n2, true);
        }
        Type type2 = this.visitExpression(operatorExpr.getOperand(0));
        ASTDecorator2.setType(expr, type2);
        return type2;
    }

    protected Type unionExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = operatorExpr.getOperandCount();
        if (n2 != 2) {
            throw new StaticError(operatorExpr);
        }
        for (int i = 0; i < 2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            Type type2 = this.visitExpression(expr2);
        }
        ASTDecorator2.setType(expr, Type.NODE);
        return Type.NODE;
    }

    protected Type predicate(Expr expr) throws TypeCheckError {
        Type type2 = this.visitExpression(expr);
        if (type2 == Type.INTEGER) {
            Node node2;
            Expr expr2 = (Expr)expr.jjtGetParent();
            boolean bl = false;
            if (XSLTCHelper.hasLastCall(expr) || XSLTCHelper.isPattern(expr2) || XSLTCHelper.isFilterStep(expr2)) {
                if (!XSLTCHelper.hasLastCall(expr)) {
                    ASTDecorator.setNthPositionFilter(expr, ASTDecorator.getCanOptimize(expr));
                } else if (XSLTCHelper.isFilterStep(expr2)) {
                    StepExpr stepExpr = (StepExpr)expr2;
                    Expr expr3 = null;
                    try {
                        expr3 = stepExpr.getPrimaryExpr();
                    }
                    catch (XPath20Exception xPath20Exception) {
                        throw new StaticError(expr);
                    }
                    boolean bl2 = true;
                    if (XSLTCHelper.isKeyCall(expr3)) {
                        bl2 = false;
                    } else if (expr3 instanceof VariableRef) {
                        bl2 = false;
                    } else if (expr3 instanceof PathExpr) {
                        bl2 = false;
                    } else if (expr3.getId() == 63) {
                        bl2 = false;
                    } else if (XSLTCHelper.hasLastCall(expr)) {
                        bl2 = false;
                    } else if (stepExpr.jjtGetParent() instanceof PathExpr && ((PathExpr)stepExpr.jjtGetParent()).getOperandCount() > 1) {
                        bl2 = false;
                    }
                    ASTDecorator.setCanOptimize(expr, bl2);
                    if (bl2) {
                        bl = true;
                    }
                }
                if (bl) {
                    ASTDecorator.setNthPositionFilter(expr, true);
                    return Type.NODE;
                }
                return Type.INTEGER;
            }
            if (expr2 != null && expr2.getId() == 85 && (node2 = expr2.jjtGetParent()) != null && node2 instanceof PathExpr) {
                PathExpr pathExpr = (PathExpr)node2;
                Expr expr4 = null;
                try {
                    if (pathExpr.isAbsolute() && (expr4 = pathExpr.getOperand(1)) instanceof StepExpr && ((StepExpr)expr4).getAxisType() == 13) {
                        ASTDecorator.setNthDescendant(expr, true);
                        return Type.NODE;
                    }
                }
                catch (XPath20Exception xPath20Exception) {
                    throw new StaticError(expr);
                }
            }
            ASTDecorator.setNthPositionFilter(expr, true);
            return Type.NODE;
        }
        if (type2 == Type.BOOLEAN && XSLTCHelper.hasPositionCall(expr)) {
            ASTDecorator.setNthPositionFilter(expr, true);
        }
        ASTDecorator.setNthPositionFilter(expr, false);
        Translator2Helper.getCompareValue(expr);
        return Type.BOOLEAN;
    }

    private boolean isFororQuantifiedExpr(Expr expr) {
        for (Expr expr2 = (Expr)expr.jjtGetParent(); expr2 != null; expr2 = (Expr)expr2.jjtGetParent()) {
            if (expr2.getId() != 53 && expr2.getId() != 42) continue;
            return true;
        }
        return false;
    }

    protected Type variableOrParameterReference(Expr expr) throws TypeCheckError {
        Object object2;
        String string2;
        VariableRef variableRef = (VariableRef)expr;
        if (this._staticContext.getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when") && !this.isFororQuantifiedExpr(expr)) {
            String string3 = this._parser.getExprString();
            ErrorMsg errorMsg = new ErrorMsg("ERR_VERUNDEFINED_USEWHEN", string3.substring(8, string3.length() - 1), variableRef.getQName().toString(), expr);
            throw new StaticError(errorMsg);
        }
        Type type2 = ASTDecorator2.getType(variableRef);
        if (type2 != null) {
            return type2;
        }
        QName qName = variableRef.getVariableName();
        String string4 = qName.getLocalPart();
        String string5 = qName.getNamespaceURI();
        QName qName2 = this._parser.getQName(string5, string2 = qName.getPrefix(), string4);
        VariableBase variableBase = this.lookupVariable(qName2);
        if (variableBase == null) {
            Object object3;
            int n2 = this._staticContext.getLanguage();
            if (n2 != 4 && n2 != 5) {
                object3 = this._staticContext.getVariableBindingType(variableRef.getVariableName());
                if (object3 != null && (type2 = XSLTC2Helper.convertSequenceTypeToXtqType((SequenceType)object3, this.getCompiler().getTypeFactory(), this.getCompiler().getStaticContext())) != null) {
                    ASTDecorator2.setType(variableRef, type2);
                    return type2;
                }
                if (n2 == 1 || n2 == 2) {
                    ASTDecorator2.setType(variableRef, ExtendedTypes.ITEM_ZERO_OR_MORE);
                    return ExtendedTypes.ITEM_ZERO_OR_MORE;
                }
            }
            object3 = new ASTMsg("VARIABLE_UNDEF_ERR", new Object[]{qName2.toString()}, (SimpleNode)expr);
            throw new StaticError(((BaseMsg)object3).getFormattedMessage());
        }
        ASTDecorator.setVariable(variableRef, variableBase);
        if (this._staticContext.getLanguage() != 3 && !this.handleVariableReference(variableBase)) {
            return null;
        }
        TypeExpr typeExpr = variableBase.getType();
        if (typeExpr != null) {
            object2 = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
            ASTDecorator2.setAsType(variableBase, (XSequenceType)object2);
        }
        if (variableBase.isLocal()) {
            object2 = variableRef;
            do {
                if (!XSLTCHelper.isClosure((Node)object2)) continue;
                ASTDecorator.setClosure(variableRef, (SimpleNode)object2);
                XSLTCHelper.addVariableToClosure((SimpleNode)object2, variableRef);
                break;
            } while (!(object2 instanceof TopLevelDecl) && (object2 = (SimpleNode)((SimpleNode)object2).jjtGetParent()) != null);
        }
        if ((type2 = ASTDecorator2.getVariableType(variableBase)) == null) {
            this.visitTree(variableBase);
            type2 = ASTDecorator2.getVariableType(variableBase);
        }
        if (type2 == null) {
            type2 = ExtendedTypes.ITEM_ZERO_OR_MORE;
        }
        ASTDecorator2.setType(variableRef, type2);
        return type2;
    }

    protected boolean handleVariableReference(VariableBase variableBase) {
        return true;
    }

    protected Type castableAsExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator sequenceTypeOperator = (SequenceTypeOperator)expr;
        Expr expr2 = sequenceTypeOperator.getLHS();
        TypeExpr typeExpr = sequenceTypeOperator.getSequenceType();
        Type type2 = this.visitExpression(expr2);
        type2 = type2.getAtomizedType();
        boolean bl = false;
        Type type3 = (Type)((Object)this.getCompiler().getTypeFactory().getTypeFromName(typeExpr.getTypeName()));
        if (type3 == null) {
            throw new StaticError(expr);
        }
        if (!(type3 instanceof AnyAtomicType)) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 0 || typeExpr.getOccurrenceIndicator() == 1) {
            throw new StaticError(expr);
        }
        if (type3 == Type.NOTATION || type3 == Type.ANYATOMICTYPE) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_INVALID_CAST_TARGETTYPE");
            throw new StaticError(errorMsg);
        }
        if (type3 == Type.ANYATOMICTYPE) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 2) {
            bl = true;
        }
        int n2 = type2.castableAs((AnyAtomicType)type3, bl);
        if (bl && type2.getQuantifier().canBeEmpty()) {
            type3 = new XSequenceType((AnyAtomicType)type3, OccurrenceIndicator.ZERO_OR_ONE);
        }
        if (expr2.getId() == 5 && type3 == TypeConstants.QNAME) {
            String string2;
            String string3 = String.valueOf(RuntimeLibrary.normalizeSpace(expr2.getValue().toCharArray()));
            int n3 = string3.indexOf(":");
            n2 = n3 == -1 ? 1 : (this._staticContext.getNamespaceURI(string2 = string3.substring(0, n3)) != null ? 1 : 0);
        }
        ASTDecorator2.setCastableAsResult(expr, n2);
        ASTDecorator2.setCastableAsTargetType(expr, type3);
        ASTDecorator2.setType(expr, Type.BOOLEAN);
        return Type.BOOLEAN;
    }

    protected Type castAsExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator sequenceTypeOperator = (SequenceTypeOperator)expr;
        Expr expr2 = sequenceTypeOperator.getLHS();
        TypeExpr typeExpr = sequenceTypeOperator.getSequenceType();
        Type type2 = this.visitExpression(expr2);
        type2 = type2.getAtomizedType();
        boolean bl = false;
        Type type3 = (Type)((Object)this.getCompiler().getTypeFactory().getTypeFromName(typeExpr.getTypeName()));
        if (type3 == null) {
            throw new StaticError(expr);
        }
        if (!(type3 instanceof AnyAtomicType)) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 0 || typeExpr.getOccurrenceIndicator() == 1) {
            throw new StaticError(expr);
        }
        if (type3 == Type.NOTATION || type3 == Type.ANYATOMICTYPE) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_INVALID_CAST_TARGETTYPE");
            throw new StaticError(errorMsg);
        }
        if (type3 == Type.ANYATOMICTYPE) {
            throw new StaticError(expr);
        }
        if (type2.getQuantifier() == OccurrenceIndicator.TWO_OR_MORE) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 2) {
            bl = true;
        }
        if (type2 == Type.EMPTY && typeExpr.getOccurrenceIndicator() == 3) {
            throw new StaticError(expr);
        }
        int n2 = type2.castableAs((AnyAtomicType)type3, bl);
        if (n2 == 0) {
            throw new StaticError(expr);
        }
        QName qName = null;
        int n3 = expr2.getId();
        if (n3 == 5 && type3 == TypeConstants.QNAME) {
            String string2 = String.valueOf(RuntimeLibrary.normalizeSpace(expr2.getValue().toCharArray()));
            int n4 = string2.indexOf(":");
            if (n4 == -1) {
                String string3 = this._staticContext.getNamespaceURI("");
                qName = string3 == null ? new QName(string2) : new QName(string3, string2);
            } else {
                String string4 = string2.substring(0, n4);
                String string5 = this._staticContext.getNamespaceURI(string4);
                if (string5 != null) {
                    qName = new QName(string5, string2.substring(n4 + 1), string4);
                } else {
                    throw new StaticError("ERR_NO_NAMESPACE_FOR_PREFIX", string4);
                }
            }
        }
        if (bl && type2.getQuantifier().canBeEmpty()) {
            type3 = new XSequenceType((AnyAtomicType)type3, OccurrenceIndicator.ZERO_OR_ONE);
        }
        ASTDecorator2.setExpressionCastValue(expr, qName);
        ASTDecorator2.setType(expr, type3);
        return type3;
    }

    protected Type everyExpression(Expr expr) {
        return null;
    }

    protected Type forExpression(Expr expr) throws TypeCheckError {
        int n2;
        Object object2;
        Object object3;
        Object object4;
        FLWORExpr fLWORExpr = (FLWORExpr)expr;
        int n3 = fLWORExpr.getClauseCount();
        for (int i = 0; i < n3; ++i) {
            object4 = fLWORExpr.getVardecl(i);
            object3 = ((VariableBase)object4).getExpression();
            Type type2 = this.visitExpression((Expr)object3);
            if (type2 instanceof CollectionType) {
                type2 = ((CollectionType)type2).getPrimeType();
            }
            ASTDecorator2.setVariableType((VariableBase)object4, type2);
            object2 = ((VariableBase)object4).getType();
            if (object2 != null) {
                XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), (TypeExpr)object2);
                ASTDecorator2.setAsType((Expr)object4, xSequenceType);
            }
            this.addVariable((VarDecl)object4);
            this.addPositionVariable((VarDecl)object4, fLWORExpr);
        }
        Expr expr2 = fLWORExpr.getWhere();
        if (expr2 != null) {
            object4 = this.visitExpression(expr2);
            ASTDecorator2.setType(expr2, (Type)object4);
        }
        object4 = fLWORExpr.getResultingExpr();
        object3 = this.visitExpression((Expr)object4);
        ASTDecorator2.setType((Expr)object4, (Type)object3);
        for (n2 = 0; n2 < fLWORExpr.orderSpecCount(); ++n2) {
            object2 = this.visitExpression(fLWORExpr.getOrderSpec(n2));
            ASTDecorator2.setType(fLWORExpr.getOrderSpec(n2), (Type)object2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = fLWORExpr.getVariableName(n2);
            this.removeVariable((QName)object2);
            this.removePositionVariable(fLWORExpr.getVardecl(n2));
        }
        return object3;
    }

    protected Type ifExpression(Expr expr) throws TypeCheckError {
        Type type2;
        ConditionalExpr conditionalExpr = (ConditionalExpr)expr;
        Expr expr2 = conditionalExpr.getThenExpr();
        Expr expr3 = conditionalExpr.getElseExpr();
        Type type3 = this.visitExpression(conditionalExpr.getTestExpr());
        Type type4 = this.visitExpression(expr2);
        if (type4.equals(type2 = this.visitExpression(expr3))) {
            return type4;
        }
        return new ChoiceType(type4, type2);
    }

    protected Type instanceofExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator sequenceTypeOperator = (SequenceTypeOperator)expr;
        Type type2 = this.visitExpression(sequenceTypeOperator.getLHS());
        TypeExpr typeExpr = sequenceTypeOperator.getSequenceType();
        XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
        if (xSequenceType == null) {
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_INSTANCE_OF");
            throw new StaticError(errorMsg);
        }
        if (xSequenceType instanceof DocumentType) {
            // empty if block
        }
        if (!(type2.getPrimeType() instanceof UntypedAtomic)) {
            int n2 = type2.typeMatches(xSequenceType);
            if (n2 == 1) {
                ASTDecorator2.setCompileTimeEvaluationValue(expr, Boolean.TRUE);
            } else {
                ASTDecorator2.setSequenceType(sequenceTypeOperator, xSequenceType);
            }
        } else {
            ASTDecorator2.setSequenceType(sequenceTypeOperator, xSequenceType);
        }
        ASTDecorator2.setType(sequenceTypeOperator, TypeConstants.BOOLEAN);
        return TypeConstants.BOOLEAN;
    }

    protected Type typeswitchExpression(Expr expr) throws TypeCheckError {
        TypeSwitch typeSwitch = (TypeSwitch)expr;
        this.visitExpression(typeSwitch.getOperandExpr());
        int n2 = typeSwitch.getCaseCount();
        for (int i = 0; i < n2; ++i) {
            CaseClause caseClause = typeSwitch.getCaseClause(i);
            QName qName = caseClause.getVarName();
            if (qName != null) {
                VarDecl varDecl = new VarDecl(29);
                varDecl.setQName(qName);
                varDecl.setLocal(true);
                varDecl.jjtSetParent(typeSwitch);
                this.addVariable(varDecl);
            }
            this.visitExpression(caseClause.getReturnExpr());
            ASTDecorator2.setSequenceType(caseClause, XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), caseClause.getType()));
            if (qName == null) continue;
            this.removeVariable(qName);
        }
        return ExtendedTypes.ITEM_ZERO_OR_MORE;
    }

    protected Type orderedExpression(Expr expr) throws TypeCheckError {
        OrderedExpr orderedExpr = (OrderedExpr)expr;
        Expr expr2 = orderedExpr.getOrderedExpr();
        return this.visitExpression(expr2);
    }

    protected Type unorderedExpression(Expr expr) throws TypeCheckError {
        UnorderedExpr unorderedExpr = (UnorderedExpr)expr;
        Expr expr2 = unorderedExpr.getUnorderedExpr();
        return this.visitExpression(expr2);
    }

    protected Type extensionExpression(Expr expr) throws TypeCheckError {
        ExtensionExpr extensionExpr = (ExtensionExpr)expr;
        if (!extensionExpr.hasExtensionExpr()) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_PRAGMA_EXPR_MISSING");
            throw new StaticError(errorMsg);
        }
        Expr expr2 = extensionExpr.getExtensionExpr();
        return this.visitExpression(expr2);
    }

    protected Type caseExpression(Expr expr) throws TypeCheckError {
        CaseClause caseClause = (CaseClause)expr;
        Expr expr2 = caseClause.getReturnExpr();
        ASTDecorator2.setSequenceType(caseClause, XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), caseClause.getType()));
        return null;
    }

    protected Type intersectOrExceptExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = operatorExpr.getOperandCount();
        if (n2 != 2) {
            throw new StaticError(operatorExpr);
        }
        for (int i = 0; i < 2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            Type type2 = this.visitExpression(expr2);
        }
        ASTDecorator2.setType(expr, Type.NODE);
        return Type.NODE;
    }

    protected Type quantifiedExpression(Expr expr) throws TypeCheckError {
        Object object2;
        Object object3;
        QuantifiedExpr quantifiedExpr = (QuantifiedExpr)expr;
        int n2 = quantifiedExpr.getClauseCount();
        for (int i = 0; i < n2; ++i) {
            object3 = quantifiedExpr.getVardecl(i);
            Expr expr2 = ((VariableBase)object3).getExpression();
            object2 = this.visitExpression(expr2);
            if (object2 instanceof CollectionType) {
                object2 = ((CollectionType)object2).getPrimeType();
            }
            ASTDecorator2.setVariableType((VariableBase)object3, (Type)object2);
            this.addVariable((VarDecl)object3);
        }
        Expr expr3 = quantifiedExpr.getResultingExpr();
        object3 = this.visitExpression(expr3);
        ASTDecorator2.setType(expr3, (Type)object3);
        for (int i = 0; i < n2; ++i) {
            object2 = quantifiedExpr.getVariableName(i);
            this.removeVariable((QName)object2);
        }
        return Type.BOOLEAN;
    }

    protected Type rangeExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = operatorExpr.getOperandCount();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            this.visitExpression(expr2);
        }
        XSequenceType xSequenceType = ExtendedTypes.INTEGER_ZERO_OR_MORE;
        ASTDecorator2.setType(expr, xSequenceType);
        return xSequenceType;
    }

    protected Type someExpression(Expr expr) {
        return null;
    }

    protected Type treatAsExpression(Expr expr) throws TypeCheckError {
        Type type2;
        TreatExpr treatExpr = (TreatExpr)expr;
        Type type3 = this.visitExpression(treatExpr.getExpr());
        TypeExpr typeExpr = treatExpr.getSequenceType();
        XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
        if (xSequenceType == null) {
            String string2 = xSequenceType.toString();
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_TREAT_AS_2", string2);
            throw new StaticError(errorMsg);
        }
        int n2 = 2;
        if (!(type3.getPrimeType() instanceof UntypedAtomic)) {
            n2 = type3.typeMatches(xSequenceType);
            if (n2 == 0) {
                String string3 = type3.toString();
                String string4 = xSequenceType.toString();
                ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_TREAT_AS", (Object)string3, (Object)string4);
                throw new StaticError(errorMsg);
            }
            type2 = n2 == 1 ? type3 : xSequenceType;
        } else {
            type2 = xSequenceType;
        }
        ASTDecorator2.setTreatAsResult(treatExpr, n2);
        ASTDecorator2.setTreatAsSequenceType(treatExpr, xSequenceType);
        return type2;
    }

    public NodeType getTypeForStep(StepExpr stepExpr, XPathCompiler xPathCompiler) {
        NodeTest nodeTest = null;
        short s = 0;
        try {
            nodeTest = stepExpr.getNodeTest();
            s = stepExpr.getAxisType();
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
        XSLTParser xSLTParser = xPathCompiler.getParser();
        if (nodeTest.isNameTest()) {
            NameTest nameTest = (NameTest)nodeTest;
            QName qName = nameTest.getQName();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (qName != null) {
                string3 = qName.getLocalPart();
                string4 = qName.getPrefix();
                string2 = s == 4 && string4.equals("") ? "" : qName.getNamespaceURI();
            } else {
                short s2 = nameTest.getNameTestType();
                if (s2 == 0) {
                    if (s == 12) {
                        return new NodeType(ExtendedTypes.NODE_ZERO_OR_MORE, -1);
                    }
                    if (s == 4) {
                        return new NodeType(ExtendedTypes.ATTRIBUTE_ZERO_OR_MORE, 2);
                    }
                    return new NodeType(ExtendedTypes.ELEMENT_ZERO_OR_MORE, 1);
                }
                if (s2 == 1) {
                    string4 = nameTest.getNCName();
                    string2 = this._staticContext.getNamespaceURI(string4);
                    string3 = "*";
                    if (stepExpr.getId() == 188 && stepExpr.getPredicateCount() == 0) {
                        ASTDecorator.setPatternPriority(stepExpr, new BigDecimal("-0.25"));
                    }
                } else if (s2 == 2) {
                    string3 = nameTest.getNCName();
                    if (stepExpr.getId() == 188 && stepExpr.getPredicateCount() == 0) {
                        ASTDecorator.setPatternPriority(stepExpr, new BigDecimal("-0.25"));
                    }
                }
                qName = string4 != null ? new QName(string2, string3, string4) : new QName(string3);
            }
            if (s == 12) {
                if (qName != null) {
                    QName qName2 = new QName("", string3, "xmlns");
                    return new NodeType(null, xPathCompiler.registerNamespaceDecl(qName2));
                }
                return NULL_NODE;
            }
            QName qName3 = xSLTParser.getQName(string2, string4, string3);
            if (s == 4) {
                int n2 = xPathCompiler.registerAttribute(qName3);
                AttributeType attributeType = new AttributeType(qName, TypeConstants.UNTYPEDATOMIC);
                return new NodeType(new XSequenceType(attributeType, OccurrenceIndicator.ZERO_OR_MORE), n2);
            }
            int n3 = xPathCompiler.registerElement(qName3);
            ElementType elementType = new ElementType(qName, TypeConstants.UNTYPEDANY);
            return new NodeType(new XSequenceType(elementType, OccurrenceIndicator.ZERO_OR_MORE), n3);
        }
        KindTest kindTest = (KindTest)nodeTest;
        short s3 = kindTest.getKindTestType();
        switch (s3) {
            case 0: {
                return new NodeType(ExtendedTypes.PI_ZERO_OR_MORE, 7);
            }
            case 1: {
                return new NodeType(ExtendedTypes.COMMENT_ZERO_OR_MORE, 8);
            }
            case 2: {
                return new NodeType(ExtendedTypes.NODE_ZERO_OR_MORE, -1);
            }
            case 3: {
                return new NodeType(ExtendedTypes.TEXT_ZERO_OR_MORE, 3);
            }
            case 4: {
                return new NodeType(ExtendedTypes.DOCUMENT_ZERO_OR_MORE, 9);
            }
            case 7: {
                this.testInScopeElementDeclarations(kindTest.getTypeName());
            }
            case 5: {
                return new NodeType(ExtendedTypes.ELEMENT_ZERO_OR_MORE, 1);
            }
            case 8: {
                this.testInScopeAttributeDeclarations(kindTest.getTypeName());
            }
            case 6: {
                return new NodeType(ExtendedTypes.ATTRIBUTE_ZERO_OR_MORE, 2);
            }
        }
        return NULL_NODE;
    }

    protected Type slashSlashPattern(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n2 = operatorExpr.getOperandCount();
        Type type2 = null;
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            type2 = this.visitExpression(expr2);
        }
        return type2;
    }

    private boolean testInScopeElementDeclarations(QName qName) {
        TypeRegistry typeRegistry = this.getCompiler().getStaticContext().getTypeRegistry();
        if (this._staticContext.getInScopeElementDeclaration(qName, typeRegistry) == null) {
            throw new StaticError("ERR_NOT_DEFINED_IN_SCOPE_SCHEMA_ELEM", qName.toString());
        }
        return true;
    }

    private boolean testInScopeAttributeDeclarations(QName qName) {
        TypeRegistry typeRegistry = this.getCompiler().getStaticContext().getTypeRegistry();
        if (this._staticContext.getInScopeAttributeDeclaration(qName, typeRegistry) == null) {
            throw new StaticError("ERR_NOT_DEFINED_IN_SCOPE_SCHEMA_ATT", qName.toString());
        }
        return true;
    }

    private void addPositionVariable(VarDecl varDecl, Expr expr) {
        if (varDecl.getPositionalVar() != null) {
            VarDecl varDecl2 = new VarDecl(29);
            varDecl2.setQName(varDecl.getPositionalVar().getQName());
            varDecl2.setLocal(true);
            varDecl2.jjtSetParent(expr);
            ASTDecorator2.setVariableType(varDecl2, Type.INTEGER);
            this.addVariable(varDecl2);
        }
    }

    private void removePositionVariable(VarDecl varDecl) {
        if (varDecl.getPositionalVar() != null) {
            this.removeVariable(varDecl.getPositionalVar().getQName());
        }
    }

    static class VisitForPositionalQueries
    extends VisitorBase {
        private static QName positionFunction = new QName("http://www.w3.org/2005/xpath-functions", "position");
        private static QName lastFunction = new QName("http://www.w3.org/2005/xpath-functions", "last");
        boolean accessesContextPosition = false;

        VisitForPositionalQueries() {
        }

        @Override
        public boolean visitNode(Expr expr, int n2) {
            if (!this.accessesContextPosition) {
                this.accessesContextPosition = this.isFunction(expr, positionFunction) || this.isFunction(expr, lastFunction);
            }
            return !this.accessesContextPosition;
        }

        private boolean isFunction(Expr expr, QName qName) {
            return expr.getId() == 105 && ((FunctionCall)expr).getFunctionQName().equals(qName);
        }
    }

    static class NodeType {
        private Type _type;
        private int _id;

        public NodeType(Type type2, int n2) {
            this._type = type2;
            this._id = n2;
        }

        public Type getType() {
            return this._type;
        }

        public int getId() {
            return this._id;
        }
    }
}

