/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.typechecker;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.VisitorBase;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.namespace.QName;

public abstract class TypeCheckerBase
extends VisitorBase
implements Constants {
    protected XPathCompiler _compiler;
    protected XSLTParser _parser;
    protected XTQStaticContext _staticContext;
    protected Hashtable<QName, Object> _variableScope;

    protected TypeCheckerBase(XPathCompiler xPathCompiler) {
        this._compiler = xPathCompiler;
        this._parser = xPathCompiler.getParser();
        this._staticContext = xPathCompiler.getStaticContext();
        this._variableScope = new Hashtable();
    }

    public XPathCompiler getCompiler() {
        return this._compiler;
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void addVariable(VarDecl varDecl) {
        this.addVariableOrParam(varDecl);
    }

    public void addParameter(Param param) {
        this.addVariableOrParam(param);
    }

    private void addVariableOrParam(VariableBase variableBase) {
        Object object2 = this._variableScope.get(variableBase.getQName());
        if (object2 != null) {
            if (object2 instanceof Stack) {
                Stack stack = (Stack)object2;
                stack.push(variableBase);
            } else if (object2 instanceof VariableBase) {
                Stack<Object> stack = new Stack<Object>();
                stack.push(object2);
                stack.push(variableBase);
                this._variableScope.put(variableBase.getQName(), stack);
            }
        } else {
            this._variableScope.put(variableBase.getQName(), variableBase);
        }
    }

    public void removeVariable(QName qName) {
        Object object2 = this._variableScope.get(qName);
        if (object2 instanceof Stack) {
            Stack stack = (Stack)object2;
            if (!stack.isEmpty()) {
                stack.pop();
            }
            if (!stack.isEmpty()) {
                return;
            }
        }
        this._variableScope.remove(qName);
    }

    public VariableBase lookupVariable(QName qName) {
        Object object2 = this._variableScope.get(qName);
        if (object2 instanceof VariableBase) {
            return (VariableBase)object2;
        }
        if (object2 instanceof Stack) {
            Stack stack = (Stack)object2;
            return (VariableBase)stack.peek();
        }
        return null;
    }

    protected QName updateScope(Expr expr) {
        if (expr instanceof VarDecl) {
            VarDecl varDecl = (VarDecl)expr;
            this.addVariable(varDecl);
            if (varDecl.getAt() != null) {
                this.updateScope(varDecl.getAt());
            }
            return varDecl.getQName();
        }
        if (expr instanceof Param) {
            Param param = (Param)expr;
            this.addParameter(param);
            return param.getQName();
        }
        return null;
    }
}

