/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.input.Util;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.ClassCollector;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.Resource;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xltxe.rnm1.xylem.instructions.DebugInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.xml.sax.InputSource;

public class XylemXSLTC {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemXSLTC.class);
    private static final String s_className = XylemXSLTC.class.getName();
    protected static SourceLoader s_sourceLoader = null;
    protected static boolean s_topResolve = false;
    protected static ArrayList s_classes;
    protected static ArrayList s_resources;
    private static boolean s_isInputXylem;

    public static void createSourceLoader(final URIResolver uRIResolver) {
        s_sourceLoader = new SourceLoader(){

            @Override
            public InputSource loadSource(String string2, String string3, XSLTParser xSLTParser) {
                try {
                    Source source = uRIResolver.resolve(string2, string3);
                    if (source != null) {
                        return Util.getInputSource(xSLTParser, source);
                    }
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
    }

    protected static void outputToJar(File file, String string2) throws IOException {
        Object object2;
        Object object32;
        Object object42;
        Manifest manifest = new Manifest();
        Attributes attributes2 = manifest.getMainAttributes();
        attributes2.put(Attributes.Name.MANIFEST_VERSION, "1.2");
        Map<String, Attributes> map2 = manifest.getEntries();
        Iterator iterator = s_classes.iterator();
        String string3 = new Date().toString();
        Attributes.Name name2 = new Attributes.Name("Date");
        while (iterator.hasNext()) {
            Iterator iterator2 = (JavaClass)iterator.next();
            object42 = ((JavaClass)((Object)iterator2)).getClassName().replace('.', '/');
            object32 = new Attributes();
            ((Attributes)object32).put(name2, string3);
            map2.put((String)object42 + ".class", (Attributes)object32);
        }
        for (Object object42 : s_resources) {
            object32 = new Attributes();
            ((Attributes)object32).put(name2, string3);
            map2.put(object42.getName(), (Attributes)object32);
        }
        object42 = new JarOutputStream((OutputStream)new FileOutputStream(new File(file, string2)), manifest);
        for (Object object32 : s_classes) {
            object2 = ((JavaClass)object32).getClassName().replace('.', '/');
            ((JarOutputStream)object42).putNextEntry(new JarEntry((String)object2 + ".class"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ((JavaClass)object32).dump(byteArrayOutputStream);
            byteArrayOutputStream.writeTo((OutputStream)object42);
        }
        for (Object object32 : s_resources) {
            ((JarOutputStream)object42).putNextEntry(new JarEntry(object32.getName()));
            object2 = new ByteArrayOutputStream(2048);
            object32.dump((OutputStream)object2);
            ((ByteArrayOutputStream)object2).writeTo((OutputStream)object42);
        }
        ((ZipOutputStream)object42).close();
    }

    public static void main(String[] stringArray) {
        XylemXSLTCommandLineParser xylemXSLTCommandLineParser = new XylemXSLTCommandLineParser();
        s_classes = new ArrayList();
        s_resources = new ArrayList();
        if (!xylemXSLTCommandLineParser.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        SessionContext sessionContext = new SessionContext();
        URL[] uRLArray = new URL[xylemXSLTCommandLineParser.m_files.size()];
        xylemXSLTCommandLineParser.m_files.toArray(uRLArray);
        if (xylemXSLTCommandLineParser.m_functor != null) {
            if (xylemXSLTCommandLineParser.m_interface == null) {
                s_logger.logp(Level.SEVERE, s_className, "main", "you must specify an interface file with -functor");
                System.exit(-1);
            }
            try {
                AutoFunctorizingXSLTLinker.compileFunctorAppliedStylesheets(xylemXSLTCommandLineParser.m_functor.toURL(), uRLArray, xylemXSLTCommandLineParser.m_interface.toURL(), xylemXSLTCommandLineParser.m_compilerSettings, s_sourceLoader, s_topResolve, sessionContext);
            }
            catch (MalformedURLException malformedURLException) {
                s_logger.logp(Level.SEVERE, s_className, "main", "malformed interface or functor filename", malformedURLException);
                System.exit(-1);
            }
        } else if (xylemXSLTCommandLineParser.m_files.size() > 1) {
            if (!xylemXSLTCommandLineParser.m_linkerSettings.isOverlapDetection()) {
                s_logger.logp(Level.SEVERE, s_className, "main", "multiple XSLT input files only supported with -functor");
                System.exit(-1);
            } else if (AutoFunctorizingXSLTLinker.compileStylesheetDetectOverlap(uRLArray, xylemXSLTCommandLineParser.m_classNames, xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, s_sourceLoader, s_topResolve, sessionContext) == null) {
                System.exit(-1);
            }
        } else if (s_isInputXylem) {
            if (xylemXSLTCommandLineParser.m_compilerSettings.isStylesheetSpecificSAX()) {
                if (XSLTLinker.s_linker.compileXylemFile(xylemXSLTCommandLineParser.m_inputFile, xylemXSLTCommandLineParser.m_linkerSettings, sessionContext) == null) {
                    System.exit(-1);
                }
            } else if (XSLTLinker.s_linker.compileXylemFile(xylemXSLTCommandLineParser.m_inputFile, sessionContext) == null) {
                System.exit(-1);
            }
        } else if (xylemXSLTCommandLineParser.m_compilerSettings.isStylesheetSpecificSAX()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "isInputXylem=" + s_isInputXylem);
            }
            if (XSLTLinker.s_linker.compileStylesheet_StylesheetSpecificSAX(xylemXSLTCommandLineParser.m_inputFile, xylemXSLTCommandLineParser.m_classNames.size() > 0 ? (String)xylemXSLTCommandLineParser.m_classNames.get(0) : null, xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, s_sourceLoader, s_topResolve, sessionContext) == null) {
                System.exit(-1);
            }
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "isInputXylem=" + s_isInputXylem);
            }
            xylemXSLTCommandLineParser.m_linkerSettings.setDumpXylem(true);
            if (XSLTLinker.s_linker.compileStylesheet(xylemXSLTCommandLineParser.m_inputFile, xylemXSLTCommandLineParser.m_classNames.size() > 0 ? (String)xylemXSLTCommandLineParser.m_classNames.get(0) : null, xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings, s_sourceLoader, s_topResolve, sessionContext) == null) {
                System.exit(-1);
            }
        }
        if (xylemXSLTCommandLineParser.m_jarFileName != null) {
            try {
                XylemXSLTC.outputToJar(xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), xylemXSLTCommandLineParser.m_jarFileName);
            }
            catch (IOException iOException) {
                s_logger.logp(Level.SEVERE, s_className, "main", "IOException outputting jar file", iOException);
                System.exit(-1);
            }
        }
    }

    static {
        s_isInputXylem = false;
    }

    private static class CachingClassCollector
    extends ChainedClassCollector {
        public CachingClassCollector(ClassCollector classCollector) {
            super(classCollector);
        }

        @Override
        public void handleGeneratedClass(JavaClass javaClass) {
            s_classes.add(javaClass);
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            s_resources.add(resource);
        }
    }

    private static abstract class ChainedClassCollector
    extends ClassCollector {
        private ClassCollector m_nextCollector;

        public ChainedClassCollector(ClassCollector classCollector) {
            this.m_nextCollector = classCollector;
        }

        public abstract void handleGeneratedClass(JavaClass var1);

        public abstract void handleGeneratedResource(Resource var1);

        @Override
        public final void acceptGeneratedClass(JavaClass javaClass) {
            this.handleGeneratedClass(javaClass);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedClass(javaClass);
            }
        }

        @Override
        public final void acceptGeneratedResource(Resource resource) {
            this.handleGeneratedResource(resource);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedResource(resource);
            }
        }
    }

    public static class XylemXSLTCommandLineParser
    extends CommandLineParserSingleInputFile {
        public File m_functor = null;
        public File m_interface = null;
        public ArrayList m_files = new ArrayList();
        public ArrayList m_classNames = new ArrayList();
        public XSLTCompilerSettings m_compilerSettings = new XSLTCompilerSettings();
        public XSLTLinkerSettings m_linkerSettings = new XSLTLinkerSettings(this.m_compilerSettings);
        public String m_jarFileName = null;
        public InterpreterUtilities m_utility = new InterpreterUtilities();

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: XylemXSLTC [-command commandfile]\n                  [-language java|cpp]\n                  [-xslt-version 1.0|2.0]\n                  [-version]\n                  [-showversion]\n                  [-split limit]\n                  [-newsplit limit]\n                  [-outputdir dir]\n                  [-jarfile file]\n                  [-uriresolver fully.qualified.ClassName]\n                  [-topresolve]\n                  [-enabletracing]\n                  [-enabledebug]\n                  [-nodesetspecialization]\n                  [-disablenvcursors]\n                  [-traceserialization]\n                  [-combinepartitions]\n                  [-dumpxylem]\n                  [-dumpintermediatexylem]\n                  [-maxfunctionsperpartition n]\n                  [-functor input0.xsl -interface input0.xylemi]\n                  [-detectoverlap]\n                  [-classloaderproxy]\n                  [-disablejavac]\n                  [-assertions]\n                  [-symbols]\n                  [-streamresultonly]\n                  [-defaultmethod method]\n                  [-forceencoding encoding]\n                  [-nometa]\n                  [-standardserializer]\n                  [-suppressComments]\n                  [-generateBCEL]\n                  [-generateCXO]\n                  [-generateFCG]\n                  [-stylesheetSpecificSAX]\n                  [-saxstreaming]\n                  [-inputXylem input.xylem]\n                  [-xhtmlCompatability]\n                  [-disablesetparameter]\n                  [-minoptimizations]\n                  [-nsd]\n                  input1.xsl input2.xsl ...");
                return -1;
            }
            if ("-command".equals(stringArray[n2])) {
                if (n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(stringArray[++n2])) {
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-split")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-split missing parameter");
                    return -1;
                }
                try {
                    this.m_compilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n2]));
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid split limit: " + stringArray[n2]);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-xslt-version")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setVersion(stringArray[n2]);
                if (!stringArray[n2].equals("1.0") && !stringArray[n2].equals("2.0")) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid version: " + stringArray[n2]);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (stringArray[n2].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return n2;
            }
            if (stringArray[n2].equals("-symbols")) {
                this.m_linkerSettings.getCodeGenerationSettings().getJavaCSettings().setGenerateSymbols(true);
                return n2;
            }
            if (stringArray[n2].equals("-enabletracing")) {
                this.m_linkerSettings.getCodeGenerationSettings().setFunctionCallTracing(true);
                this.m_utility.setDebuggerflag(true);
                return n2;
            }
            if (stringArray[n2].equals("-nodesetspecialization")) {
                this.m_linkerSettings.setNodesetSpecialization(true);
                return n2;
            }
            if (stringArray[n2].equals("-minoptimizations")) {
                this.m_linkerSettings.setMinOptimization(true);
                return n2;
            }
            if (stringArray[n2].equals("-nsd")) {
                this.m_linkerSettings.setEnableNodeSetDeforester(true);
                return n2;
            }
            if (stringArray[n2].equals("-disablecnlfoptimizer")) {
                this.m_linkerSettings.setDisableCNLFOptimizer(true);
                return n2;
            }
            if (stringArray[n2].equals("-disablenvcursors")) {
                this.m_linkerSettings.setDisableNVCursor(true);
                return n2;
            }
            if (stringArray[n2].equals("-detectoverlap")) {
                this.m_linkerSettings.setOverlapDetection(true);
                return n2;
            }
            if (stringArray[n2].equals("-dumpxylem")) {
                this.m_linkerSettings.setDumpXylem(true);
                return n2;
            }
            if (stringArray[n2].equals("-dumpintermediatexylem")) {
                this.m_linkerSettings.setDumpIntermediateXylem(true);
                return n2;
            }
            if (stringArray[n2].equals("-inputXylem")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-inputXylem missing parameter");
                    return -1;
                }
                this.m_inputFile = this.validateInputFilename(stringArray[n2], s_topResolve);
                s_isInputXylem = true;
                return n2;
            }
            if (stringArray[n2].equals("-maxfunctionsperpartition")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-maxfunctionsperpartition missing parameter");
                    return -1;
                }
                this.m_linkerSettings.getCodeGenerationSettings().setMaxFunctionsPerPartition(Integer.parseInt(stringArray[n2]));
                return n2;
            }
            if (stringArray[n2].equals("-functor")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-functor missing parameter");
                    return -1;
                }
                if (this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-detectoverlap and functor mode are mutually exclusive");
                    return -1;
                }
                this.m_functor = new File(stringArray[n2]);
                if (!this.m_functor.exists()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "specified functor input file does not exist: " + this.m_functor);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-interface")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-interface missing parameter");
                    return -1;
                }
                if (this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-detectoverlap and functor mode are mutually exclusive");
                    return -1;
                }
                this.m_interface = new File(stringArray[n2]);
                if (!this.m_interface.exists()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "specified interface input file does not exist: " + this.m_interface);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-classname")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-classname missing parameter");
                    return -1;
                }
                this.m_classNames.add(stringArray[n2]);
                return n2;
            }
            if (stringArray[n2].equals("-outputdir")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-outputdir missing parameter");
                    return -1;
                }
                File file = new File(stringArray[n2]);
                this.m_linkerSettings.setOutputDir(file);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "specified output directory does not exist or is not a directory: " + file);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-jarfile")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-jarfile missing parameter");
                    return -1;
                }
                String string2 = stringArray[n2];
                this.m_jarFileName = string2.endsWith(".jar") ? string2 : string2 + ".jar";
                this.m_linkerSettings.getCodeGenerationSettings().setBCELClassCollector(new CachingClassCollector(null));
                return n2;
            }
            if (stringArray[n2].equals("-uriresolver")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-uriresolver missing parameter");
                    return -1;
                }
                try {
                    URIResolver uRIResolver = (URIResolver)ObjectFactory.newInstance(stringArray[n2], ObjectFactory.findClassLoader(), true);
                    XylemXSLTC.createSourceLoader(uRIResolver);
                }
                catch (Exception exception) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-uriresolver invalid class");
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-topresolve")) {
                s_topResolve = true;
                return n2;
            }
            if (stringArray[n2].equals("-streamresultonly")) {
                this.m_compilerSettings.setStreamResultOnly(true);
                return n2;
            }
            if (stringArray[n2].equals("-defaultmethod")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-defaultmethod missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setStreamResultDefaultOutputMethod(stringArray[n2].toLowerCase());
                return n2;
            }
            if (stringArray[n2].equals("-forceencoding")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-forceencoding missing parameter");
                    return -1;
                }
                this.m_compilerSettings.setForcedOutputEncoding(stringArray[n2]);
                return n2;
            }
            if (stringArray[n2].equals("-nometa")) {
                this.m_compilerSettings.setStreamResultNoMeta(true);
                return n2;
            }
            if (stringArray[n2].equals("-standardserializer")) {
                this.m_compilerSettings.setStreamResultOnly(false);
                return n2;
            }
            if (stringArray[n2].equals("-enabledebug")) {
                DebugInstruction.enable(stringArray[++n2]);
                return n2;
            }
            if (stringArray[n2].equals("-traceserialization")) {
                this.m_compilerSettings.setSerializationTraceEnabled(true);
                return n2;
            }
            if (stringArray[n2].equals("-classloaderproxy")) {
                this.m_linkerSettings.setGenerateClassLoadingProxy(true);
                return n2;
            }
            if (stringArray[n2].equals("-stylesheetSpecificSAX")) {
                this.m_compilerSettings.setStylesheetSpecificSAX(true);
                this.m_linkerSettings.setStylesheetSpecificSAX(true);
                return n2;
            }
            if (stringArray[n2].equals("-saxstreaming")) {
                this.m_compilerSettings.setStreaming(true);
                this.m_compilerSettings.setStylesheetSpecificSAX(true);
                this.m_linkerSettings.setStylesheetSpecificSAX(true);
                return n2;
            }
            if (stringArray[n2].equals("-assertions")) {
                return n2;
            }
            if (stringArray[n2].equals("-xhtmlCompatability")) {
                this.m_compilerSettings.setXHTMLCompatability(true);
                return n2;
            }
            if (stringArray[n2].equals("-interpret")) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-interpret no longer supported; use XSLTInterpreter instead");
                return n2;
            }
            if ("-DISABLESETPARAMETER".equalsIgnoreCase(stringArray[n2])) {
                this.m_compilerSettings.setDisableSetParameter(true);
                return n2;
            }
            if (stringArray[n2].equals("-interpretOverlap")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-interpretOverlap missing functorindex");
                    return -1;
                }
                if (!this.m_linkerSettings.isOverlapDetection()) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "Set -interpretOverlap after -detectoverlap");
                    return -1;
                }
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(stringArray[n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid functor index: " + stringArray[n2]);
                    return -1;
                }
                this.m_linkerSettings.setInterpretIndex(n3);
                return n2;
            }
            int n4 = this.m_linkerSettings.getCodeGenerationSettings().parseOption(stringArray, n2);
            if (n4 == -1) {
                return -1;
            }
            if (n4 != -2) {
                return n4;
            }
            this.m_inputFile = this.validateInputFilename(stringArray[n2], s_topResolve);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_files.add(this.m_inputFile);
            return n2;
        }

        @Override
        public boolean parseCommandLine(String[] stringArray) {
            boolean bl = super.parseCommandLine(stringArray);
            if (this.m_linkerSettings.isOverlapDetection() && this.m_files.size() <= 1) {
                this.m_linkerSettings.setOverlapDetection(false);
            }
            return bl;
        }
    }
}

