/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Whitespace;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WhitespaceHelper
implements Constants {
    public static final int RULE_NONE = 0;
    public static final int RULE_ELEMENT = 1;
    public static final int RULE_NAMESPACE = 2;
    public static final int RULE_ALL = 3;

    public static List getRules(Whitespace whitespace) {
        ArrayList<WhitespaceRule> arrayList = new ArrayList<WhitespaceRule>();
        StringTokenizer stringTokenizer = Util.whitespaceTokenize(whitespace.getElementList());
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(new WhitespaceRule(whitespace.getAction(), stringTokenizer.nextToken(), whitespace.getImportPrecedence().getPrecedence()));
        }
        return arrayList;
    }

    public static final class WhitespaceRule {
        private final int _action;
        private String _namespace;
        private String _element;
        private int _type;
        private int _priority;

        public WhitespaceRule(int n2, String string2, String string3, int n3, int n4) {
            this._action = n2;
            this._namespace = string2;
            this._element = string3;
            this._type = n3;
            this._priority = n4;
        }

        public String getGeneratedConstructor() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("new com.ibm.xltxe.rnm1.xtq.xslt.translator.WhitespaceHelper.WhitespaceRule(");
            stringBuffer.append(this.getAction());
            stringBuffer.append(", \"");
            stringBuffer.append(this.getNamespace());
            stringBuffer.append("\", \"");
            stringBuffer.append(this.getElement());
            stringBuffer.append("\", ");
            stringBuffer.append(this.getStrength());
            stringBuffer.append(", ");
            stringBuffer.append(this.getPriority());
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public WhitespaceRule(int n2, String string2, int n3) {
            this._action = n2;
            int n4 = string2.lastIndexOf(58);
            if (n4 >= 0) {
                this._namespace = string2.substring(0, n4);
                this._element = string2.substring(n4 + 1, string2.length());
            } else {
                this._namespace = "";
                this._element = string2;
            }
            this._priority = n3 << 2;
            if (this._element.equals("*")) {
                if (this._namespace == "") {
                    this._type = 3;
                } else {
                    this._type = 2;
                    ++this._priority;
                }
            } else {
                this._type = 1;
                this._priority += 2;
            }
        }

        public boolean matches(String string2, String string3) {
            if (this._type == 3) {
                return true;
            }
            if (this._type == 2) {
                return this._namespace.equals(string2);
            }
            if (this._type == 1) {
                if (this._namespace.equals("*")) {
                    return this._element.equals(string3);
                }
                return this._namespace.equals(string2) && this._element.equals(string3);
            }
            return false;
        }

        public int compareTo(WhitespaceRule whitespaceRule) {
            return this._priority < whitespaceRule._priority ? -1 : (this._priority > whitespaceRule._priority ? 1 : 0);
        }

        public int getAction() {
            return this._action;
        }

        public int getStrength() {
            return this._type;
        }

        public int getPriority() {
            return this._priority;
        }

        public String getElement() {
            return this._element;
        }

        public String getNamespace() {
            return this._namespace;
        }
    }
}

